/****************************************************************************
 File: lboxes.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.6  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:45:02  $

 This file contains the listbox demoing code of the tkdemo application.
****************************************************************************/

#ifndef _STDIO_H_INCLUDED
#include <stdio.h>
#endif

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#ifndef CLASSES_INCLUDED
#include <methods.h>
#endif

#ifndef DEBUG_INCLUDED
#include <debug.h>
#endif

#ifndef OPTTABLE_INCLUDED
#include <opttable.h>
#endif

#ifndef SWIN_INCLUDED
#include <swin.h>
#endif

#ifndef LISTBOX_INCLUDED
#include <listbox.h>
#endif

#ifndef BUTTON_INCLUDED
#include <button.h>
#endif

#ifndef STRLBOX_INCLUDED
#include <strlbox.h>
#endif

#ifndef FONTLBOX_INCLUDED
#include <fontlbox.h>
#endif

#ifndef TKDEMO_INCLUDED
#include <tkdemo.h>
#endif



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Local Utilities							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS LOCAL AddListBoxExamples (
	WIN		parent,
	APP		app)
{
	STATUS			s;
	LIST_BOX_NEW	lbn;
	STRLB_NEW		slbn;
	FONTLB_NEW		flbn;

	AddLabel(parent, "List Box");
	ObjCallRet(msgNewDefaults, clsListBox, &lbn, s);
	lbn.listBox.client = app;
	lbn.listBox.nEntries = 20;
	ObjCallRet(msgNew, clsListBox, &lbn, s);
	lbn.win.parent = parent;
	ObjCallRet(msgWinInsert, lbn.object.uid, &lbn.win, s);

	AddLabel(parent, "String List Box, Toggles");
	ObjCallRet(msgNewDefaults, clsStringListBox, &slbn, s);
	slbn.listBox.style.filing = lbFileEntryInfo;
	slbn.listBox.client = app;
	slbn.listBox.nEntries = 20;
	ObjCallRet(msgNew, clsStringListBox, &slbn, s);
	slbn.win.parent = parent;
	ObjCallRet(msgWinInsert, slbn.object.uid, &slbn.win, s);

	AddLabel(parent, "Font List Box, Choice");
	ObjCallRet(msgNewDefaults, clsFontListBox, &flbn, s);
	flbn.listBox.style.filing = lbFileMin;
	flbn.listBox.client = app;
	flbn.stringListBox.style.role = slbRoleChoice01;
	flbn.stringListBox.style.look = slbLookDecorate;
	ObjCallRet(msgNew, clsFontListBox, &flbn, s);
	flbn.win.parent = parent;
	ObjCallRet(msgWinInsert, flbn.object.uid, &flbn.win, s);

	return stsOK;

} /* AddListBoxExamples */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Global Utilities						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS GLOBAL TkDemoAddListBoxesCard (
	WIN		swin,
	WIN		tabBar,
	APP		app)
{
	STATUS				s;
	OPTION_TABLE_NEW	otn;

	// Create the card window.
	ObjCallRet(msgNewDefaults, clsOptionTable, &otn, s);
	otn.tableLayout.style.growChildWidth = true;
	otn.tableLayout.colWidth.constraint = tlAbsolute;
	otn.tableLayout.colWidth.value = 80;
	otn.tableLayout.colWidth.valueUnits = bsUnitsLayout;
	ObjCallRet(msgNew, clsOptionTable, &otn, s);

	// Add it to the scrollwin.
	ObjCallRet(msgScrollWinAddClientWin, swin, (P_ARGS) otn.object.uid, s);

	// Create and add a corresponding tab.
	StsRet(AddTab(tabBar, "List Boxes", otn.object.uid), s);

	// fill the card with border examples
	StsRet(AddListBoxExamples(otn.object.uid, app), s);

	return stsOK;

	Unused(app);

} /* TkDemoAddListBoxesCard */


MsgHandlerArgType(TkDemoLBProvideEntry, P_LIST_BOX_ENTRY)
{
	STATUS				s;
	LIST_BOX_METRICS	metrics;
	U8					buf[40];
	LABEL_NEW			ln;

	Dbg(Debugf("tkdemo[%p]: msgListBoxProvideEntry", self);)

	ObjCallRet(msgListBoxGetMetrics, pArgs->listBox, &metrics, s);
	if (pArgs->position >= metrics.nEntries)
		return stsFailed;

	sprintf(buf, "Test String %d", pArgs->position);
	ObjCallWarn(msgNewDefaults, clsLabel, &ln);
	ln.win.flags.style |= wsParentClip;
	ln.win.flags.style &= ~(wsClipChildren | wsClipSiblings);
	ln.label.pString = buf;
	ObjCallRet(msgNew, clsLabel, &ln, s);

	pArgs->win = ln.object.uid;
	pArgs->freeEntry = lbFreeDataDefault;

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* TkDemoLBProvideEntry */


MsgHandler(TkDemoLBEntryGesture)
{
	Dbg(Debugf("tkdemo[%p]: msgListBoxEntryGesture", self);)

	return stsOK;
	MsgHandlerParametersNoWarning;
}


MsgHandlerArgType(TkDemoSLBProvideString, P_STRLB_PROVIDE)
{
	STATUS				s;
	LIST_BOX_METRICS	metrics;

	ObjCallRet(msgListBoxGetMetrics, pArgs->strListBox, &metrics, s);
	if (pArgs->position >= metrics.nEntries)
		return stsFailed;

	Dbg(Debugf("tkdemo[%p]: msgSLBProvideString", self);)
	sprintf(pArgs->pString, "Test String %d", pArgs->position);
	pArgs->data = (U32) pArgs->position;

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* TkDemoLBEntryGesture */

