/****************************************************************************
 File: tables.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.8  $
   $Author:   kcatlin  $
     $Date:   07 Feb 1992 17:19:18  $

 This file contains the clsTableLayout demoing code of the tkdemo application.
****************************************************************************/

#ifndef BORDER_INCLUDED
#include <border.h>
#endif

#ifndef OPTTABLE_INCLUDED
#include <opttable.h>
#endif

#ifndef SWIN_INCLUDED
#include <swin.h>
#endif

#ifndef TLAYOUT_INCLUDED
#include <tlayout.h>
#endif

#ifndef TKDEMO_INCLUDED
#include <tkdemo.h>
#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *									Constants							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Local Utilities	  					   	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS LOCAL AddLabelChild (
	WIN			parent,
	P_STRING	pString,
	BOOLEAN		wordWrap,
	U16			scaleUnits)
{
	STATUS		s;
	LABEL_NEW	ln;

	ObjCallRet(msgNewDefaults, clsLabel, &ln, s);
	ln.border.style.edge = bsEdgeAll;
	ln.label.style.xAlignment	= lsAlignCenter;
	ln.label.style.yAlignment	= lsAlignCenter;
	ln.label.style.scaleUnits	= scaleUnits;
	ln.label.pString			= pString;
	if (wordWrap) {
		ln.label.style.wordWrap = true;
		ln.label.style.numCols = lsNumAbsolute;
		ln.label.cols = 7;
	}
	ObjCallRet(msgNew, clsLabel, &ln, s);
	ln.win.parent = parent;
	ObjCallRet(msgWinInsert, ln.object.uid, &ln.win, s);

	return stsOK;

} /* AddLabelChild */


#if 0
STATUS LOCAL AddBorderChild (
	WIN		parent,
	S16		w,
	S16		h)
{
	STATUS		s;
	BORDER_NEW	bn;

	ObjCallRet(msgNewDefaults, clsBorder, &bn, s);
	bn.win.bounds.size.w = w;
	bn.win.bounds.size.h = h;
	bn.border.style.backgroundInk = bsInkGray66;
	ObjCallRet(msgNew, clsBorder, &bn, s);
	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	return stsOK;
}
#endif


STATUS LOCAL AddTableExamples (
	WIN	parent)
{
	STATUS			s;
	TBL_LAYOUT_NEW	tln;
	U8	child1[] = "Child 1";
	U8	child2[] = "Child 2 has a lot of text and is word wrapped";
	U8	child3[] = "Child 3 has a lot of text and is word wrapped";
	U8	child4[] = "Child 4";


	AddLabel(parent, "One Row, Two Columns, GroupMax Width, ChildrenMax Height");
	ObjCallRet(msgNewDefaults, clsTableLayout, &tln, s);
	tln.border.style.backgroundInk	= bsInkGray33;
	tln.border.style.leftMargin		= bsMarginMedium;
	tln.border.style.rightMargin	= bsMarginMedium;
	tln.border.style.bottomMargin	= bsMarginMedium;
	tln.border.style.topMargin		= bsMarginMedium;
	tln.tableLayout.rowHeight.gap			= 2;
	tln.tableLayout.colWidth.gap			= 2;
	ObjCallRet(msgNew, clsTableLayout, &tln, s);
	AddLabelChild(tln.object.uid, child1, false, bsUnitsLayout);
	AddLabelChild(tln.object.uid, child2, true, bsUnitsLayout);
	tln.win.parent = parent;
	ObjCallRet(msgWinInsert, tln.object.uid, &tln.win, s);

	AddLabel(parent, "Two Rows, One Column, ChildrenMax Width, GroupMax Height");
	ObjCallRet(msgNewDefaults, clsTableLayout, &tln, s);
	tln.border.style.backgroundInk	= bsInkGray33;
	tln.border.style.leftMargin		= bsMarginMedium;
	tln.border.style.rightMargin	= bsMarginMedium;
	tln.border.style.bottomMargin	= bsMarginMedium;
	tln.border.style.topMargin		= bsMarginMedium;
	tln.tableLayout.numCols.constraint		= tlAbsolute;
	tln.tableLayout.numCols.value			= 1;
	tln.tableLayout.numRows.constraint		= tlInfinite;
	tln.tableLayout.rowHeight.constraint	= tlGroupMax;
	tln.tableLayout.colWidth.constraint		= tlChildrenMax;
	tln.tableLayout.rowHeight.gap			= 2;
	tln.tableLayout.colWidth.gap			= 2;
	ObjCallRet(msgNew, clsTableLayout, &tln, s);
	AddLabelChild(tln.object.uid, child1, false, bsUnitsLayout);
	AddLabelChild(tln.object.uid, child2, true, bsUnitsLayout);
	tln.win.parent = parent;
	ObjCallRet(msgWinInsert, tln.object.uid, &tln.win, s);

	AddLabel(parent, "Two Rows, Two Columns, GroupMax Width and Height");
	ObjCallRet(msgNewDefaults, clsTableLayout, &tln, s);
	tln.border.style.backgroundInk	= bsInkGray33;
	tln.border.style.leftMargin		= bsMarginMedium;
	tln.border.style.rightMargin	= bsMarginMedium;
	tln.border.style.bottomMargin	= bsMarginMedium;
	tln.border.style.topMargin		= bsMarginMedium;
	tln.tableLayout.numRows.constraint		= tlAbsolute;
	tln.tableLayout.numRows.value			= 2;
	tln.tableLayout.numCols.constraint		= tlAbsolute;
	tln.tableLayout.numCols.value			= 2;
	tln.tableLayout.rowHeight.constraint	= tlGroupMax;
	tln.tableLayout.colWidth.constraint		= tlGroupMax;
	tln.tableLayout.rowHeight.gap			= 2;
	tln.tableLayout.colWidth.gap			= 2;
	ObjCallRet(msgNew, clsTableLayout, &tln, s);
	AddLabelChild(tln.object.uid, child1, false, bsUnitsLayout);
	AddLabelChild(tln.object.uid, child2, true, bsUnitsLayout);
	AddLabelChild(tln.object.uid, child3, true, bsUnitsLayout);
	AddLabelChild(tln.object.uid, child4, false, bsUnitsLayout);
	tln.win.parent = parent;
	ObjCallRet(msgWinInsert, tln.object.uid, &tln.win, s);

	AddLabel(parent, "One Row, Two Columns, MaxFit Width, GroupMax Height");
	ObjCallRet(msgNewDefaults, clsTableLayout, &tln, s);
	tln.win.flags.style &= ~wsShrinkWrapWidth;
	tln.win.bounds.size.w = 200;
	tln.border.style.backgroundInk	= bsInkGray33;
	tln.border.style.leftMargin		= bsMarginMedium;
	tln.border.style.rightMargin	= bsMarginMedium;
	tln.border.style.bottomMargin	= bsMarginMedium;
	tln.border.style.topMargin		= bsMarginMedium;
	tln.tableLayout.rowHeight.constraint	= tlGroupMax;
	tln.tableLayout.rowHeight.gap			= 2;
	tln.tableLayout.colWidth.constraint		= tlMaxFit;
	tln.tableLayout.colWidth.gap			= 2;
	ObjCallRet(msgNew, clsTableLayout, &tln, s);
	AddLabelChild(tln.object.uid, child1, false, bsUnitsFitWindowProper);
	AddLabelChild(tln.object.uid, child2, true, bsUnitsFitWindowProper);
	tln.win.parent = parent;
	ObjCallRet(msgWinInsert, tln.object.uid, &tln.win, s);

	return stsOK;

} /* AddTableExamples */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Global Utilities						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS GLOBAL TkDemoAddTablesCard (
	WIN		swin,
	WIN		tabBar,
	APP		app)
{
	STATUS				s;
	OPTION_TABLE_NEW	otn;

	// Create the card window.
	ObjCallRet(msgNewDefaults, clsOptionTable, &otn, s);

	//
	// default layout uses tlAlignBaseline, so change it to align the
	// children by their top edges.
	//
	otn.tableLayout.style.childYAlignment = tlAlignTop;
	ObjCallRet(msgNew, clsOptionTable, &otn, s);

	// Add it to the scrollwin.
	ObjCallRet(msgScrollWinAddClientWin, swin, (P_ARGS) otn.object.uid, s);

	// Create and add a corresponding tab.
	StsRet(AddTab(tabBar, "Tables", otn.object.uid), s);

	// fill the card with table examples
	StsRet(AddTableExamples(otn.object.uid), s);

	return stsOK;

	Unused(app);

} /* TkDemoAddTablesCard */


