/****************************************************************************
 File: apptag.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.33  $
     $Date:   24 Mar 1992 16:19:44  $

 This file contains constant tags used by the Application Framework.

 There are three kinds of tags in this file:
    -: Resource tags
    -: Window tags
    -: Quick help tags

 Resource tags are used to construct resource identifiers (resID's) that
 identify well-known resources in the system resource file.  Developers
 can use these tags to read a copy of any of these resources from their
 document's resList (see app.h and resfile.h).

 Window tags are used as arguments to msgWinFindTag to locate well-known
 windows. For example, all the standard application menus (SAMS) are
 tagged so they can be programatically located and changed or removed by
 an application.
 
 Quick help tags are used for two purposes: (1) to construct the resource
 identifier used to read a quick-help string from the document's resList,
 and (2) stored in clsGWin as the quick-help tag (see gwin.h).

 All the resource ids in this file are constructed by (see resfile.h):
//{
	MakeWknResId(resId, appResId, tag);
//}

 To write an object resource:
//{
	write.resId		= tagAppObject;
	write.mode		= resWriteObjectOnce;
	write.object	= objectToWrite;
	ObjCallRet(msgResWriteObject, file, &write, s);
//}

 To read an object resource:
//{ 
	ObjectCall(msgNewDefaults, clsObject, &read.new);
	read.resId	= tagAppObject;
	read.mode	= resReadObjectOnce;
	ObjCallRet(msgResReadObject, resList, &read, s);
	newObject = read.new.uid;
//}
****************************************************************************/
#ifndef APPTAG_INCLUDED
#define APPTAG_INCLUDED

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Resource Tags								   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****  clsApp Resource Identifiers  ****/
/*
 * Used to construct Application Framework resID's (see above).
 */
#define appResId									MakeTag(clsApp, 1)

// next: 194

/*
 * Tags used by StdMsg.
 */

#define tagAppDeleteRequest				        MakeDialogTag(clsAppMgr, 0)
#define tagAppDeleteSectRequest			        MakeDialogTag(clsAppMgr, 1)
#define tagAppRevertRequest				        MakeDialogTag(clsAppMgr, 2)
#define tagAppSystemShutdownRequest		        MakeDialogTag(clsAppMgr, 3)
#define tagAppSystemSoftShutdownRequest	        MakeDialogTag(clsAppMgr, 4)

/*
 * Miscellaneous tags.
 */
#define tagAppObject								MakeTag(clsApp, 138)
#define tagAppClass									MakeTag(clsApp, 118)
#define tagAppQHAppClass							MakeTag(clsApp, 155)
#define tagAppTitleBar								MakeTag(clsApp, 119)
#define tagAppMoveIconMarquee						MakeTag(clsApp, 135)
#define tagAppCopyIconMarquee						MakeTag(clsApp, 136)
#define tagAppPrintMetrics							MakeTag(clsApp, 139)
#define tagAppMenuImport							MakeTag(clsApp, 148)
#define tagAppMenuExport							MakeTag(clsApp, 149)

/*
 * These identify each item in the SAMS menu bar.
 */
#define tagAppMenuBar								MakeTag(clsApp, 1)
#define tagAppMenuDocument							MakeTag(clsApp, 2)
#define tagAppMenuEdit								MakeTag(clsApp, 3)
#define tagAppMenuOptions							MakeTag(clsApp, 4)
#define tagAppMenuCreate							MakeTag(clsApp, 156)

/*
 * These identify each item in the Document menu.
 */
#define tagAppMenuCheckpoint						MakeTag(clsApp, 5)
#define tagAppMenuRevert							MakeTag(clsApp, 6)
#define tagAppMenuPrint								MakeTag(clsApp, 7)
#define tagAppMenuPrintSetup						MakeTag(clsApp, 8)
#define tagAppMenuSend								MakeTag(clsApp, 9)
#define tagAppMenuAbout								MakeTag(clsApp, 10)

/*
 * These identify each item in the Edit menu.
 */
#define tagAppMenuUndo								MakeTag(clsApp, 11)
#define tagAppMenuSelectAll							MakeTag(clsApp, 12)
#define tagAppMenuMove								MakeTag(clsApp, 13)
#define tagAppMenuCopy								MakeTag(clsApp, 14)
#define tagAppMenuDelete							MakeTag(clsApp, 124)
#define tagAppMenuSearch							MakeTag(clsApp, 125)
#define tagAppMenuSpell								MakeTag(clsApp, 126)

/*
 * These identify SAMS option sheets.
 */
#define tagAppAboutOptSheet							MakeTag(clsApp, 120)
#define tagAppDocOptSheet							MakeTag(clsApp, 121)
#define tagAppPrintSetupOptSheet					MakeTag(clsApp, 122)
#define tagAppIconOptSheet							MakeTag(clsApp, 123)

/*
 * These identify each card in the Document option sheet.
 */
#define tagAppOptControlsCard						MakeTag(clsApp, 142)
#define tagAppOptAccessCard							MakeTag(clsApp, 143)
#define tagAppOptCommentsCard						MakeTag(clsApp, 144)
#define tagAppOptIconCard							MakeTag(clsApp, 147)
#define tagAppOptGotoButtonCard						MakeTag(clsApp, 154)
#define tagAppOptIconWinCard						MakeTag(clsApp, 172)

/*
 * These identify each card in the About option sheet.
 */
#define tagAppOptInfoCard							MakeTag(clsApp, 140)
#define tagAppOptAboutCard							MakeTag(clsApp, 141)

/*
 * These identify each card in the Print Setup option sheet.
 */
#define tagAppOptPrintCard							MakeTag(clsApp, 145)
#define tagAppOptHeadersCard						MakeTag(clsApp, 146)
#define tagAppOptEmbeddeeCard						MakeTag(clsApp, 173)

/*
 * These identify each item in the Borders & Controls card.
 */
#define tagAppOptCtrls 								MakeTag(clsApp, 127)
#define tagAppOptCtrlsLabel							MakeTag(clsApp, 128)
#define tagAppOptCtrlsOn							MakeTag(clsApp, 129)
#define tagAppOptCtrlsOff							MakeTag(clsApp, 130)
#define tagAppOptCtrlStyle							MakeTag(clsApp, 131)
#define tagAppOptCtrlStyleLabel						MakeTag(clsApp, 132)
#define tagAppOptCtrlTitleBar						MakeTag(clsApp, 133)
#define tagAppOptCtrlMenuBar						MakeTag(clsApp, 134)
#define tagAppOptCtrlScrollBars						MakeTag(clsApp, 26)
#define tagAppOptCtrlCorkMargin						MakeTag(clsApp, 27)
#define tagAppOptBorderStyle	 					MakeTag(clsApp, 157)
#define tagAppOptBorderStyleLabel					MakeTag(clsApp, 158)
#define tagAppOptBorderSingle						MakeTag(clsApp, 159)
#define tagAppOptBorderDouble						MakeTag(clsApp, 162)
#define tagAppOptBorderDashed						MakeTag(clsApp, 161)
#define tagAppOptBorderNone							MakeTag(clsApp, 160)

/*
 * These identify each item in the Access card.
 */
#define tagAppOptDelete								MakeTag(clsApp, 28)
#define tagAppOptDeleteLabel						MakeTag(clsApp, 29)
#define tagAppOptDeleteOn 							MakeTag(clsApp, 30)
#define tagAppOptDeleteOff							MakeTag(clsApp, 31)
#define tagAppOptReadOnly							MakeTag(clsApp, 32)
#define tagAppOptReadOnlyLabel						MakeTag(clsApp, 33)
#define tagAppOptReadOnlyOn		 					MakeTag(clsApp, 34)
#define tagAppOptReadOnlyOff						MakeTag(clsApp, 35)
#define tagAppOptHotMode 							MakeTag(clsApp, 36)
#define tagAppOptHotModeLabel						MakeTag(clsApp, 37)
#define tagAppOptHotModeOn 							MakeTag(clsApp, 38)
#define tagAppOptHotModeOff							MakeTag(clsApp, 39)

/*
 * These identify each item in the Comments card.
 */
#define tagAppOptCommentsTable						MakeTag(clsApp, 191)
#define tagAppOptTitle								MakeTag(clsApp, 40)
#define tagAppOptTitleLabel							MakeTag(clsApp, 41)
#define tagAppOptAuthor								MakeTag(clsApp, 42)
#define tagAppOptAuthorLabel						MakeTag(clsApp, 43)
#define tagAppOptComments							MakeTag(clsApp, 44)
#define tagAppOptCommentsSWin 						MakeTag(clsApp, 190)
#define tagAppOptCommentsLabel						MakeTag(clsApp, 45)

/*
 * These identify each item in the About/Document card.
 */
#define tagAppOptCreated							MakeTag(clsApp, 46)
#define tagAppOptCreatedLabel						MakeTag(clsApp, 47)
#define tagAppOptModified							MakeTag(clsApp, 48)
#define tagAppOptModifiedLabel						MakeTag(clsApp, 49)
#define tagAppOptFiledSize							MakeTag(clsApp, 50)
#define tagAppOptFiledSizeLabel						MakeTag(clsApp, 51)
#define tagAppOptActiveSize							MakeTag(clsApp, 52)
#define tagAppOptActiveSizeLabel					MakeTag(clsApp, 53)

/*
 * These identify each item in the About/Application card.
 */
#define tagAppOptApp								MakeTag(clsApp, 54)
#define tagAppOptAppLabel							MakeTag(clsApp, 55)
#define tagAppOptVersion							MakeTag(clsApp, 56)
#define tagAppOptVersionLabel						MakeTag(clsApp, 57)
#define tagAppOptCompany							MakeTag(clsApp, 58)
#define tagAppOptCompanyLabel						MakeTag(clsApp, 59)
#define tagAppOptCopyright							MakeTag(clsApp, 60)
#define tagAppOptCopyrightLabel						MakeTag(clsApp, 61)
#define tagAppOptIcon								MakeTag(clsApp, 62)
#define tagAppOptIconLabel							MakeTag(clsApp, 63)
#define tagAppOptIconSmall							MakeTag(clsApp, 64)
#define tagAppOptIconSmallLabel						MakeTag(clsApp, 65)

/*
 * These identify each item in the Icon Window Layout card.
 */
#define tagAppIconWinLayout							MakeTag(clsApp, 163)
#define tagAppIconWinLayoutLabel					MakeTag(clsApp, 164)
#define tagAppIconWinTToB							MakeTag(clsApp, 165)
#define tagAppIconWinBToT							MakeTag(clsApp, 166)
#define tagAppIconWinUnconstrained					MakeTag(clsApp, 167)
#define tagAppIconWinStyle							MakeTag(clsApp, 168)
#define tagAppIconWinStyleLabel						MakeTag(clsApp, 169)
#define tagAppIconWinKeepSame						MakeTag(clsApp, 170)
#define tagAppIconWinOpenInPlace					MakeTag(clsApp, 171)

/*
 * These identify each item in the Print Setup cards.
 */
#define tagAppPaperSize								MakeTag(clsApp, 66)
#define tagAppPaperSizeLabel						MakeTag(clsApp, 67)
#define	tagAppPaperWidth							MakeTag(clsApp, 68)
#define	tagAppPaperHeight							MakeTag(clsApp, 69)
#define tagAppTopMargin								MakeTag(clsApp, 70)
#define tagAppTopMarginLabel						MakeTag(clsApp, 71)
#define tagAppBottomMargin							MakeTag(clsApp, 72)
#define tagAppBottomMarginLabel						MakeTag(clsApp, 73)
#define tagAppLeftMargin							MakeTag(clsApp, 74)
#define tagAppLeftMarginLabel						MakeTag(clsApp, 75)
#define tagAppRightMargin							MakeTag(clsApp, 76)
#define tagAppRightMarginLabel						MakeTag(clsApp, 77)
#define tagAppLeftHeader							MakeTag(clsApp, 78)
#define tagAppLeftHeaderLabel						MakeTag(clsApp, 79)
#define tagAppCenterHeader							MakeTag(clsApp, 80)
#define tagAppCenterHeaderLabel						MakeTag(clsApp, 81)
#define tagAppRightHeader							MakeTag(clsApp, 82)
#define tagAppRightHeaderLabel						MakeTag(clsApp, 83)
#define tagAppLeftFooter							MakeTag(clsApp, 84)
#define tagAppLeftFooterLabel						MakeTag(clsApp, 85)
#define tagAppCenterFooter							MakeTag(clsApp, 86)
#define tagAppCenterFooterLabel						MakeTag(clsApp, 87)
#define tagAppRightFooter							MakeTag(clsApp, 88)
#define tagAppRightFooterLabel						MakeTag(clsApp, 89)
#define tagAppEmbedVisible							MakeTag(clsApp, 90)
#define tagAppEmbedVisibleLabel						MakeTag(clsApp, 91)
#define tagAppOrientation							MakeTag(clsApp, 92)
#define tagAppOrientationLabel						MakeTag(clsApp, 93)
#define tagAppHeaderMargin							MakeTag(clsApp, 94)
#define tagAppHeaderMarginLabel						MakeTag(clsApp, 95)
#define tagAppFooterMargin							MakeTag(clsApp, 96)
#define tagAppFooterMarginLabel						MakeTag(clsApp, 97)
#define tagAppHeaderFont							MakeTag(clsApp, 98)
#define tagAppHeaderFontLabel						MakeTag(clsApp, 99)
#define tagAppHeaderSize							MakeTag(clsApp, 100)
#define tagAppHeaderSizeLabel						MakeTag(clsApp, 101)
#define tagAppFirstPage								MakeTag(clsApp, 102)
#define tagAppFirstPageLabel						MakeTag(clsApp, 103)
#define tagAppOtherLabel							MakeTag(clsApp, 104)
#define tagAppEmbedLoc								MakeTag(clsApp, 174)
#define tagAppEmbedLocLabel							MakeTag(clsApp, 175)
#define tagAppEmbedApplyTo							MakeTag(clsApp, 176)
#define tagAppHeaderMarginOtherButton				MakeTag(clsApp, 177)
#define tagAppHeaderMarginOtherField				MakeTag(clsApp, 178)
#define tagAppFooterMarginOtherButton				MakeTag(clsApp, 179)
#define tagAppFooterMarginOtherField				MakeTag(clsApp, 180)
#define tagAppTopMarginOtherButton				    MakeTag(clsApp, 181)
#define tagAppTopMarginOtherField				    MakeTag(clsApp, 182)
#define tagAppBottomMarginOtherButton				MakeTag(clsApp, 183)
#define tagAppBottomMarginOtherField				MakeTag(clsApp, 184)
#define tagAppLeftMarginOtherButton				    MakeTag(clsApp, 185)
#define tagAppLeftMarginOtherField				    MakeTag(clsApp, 186)
#define tagAppRightMarginOtherButton				MakeTag(clsApp, 187)
#define tagAppRightMarginOtherField				    MakeTag(clsApp, 188)
#define tagAppEmbedApplyToLabel						MakeTag(clsApp, 192)

/*
 * These identify each item in the Icon option card.
 */
#define tagAppIconTitle								MakeTag(clsApp, 105)
#define tagAppIconTitleLabel						MakeTag(clsApp, 106)
#define tagAppIconOpen 								MakeTag(clsApp, 107)
#define tagAppIconOpenLabel							MakeTag(clsApp, 108)
#define tagAppIconOpenInPlace						MakeTag(clsApp, 109)
#define tagAppIconOpenFloating						MakeTag(clsApp, 110)
#define tagAppIconType 								MakeTag(clsApp, 111)
#define tagAppIconTypeLabel							MakeTag(clsApp, 112)
#define tagAppIconTypePictAndTitle					MakeTag(clsApp, 113)
#define tagAppIconTypePictOnly						MakeTag(clsApp, 114)
#define tagAppIconTypeSmallPictAndTitle				MakeTag(clsApp, 115)
#define tagAppIconTypeSmlPictOverTitle				MakeTag(clsApp, 116)
#define tagAppIconTypeSmallPictOnly					MakeTag(clsApp, 117)

/*
 * These identify each item in the Goto Button option card.
 */
#define tagAppGotoButtonTitle						MakeTag(clsApp, 150)
#define tagAppGotoButtonTitleLabel					MakeTag(clsApp, 151)
#define tagAppGotoButtonTargetDoc					MakeTag(clsApp, 152)
#define tagAppGotoButtonTargetDocLabel				MakeTag(clsApp, 153)
#define tagAppGotoButtonBorderLabel					MakeTag(clsApp, 154)
#define tagAppGotoButtonBorder						MakeTag(clsApp, 155)
#define tagAppGotoButtonSquare						MakeTag(clsApp, 156)
#define tagAppGotoButtonRound						MakeTag(clsApp, 157)
#define tagAppGotoButtonHRound						MakeTag(clsApp, 158)
#define tagAppGotoButtonNone						MakeTag(clsApp, 159)

/*
 * These identify various bitmaps.
 */
#define tagAppIconBitmap							MakeTag(clsApp, 15)
#define tagAppSmallIconBitmap						MakeTag(clsApp, 16)
#define tagAppDefaultDocIconBitmap					MakeTag(clsApp, 17)
#define tagAppDefaultDocSmallIconBitmap				MakeTag(clsApp, 18)
#define tagAppMoveIconBitmap						MakeTag(clsApp, 19)
#define tagAppCopyIconBitmap						MakeTag(clsApp, 20)
#define tagAppLinkIconBitmap						MakeTag(clsApp, 21)
#define tagAppClosedFolderBitmap					MakeTag(clsApp, 22)
#define tagAppClosedFolderSmBitmap					MakeTag(clsApp, 23)
#define tagAppOpenFolderBitmap						MakeTag(clsApp, 24)
#define tagAppOpenFolderSmBitmap					MakeTag(clsApp, 25)

/*
 * Tags used during the creation of a document to get default values
 * for some fields from the application resource file.
 */
#define tagAppMgrDefaultDocName						MakeTag(clsApp, 189)
#define tagAppMgrDisplayedAppName					MakeTag(clsApp, 193)

#endif	// APPTAG_INCLUDED
