/****************************************************************************

 File: bkshelf.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.48  $
   $Author:   DYEE  $
     $Date:   26 Feb 1992 13:37:48  $

 This file contains the API definition for clsDVBookshelf.
 clsDVBookshelf inherits from clsIconWin.

 It provides a view of bookshelves on external disks.

****************************************************************************/

#ifndef BKSHELF_INCLUDED
#define BKSHELF_INCLUDED

#ifndef APPWIN_INCLUDED
#include <appwin.h>
#endif // APPWIN_INCLUDED

#ifndef ICONWIN_INCLUDED
#include <iconwin.h>
#endif // ICONWIN_INCLUDED

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef struct BOOKSHELF_METRICS {
	U32					spare1;     // Spare: reserved.
	U32					spare2;     // Spare: reserved.
} BOOKSHELF_METRICS, *P_BOOKSHELF_METRICS;


/****************************************************************************
 msgNew						takes P_BOOKSHELF_NEW, returns STATUS
	category: class message
	Creates a new bookshelf viewer.
*/

typedef struct BOOKSHELF_NEW_ONLY {
	BOOKSHELF_METRICS	metrics;	// Initial metrics setting.
	OBJECT				rootDH;		// Dir handle of volume for this bkshelf.
    OBJECT              win;        // Window for move/copy.
	U32					reserved1;
	U32	   				reserved2;
} BOOKSHELF_NEW_ONLY, *P_BOOKSHELF_NEW_ONLY;

#define	bookshelfNewFields	\
	iconWinNewFields  		\
	BOOKSHELF_NEW_ONLY		bookshelf;

typedef struct BOOKSHELF_NEW {
	bookshelfNewFields
} BOOKSHELF_NEW, *P_BOOKSHELF_NEW;


/****************************************************************************
 msgBookshelfGetMetrics  		    takes P_BOOKSHELF_METRICS, returns STATUS
	Gets current metrics setting.
*/
#define msgBookshelfGetMetrics 					MakeMsg(clsDVBookshelf, 1)


/****************************************************************************
 msgBookshelfSetMetrics  		    takes P_BOOKSHELF_METRICS, returns STATUS
	Sets current metrics setting.
*/
#define msgBookshelfSetMetrics 					MakeMsg(clsDVBookshelf, 2)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Miscellaneous							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// "-- Empty --" label tag
#define tagBookshelfEmpty 			            MakeTag(clsDVBookshelf, 1) 
#define hlpBKBookshelfEmpty     	   		   	MakeTag(clsDVBookshelf, 100) 

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *	                            Private         						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define stsDVBookshelfVolNotDirIndexable        MakeStatus(clsDVBookshelf, 1)

#endif	// BKSHELF_INCLUDED
