/****************************************************************************
 File: itoggle.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.5  $
   $Author:   cmeyer  $
     $Date:   16 Mar 1992 17:34:48  $

 This file contains the API definition for clsIconToggle.

 clsIconToggle inherits from clsIcon.

 Icon toggles are toggle buttons with pictures for on and off states.
 These can be used to display an on/off mode switch.
****************************************************************************/
#ifndef ITOGGLE_INCLUDED
#define ITOGGLE_INCLUDED

												#ifndef ICON_INCLUDED
#include <icon.h>
												#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT ICON_TOGGLE;

typedef struct ICON_TOGGLE_STYLE {
	U16	spare	: 16;	// unused (reserved)
} ICON_TOGGLE_STYLE, *P_ICON_TOGGLE_STYLE;

/*
 * Default off/on picture tags
 * These are the resids for bitmaps in the system resource file
 * The default bitmaps represent "ink mode" for off (a picture of a pencil)
 * and "gesture mode" for on (a picture of a check mark)
 */
#define	tagIconToggleOff		MakeTag(clsIconToggle, 1)
#define	tagIconToggleOn			MakeTag(clsIconToggle, 2)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew		takes P_ICON_TOGGLE_NEW, returns STATUS
	category: class message
	Creates an icon toggle window.

 The fields you commonly set are:
	pArgs->iconToggle.offTag	picture tag to use when button is off
	pArgs->iconToggle.onTag		picture tag to use when button is on
*/

typedef struct ICON_TOGGLE_NEW_ONLY {
	ICON_TOGGLE_STYLE	style;	// overall style
	TAG					offTag;	// picture tag to use when off
	TAG					onTag;	// picture tag to use when on
	U32					spare1;	// unused (reserved)
	U32					spare2;	// unused (reserved)
} ICON_TOGGLE_NEW_ONLY, *P_ICON_TOGGLE_NEW_ONLY;

#define	iconToggleNewFields		\
	iconNewFields				\
	ICON_TOGGLE_NEW_ONLY		iconToggle;

typedef struct ICON_TOGGLE_NEW {
	iconToggleNewFields
} ICON_TOGGLE_NEW, *P_ICON_TOGGLE_NEW;


/****************************************************************************
 msgNewDefaults				takes P_ICON_TOGGLE_NEW, returns STATUS
	category: class message
	Initializes the ICON_TOGGLE_NEW structure to default values.

 Zeroes out pArgs->iconToggle and sets:
//{
	pArgs->gWin.style.gestureEnable	= false;

	pArgs->button.style.feedback	= bsFeedbackNone;
	pArgs->button.style.contact		= bsContactToggle;

	pArgs->icon.pictureSize.w	= 8
	pArgs->icon.pictureSize.h	= 8

	pArgs->iconToggle.offTag	= tagIconToggleOff;
	pArgs->iconToggle.onTag		= tagIconToggleOn;
//}

 Note that the default picture size is set to 8x8 layout units, which is
 the width and height of the system font.

 The default off and on tags represent bitmaps stored in the system resource
 file.  These are the bitmaps for "ink mode" (off) and "gesture mode" (on). 
*/

/****************************************************************************
 msgIconToggleGetStyle		takes P_ICON_TOGGLE_STYLE, returns STATUS
	Passes back the current style values.

*/
#define msgIconToggleGetStyle	MakeMsg(clsIconToggle, 1)


/****************************************************************************
 msgIconToggleSetStyle		takes P_ICON_TOGGLE_STYLE, returns STATUS
	Sets the style values.

*/
#define msgIconToggleSetStyle	MakeMsg(clsIconToggle, 2)


/****************************************************************************
 msgIconToggleGetOnTag		takes P_TAG, returns STATUS
	Passes back the onTag.

*/
#define msgIconToggleGetOnTag	MakeMsg(clsIconToggle, 3)

/****************************************************************************
 msgIconToggleGetOffTag		takes P_TAG, returns STATUS
	Passes back the offTag.

*/
#define msgIconToggleGetOffTag	MakeMsg(clsIconToggle, 4)


/****************************************************************************
 msgIconToggleSetOnTag		takes TAG, returns STATUS
	Sets the onTag.

 clsIconToggle will remember the onTag for use when the button is on.
 If the button is currently on, msgIconFreeCache will be self-sent to
 free the current picture bitmap and use the new one.
*/
#define msgIconToggleSetOnTag	MakeMsg(clsIconToggle, 5)

/****************************************************************************
 msgIconToggleSetOffTag		takes TAG, returns STATUS
	Sets the offTag.

 clsIconToggle will remember the offTag for use when the button is off.
 If the button is currently off, msgIconFreeCache will be self-sent to
 free the current picture bitmap and use the new one.
*/
#define msgIconToggleSetOffTag	MakeMsg(clsIconToggle, 6)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				    Messages from Other Classes							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgButtonShowFeedback		takes BOOLEAN, returns STATUS
	category: self-sent
	Shows the feedback for an on/off button if pArgs is true/false.

 clsIconToggle will free the old bitmap via msgIconFreeCache and cause
 the new one to be displayed by damaging the picture rectangle.
 The current feedback state will be remembered for use in
 msgIconProvideBitmap, at which time the picture tag will be set to either
 the onTag (pArgs == true) or the offTag (pArgs == false).

 See Also
 	msgIconProvideBitmap
*/

/****************************************************************************
 msgIconProvideBitmap		takes P_ICON_PROVIDE_BITMAP, returns STATUS
	category: client notification
	Sent to control client when icon needs the picture bitmap.

 clsIconToggle will alter pArgs->tag to be onTag if the current feedback
 state is on, or the offTag otherwise.  This results in the client of the
 icon receiving this message and providing the on or off bitmap.
*/

#endif	// ITOGGLE_INCLUDED
