/****************************************************************************
 File: openserv.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.55  $
   $Author:   sisaac  $
     $Date:   02 Mar 1992 10:08:52  $

 This file contains the API definition for clsOpenServiceObject.
 clsOpenServiceObject inherits from clsStream.
 Provides default behavior for open service objects.
 
 All open service object classes must be a subclass of clsOpenServiceObject.
 This superclass forwards all clsService messages to the actual service
 instance. It also allows a subclass to easily get the service instance
 that it is associated with.
****************************************************************************/
#ifndef OPENSERV_INCLUDED
#define OPENSERV_INCLUDED

#ifndef STREAM_INCLUDED
#include <stream.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  				  	Messages  		  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew				takes P_OSO_NEW, returns STATUS
	category: class message
	Creates a new service object. 

*/

typedef struct OSO_NEW_ONLY {
	OBJECT					serviceInstance;	// This is filled in by
												// clsService at open time.
	U32						unused1;
	U32						unused2;
	U32						unused3;
	U32						unused4;
} OSO_NEW_ONLY, *P_OSO_NEW_ONLY, OSO_METRICS, *P_OSO_METRICS;

#define	openServiceObjectNewFields	\
	streamNewFields					\
	OSO_NEW_ONLY			openServiceObject;

typedef struct OSO_NEW {
	openServiceObjectNewFields	
} OSO_NEW, *P_OSO_NEW;


/****************************************************************************
 msgOSOGetServiceInstance 	  	takes P_OBJECT, returns STATUS
	Returns the service instance that this object is associated with.

*/
#define msgOSOGetServiceInstance   		MakeMsg(clsOpenServiceObject, 1)

#endif	// OPENSERV_INCLUDED

											
