/****************************************************************************
 File: prmargin.h

 Copyright 1992, GO Corporation, All Rights Reserved.

 $Revision:   1.8  $
   $Author:   kcatlin  $
     $Date:   24 Feb 1992 11:32:40  $

 This file contains the API for clsPrMargin. 

 clsPrMargin inherits from clsWin.
 Provides clipping of children.

****************************************************************************/

#ifndef PRMARGIN_INCLUDED
#define PRMARGIN_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif
#ifndef UID_INCLUDED
#include <uid.h>
#endif
#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif
#ifndef CLAYOUT_INCLUDED
#include <clayout.h>
#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				Common #defines and typedefs							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
 msgNew	takes P_PRMARGIN_NEW, returns STATUS
	Create a new object.

 The prmargin object handles msgCstmLayoutGetChildSpec and then
 sends it on to the client for adjustment of default layout behavior.
*/
typedef struct PRMARGIN_NEW_ONLY {
	OBJECT			client;	  	// object to adjust layout 
} PRMARGIN_NEW_ONLY, *P_PRMARGIN_NEW_ONLY;

#define	prMarginNewFields				\
	customLayoutNewFields				\
	PRMARGIN_NEW_ONLY		prMargin;

typedef struct PRMARGIN_NEW {
	prMarginNewFields
} PRMARGIN_NEW, *P_PRMARGIN_NEW;

/****************************************************************************
 msgPrMarginSetMetrics				takes P_PRMARGIN_METRICS, returns STATUS
 	Set the prMargin metrics.
	 
*/
typedef struct PRMARGIN_METRICS {
	OBJECT	client;
} PRMARGIN_METRICS, *P_PRMARGIN_METRICS;
#define msgPrMarginSetMetrics		MakeMsg(clsPrMargin, 1)

#endif

