/****************************************************************************
 File: servmisc.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.11  $
   $Author:   sisaac  $
     $Date:   02 Mar 1992 11:34:36  $

 This file contains additional API definitions for clsService.
 clsService inherits from clsStream.
 Provides default behavior for services.
 
 This header file defines auxiliary clsService messages that are not used by
 the majority of service clients.
****************************************************************************/
#ifndef SERVMISC_INCLUDED
#define SERVMISC_INCLUDED


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *	   							Owner Messages	  						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgSvcGetMyOwner		  	takes P_OBJECT, returns STATUS
	Gets the current owner of this service, if any.

 Passes back objNull if there is no current owner.
*/
#define msgSvcGetMyOwner		 	 	 		MakeMsg(clsService, 21)


/****************************************************************************
 msgSvcGetOwned		  	takes P_OBJECT, returns STATUS
	Passes back the item that this service owns.

 This message is only valid for autoOwnTarget services (style.autoOwnTarget
 is true).

 If this service has become the owner of its target then this message 
 passes back the item that it owns; otherwise it returns objNull.
*/
#define msgSvcGetOwned		 			 		MakeMsg(clsService, 31)


/****************************************************************************
 msgSvcOwnerReleaseRequested  	takes P_SVC_OWNED_NOTIFY, returns STATUS
    Is it OK to remove you as the owner of a service?

 A client sent msgSMSetOwner to a service manager for a service you currently
 own. See servmgr.h/msgSMSetOwner for details on the entire owner change 
 message protocol.

 You can veto the ownership change by returning anything other than stsOK or 
 stsNotUnderstood.

 The service must not be in use for the owner change to occur. If you have 
 the service open and want to give up ownership, you should close the service
 when you receive this message.

 This message must be passed to ancestor. 
*/
#define msgSvcOwnerReleaseRequested	 			MakeMsg(clsService, 38)

typedef struct SVC_OWNED_NOTIFY {
	OBJECT					ownedService; // The service or MIL conflict
										  //   group which will have its
										  //   owner changed.
	OBJECT					oldOwner;	  // The old owner.
	OBJECT					newOwner;	  // The proposed new owner.
	U8						reserved[16];
} SVC_OWNED_NOTIFY, *P_SVC_OWNED_NOTIFY;


/****************************************************************************
 msgSvcOwnerAcquireRequested  	takes P_SVC_OWNED_NOTIFY, returns STATUS
    Is it OK to make you the new owner of a service?

 A client sent msgSMSetOwner to a service manager, proposing that you be the
 new owner of a service. See servmgr.h/msgSMSetOwner for details on the 
 entire owner change message protocol.

 You can veto the ownership change by returning	anything other than stsOK or 
 stsNotUnderstood.

 This message must be passed to ancestor. 
*/
#define msgSvcOwnerAcquireRequested	 			MakeMsg(clsService, 39)


/****************************************************************************
 msgSvcOwnerAcquired	 	  	takes P_SVC_OWNED_NOTIFY, returns STATUS
	You are now the new owner of a service.

 A client sent msgSMSetOwner to a service manager and requested that you 
 become the new owner of the service. This message signifies that you are
 the new owner of the service. See servmgr.h/msgSMSetOwner for 
 details on the entire owner change message protocol.

 Any saved state that you have for the owned service should be restored 
 (typically via msgSvcSetMetrics).

 This message must be passed to ancestor. 
*/
#define msgSvcOwnerAcquired	 	 			MakeMsg(clsService, 29)


/****************************************************************************
 msgSvcOwnerReleased	 	  	takes P_SVC_OWNED_NOTIFY, returns STATUS
	You are no longer the owner of a service.

 A client sent msgSMSetOwner to a service manager for a service you currently
 own. This message signifies that you are no longer the owner of the service.
 See servmgr.h/msgSMSetOwner for details on the entire owner change 
 The ownership change actually happens when you return from this message. 

 Any state for the owned state that you are interested in preserving should be
 gotten (typically via msgSvcGetMetrics) and saved in your state file. You 
 can manipulate the service as its owner until you return from this message.

 This message must be passed to ancestor. 
*/
#define msgSvcOwnerReleased	 	 			MakeMsg(clsService, 30)


/****************************************************************************
  msgSvcChangeOwnerRequested 	  	takes P_SVC_OWNED_NOTIFY, returns STATUS
	Owner change request message.

 This message is sent to the service instance whose owner is being changed. 
 The service instance can veto the ownership change by returning anything 
 other than stsOK or stsNotUnderstood.

 This message must be passed to ancestor if the service does not
 want to veto the owner change. 
*/
#define msgSvcChangeOwnerRequested 	 			MakeMsg(clsService, 40)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  	  	   	Save Messages 		  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgSvcSaveRequested 	  	  	takes P_FS_FLAT_LOCATOR, returns STATUS
	Client asked to save this instance to external media.

 A client sent msgSMSave to a service manager.

 Default superclass behavior is to save the state file and the current
 target only. Subclasses should ensure that their state file is up to date 
 if they wish to make use of this behavior. Alternatively, subclasses can 
 not pass this message to ancestor and perform whatever form of save they 
 wish. 

 The pArgs references the parent directory in which this service instance 
 should be saved. If a node with the same name as the service instance
 already exists within this directory, default superclass behavior is to 
 overwrite the destination. Subclasses can perform other forms of behavior
 if the destination exists before passing this message to ancestor.

 This message does not have to be passed to ancestor.
*/
#define msgSvcSaveRequested 	 				MakeMsg(clsService, 34)


/****************************************************************************
 msgSvcClassLoadInstance	takes P_SVC_LOAD_INSTANCE, returns STATUS
	category: class message
	Loads an instance state file from disk and creates a new instance.

 This function copies the state node specified by pArgs->source into the 
 INST directory of the service and starts up an instance of the service on 
 this state file. This is very similar to what happens when a warm-boot 
 occurs, or when state nodes are automatically loaded when a service is 
 first installed.

 If a service instance with the same name already exists, default behavior 
 is to generate a unique name for the new service instance.

 Subclasses do not normally process this message, but can if they wish to
 change the exist behavior. 

 Return Value
	stsFSNodeNotFound:	source file not found.

 See Also 
	msgSMSave
	msgSvcSaveRequested
*/
#define msgSvcClassLoadInstance					MakeMsg(clsService, 47)

typedef struct SVC_LOAD_INSTANCE {
	FS_LOCATOR				source;		// Source state file location.
} SVC_LOAD_INSTANCE, *P_SVC_LOAD_INSTANCE;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 		  				  Class Metrics Messages						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgSvcGetClassMetrics		   	takes P_SVC_CLASS_METRICS, returns STATUS
	Gets metrics for the service class that controls this instance.

 Note: This message can also be sent directly to the service class.
*/
#define msgSvcGetClassMetrics 	 				MakeMsg(clsService, 23)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *	 	   				Instance Metrics Messages	  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgSvcGetMetrics	takes P_SVC_GET_SET_METRICS, returns STATUS
	Passes back the current configuration metrics.

 Configuration metrics are service specific. This interface allows the
 caller to find out how large the metrics set for a given service are.

 The caller should first send msgSvcGetMetrics with pArgs->len set to 0 to 
 get the actual size of	the metrics buffer. The caller should allocate a
 buffer of this size then send the message again.

 Subclasses that have configuration metrics must handle this message.
*/
#define msgSvcGetMetrics					   	MakeMsg(clsService, 32)

typedef struct SVC_GET_SET_METRICS {
	P_UNKNOWN				pMetrics;	// Out through Ptr: Metrics buffer.
	U16						len;		// In/Out: Metrics buffer size in
										//   bytes. If 0 then the actual 
										//   size is returned.
} SVC_GET_SET_METRICS, *P_SVC_GET_SET_METRICS;


/****************************************************************************
 msgSvcSetMetrics	takes P_SVC_GET_SET_METRICS, returns STATUS
	Sets the configuration metrics.

 Configuration metrics are service specific. The caller should set
 pArgs->len to the size that was returned from msgSvcGetMetrics when the
 metrics were originally gotten. A caller should never try and synthesize
 a metrics buffer; he should only pass back a buffer that was gottem from
 msgSvcGetMetrics.

 Subclasses can determine the version of a configuration buffer from its
 size. Subclasses should make sure that different versions of configuration
 information have different sizes.

 Subclasses	must update their state node when they handle this message.

 Subclasses that have configuration metrics must handle this message.
*/
#define msgSvcSetMetrics					   	MakeMsg(clsService, 33)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *		 				Service Manager Messages						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgSvcAddToManager	 		takes P_SVC_ADD_TO_MANAGER, returns STATUS
	Add this service instance to a service manager. 

 This message allows a service to add itself to additional service managers
 after msgNew time.

 This results in msgIMInstalled being sent to observers of the service 
 manager.
*/
#define msgSvcAddToManager	   		 			MakeMsg(clsService, 17)

typedef struct SVC_ADD_TO_MANAGER {
	OBJECT					manager; 
} SVC_ADD_TO_MANAGER, *P_SVC_ADD_TO_MANAGER;


/****************************************************************************
 msgSvcRemoveFromManager takes P_SVC_REMOVE_FROM_MANAGER, returns STATUS
	Removes this service instance from a service manager. 

 This message allows a service to remove itself from a service manager it
 is currently on.

 This results in msgIMDeinstalled being sent to observers of the service
 manager and any objects which have bound to this service. It cleans up 
 this service's bind list, removing anyone who bound via the specified 
 service manager. 

 Note: service managers automatically remove a service when the 
 service class is deinstalled. There is no need to do so explicitly. 

 Return Value
	stsNoMatch:		Service instance is not on the specified service manager.
*/
#define msgSvcRemoveFromManager	   	 			MakeMsg(clsService, 18)

typedef struct SVC_REMOVE_FROM_MANAGER {
	OBJECT					manager;		// Manager to remove self from
} SVC_REMOVE_FROM_MANAGER, *P_SVC_REMOVE_FROM_MANAGER;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *			 				Client List Messages	 					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgSvcGetBindList 	  			takes P_SVC_GET_LIST, returns STATUS
	Gets a list of all the callers that have bound to this service.

*/
#define msgSvcGetBindList	 	 				MakeMsg(clsService, 26)

typedef struct SVC_GET_LIST {
	P_OBJECT				pList;	// Out: list, allocated from process heap.
									//  CLIENT MUST OSHeapBlockFree WHEN 
									//  FINISHED!
	U16						count;	// Out: number of elements in list
} SVC_GET_LIST, *P_SVC_GET_LIST;


/****************************************************************************
 msgSvcGetOpenList 	  		takes P_SVC_GET_LIST, returns STATUS
	Gets a list of all the callers that have opened this service.

 See Also
	msgSvcGetOpenObjectList
*/
#define msgSvcGetOpenList	 	 				MakeMsg(clsService, 27)


/****************************************************************************
 msgSvcGetOpenObjectList  	takes P_SVC_GET_LIST, returns STATUS
	Gets a list of the open objects which were returned for each open.

 This list is ordered the same as the open list. The caller in openlist[i]
 was given the object in openObjectList[i].

 See Also
	msgSvcGetOpenList
*/
#define msgSvcGetOpenObjectList	 				MakeMsg(clsService, 49)


/****************************************************************************
 msgSvcGetManagerList 	  	takes P_SVC_GET_LIST, returns STATUS
	Gets a list of all the service managers that this service is on.

 See Also
	msgSvcGetManagerHandleList
*/
#define msgSvcGetManagerList	  				MakeMsg(clsService, 28)


/****************************************************************************
 msgSvcGetManagerHandleList 	  	takes P_SVC_GET_LIST, returns STATUS
	Gets a list of the svc mgr handles that this service is represented by.

 This list is ordered the same as the manager list. The handle in 
 handleList[i] is this service's handle in serviceManagerList[i].

 See Also
	msgSvcGetManagerList
*/
#define msgSvcGetManagerHandleList	  	  		MakeMsg(clsService, 50)


/****************************************************************************
 msgSvcGetDependentAppList 	  	takes P_SVC_GET_LIST, returns STATUS
	Gets a list of theInstalledApps handles for all dependent apps.

*/
#define msgSvcGetDependentAppList	  	  		MakeMsg(clsService, 51)


/****************************************************************************
 msgSvcGetDependentServiceList 	  	takes P_SVC_GET_LIST, returns STATUS
	Gets a list of theInstalledServices handles for all dependent services.

*/
#define msgSvcGetDependentServiceList  	  		MakeMsg(clsService, 52)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 		  		  Deinstallation/Destruction Messages					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgSvcClassTerminateOK			takes P_OBJECT, returns STATUS
	category: class message
	Deinstalls the entire service.

 Deinstallation is a two-phase process. The first phase allows any of the
 services or apps being deinstalled to cancel the entire deinstall. 
 msgSvcClassTerminateOK is the veto phase. Returning anything other than 
 stsOK signifies a veto. If anyone vetos the deinstall then 
 msgSvcClassTerminateVetoed is sent to all services that were sent 
 msgSvcClassTerminateOK. If nobody vetos the deinstall then 
 msgSvcClassTerminate is sent.

 The pArgs to msgSvcClassTerminateOK is used to pass back the object which is 
 responsible for the veto.

 Default superclass behavior is to send msgSvcDeinstallRequested to each 
 instance of the service, and veto the deinstallation if any service instance
 vetos the deinstallation. The uid of the instance that vetoed the deinstall
 is passed back via the pArgs. 

 This approach allows multiple services and applications that are dependent
 on each other to be deinstalled in a coherent fashion. 

 Subclasses can override this message if they wish.

 See Also
	msgSvcDeinstall
	msgSvcClassTerminateVetoed
	msgSvcClassTerminate 
*/
#define msgSvcClassTerminateOK					MakeMsg(clsService, 43)


/****************************************************************************
 msgSvcClassTerminateVetoed		takes P_SVC_TERMINATE_VETOED, returns STATUS
	category: class message
	Deinstall process was vetoed.

 This message informs the service that the deinstallation sequence that
 started with msgSvcClassTerminateOK has been vetoed by one of the services
 or applications that was part of the deinstall.

 pArgs->vetoer gives the uid of the object or class which vetoed the
 deinstall. pArgs->status gives the return status of the veto.

 Default superclass behavior is to send msgSvcDeinstallVetoed to each 
 instance of the service.

 Subclasses can override this message if they wish.

 See Also
	msgSvcDeinstallVetoed
	msgSvcClassTerminateOK
	msgSvcClassTerminate 
*/
#define msgSvcClassTerminateVetoed 				MakeMsg(clsService, 45)

typedef struct SVC_TERMINATE_VETOED {
	OBJECT					vetoer;	// Object that vetoed the deinstall.
	STATUS					status;	// Veto status.
} SVC_TERMINATE_VETOED, *P_SVC_TERMINATE_VETOED;


/****************************************************************************
 msgSvcClassTerminate		takes pNull, returns STATUS
	category: class message
	Terminate the service.

 Unconditionally terminate the service. All applications and services
 that are to be deinstalled have agreed to the deinstallation.

 Default superclass behavior is to send msgDestroy to each instance of the 
 service.

 Subclasses must pass this message to ancestor.

 See Also
	msgDestroy
	msgSvcClassTerminateOK
	msgSvcClassTerminateVetoed
*/
#define msgSvcClassTerminate 				MakeMsg(clsService, 24)


/****************************************************************************
  msgSvcClientDestroyedEarly  	takes OBJECT, returns STATUS
	An active client was destroyed.

 This message is sent to the service instance when a caller or service
 owner terminates unexpectedly. The pArgs is the uid of the caller or
 owner.

 Superclass behavior is to clean up the service instance by sending 
 msgSMUnbind, msgSMClose and msgSMSetOwner to self as appropriate.

 Services that keep their own per-client information will need to process
 this message in order to clean up their state.

 This message must be passed to ancestor. 
*/
#define msgSvcClientDestroyedEarly 	 			MakeMsg(clsService, 48)


/****************************************************************************
 msgSvcDeinstallRequested 	  	takes pNull, returns STATUS
	Client asked to destroy this service instance.

 A client has sent msgSMDeinstall to a service manager (to get rid of
 just this service instance), or the entire service class is being
 deinstalled.

 Deinstallation is a two phase process. All service instances that are
 going to be deinstalled are sent msgSvcDeinstallRequested. Each service
 has the chance to veto the deinstall by returning an error status. If
 all parties agree to the deinstall then msgFree is sent to each service
 instance. msgFree cannot be vetoed. It causes the service to be removed
 from all service managers.	

 If anybody vetos the deinstall then msgSvcDeinstallVetoed is sent to each
 service that is part of the deinstall process.	Services should not accept
 any new clients while a deinstall is in process. msgSvcDeinstallVetoed
 indicates that new clients can once again be accepted.
 
 Default superclass behavior is to veto the deinstall if the service is
 in use (open). The superclass will also handle new client rejection while
 a deinstall is in process if it gets this message.

 This message must be passed to ancestor.

 Note: A service might get msgSvcDeinstallRequested more than once for a
 given deinstallation sequence.
*/
#define msgSvcDeinstallRequested 	 			MakeMsg(clsService, 8)


/****************************************************************************
 msgSvcDeinstallVetoed 	  	takes P_SVC_DEINSTALL_VETOED, returns STATUS
	Deinstallation process was vetoed.

 One of the objects or classes in the deinstall process decided to veto
 the deinstall. 

 Services can once again accept new clients.
 
 This message must be passed to ancestor.
*/
#define msgSvcDeinstallVetoed	 	 			MakeMsg(clsService, 47)

typedef struct SVC_DEINSTALL_VETOED {
	OBJECT					vetoer;	// Object that vetoed the deinstall.
	STATUS					status;	// Veto status.
} SVC_DEINSTALL_VETOED, *P_SVC_DEINSTALL_VETOED;


/****************************************************************************
 msgDestroy			takes OBJ_KEY, returns STATUS
	Frees a service instance.

 Subclasses should destroy all dynamic resources. Warning: Do not destroy
 any clsService resources, such as the state node handle!

 WARNING: Clients must NEVER send msgDestroy directly to a service instance; 
 instead they should send msgIMDeinstall to a service manager which the 
 service instance is on.

 Note that service manager message msgSMRemoveReference allows a service
 instance to be removed from a single service manager without removing it
 from other service managers, or destroying the instance. See servmgr.h for
 details on msgIMDeinstall and msgSMRemoveReference.
*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *		 					Miscellenous Messages						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgSvcGetStyle					  	takes P_SVC_STYLE, returns STATUS
	Returns current style settings.

*/
#define msgSvcGetStyle						  	MakeMsg(clsService, 10)


/****************************************************************************
 msgSvcSetStyle					  	takes P_SVC_STYLE, returns STATUS
	Changes style settings.

*/
#define msgSvcSetStyle				 			MakeMsg(clsService, 11)


/****************************************************************************
 msgSvcGetFunctions	takes P_SVC_GET_FUNCTIONS, returns STATUS
	Passes back a pointer to a table of function entry points.

 This is for services that cannot afford the overhead of being accessed
 via object calls. The format of this pointer block is up to the subclass.
 Default superclass behavior is to set pFunctions to pNull, which means
 this service doesn't provide a table.

 Subclasses should handle this message if they wish to provide a function
 interface to their service.

 Default superclass behavior is to set pArgs->pFunctions to pNull and
 pArgs->info to 0.
*/
#define msgSvcGetFunctions					   	MakeMsg(clsService, 1)

typedef struct SVC_GET_FUNCTIONS {
	P_UNKNOWN				pFunctions;		// Out: Pointer to function table.
	U32						info;			// Out: service-specific info.
} SVC_GET_FUNCTIONS, *P_SVC_GET_FUNCTIONS;


/****************************************************************************
 msgSvcGetName	    	takes P_SVC_GET_NAME, returns STATUS
	Gets the name of this service instance. 

*/
#define msgSvcGetName		 	 				MakeMsg(clsService, 22)
															  
typedef struct SVC_GET_NAME {
	P_STRING				pName;		// Out: caller must allocate 
										//   nameBufLength buffer here
} SVC_GET_NAME, *P_SVC_GET_NAME;


/****************************************************************************
  msgSvcNameChanged		 	  	takes pNull, returns STATUS
	The service's name has been changed.

 This message is self-sent to the service instance when its name is changed.
 This occurs when msgIMSetName is sent to a service manager that this
 service is on.

 The service is already set to the new name when this message is 
 recieved. msgSvcGetName can be used to get the new name.

 This message is informational only. It does not have to be passed to
 ancestor.
*/
#define msgSvcNameChanged		 	 			MakeMsg(clsService, 55)


/****************************************************************************
 msgSvcPropagateMsg 	  	takes P_SVC_PROPAGATE_MSG, returns STATUS
	Propagates a service-specific message.

 This message allows services to send their own informational messages to 
 everyone who is bound to the service and everyone who is an observer of 
 any service manager that this service is on. This is similar to what the
 system does with messages like msgSMConnectedChanged.

 The first two arguments of the pArgs of your notification message must be:

	OBJECT				manager;	// manager that sent notification
	IM_HANDLE			handle;		// handle to service

 msgSvcPropagateNotify will fill these in with the correct service manager
 and handle for all of the observers. For example:

 typedef struct FOO_NOTIFY {
	OBJECT				manager;	// svc manager that sent notification.
	OBJECT				handle;		// handle to service.
	FOO					newFoo;		// new foo.
	FOO					oldFoo;		// old foo.
 } FOO_NOTIFY, *P_FOO_NOTIFY;

 FOO_NOTIFY			fooNotify;
 SVC_PROPAGATE_MSG	propagate;

 propagate.pArgs = fooNotify;
 propagate.pArgsSize = SizeOf(fooNotify);
 propagate.msg = msgFoo;
 ObjCallRet(msgSvcPropagateMsg, self, &propagate, s);
*/
#define msgSvcPropagateMsg	 			   		MakeMsg(clsService, 25)

 typedef struct SVC_PROPAGATE_MSG {
	P_ARGS				pArgs;
	SIZEOF				pArgsSize;
	MESSAGE				msg;
 } SVC_PROPAGATE_MSG, *P_SVC_PROPAGATE_MSG;


/****************************************************************************
 msgSvcAutoDetectingHardware			takes P_BOOLEAN, returns STATUS
	Is the hardware that this service ultimately talks to auto-detecting?
 
 This message is propogated to this service's target, then the target's 
 target, etc. until it finds the service which actually interfaces to 
 hardware (has no target). The hardware interface service is then asked
 if it can autodetect connect/disconnect.

 Return Value
	stsSvcValidConnectStyleNotFound:	target chain ended without reaching
										hardware service instance.
*/
#define msgSvcAutoDetectingHardware	 			MakeMsg(clsService, 37)


/****************************************************************************
 msgSvcClassPopUpOptionSheet	takes pNull, returns STATUS
	category: class message
	Creates an option sheet for the service's global options and pops it up.

 The option sheet is only displayed if this is the first time the service
 is installed. 

 Subclasses do not normally process this message.
*/
#define msgSvcClassPopUpOptionSheet				MakeMsg(clsService, 57)


/****************************************************************************
 msgSvcClassGetInstallDir			takes P_OBJECT, returns STATUS
	Creates a directory handle on the service's installation directory.

 The service class creates a clsDirHandle object which references the
 location on external media that the service was installed from.
 If the external volume is not connected, the user is asked to attach it. 

 If this service was bundled with PenPoint then there is no valid
 external volume beyond installation time. stsFailed is returned in
 this case.

 NOTE: CALLER IS RESPONSIBLE FOR DESTROYING THE DIR HANDLE WHEN DONE.

 Return Value
	stsOK					The external volume is attached.
	stsFSVolDisconnected	The user tapped the Cancel button when prompted
							to attach the external volume.
	stsFailed				The external volume cannot be determined because
							this application was bundled with PenPoint.

 Descendants: You normally do not handle this message.
*/
#define msgSvcClassGetInstallDir	 	 		MakeMsg(clsService, 58)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *	 						Notification Messages						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgSvcTargetChanged	  	takes P_SVC_TARGET_CHANGE_NOTIFY, returns STATUS
	category: observer notification
	A service's target has changed.

 This message is broadcast to all service managers that this service
 is on.
*/
#define msgSvcTargetChanged		  	  		MakeMsg(clsService, 53)

typedef struct SVC_TARGET_CHANGE_NOTIFY {
	OBJECT				manager;	// svc manager that sent notification.
	OBJECT				handle;		// handle to service.
	SVC_TARGET			oldTarget;	// old target.
	SVC_TARGET			newTarget;	// new target.
} SVC_TARGET_CHANGE_NOTIFY, *P_SVC_TARGET_CHANGE_NOTIFY;

#endif	// SERVMISC_INCLUDED

