/****************************************************************************
 tile.h
 Copyright 1992, GO Corporation, All Rights Reserved

 Interface to the pop-up tiling routine.
 
 The functions described in this file are contained in MISC.LIB. 
													   
 $Revision:   1.3  $
   $Author:   bschwart  $
     $Date:   06 Mar 1992 14:06:30  $
****************************************************************************/
#ifndef TILE_INCLUDED
#define TILE_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif
#ifndef GEO_INCLUDED
#include <geo.h>
#endif


typedef enum {
    tileAbove,  // above the target
    tileBelow,  // below the target
    tileLeft,   // to the left of the target
    tileRight   // to the right of the target
} TILE_LOCATOR;

/****************************************************************************
 TilePopUp	returns STATUS
  Center a rectangle under (over/to the left/right of) another rectangle
  but staying inside the bounds of a third rectangle.

  	This routine makes it easy to position pop-up windows next to existing
  	windows or screen regions.  pPop->origin is set to the best position to
  	place that rectangle.  For example, if you want to center a popup window
  	under a selected word but stay inside theRootWindow, you'd set preferred
	to tileBelow, pPop->size to the size of the new window, pTarget to the
	RECT32 containing the selection, and pWorld	to pNull.  If a window of
	that size can be centered below pTarget, TilePopUp will return the
	origin to insert it at.  If it won't fit below, but it will fit above,
	it will give THAT position.  If it will fit below, but not centered,
	it will sacrifice centering to keep it all on screen.

  	All rects are assumed to be relative to the same origin.  You still
	have to actually position and insert the actual window; this just
	tells you where to put it.
*/
STATUS PASCAL TilePopUp(
    TILE_LOCATOR preferred,     // preferred location
    P_RECT32 pPop,              // In-Out rect to be manipulated
    P_RECT32 pTarget,           // anchor rect
    P_RECT32 pWorld             // surrounding rect, base for pop & target
                                // use pNull for theRootWindow
);

#endif

