/****************************************************************************
 File: tkfield.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.28  $
   $Author:   cmeyer  $
     $Date:   18 Mar 1992 16:59:00  $

 This file contains the API definitions for clsDateField, clsFixedField,
 clsIntegerField, and clsTextField.

 clsDateField inherits from clsField.
 Provides a field that treats its label string as a date.

 clsFixedField inherits from clsField.
 Provides a field that treats its label string as a number in hundredths.

 clsIntegerField inherits from clsField.
 Provides a field that treats its label string as an integer.

 clsTextField inherits from clsField.
 Provides a field that treats its label string as a string.

 These four classes are used mainly on option sheets.  Because these
 subclasses provide a simple API and somewhat limited functionality,
 clients should consider subclassing clsField rather than these.
****************************************************************************/

#ifndef TKFIELD_INCLUDED
#define TKFIELD_INCLUDED

												#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
												#endif
												#ifndef FIELD_INCLUDED
#include <field.h>
												#endif
#include <time.h>


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								  clsDateField							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*
 This section describes the API for clsDateField.
*/


/**** Debugging Flags ****/

/*
 The clsDateField debugging flag is 'K'.  Defined values are:

    flag0  (0x0001):    general
*/

/****  Common #defines and typedefs  ****/

#define stsDateFieldEmpty		MakeStatus(clsDateField, 1)
#define stsDateFieldInvalid		MakeStatus(clsDateField, 2)

// Date Flags
#define dfsMonthName	flag0
#define dfsFullName		flag1

typedef struct {
	U16		flags;
	U16		spare;
} DATE_FIELD_STYLE, *P_DATE_FIELD_STYLE;

/*
 Default DATE_FIELD_STYLE:
//{
	flags	= 0
//}
*/

typedef struct tm	TIME_DESC, *P_TIME_DESC;

/****************************************************************************
 msgNew			takes P_DATE_FIELD_NEW, returns STATUS
	category: class message
	Creates a date field.

 The fields you commonly set are:
	pArgs->dateField.style.flags:	appropriate flags
*/

typedef struct {
	DATE_FIELD_STYLE	style;
	U32					spare;
} DATE_FIELD_NEW_ONLY, *P_DATE_FIELD_NEW_ONLY;

#define dateFieldNewFields	\
	fieldNewFields			\
	DATE_FIELD_NEW_ONLY		dateField;

typedef struct DATE_FIELD_NEW {
	dateFieldNewFields
} DATE_FIELD_NEW, *P_DATE_FIELD_NEW;


/****************************************************************************
 msgNewDefaults					takes P_DATE_FIELD_NEW, returns STATUS
	category: class message
	Initializes the DATE_FIELD_NEW structure to default values.

 Zeroes out pArgs->dateField and sets:
//{
	pArgs->border.style.edge = bsEdgeNone;
	pArgs->border.style.borderInk = bsInkGray66;
	pArgs->field.style.editType = fstOverWrite;
//}
*/


/****************************************************************************
 msgDateFieldGetStyle			takes P_DATE_FIELD_STYLE, returns STATUS
	Passes back the receiver's style.
*/
#define msgDateFieldGetStyle	MakeMsg(clsDateField, 1)


/****************************************************************************
 msgDateFieldSetStyle			takes P_DATE_FIELD_STYLE, returns STATUS
	Sets the receiver's style.
*/
#define msgDateFieldSetStyle	MakeMsg(clsDateField, 2)


/****************************************************************************
 msgDateFieldGetValue			takes P_TIME_DESC, returns STATUS
	Passes back the receiver's value in the time descriptor.

 Return Value
	stsDateFieldEmpty:		field has no content (*pArgs not set).
	stsDateFieldInvalid:	field's content unrecognized (*pArgs not set).
*/
#define msgDateFieldGetValue	MakeMsg(clsDateField, 3)


/****************************************************************************
 msgDateFieldSetValue			takes P_TIME_DESC, returns STATUS
	Sets the receiver's label string from the time descriptor.
*/
#define msgDateFieldSetValue	MakeMsg(clsDateField, 4)


/****************************************************************************
 msgControlGetValue				takes P_U32, returns STATUS
	Passes back the receiver's value in YYYYMMDD format.

 Return Value
	stsDateFieldEmpty:		field has no content (*pArgs not set).
	stsDateFieldInvalid:	field's content unrecognized (*pArgs not set).
*/


/****************************************************************************
 msgControlSetValue				takes U32, returns STATUS
	Sets the receiver's label string from a U32 in YYYYMMDD format.
*/


/****************************************************************************
 msgControlSetDirty		takes BOOLEAN, returns STATUS
	Sets style.dirty.

 The date field will alter the ink of its bottom edge (if it has one)
 to bsInkBlack if dirty, bsInkGray66 if not.

 In PenPoint 1.0, clsDateField does not respond to msgControlSetStyle or
 msgControlSetMetrics to watch for the CONTROL_STYLE.enable bit changing.
*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								 clsFixedField							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*
 This section describes the API for clsFixedField.
*/

/****  Common #defines and typedefs  ****/

#define stsFixedFieldEmpty		MakeStatus(clsFixedField, 1)
#define stsFixedFieldInvalid	MakeStatus(clsFixedField, 2)

typedef struct {
	U16		flags;
	U16		spare;
} FIXED_FIELD_STYLE, *P_FIXED_FIELD_STYLE;

/****************************************************************************
 msgNew			takes P_FIXED_FIELD_NEW, returns STATUS
	category: class message
	Creates a fixed field.
*/

typedef struct {
	FIXED_FIELD_STYLE	style;
	U32					spare;
} FIXED_FIELD_NEW_ONLY, *P_FIXED_FIELD_NEW_ONLY;

#define fixedFieldNewFields	\
	fieldNewFields			\
	FIXED_FIELD_NEW_ONLY	fixedField;

typedef struct FIXED_FIELD_NEW {
	fixedFieldNewFields
} FIXED_FIELD_NEW, *P_FIXED_FIELD_NEW;


/****************************************************************************
 msgNewDefaults					takes P_FIXED_FIELD_NEW, returns STATUS
	category: class message
	Initializes the FIXED_FIELD_NEW structure to default values.

 Zeroes out pArgs->fixedField and sets:
//{
	pArgs->border.style.edge = bsEdgeNone;
	pArgs->border.style.borderInk = bsInkGray66;
	pArgs->field.style.editType = fstOverWrite;
	pArgs->field.style.noSpace = true;
	pArgs->field.style.veto = true;
//}
*/


/****************************************************************************
 msgFixedFieldGetStyle			takes P_FIXED_FIELD_STYLE, returns STATUS
	Passes back the receiver's style.
*/
#define msgFixedFieldGetStyle	MakeMsg(clsFixedField, 1)


/****************************************************************************
 msgFixedFieldSetStyle			takes P_FIXED_FIELD_STYLE, returns STATUS
	Sets the receiver's style.
*/
#define msgFixedFieldSetStyle	MakeMsg(clsFixedField, 2)


/****************************************************************************
 msgControlGetValue				takes P_S32, returns STATUS
	Get the receiver's value as an S32 in hundredths.

 Return Value
	stsFixedFieldEmpty:		field has no content (*pArgs not set).
	stsFixedFieldInvalid:	field's content unrecognized (*pArgs not set).
*/


/****************************************************************************
 msgControlSetValue				takes S32, returns STATUS
	Sets the receiver's label string from a S32 in hundredths.
*/


/****************************************************************************
 msgControlSetDirty		takes BOOLEAN, returns STATUS
	Sets style.dirty.

 The fixed field will alter the ink of its bottom edge (if it has one)
 to bsInkBlack if dirty, bsInkGray66 if not.

 In PenPoint 1.0, clsFixedField does not respond to msgControlSetStyle or
 msgControlSetMetrics to watch for the CONTROL_STYLE.enable bit changing.
*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								clsIntegerField							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*
 This section describes the API for clsIntegerField.
*/

/****  Common #defines and typedefs  ****/

#define stsIntegerFieldEmpty	MakeStatus(clsIntegerField, 1)
#define stsIntegerFieldInvalid	MakeStatus(clsIntegerField, 2)

typedef struct {
	U16		flags;
	U16		spare;
} INTEGER_FIELD_STYLE, *P_INTEGER_FIELD_STYLE;

/****************************************************************************
 msgNew			takes P_INTEGER_FIELD_NEW, returns STATUS
	category: class message
	Creates an integer field.
*/

typedef struct {
	INTEGER_FIELD_STYLE	style;
	U32					spare;
} INTEGER_FIELD_NEW_ONLY, *P_INTEGER_FIELD_NEW_ONLY;

#define integerFieldNewFields	\
	fieldNewFields				\
	INTEGER_FIELD_NEW_ONLY		integerField;

typedef struct INTEGER_FIELD_NEW {
	integerFieldNewFields
} INTEGER_FIELD_NEW, *P_INTEGER_FIELD_NEW;


/****************************************************************************
 msgNewDefaults					takes P_INTEGER_FIELD_NEW, returns STATUS
	category: class message
	Initializes the INTEGER_FIELD_NEW structure to default values.

 Zeroes out pArgs->integerField and sets:
//{
	pArgs->border.style.edge = bsEdgeNone;
	pArgs->border.style.borderInk = bsInkGray66;
	pArgs->field.style.editType = fstOverWrite;
	pArgs->field.style.noSpace = true;
	pArgs->field.style.veto = true;
//}
*/


/****************************************************************************
 msgIntegerFieldGetStyle		takes P_INTEGER_FIELD_STYLE, returns STATUS
	Passes back the receiver's style.
*/
#define msgIntegerFieldGetStyle		MakeMsg(clsIntegerField, 1)


/****************************************************************************
 msgIntegerFieldSetStyle		takes P_INTEGER_FIELD_STYLE, returns STATUS
	Sets the receiver's style.
*/
#define msgIntegerFieldSetStyle		MakeMsg(clsIntegerField, 2)


/****************************************************************************
 msgControlGetValue				takes P_S32, returns STATUS
	Passes back the receiver's value as an S32.

 Return Value
	stsIntegerFieldEmpty:	field has no content (*pArgs not set).
	stsIntegerFieldInvalid:	field's content unrecognized (*pArgs not set).
*/


/****************************************************************************
 msgControlSetValue				takes S32, returns STATUS
	Sets the receiver's label string from a S32.
*/


/****************************************************************************
 msgControlSetDirty		takes BOOLEAN, returns STATUS
	Sets style.dirty.

 The integer field will alter the ink of its bottom edge (if it has one)
 to bsInkBlack if dirty, bsInkGray66 if not.

 In PenPoint 1.0, clsIntegerField does not respond to msgControlSetStyle or
 msgControlSetMetrics to watch for the CONTROL_STYLE.enable bit changing.
*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								  clsTextField							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*
 This section describes the API for clsTextField.
*/

/****  Common #defines and typedefs  ****/

typedef struct {
	U16		flags;
	U16		spare;
} TEXT_FIELD_STYLE, *P_TEXT_FIELD_STYLE;

/****************************************************************************
 msgNew			takes P_TEXT_FIELD_NEW, returns STATUS
	category: class message
	Creates a text field.
*/

typedef struct {
	TEXT_FIELD_STYLE	style;
	U32					spare;
} TEXT_FIELD_NEW_ONLY, *P_TEXT_FIELD_NEW_ONLY;

#define textFieldNewFields	\
	fieldNewFields			\
	TEXT_FIELD_NEW_ONLY		textField;

typedef struct TEXT_FIELD_NEW {
	textFieldNewFields
} TEXT_FIELD_NEW, *P_TEXT_FIELD_NEW;


/****************************************************************************
 msgNewDefaults					takes P_TEXT_FIELD_NEW, returns STATUS
	category: class message
	Initializes the TEXT_FIELD_NEW structure to default values.

 Zeroes out pArgs->textField and sets:
//{
	pArgs->border.style.edge = bsEdgeBottom;
	pArgs->border.style.borderInk = bsInkGray66;
//}
*/


/****************************************************************************
 msgTextFieldGetStyle			takes P_TEXT_FIELD_STYLE, returns STATUS
	Passes back the receiver's style.
*/
#define msgTextFieldGetStyle	MakeMsg(clsTextField, 1)


/****************************************************************************
 msgTextFieldSetStyle			takes P_TEXT_FIELD_STYLE, returns STATUS
	Sets the receiver's style.
*/
#define msgTextFieldSetStyle	MakeMsg(clsTextField, 2)


/****************************************************************************
 msgControlSetDirty		takes BOOLEAN, returns STATUS
	Sets style.dirty.

 The text field will alter the ink of its bottom edge (if it has one)
 to bsInkBlack if dirty, bsInkGray66 if not.

 In PenPoint 1.0, clsTextField does not respond to msgControlSetStyle or
 msgControlSetMetrics to watch for the CONTROL_STYLE.enable bit changing.
*/


#endif

