/****************************************************************************
 File: cwin.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.15  $
   $Author:   pstahl  $
     $Date:   16 Mar 1992 14:49:44  $

 This file contains the class definition and methods for clsClockWin.
****************************************************************************/
#include <methods.h>
#include <cwin.h>
#include <os.h>
#include <string.h>
#include <debug.h>
#include <clabel.h>
#include <sel.h>
#include <xgesture.h>
#include <embedwin.h>
#include <list.h>
#include <strobj.h>
#include <clockapp.h>
#include <xfer.h>

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * // 
//                           Utility Routines							   //
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

/****************************************************************************
	ClockWinLookSelected
	
	Select or un-select self and the children.
****************************************************************************/
STATUS LOCAL ClockWinLookSelected (
	OBJECT		self,
	BOOLEAN 	select)
{
	WIN_ENUM   	we;
	OBJECT		wins[10];
	U16			i;
	STATUS		s;


	// Recursively enum children self.
	we.max		= 10;
	we.count	= maxU16;
	we.pWin		= wins;
	we.pFlags	= pNull;
	we.flags	= wsEnumChildren | wsEnumRecursive;
	we.next		= 0;
	s = ObjectCall(msgWinEnum, self, &we);

	// Errors?
	if (s != stsOK AND s != stsEndOfData) {

		StsPrint(s);
		return s;
	}

	// Select all children that are clsClockLabels...
	for (i = 0; i < we.count; i++) {

		// Is this window of clsAppWin?
		s = ObjectCall(msgIsA, we.pWin[i], (P_ARGS)clsClockLabel);

		if (s == stsOK) {

			// Make it look selected or un-selected.
			ObjCallWarn(msgBorderSetSelected, we.pWin[i], (P_ARGS)select);
		}
	}

	// Free the enum buffer.
	if (we.pWin != (P_OBJECT)wins) {

		StsWarn(OSHeapBlockFree(we.pWin));
	}

	return stsOK;

}	// ClockWinLookSelected

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * // 
//                           clsObject Methods							   //
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

/****************************************************************************
	ClockWinNewDefaults
	
	Respond to msgNewDefaults.
****************************************************************************/
MsgHandlerArgType(ClockWinNewDefaults, P_TBL_LAYOUT_NEW)
{
	MsgHandlerParametersNoWarning;


	pArgs->border.style.getDeltaWin		= true;
	pArgs->border.style.selectedAlter	= bsAlterBackground;

	return stsOK;

}	// ClockWinNewDefaults

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //
//                           clsSelection Methods						   //
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

/****************************************************************************
	ClockWinSelSelect
	
	Respond to msgSelSelect
****************************************************************************/
MsgHandlerArgType(ClockWinSelSelect, P_ARGS)
{
	STATUS		s;
	MsgHandlerParametersNoWarning;


	// Are we selected?
	s = ObjectCall(msgSelIsSelected, self, pNull);

	// If we are already selected, toggle.
	if (s == stsOK) {

		ObjCallRet(msgSelSetOwner, theSelectionManager, pNull, s);
	}

	// Otherwise, take the selection and look selected.
	else {

		// Take the selection.
		ObjectCallAncestor(msg, self, pArgs, ctx);

		// Look selected.
		ClockWinLookSelected(self, true);
	}

	return stsOK;

}	// ClockWinSelSelect

/****************************************************************************
	ClockWinSelYield
	
	Respond to msgSelYield.
****************************************************************************/
MsgHandlerArgType(ClockWinSelYield, P_ARGS)
{
	MsgHandlerParametersNoWarning;


	// Yield the selection.
	ObjectCallAncestor(msg, self, pArgs, ctx);

	// Look un-selected.
	ClockWinLookSelected(self, false);

	return stsOK;

}	// ClockWinSelYield

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //
//                           clsXfer Methods						   	   //
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

/****************************************************************************
	ClockWinXferList
	
	Respond to msgXferList.
****************************************************************************/
MsgHandlerArgType(ClockWinXferList, P_ARGS)
{
	MsgHandlerParametersNoWarning;


	// Fill in the xfer list.
	ObjCallWarn(msgListAddItem, pArgs, (P_ARGS)xferLongString);
	//ObjCallWarn(msgListAddItem, pArgs, (P_ARGS)xferObject);

	return stsOK;

}	// ClockWinXferList

/****************************************************************************
	ClockWinXferGet
	
	Respond to msgXferGet.
****************************************************************************/
MsgHandlerArgType(ClockWinXferGet, P_ARGS)
{
	P_STRING 	pBuf;
	STATUS		s;
	U32			len;
	MsgHandlerParametersNoWarning;


	// xferLongString?
	if (((P_XFER_BUF)pArgs)->id == xferLongString) {

		// Get our string.  This alloc's a global buf.
		ObjCallRet(msgClockAppGetDisplayString, OSThisApp(), &pBuf, s);

		len = strlen(pBuf) + 1;

		// Return the string buffer.  Caller must free.
		((P_XFER_BUF)pArgs)->pBuf	= pBuf;
		((P_XFER_BUF)pArgs)->len	= len;

		return stsOK;
	}

#if 0
	// xferObject?
	else if (((P_XFER_OBJECT)pArgs)->id == xferObject) {

		STROBJ_NEW	sn;
		OBJECT		string;

		// Get our string.  This alloc's a global buf.
		ObjCallRet(msgClockAppGetDisplayString, OSThisApp(), &pBuf, s);

		// Create a string object.  Use msgObjectNew to create 
		// the new string object in the context of the receiver.  
		ObjectCall(msgNewDefaults, clsString, &sn);
		sn.strobj.pString = pBuf;
		ObjSendUpdateRet(msgObjectNew, ((P_XFER_OBJECT)pArgs)->receiver, &sn, SizeOf(sn), s);
		string = sn.object.uid;

		// Return the string object.  Caller must free.
		((P_XFER_OBJECT)pArgs)->uid			= string;
		((P_XFER_OBJECT)pArgs)->objClass	= clsString;

		// Free the string buf.
		OSHeapBlockFree(pBuf);

		return stsOK;
	}
#endif

	// Not our type...
	else {

		return ObjectCallAncestorCtx(ctx);
	}

	return stsOK;

}	// ClockWinXferGet

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //
//                           clsGWin Methods							   //
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

/****************************************************************************
	ClockWinProcessGesture
	
	Respond to msgGWinForwardedGesture.
****************************************************************************/
MsgHandlerArgType(ClockWinProcessGesture, P_GWIN_GESTURE)
{
	EMBEDDED_WIN_BEGIN_MOVE_COPY	bm;
	WIN_METRICS						wm;
	STATUS							s;
	OBJECT							selOwner;
	MsgHandlerParametersNoWarning;	

	ObjCallWarn(msgSelOwner, theSelectionManager, &selOwner);
												  
	switch(pArgs->msg) {

	case xgs1Tap:
	case xgsTGesture:
	case xgsPlus:
 		if(selOwner == self)
		   	ObjCallWarn(msgSelSetOwner, theSelectionManager, pNull);
 		else	   												  
			ObjCallWarn(msgSelSelect, self, pNull);				 

		return stsOK;

	case xgsPressHold:
	case xgsTapHold:

		// Get self's bounds.
		ObjCallRet(msgWinGetMetrics, self, &wm, s);

		// Tell clsEmbeddedWin to start the copy.
		bm.xy				= pArgs->hotPoint;
		bm.bounds.origin.x	= 0;
		bm.bounds.origin.y	= 0;
		bm.bounds.size.w	= wm.bounds.size.w;
		bm.bounds.size.h	= wm.bounds.size.h;
		ObjCallRet(msgEmbeddedWinBeginCopy, self, &bm, s);

		return stsOK;
	}

	// Pass to ancestor...
	return ObjectCallAncestor(msg, self, pArgs, ctx);

}	// ClockWinProcessGesture

/****************************************************************************
	ClsClockWinInit
	
	Install the class.
****************************************************************************/
STATUS ClsClockWinInit (void)
{
	CLASS_NEW		new;
	STATUS			s;


	// Create the class.
	ObjectCall(msgNewDefaults, clsClass, &new);
	new.object.uid		= clsClockWin;
	new.object.key		= (OBJ_KEY)clsClockWinTable;
	new.cls.pMsg		= clsClockWinTable;
	new.cls.ancestor	= clsTableLayout;
	new.cls.size		= 0;
	new.cls.newArgsSize	= SizeOf(TBL_LAYOUT_NEW);
	ObjCallRet(msgNew, clsClass, &new, s);

	return stsOK;

}  // ClsClockWinInit

