/****************************************************************************
 File: emptyapp.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.5  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:02:48  $

 This file contains just about the simplest possible application.
 It does not have a window.
 It does not have any state it needs to save.
 This class does respond to a single message, so it has a separate method
 table and a method to handle that message.
 All the method does is print out a debugging string.

 If you turn on the "F1" debugging flag (e.g. by putting
	DEBUGSET=/DF0001
 in \penpoint\boot\environ.ini), then messages to clsEmptyApp will be
 traced.

***************************************************************************/

#ifndef APP_INCLUDED
#include <app.h>				// for application messages (and clsmgr.h)
#endif

#ifndef DEBUG_INCLUDED
#include <debug.h>				// for debugging statements.
#endif				   

#ifndef APPMGR_INCLUDED
#include <appmgr.h>				// for AppMgr startup stuff
#endif				   

#include <methods.h>  			// method function prototypes generated by MT

#include <string.h>				// for strcpy().


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Defines, Types, Globals, Etc				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS EXPORTED EmptyAppInit (void);

#define	clsEmptyApp		wknGDTa

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Utility Routines							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Message Handlers   							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
	EmptyAppDestroy

	Respond to msgDestroy by printing a simple message if in DEBUG mode.
****************************************************************************/
MsgHandler(EmptyAppDestroy)
{

#ifdef DEBUG
	Debugf("EmptyApp: app instance %p about to die!", self);
#endif

	//
	// The Class Manager will pass the message onto the ancestor
	// if we return a non-error status value.
	//
	return stsOK;
	MsgHandlerParametersNoWarning; 	// suppress compiler warnings 
} /* EmptyAppDestroy */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Installation								   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
  ClsEmptyAppInit

  Install the EmptyApp application class as a well-known UID.
****************************************************************************/
STATUS 
ClsEmptyAppInit (void)
{
	APP_MGR_NEW	new;
	STATUS		s;

	//
	// Install the Empty App class as a descendant of clsApp.
	//
	ObjCallRet(msgNewDefaults, clsAppMgr, &new, s);
	new.object.uid	 		  	= clsEmptyApp;
	new.object.key 			  	= (OBJ_KEY)clsEmptyAppTable;
	new.cls.pMsg				= clsEmptyAppTable;
	new.cls.ancestor			= clsApp;

	//
	// This class has no instance data, so its size is zero.
	//
	new.cls.size				= Nil(SIZEOF);

	//
	// This class has no msgNew arguments of its own.
	//
	new.cls.newArgsSize			= SizeOf(APP_NEW);
	new.appMgr.flags.accessory	= true;
	strcpy(new.appMgr.company, "GO Corporation");
	strcpy(new.appMgr.defaultDocName, "Empty App Document");
	ObjCallJmp(msgNew, clsAppMgr, &new, s, Error);

	//
	// Turn on message tracing if flag is set.
	//
	if (DbgFlagGet('F', 0x1L)) {
		Debugf("Turning on message tracing for clsEmptyApp");
		(void)ObjCallWarn(msgTrace, clsEmptyApp, (P_ARGS) true);
	}

	return stsOK;

Error:
	return s;
} /* ClsEmptyAppInit */

/****************************************************************************
	main
	
	Main application entry point (as a PROCESS -- the app's MsgProc
		is where messages show up once an instance is running).
****************************************************************************/
void CDECL 
main (
	int			argc,
	char *		argv[],
	U16			processCount)
{
	Dbg(Debugf("main: starting emptyapp.exe[%d]", processCount);)

	if (processCount == 0) {
	 
		// Create application class.
		ClsEmptyAppInit();

		// Invoke app monitor to install this application.
		AppMonitorMain(clsEmptyApp, objNull);

	} else {

		// Create an application instance and dispatch messages.
		AppMain();
	}
	// Suppress compiler's "unused parameter" warnings
	Unused(argc); Unused(argv); 
} /* main */
