/****************************************************************************
 File: testsvc.c
 
 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.22  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:40:14  $

 This file contains the class definition and methods for clsTestService.

 This is a cannonical service, designed to give service writers a head
 start. Stubs for the messages that are typically subclassed by a service
 are provided. Note that not every subclass-responsibility message is
 given; only those that are most often used. For example, a handler for
 msgSvcBindRequested isn't provided since it is very rarely subclassed.

 Notes:

 Remember that service instances have capCall turned on. This means that 
 they can be called from a process besides their owning process. If it is
 possible for more than one caller to access the same service instance
 simultaneously, think through the concurrency issues! You might have to 
 use semaphores to protect areas which can't handle being called 
 simultaneously by multiple folks.
****************************************************************************/
#include <string.h>
#include <stdlib.h>
#include <debug.h>
#include <list.h>
#include <fs.h>
#include <os.h>
#include <osheap.h>
#include <opttable.h>
#include <option.h>
#include <servmgr.h>
#include <method.h>

#include <testsvc.h>


// TKTables for instance and class option cards.
static TK_TABLE_ENTRY	optionCard[] = {
	{"Instance Option1:",0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, clsButton},
	{"Instance Option2:",0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, clsButton},
	{pNull}
};

static TK_TABLE_ENTRY	globalOptionCard[] = {
	{"Global Option1:",0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, clsButton},
	{"Global Option2:",0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, clsButton},
	{pNull}
};

// The service manager(s) we should be put on.
static UID	managers = {thePrinterDevices};

typedef struct INSTANCE_DATA {
	U32					unused1;
	U32					unused2;
} INSTANCE_DATA, *P_INSTANCE_DATA;


/****************************************************************************
	TestSvcNewDefaults
	
	Set defaults. This is where the service characterstics that are common
	to all instances of your service subclasses are specified.
****************************************************************************/
MsgHandlerWithTypes(TestSvcNewDefaults, P_TEST_SVC_NEW, P_INSTANCE_DATA)
{
	MsgHandlerParametersNoWarning;

	// These are the default values from clsService. 
	pArgs->svc.style.exclusiveOpen = false;	// Exclusive open service?
	pArgs->svc.style.autoOption = false;	// Set to true to pass option
											//  sheet messages to your target.

	pArgs->svc.handleClass = clsFileHandle;	// Change this if you want your 
										    //  state handle to be something
										    //  other than a file handle.
	// The next two lines are only needed if you change svc.handleClass.
	ObjCallWarn(msgNewDefaults, pArgs->svc.handleClass, &(pArgs->svc.fsNew));
	pArgs->svc.fsNew.fs.exist = fsExistOpen | fsNoExistCreate;

	// Service managers that this instance should go on. Often statically
	// defined, as in this example. See managers definition above.
	pArgs->svc.pManagerList = &managers;
	pArgs->svc.numManagers = 1;

	// The setting of openClass determines whether the service instance
	// object is passed back on open (openClass = objNull), or a new 
	// instance of the openClass is created and passed 
	// back (openClass = clsYourOpenObject). openObject classes should
	// be subclasses of clsOpenServiceObject.
	pArgs->svc.style.openClass = objNull;

	return stsOK;
	
} // TestSvcNewDefaults


/****************************************************************************
	TestSvcNew
	
	Create a new Test Service. 
	
	1. Set up your instance data. 
	2. Deal with your state file. Your state file will either contain stuff
	   (if you are being recreated due to a warm boot or having been copied
	   in from disk) or be empty (if this is the first time). You must call 
	   ancestor before dealing with your state file.

	Notes:

	If autoCreate in msgSvcClassInitService was true then the system will 
	send msgNewDefaults and msgNew for each state file it finds. 
****************************************************************************/
MsgHandlerWithTypes(TestSvcNew, P_TEST_SVC_NEW, P_INSTANCE_DATA)
{
	INSTANCE_DATA					inst;
	OBJECT							stateHandle;
	STATUS							s;

	MsgHandlerParametersNoWarning;

	inst.unused1 = 0;
	inst.unused2 = 0;

	// Get my state file.
	ObjCallJmp(msgSvcGetHandle, self, &stateHandle, s, objectWrite);
	
	// Is it empty? Initialize it. Is it full? Update instance data if
	// appropriate.

	s = stsOK;

objectWrite:
	StsWarn(ObjectWrite(self, ctx, &inst));

	return s;

} // TestSvcNew


/****************************************************************************
	TestSvcFree

	Free any resources that this service created. Don't delete the state file
	or free the state file handle!
****************************************************************************/
MsgHandlerWithTypes(TestSvcFree, P_ARGS, P_INSTANCE_DATA)
{
	MsgHandlerParametersNoWarning;

	return stsOK;

} 	// TestSvcFree


/****************************************************************************
	TestSvcGetMetrics

 If this service supports client accessable metrics then this message
 must be handled. Be sure to include some form of version identification
 with the metrics.
****************************************************************************/
MsgHandlerWithTypes(TestSvcGetMetrics, P_SVC_GET_SET_METRICS, P_INSTANCE_DATA)
{
	MsgHandlerParametersNoWarning;

	if (pArgs->len == 0) {
//		pArgs->len = myMetricsLength;
	} else {
		// Copy out my metrics to pArgs->pMetrics.		
	}
	return stsOK;

} // TestSvcGetMetrics


/****************************************************************************
	TestSvcSetMetrics

 If this service supports client accessable metrics then this message
 must be handled. Be able to handle old versions of the metrics...
****************************************************************************/
MsgHandlerWithTypes(TestSvcSetMetrics, P_SVC_GET_SET_METRICS, P_INSTANCE_DATA)
{
	MsgHandlerParametersNoWarning;

	return stsOK;

} // TestSvcSetMetrics


/****************************************************************************
	TestSvcOpenDefaultsRequested

	A client wants to get the defaults for the pArgs field of his open
	structure.

	The client sent msgSMOpenDefaults to a service manager.
****************************************************************************/
MsgHandlerWithTypes(TestSvcOpenDefaultsRequested, P_SVC_OPEN_CLOSE, P_INSTANCE_DATA)
{
	MsgHandlerParametersNoWarning;

	// If you are a multi-user service (openClass <> objNull) then
	// you probably don't need to handle this message. Superclass behavior
	// is to send msgNewDefaults to your openClass.

	// Single-user services that support the concept of a defaulted open
	// pArgs should initialize pArgs->pArgs here.

	return stsOK;

} // TestSvcOpenDefaultsRequested


/****************************************************************************
	TestSvcOpenRequested

 A client wants interact directly with the service, typically to move data.

 The client sent msgSMOpen to a service manager.
****************************************************************************/
MsgHandlerWithTypes(TestSvcOpenRequested, P_SVC_OPEN_CLOSE, P_INSTANCE_DATA)
{
//	SVC_OPEN_CLOSE_TARGET		openTarget;
//	SVC_GET_TARGET				getTarget;
//	STATUS						s;

	MsgHandlerParametersNoWarning;

	// If this is a multi-user service then clsService will automatically
	// create an instance of the openClass you specified in 
	// msgNewDefaults. You might want to specify or modify the open
	// request's pArgs (pArgs->pArgs). These become the pArgs for the msgNew 
	// to your openClass, and is how you can communicate with your
	// openClass.

	// If this is a single-user service you might need to update instance
	// data state at this time. Note that you don't have handle checking for
	// exclusive access; clsService does this all for you.

	// If auto-open is false, this service will probably want to open its
	// target.
//	openTarget.pArgs = ...;
//	ObjCallRet(msgSvcOpenTarget, self, &openTarget, s);

	// Get the actual target object.
//	ObjCallRet(msgSvcGetTarget, self, &getTarget, s);

	// Send some messages to my target.
//	ObjCallRet(msgBlahBlah, getTarget.targetService, &blah, s);

	return stsOK;

} // TestSvcOpenRequested


/****************************************************************************
	TestSvcCloseRequested

	A client is finished interacting with the service.

	The client sent msgSMClose to a service manager.
****************************************************************************/
MsgHandlerWithTypes(TestSvcCloseRequested, P_SVC_OPEN_CLOSE, P_INSTANCE_DATA)
{
//	SVC_OPEN_CLOSE_TARGET		closeTarget;
//	STATUS						s;

	MsgHandlerParametersNoWarning;

	// If this is a multi-user service then clsService will automatically
	// send msgDestroy the openClass instance created at open time. 
	// pArgs->pArgs becomes the pArgs for the msgDestroy.

	// If this is a single-user service you might need to update instance
	// data state at this time.

	// If auto-open is false, this service will probably want to close its
	// target.
//	closeTarget.pArgs = ...;
//	ObjCallRet(msgSvcCloseTarget, self, &closeTarget, s);

	return stsOK;

} // TestSvcCloseRequested


/****************************************************************************
	TestSvcAddCards

 Add service instance option cards. This routine should be used if this
 service provides options cards for its instances.
****************************************************************************/
MsgHandlerWithTypes(TestSvcAddCards, P_OPTION_TAG, P_INSTANCE_DATA)
{
	OPTION_CARD						optCard;
	STATUS							s;

	MsgHandlerParametersNoWarning;

	optCard.tag = tagTestSvcOptionCard;
	optCard.pName = "Testing, testing, testing...";
	optCard.win = objNull;
	optCard.client = self;
	ObjCallRet(msgOptionAddCard, pArgs->option, &optCard, s);

	return stsOK;

}	// TestSvcAddCards


/****************************************************************************
	TestSvcProvideCardWin

 Provide service instance option cards. This routine should be used if this
 service provides options cards for its instances.
****************************************************************************/
MsgHandlerWithTypes(TestSvcProvideCardWin, P_OPTION_CARD, P_INSTANCE_DATA)
{
	OPTION_TABLE_NEW				optTable;
	STATUS							s;

	MsgHandlerParametersNoWarning;

	if (pArgs->tag == tagTestSvcOptionCard) {
		ObjCallWarn(msgNewDefaults, clsOptionTable, &optTable);
		optTable.win.flags.style |= wsShrinkWrapWidth | wsShrinkWrapHeight;
		optTable.gWin.helpId = hlpTestSvcOptionCard;
		optTable.tkTable.pEntries = optionCard;
		ObjCallRet(msgNew, clsOptionTable, &optTable, s);
		pArgs->win = optTable.object.uid;
	}

	return stsOK;

}	// TestSvcProvideCardWin


/****************************************************************************
	TestSvcRefreshCard
	
 Refresh the instance option cards.
****************************************************************************/
MsgHandlerWithTypes(TestSvcRefreshCard, P_OPTION_CARD, P_INSTANCE_DATA)
{
	MsgHandlerParametersNoWarning;

	if (pArgs->tag != tagTestSvcOptionCard) {
		return stsOK;
	}

	// Refresh our card(s) here.

	return stsOK;

}	// TestSvcRefreshCard


/****************************************************************************
	TestSvcApplyCard
	
 Apply the instance option cards.
****************************************************************************/
MsgHandlerWithTypes(TestSvcApplyCard, P_OPTION_CARD, P_INSTANCE_DATA)
{
	MsgHandlerParametersNoWarning;

	if (pArgs->tag != tagTestSvcOptionCard) {
		return stsOK;
	}

	// Apply our card(s) here.

	return stsOK;

}	// TestSvcApplyCard


/***************************** Class Messages ******************************/


/****************************************************************************
	TestSvcTerminate

	Perform any operations required when the entire service is being 
	deinstalled. Note that all instances have already been destroyed.
****************************************************************************/
MsgHandlerArgType(TestSvcTerminate, P_ARGS)
{
	MsgHandlerParametersNoWarning;

	return stsOK;

} 	// TestSvcTerminate


/****************************************************************************
	TestSvcClassAddCards

 Add global service option cards. These cards are popped up when the user
 checks on this service in the installer, and when the user initially 
 installs the service if svcPopupOptions is or-ed in to the InitService()
 flags.
****************************************************************************/
MsgHandlerArgType(TestSvcClassAddCards, P_OPTION_CARD)
{
	OPTION_CARD						optCard;
	STATUS							s;

	MsgHandlerParametersNoWarning;

	optCard.tag = tagTestSvcGlobalOptionCard;
	optCard.pName = "Global Options";
	optCard.win = objNull;
	optCard.client = self;
	ObjCallRet(msgOptionAddCard, pArgs->option, &optCard, s);

	return stsOK;

}	// TestSvcClassAddCards


/****************************************************************************
	TestSvcClassProvideCardWin

 Provide the win for our cards.
****************************************************************************/
MsgHandlerArgType(TestSvcClassProvideCardWin, P_OPTION_CARD)
{
	OPTION_TABLE_NEW				optTable;
	STATUS							s;

	MsgHandlerParametersNoWarning;

	if (pArgs->tag == tagTestSvcGlobalOptionCard) {
		ObjCallWarn(msgNewDefaults, clsOptionTable, &optTable);
		optTable.win.flags.style |= wsShrinkWrapWidth | wsShrinkWrapHeight;
		optTable.gWin.helpId = hlpTestSvcGlobalOptionCard;
		optTable.tkTable.pEntries = globalOptionCard;
		ObjCallRet(msgNew, clsOptionTable, &optTable, s);
		pArgs->win = optTable.object.uid;
	}
	
	return stsOK;

}	// TestSvcClassProvideCardWin


/****************************************************************************
	TestSvcClassRefreshCard
	
 Refresh the global option cards.
****************************************************************************/
MsgHandlerArgType(TestSvcClassRefreshCard, P_OPTION_CARD)
{
	MsgHandlerParametersNoWarning;

	if (pArgs->tag != tagTestSvcGlobalOptionCard) {
		return stsOK;
	}

	// Refresh our global option card(s) here...

	return stsOK;

}	// TestSvcClassRefreshCard


/****************************************************************************
	TestSvcClassApplyCard
	
 Apply the global option cards.
****************************************************************************/
MsgHandlerArgType(TestSvcClassApplyCard, P_OPTION_CARD)
{
	MsgHandlerParametersNoWarning;

	if (pArgs->tag != tagTestSvcGlobalOptionCard) {
		return stsOK;
	}

	// Apply our global option cards here...

	return stsOK;

}	// TestSvcClassApplyCard


/****************************************************************************
	ClsTestServiceInit
	
	Install our class.
****************************************************************************/
STATUS PASCAL ClsTestServiceInit(void)
{
	STATUS					s;
	CLASS_NEW				new;

	// Create the service class.
	ObjCallWarn(msgNewDefaults, clsClass, &new);
	new.object.uid			= clsTestService;
	new.cls.pMsg			= clsTestServiceTable;
	new.cls.ancestor		= clsService;
	new.cls.size			= SizeOf(INSTANCE_DATA);
	new.cls.newArgsSize		= SizeOf(TEST_SVC_NEW);
	ObjCallRet(msgNew, clsClass, &new, s);

	return s;

} // ClsTestServiceInit

// STATUS PASCAL ClsTestOpenObjectInit(void); // Only needed if multi-user.


/****************************************************************************
	DLLMain()
	
	Install our service. This routine is called once when the service is
	first installed on PenPoint.
****************************************************************************/
STATUS EXPORTED DLLMain(void)
{
	SVC_INIT_SERVICE	initService;
	SVC_NEW				svcNew;
	STATUS				s;

	// Install classes.
	StsRet(ClsTestServiceInit(), s);
//	StsRet(ClsTestOpenObjectInit(), s);	 // Only needed if multi-user service.

	// Let system know about our service and set global service 
	// characteristics. THIS IS REQUIRED!
	memset(initService.spare, 0, sizeof(initService.spare));
	initService.autoCreate = false;			
	initService.serviceType = 0;
	initService.initServiceFlags = svcPopupOptions; // Flags. Or-in options.
	ObjCallRet(msgSvcClassInitService, clsTestService, &initService, s);

	// Create any static service instances. Set autoCreate above to false 
	// if you do this. If you know exactly how many	service instances 
	// there will be, this is where you should create them.
	// Alternatively, they can be dynamically created elsewhere, after 
	// DLLMain() runs. Beware of process ownership issues if you create
	// services dynamically. You must ensure that the process which owns
	// the dynamically created service instance will be around for the 
	// lifetime of the service instance!
	ObjCallWarn(msgNewDefaults, clsTestService, &svcNew);
	svcNew.svc.pServiceName = "Test Instance";  // Name of this instance
	svcNew.svc.target.manager = theTransportHandlers; // Target svc manager
	strcpy(svcNew.svc.target.pName, "Netware"); // Target name
	ObjCallRet(msgNew, clsTestService, &svcNew, s);

	return stsOK;

} // DllMain










