/****************************************************************************
 File: customs.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.8  $
   $Author:   kcatlin  $
     $Date:   07 Feb 1992 17:19:24  $

 This file contains the clsCustomLayout demoing code of the tkdemo application.
****************************************************************************/

#ifndef TLAYOUT_INCLUDED
#include <tlayout.h>
#endif

#ifndef OPTTABLE_INCLUDED
#include <opttable.h>
#endif

#ifndef SWIN_INCLUDED
#include <swin.h>
#endif

#ifndef CLAYOUT_INCLUDED
#include <clayout.h>
#endif

#ifndef TKDEMO_INCLUDED
#include <tkdemo.h>
#endif



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *									Constants							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define		c1Dim	55
#define		c2Dim	35


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Local Utilities	  					   	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS LOCAL CstmAddLabelChild (
	WIN			parent,
	P_STRING	pString,
	S16			dim,
	P_WIN		pChild)
{
	STATUS		s;
	LABEL_NEW	ln;

	ObjCallRet(msgNewDefaults, clsLabel, &ln, s);
	ln.win.flags.style &= ~(wsShrinkWrapWidth | wsShrinkWrapHeight);
	ln.win.bounds.size.w = dim;
	ln.win.bounds.size.h = dim;
	ln.border.style.edge = bsEdgeAll;
	ln.label.style.xAlignment	= lsAlignCenter;
	ln.label.style.yAlignment	= lsAlignCenter;
	ln.label.pString			= pString;
	ObjCallRet(msgNew, clsLabel, &ln, s);
	ln.win.parent = parent;
	ObjCallRet(msgWinInsert, ln.object.uid, &ln.win, s);

	*pChild = ln.object.uid;

	return stsOK;

} /* CstmAddLabelChild */

STATUS LOCAL AddCustomExamples (
	WIN	parent)
{
	STATUS					s;
	CSTM_LAYOUT_NEW			cln;
	WIN						c1, c2;
	CSTM_LAYOUT_CHILD_SPEC	clcs;
	U8	child1[] = "C1";
	U8	child2[] = "C2";


	AddLabel(parent, "x: MinEdge SameAs MinEdge(P), w: SameAs C1");
	ObjCallRet(msgNewDefaults, clsCustomLayout, &cln, s);
	cln.win.flags.style |= wsShrinkWrapHeight;
	cln.border.style.backgroundInk	= bsInkGray33;
	ObjCallRet(msgNew, clsCustomLayout, &cln, s);
	CstmAddLabelChild(cln.object.uid, child1, c1Dim, &c1);
	CstmAddLabelChild(cln.object.uid, child2, c2Dim, &c2);
	cln.win.parent = parent;
	ObjCallRet(msgWinInsert, cln.object.uid, &cln.win, s);
	CstmLayoutSpecInit(&clcs.metrics);
	clcs.child = c1;
	clcs.metrics.x.constraint	= ClAlign(clMinEdge, clSameAs, clMinEdge);
	clcs.metrics.y.constraint	= ClAlign(clMinEdge, clSameAs, clMinEdge);
	ObjCallRet(msgCstmLayoutSetChildSpec, cln.object.uid, &clcs, s);
	CstmLayoutSpecInit(&clcs.metrics);
	clcs.child = c2;
	clcs.metrics.x.constraint	= ClAlign(clMinEdge, clSameAs, clMinEdge);
	clcs.metrics.y.constraint	= ClAlign(clMinEdge, clAfter, clMaxEdge);
	clcs.metrics.y.relWin		= c1;
	clcs.metrics.w.constraint	= clSameAs;
	clcs.metrics.w.relWin		= c1;
	ObjCallRet(msgCstmLayoutSetChildSpec, cln.object.uid, &clcs, s);

	AddLabel(parent, "x: MinEdge After MaxEdge(C1), w: Extend Before MaxEdge(P)");
	ObjCallRet(msgNewDefaults, clsCustomLayout, &cln, s);
	cln.win.flags.style |= wsShrinkWrapHeight;
	cln.border.style.backgroundInk	= bsInkGray33;
	ObjCallRet(msgNew, clsCustomLayout, &cln, s);
	CstmAddLabelChild(cln.object.uid, child1, c1Dim, &c1);
	CstmAddLabelChild(cln.object.uid, child2, c2Dim, &c2);
	cln.win.parent = parent;
	ObjCallRet(msgWinInsert, cln.object.uid, &cln.win, s);
	CstmLayoutSpecInit(&clcs.metrics);
	clcs.child = c1;
	clcs.metrics.x.constraint	= ClAlign(clMinEdge, clSameAs, clMinEdge);
	clcs.metrics.y.constraint	= ClAlign(clMinEdge, clSameAs, clMinEdge);
	ObjCallRet(msgCstmLayoutSetChildSpec, cln.object.uid, &clcs, s);
	CstmLayoutSpecInit(&clcs.metrics);
	clcs.child = c2;
	clcs.metrics.x.constraint	= ClAlign(clMinEdge, clAfter, clMaxEdge);
	clcs.metrics.x.relWin		= c1;
	clcs.metrics.y.constraint	= ClAlign(clMinEdge, clAfter, clMaxEdge);
	clcs.metrics.y.relWin		= c1;
	clcs.metrics.w.constraint	= ClExtend(clBefore, clMaxEdge);
	ObjCallRet(msgCstmLayoutSetChildSpec, cln.object.uid, &clcs, s);

	AddLabel(parent, "x: MaxEdge SameAs MaxEdge(C1), w: 50 PctOf(C1)");
	ObjCallRet(msgNewDefaults, clsCustomLayout, &cln, s);
	cln.win.flags.style |= wsShrinkWrapHeight;
	cln.border.style.backgroundInk	= bsInkGray33;
	ObjCallRet(msgNew, clsCustomLayout, &cln, s);
	CstmAddLabelChild(cln.object.uid, child1, c1Dim, &c1);
	CstmAddLabelChild(cln.object.uid, child2, c2Dim, &c2);
	cln.win.parent = parent;
	ObjCallRet(msgWinInsert, cln.object.uid, &cln.win, s);
	CstmLayoutSpecInit(&clcs.metrics);
	clcs.child = c1;
	clcs.metrics.x.constraint	= ClAlign(clMinEdge, clSameAs, clMinEdge);
	clcs.metrics.y.constraint	= ClAlign(clMinEdge, clSameAs, clMinEdge);
	ObjCallRet(msgCstmLayoutSetChildSpec, cln.object.uid, &clcs, s);
	CstmLayoutSpecInit(&clcs.metrics);
	clcs.child = c2;
	clcs.metrics.x.constraint	= ClAlign(clMaxEdge, clSameAs, clMaxEdge);
	clcs.metrics.x.relWin		= c1;
	clcs.metrics.y.constraint	= ClAlign(clMinEdge, clAfter, clMaxEdge);
	clcs.metrics.y.relWin		= c1;
	clcs.metrics.w.constraint	= clPctOf;
	clcs.metrics.w.value		= 50;
	clcs.metrics.w.relWin		= c1;
	ObjCallRet(msgCstmLayoutSetChildSpec, cln.object.uid, &clcs, s);

	AddLabel(parent, "x: CenterEdge SameAs CenterEdge(C1), w: Absolute 20");
	ObjCallRet(msgNewDefaults, clsCustomLayout, &cln, s);
	cln.win.flags.style |= wsShrinkWrapHeight;
	cln.border.style.backgroundInk	= bsInkGray33;
	ObjCallRet(msgNew, clsCustomLayout, &cln, s);
	CstmAddLabelChild(cln.object.uid, child1, c1Dim, &c1);
	CstmAddLabelChild(cln.object.uid, child2, c2Dim, &c2);
	cln.win.parent = parent;
	ObjCallRet(msgWinInsert, cln.object.uid, &cln.win, s);
	CstmLayoutSpecInit(&clcs.metrics);
	clcs.child = c1;
	clcs.metrics.x.constraint	= ClAlign(clMinEdge, clSameAs, clMinEdge);
	clcs.metrics.y.constraint	= ClAlign(clMinEdge, clSameAs, clMinEdge);
	ObjCallRet(msgCstmLayoutSetChildSpec, cln.object.uid, &clcs, s);
	CstmLayoutSpecInit(&clcs.metrics);
	clcs.child = c2;
	clcs.metrics.x.constraint	= ClAlign(clCenterEdge, clSameAs, clCenterEdge);
	clcs.metrics.x.relWin		= c1;
	clcs.metrics.y.constraint	= ClAlign(clMinEdge, clAfter, clMaxEdge);
	clcs.metrics.y.relWin		= c1;
	clcs.metrics.w.constraint	= clAbsolute;
	clcs.metrics.w.value		= 20;
	clcs.metrics.w.relWin		= c1;
	ObjCallRet(msgCstmLayoutSetChildSpec, cln.object.uid, &clcs, s);

	return stsOK;

} /* AddCustomExamples */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Global Utilities						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS GLOBAL TkDemoAddCustomsCard (
	WIN		swin,
	WIN		tabBar,
	APP		app)
{
	STATUS				s;
	OPTION_TABLE_NEW	otn;

	// Create the card window.
	ObjCallRet(msgNewDefaults, clsOptionTable, &otn, s);
	otn.tableLayout.style.growChildWidth = true;
	otn.tableLayout.colWidth.constraint = tlAbsolute;
	otn.tableLayout.colWidth.value = 75;
	ObjCallRet(msgNew, clsOptionTable, &otn, s);

	// Add it to the scrollwin.
	ObjCallRet(msgScrollWinAddClientWin, swin, (P_ARGS) otn.object.uid, s);

	// Create and add a corresponding tab.
	StsRet(AddTab(tabBar, "Custom", otn.object.uid), s);

	// fill the card with table examples
	StsRet(AddCustomExamples(otn.object.uid), s);

	return stsOK;

	Unused(app);

} /* TkDemoAddCustomsCard */



