/****************************************************************************
 File: notes.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.6  $
   $Author:   kcatlin  $
     $Date:   05 Feb 1992 09:07:22  $

 This file contains the clsNote demoing code of the tkdemo application.
****************************************************************************/

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#ifndef CLASSES_INCLUDED
#include <methods.h>
#endif

#ifndef DEBUG_INCLUDED
#include <debug.h>
#endif

#ifndef OPTTABLE_INCLUDED
#include <opttable.h>
#endif

#ifndef SWIN_INCLUDED
#include <swin.h>
#endif

#ifndef NOTE_INCLUDED
#include <note.h>
#endif

#ifndef TKDEMO_INCLUDED
#include <tkdemo.h>
#endif



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *									Constants							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define tagDummy			MakeTag(clsTkDemo, 1)

static const TK_TABLE_ENTRY	sysNoteContent[] = {
	{"The battery is low."},
	{"(Feed me, Seymour!)"},
	{pNull}
};

static const TK_TABLE_ENTRY	appNoteContent[] = {
	{"This space for rent."},
	{pNull}
};

static const TK_TABLE_ENTRY	appNoteButtons[] = {
	{"OK"		/* , message */	},
	{"Cancel"	/* , message */	},
	{pNull}
};

static const TK_TABLE_ENTRY	liteNoteContent[] = {
	{"thinking..."},
	{pNull}
};


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Local Utilities	  					   	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


STATUS LOCAL AddNoteExamples (
	WIN	parent,
	APP	app)
{
	STATUS		s;
	BUTTON_NEW	bn;

	AddLabel(parent, "System Note, No Buttons");
	ObjCallRet(msgNewDefaults, clsButton, &bn, s);
	bn.control.client = app;
	bn.label.pString = "Show";
	bn.button.msg = msgTkDemoShowNote;
	bn.button.data = msgTkDemoShowSysNote;
	ObjCallRet(msgNew, clsButton, &bn, s);
	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	AddLabel(parent, "App Note, Two Buttons");
	ObjCallRet(msgNewDefaults, clsButton, &bn, s);
	bn.control.client = app;
	bn.label.pString = "Show";
	bn.button.msg = msgTkDemoShowNote;
	bn.button.data = msgTkDemoShowAppNote;
	ObjCallRet(msgNew, clsButton, &bn, s);
	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	AddLabel(parent, "'Lite' Note, No Title or Buttons");
	ObjCallRet(msgNewDefaults, clsButton, &bn, s);
	bn.control.client = app;
	bn.label.pString = "Show";
	bn.button.msg = msgTkDemoShowNote;
	bn.button.data = msgTkDemoShowLiteNote;
	ObjCallRet(msgNew, clsButton, &bn, s);
	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	return stsOK;

} /* AddNoteExamples */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Global Utilities						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS GLOBAL TkDemoAddNotesCard (
	WIN		swin,
	WIN		tabBar,
	APP		app)
{
	STATUS				s;
	OPTION_TABLE_NEW	otn;

	// Create the card window.
	ObjCallRet(msgNewDefaults, clsOptionTable, &otn, s);
	ObjCallRet(msgNew, clsOptionTable, &otn, s);

	// Add it to the scrollwin.
	ObjCallRet(msgScrollWinAddClientWin, swin, (P_ARGS) otn.object.uid, s);

	// Create and add a corresponding tab.
	StsRet(AddTab(tabBar, "Notes", otn.object.uid), s);

	// fill the card with border examples
	StsRet(AddNoteExamples(otn.object.uid, app), s);

	return stsOK;

	Unused(app);

} /* TkDemoAddNotesCard */


MsgHandler(TkDemoShowNote)
{
	Dbg(Debugf("tkdemo[%p]: msgTkDemoShowNote", self);)

	return ObjectPostU32((MESSAGE) pArgs, self, pNull);
	MsgHandlerParametersNoWarning;

} /* TkDemoShowNote */


MsgHandler(TkDemoShowSysNote)
{
	STATUS		s;
	NOTE_NEW	nn;
	MESSAGE		m;

	ObjCallRet(msgNewDefaults, clsNote, &nn, s);
	nn.note.pContentEntries	= sysNoteContent;
	ObjCallRet(msgNew, clsNote, &nn, s);

	ObjCallRet(msgNoteShow, nn.object.uid, &m, s);

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* TkDemoShowSysNote */


MsgHandler(TkDemoShowAppNote)
{
	STATUS		s;
	NOTE_NEW	nn;
	MESSAGE		m;

	ObjCallRet(msgNewDefaults, clsNote, &nn, s);
	nn.note.metrics.flags = nfDefaultAppFlags | nfAutoDestroy;
	nn.note.pContentEntries	= appNoteContent;
	nn.note.pCmdBarEntries	= appNoteButtons;
	ObjCallRet(msgNew, clsNote, &nn, s);

	ObjCallRet(msgNoteShow, nn.object.uid, &m, s);

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* TkDemoShowAppNote */


MsgHandler(TkDemoShowLiteNote)
{
	STATUS		s;
	NOTE_NEW	nn;
	MESSAGE		m;

	ObjCallRet(msgNewDefaults, clsNote, &nn, s);
	nn.note.metrics.flags = nfAutoDestroy | nfTimeout | nfNoWordWrap;
	nn.note.metrics.timeout = 4000;
	nn.note.pContentEntries	= liteNoteContent;
	ObjCallRet(msgNew, clsNote, &nn, s);

	ObjCallRet(msgNoteShow, nn.object.uid, &m, s);

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* TkDemoShowLiteNote */


