/****************************************************************************
 File: tttvopt.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.5  $
 $Author:   kcatlin  $
 $Date:   05 Feb 1992 09:19:02  $

 This file contains the implementation of clsTttView's Option Sheets.

 Notes:
	
 [1]	The Option Sheet protocol allows any class of an
		object to create an option sheet and/or add cards.  
		Therefore this code carefully validates that it only
		operates on Option Sheets and Cards that it knows about. 
		This could be overkill.

****************************************************************************/

#ifndef OPTION_INCLUDED
#include <option.h>
#endif

#ifndef TTTVIEW_INCLUDED
#include <tttview.h>
#endif

#ifndef DEBUG_INCLUDED
#include <debug.h>
#endif

#ifndef OPTTABLE_INCLUDED
#include <opttable.h>
#endif

#ifndef TTTDATA_INCLUDED
#include <tttdata.h>
#endif

#ifndef OS_INCLUDED
#include <os.h>
#endif

#ifndef SEL_INCLUDED
#include <sel.h>
#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Defines, Types, Globals, Etc				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

//
// The following static maps to the TK_TABLE_ENTRY struct, in tktable.h
// It is short-hand for defining a TkTable.
// 
static const TK_TABLE_ENTRY cardEntries[] = {
	{"Line Thickness:", 0, 0, 0, 0, 0, tagTttQHelpForLineCtrl},
		{"1", 0, 0, tagCardLineThickness, 0, clsIntegerField, 
			tagTttQHelpForLineCtrl}, 
	{pNull}
};


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Utility Routines							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Message Handlers							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */



/****************************************************************************
	TttViewOptionAddCards
	
	Handles msgOptionAddCards.
	
	Note on error handling: Once a card has been added to the sheet,
	destroying the sheet will destroy the card.
****************************************************************************/
#define DbgTttViewOptionAddCards(x) \
	TttDbgHelper("TttViewOptionAddCards",tttViewOptsDbgSet,0x4,x)

MsgHandlerWithTypes(TttViewOptionAddCards, P_OPTION_TAG, PP_TTT_VIEW_INST)
{
	OPTION_CARD			card;
	STATUS				s;

	DbgTttViewOptionAddCards((""))

	//
	// Create the card.
	//
	card.tag = tagTttViewCard;
	card.win = objNull;
	card.pName = "TTT Card";
	card.client = self;
	ObjCallJmp(msgOptionAddLastCard, pArgs->option, &card, s, Error);

	DbgTttViewOptionAddCards(("return stsOK"))
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	DbgTttViewOptionAddCards(("Error; return 0x%lx",s))
	return s;
} /* TttViewOptionAddCards */

/****************************************************************************
	TttViewOptionProvideCard
	
	Handles msgOptionProvideCardWin.
****************************************************************************/
#define DbgTttViewOptionProvideCard(x) \
	TttDbgHelper("TttViewOptionProvideCard",tttViewOptsDbgSet,0x8,x)

MsgHandlerWithTypes(TttViewOptionProvideCard, P_OPTION_CARD, P_UNKNOWN)
{
	STATUS 				s;
	OPTION_TABLE_NEW 	otn;

	DbgTttViewOptionProvideCard((""))

	pArgs->win = objNull;
	if (pArgs->tag == tagTttViewCard)
	{				 
		ObjCallJmp(msgNewDefaults, clsOptionTable, &otn, s, Error);
		otn.tkTable.client = self;
		otn.tkTable.pEntries = cardEntries;
		otn.win.tag = pArgs->tag;
		otn.gWin.helpId = tagCardLineThickness;
		ObjCallJmp(msgNew, clsOptionTable, &otn, s, Error);
		pArgs->win = otn.object.uid;
	}

	return(stsOK);
	MsgHandlerParametersNoWarning;

Error:
	DbgTttViewOptionProvideCard(("Error; return 0x%lx",s))
	return s;
} /* TttViewOptionProvideCard */

/****************************************************************************
	TttViewOptionRefreshCard

	Handles msgOptionRefreshCard
****************************************************************************/
#define DbgTttViewOptionRefreshCard(x) \
	TttDbgHelper("TttViewOptionRefreshCard",tttViewOptsDbgSet,0x10,x)

MsgHandlerWithTypes(TttViewOptionRefreshCard, P_OPTION_CARD, PP_TTT_VIEW_INST)
{
	OBJECT				view;
	TTT_VIEW_METRICS	vm;
	OBJECT				control;
	STATUS				s;

	DbgTttViewOptionRefreshCard((""))

	//
	// See note [1] at the beginning of this file.
	//
	if (pArgs->tag != tagTttViewCard) {
		DbgTttViewOptionRefreshCard(("unrecognized card; call ancestor"))
		return ObjCallAncestorCtxWarn(ctx);
	}

	//
	// Collect info needed to refresh card.
	//
	StsJmp(TttUtilGetComponents(OSThisApp(), tttGetView, \
			objNull, &view, objNull), s, Error);
	ObjCallJmp(msgTttViewGetMetrics, view, &vm, s, Error);

	DbgTttViewOptionRefreshCard(("refreshing card"))
	control = (OBJECT) ObjectCall(msgWinFindTag, pArgs->win, \
			(P_ARGS)tagCardLineThickness);
	ObjCallJmp(msgControlSetValue, control, (P_ARGS)(vm.lineThickness), \
			s, Error);		

	//
	// The whole card is clean now.
	//
	ObjCallJmp(msgControlSetDirty, pArgs->win, (P_ARGS)false, s, Error);

	DbgTttViewOptionRefreshCard(("return stsOK"))
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	DbgTttViewOptionRefreshCard(("Error; return 0x%lx",s))
	return s;
} /* TttViewOptionRefreshCard */


/****************************************************************************
	TttViewOptionApplyCard

	Handles msgOptionApplyCard

	Note:  Perhaps this should be an undoable operation.
****************************************************************************/
#define DbgTttViewOptionApplyCard(x) \
	TttDbgHelper("TttViewOptionApplyCard",tttViewOptsDbgSet,0x20,x)

MsgHandlerWithTypes(TttViewOptionApplyCard, P_OPTION_CARD, PP_TTT_VIEW_INST)
{
	OBJECT				view;
	TTT_VIEW_METRICS	vm;
	BOOLEAN				dirty;
	OBJECT				control;
	U32					value;
	OBJECT				owner;
	STATUS				s;

	DbgTttViewOptionApplyCard((""))

	//
	// See note [1] at the beginning of this file.
	//
	if (pArgs->tag != tagTttViewCard) {
		DbgTttViewOptionRefreshCard(("unrecognized card; call ancestor"))
		return ObjCallAncestorCtxWarn(ctx);
	}

	//
	// Collect info needed to apply card.
	//
	StsJmp(TttUtilGetComponents(OSThisApp(), tttGetView, objNull, \
			&view, objNull), s, Error);

	DbgTttViewOptionApplyCard(("applying card"))
	control = (OBJECT) ObjectCall(msgWinFindTag, pArgs->win, \
			(P_ARGS)tagCardLineThickness);
	ObjCallJmp(msgControlGetDirty, control, &dirty, s, Error);
	if (dirty) {
		// Promote the view's selection, if it is not already promoted.
		ObjCallJmp(msgSelOwner, theSelectionManager, &owner, s, Error);
		if (owner != self) {
			ObjCallJmp(msgSelSetOwnerPreserve, theSelectionManager, \
					pNull, s, Error);
		}
		ObjCallJmp(msgControlGetValue, control, &value, s, Error);
		DbgTttViewOptionApplyCard(("\"Line Thickness\" is dirty; value=%ld",value))
		ObjCallJmp(msgTttViewGetMetrics, view, &vm, s, Error);
		vm.lineThickness = value;
		ObjCallJmp(msgTttViewSetMetrics, view, &vm, s, Error);
	} else {
		DbgTttViewOptionApplyCard(("\"Line Thickness\" is not dirty"))
	}
	
	DbgTttViewOptionApplyCard(("return stsOK"))
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	DbgTttViewOptionApplyCard(("Error; return 0x%lx",s))
	return s;
} /* TttViewOptionApplyCard */


/****************************************************************************
	TttViewOptionApplicableCard

	Handles msgOptionApplicableCard
****************************************************************************/
#define DbgTttViewOptionApplicableCard(x) \
	TttDbgHelper("TttViewOptionApplicableCard",tttViewOptsDbgSet,0x80,x)

MsgHandlerWithTypes(TttViewOptionApplicableCard, P_OPTION_CARD, \
		PP_TTT_VIEW_INST)
{
	OBJECT		owner;
	STATUS		s;

	DbgTttViewOptionApplicableCard((""))

	//
	// See note [1] at the beginning of this file.  Also, don't use 
	// ObjCallAncestorCtxWarn();  it is not an error for the ancestor to
	// return stsFailed, and we don't want to generate a debugging message.
	//
	if (pArgs->tag != tagTttViewCard) {
		DbgTttViewOptionApplicableCard(("unrecognized card; call ancestor"))
		return ObjectCallAncestorCtx(ctx);
	}

	// 
	// So it's a ttt card.  Decide if it's consistent with the current seln.
	//
	ObjCallJmp(msgSelOwner, theSelectionManager, &owner, s, Error);
	if (owner == self) {
		DbgTttViewOptionApplicableCard(("owner is self; return stsOK"))
		return stsOK;
	} else {
		DbgTttViewOptionApplicableCard(("owner is not self; return stsFailed"))
		return stsFailed;
	}

	MsgHandlerParametersNoWarning;

Error:
	DbgTttViewOptionApplicableCard(("Error; return 0x%lx",s))
	return s;
} /* TttViewOptionApplicableCard */


