/****************************************************************************
 File: tttvxfer.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.5  $
 $Author:   kcatlin  $
 $Date:   07 Feb 1992 17:02:44  $

 This file contains the implementation of clsTttView's Data Transfer
****************************************************************************/

#ifndef TTTVIEW_INCLUDED
#include <tttview.h>
#endif

#ifndef LIST_INCLUDED
#include <list.h>
#endif

#ifndef XFER_INCLUDED
#include <xfer.h>
#endif

#ifndef SEL_INCLUDED
#include <sel.h>
#endif

#ifndef TTTDATA_INCLUDED
#include <tttdata.h>
#endif

#ifndef EMBEDWIN_INCLUDED
#include <embedwin.h>
#endif

#ifndef DEBUG_INCLUDED
#include <debug.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Defines, Types, Globals, Etc				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

							
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Utility Routines							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Message Handlers		  		  			   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
	TttViewSelBeginMoveAndCopy

	Handles both msgSelBeginMove and msgSelBeginCopy
****************************************************************************/
#define DbgTttViewSelBeginMoveAndCopy(x) \
	TttDbgHelper("TttViewSelBeginMoveAndCopy",tttViewXferDbgSet,0x1,x)

MsgHandlerWithTypes(TttViewSelBeginMoveAndCopy, P_XY32, PP_TTT_VIEW_INST)
{
	EMBEDDED_WIN_BEGIN_MOVE_COPY 	bmc;
	STATUS								s;

	DbgTttViewSelBeginMoveAndCopy(("self=0x%lx",self))

	//
	// If we don't handle this message, the default behavior is to 
	// draw a marquee around the entire selection. For ttt, the marquee
	// would stretch around the entire board, which is too large to be
	// be easily dragged into another document. So, we handle this message,
	// and set the bounds of the move/copy area to an empty rectangle.
	// msgEmbeddedWinBeginMove/Copy will know to display a move/copy icon
	// instead of drawing the marquee.
	//
	if (pArgs) {
		bmc.xy = *pArgs;
	} else {
		bmc.xy.x =
		bmc.xy.y = 0;
	}
	bmc.bounds.origin.x = 
	bmc.bounds.origin.y = 
	bmc.bounds.size.w =
	bmc.bounds.size.h = 0;
	ObjCallJmp(MsgEqual(msg, msgSelBeginMove) ?
			msgEmbeddedWinBeginMove : msgEmbeddedWinBeginCopy,
			self, &bmc, s, Error);

	DbgTttViewSelBeginMoveAndCopy(("returns stsOK"))
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	DbgTttViewSelBeginMoveAndCopy(("Error; return 0x%lx",s))
	return s;
} /* TttViewSelBeginMoveAndCopy */


/****************************************************************************
	TttViewXferGet
****************************************************************************/
#define DbgTttViewXferGet(x) \
	TttDbgHelper("TttViewXferGet",tttViewXferDbgSet,0x2,x)

MsgHandlerWithTypes(TttViewXferGet, P_XFER_FIXED_BUF, PP_TTT_VIEW_INST)
{
	STATUS	s;

	DbgTttViewXferGet(("self=0x%lx",self))

	if (pArgs->id == xferString) {
		OBJECT dataObj;
		TTT_DATA_METRICS dm;
		U16 row;
		U16 col;
		P_XFER_FIXED_BUF p = (P_XFER_FIXED_BUF)pArgs;
		ObjCallJmp(msgViewGetDataObject, self, &dataObj, s, Error);
		ObjCallJmp(msgTttDataGetMetrics, dataObj, &dm, s, Error);
		
		//
		// initialize the length to the number of squares (9) plus 1
		// to allow for a string termination character (just in case
		// the user copies/moves the string into a text processor.
		//
		p->len = 10;
		p->data = 0L;
		for (row=0; row<3; row++) {
			for (col=0; col<3; col++) {
				p->buf[(row*3)+col] = dm.squares[row][col];
			}
		}
		p->buf[9] = '\0';
		s = stsOK;
	} else {
		s = ObjectCallAncestorCtx(ctx);
	}

	DbgTttViewXferGet(("returns 0x%lx",s))
	return s;
	MsgHandlerParametersNoWarning;

Error:
	DbgTttViewXferGet(("Error; return 0x%lx",s))
	return s;
} /* TttViewXferGet */


/****************************************************************************
	TttViewXferList
****************************************************************************/
static TAG
sourceFormats[] = {xferString};

#define N_SOURCE_FORMATS (SizeOf(sourceFormats) / SizeOf(sourceFormats[0]))

#define DbgTttViewXferList(x) \
	TttDbgHelper("TttViewXferList",tttViewXferDbgSet,0x4,x)

MsgHandlerWithTypes(TttViewXferList, OBJECT, PP_TTT_VIEW_INST)
{
	STATUS	s;

	DbgTttViewXferList(("self=0x%lx",self))

	//
	// Don't let ancestor add types.  We aren't interested in 
	// moving/copying the window, which is the only type the
	// ancestor supports.
	//
	StsJmp(XferAddIds(pArgs, sourceFormats, N_SOURCE_FORMATS), s, Error);

	DbgTttViewXferList(("returns stsOK"))
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	DbgTttViewXferList(("Error; return 0x%lx",s))
	return s;
} /* TttViewXferList */


/****************************************************************************
	TttViewSelMoveAndSelCopy

	Handles both msgSelMoveSelection and msgSelCopySelection
****************************************************************************/

static TAG
receiverFormats[] = {xferString};

#define N_RECEIVER_FORMATS (SizeOf(receiverFormats) / SizeOf(receiverFormats[0]))

#define DbgTttViewSelMoveAndSelCopy(x) \
	TttDbgHelper("TttViewSelMoveAndSelCopy",tttViewXferDbgSet,0x8,x)

MsgHandlerWithTypes(TttViewSelMoveAndSelCopy, P_XY32, PP_TTT_VIEW_INST)
{
	TAG 			transferType;
	OBJECT			owner;
	XFER_LIST_NEW	listNew;
	STATUS			s;

	DbgTttViewSelMoveAndSelCopy(("self=0x%lx",self))

	//
	// Initialize for error recovery
	//
	listNew.object.uid = NULL;

	//
	// Get source of move/copy.
	//
	ObjCallJmp(msgSelOwner, theSelectionManager, &owner, s, Error);
	if (! owner) {
		DbgTttViewSelMoveAndSelCopy(("no owner!"))
		s = stsFailed;
		goto Error;
	}

	//
	// Don't bother doing move/copy to self.  Use the Error exit out of 
	// this routine even though this really isn't really an error.
	// 
	if (owner == self) {
		DbgTttViewSelMoveAndSelCopy(("owner == self"))
   		s = stsOK;
		goto Error;
	}


	//
	// Get list of available types.  
	//
	ObjCallJmp(msgNewDefaults, clsXferList, &listNew, s, Error);
	ObjCallJmp(msgNew, clsXferList, &listNew, s, Error);
	ObjCallJmp(msgXferList, owner, listNew.object.uid, s, Error);
	StsJmp(XferListSearch(listNew.object.uid, receiverFormats,
  			N_RECEIVER_FORMATS, &transferType), s, Error);

	//
	// This only handles one transfer type now, but we expect to handle
	// more in the future.  So code it in that style.
	//
	if (transferType == xferString) {

		TTT_DATA_METRICS metrics;
		OBJECT dataObj;
		XFER_FIXED_BUF xfer;
		U16 i;
		DbgTttViewSelMoveAndSelCopy(("transferType is xferString"))
		ObjCallJmp(msgViewGetDataObject, self, &dataObj, s, Error);
		ObjCallJmp(msgTttDataGetMetrics, dataObj, &metrics, s, Error);
		xfer.id = xferString;
		ObjSendUpdateJmp(msgXferGet, owner, &xfer, SizeOf(xfer), s, Error);
		DbgTttViewSelMoveAndSelCopy(("data=%ld len=%ld",
				(U32)(xfer.data), (U32)(xfer.len)))
		for (i=0; i < (U16)Min(xfer.len,9L); i++) {
			metrics.squares[i/3][i%3] =
					TttUtilSquareValueForChar(xfer.buf[i]);
		}
		metrics.undoTag = tagTttDataUndoMoveCopy;
		ObjCallJmp(msgTttDataSetMetrics, dataObj, &metrics, s, Error);

	} else {

		goto Error;

	}

	//
	// If this was a move, delete the source.
	//
	if (MsgEqual(msgSelMoveSelection, msg)) {
		ObjSendU32Jmp(msgSelDelete, owner, (P_ARGS)SelDeleteNoSelect, s,
				Error);
	}

	//
	// Take the selection.  Be sure to do this AFTER deleting the 
	// selection because the source may "forget" what to delete when
	// the selection is pulled from it.
	//
	ObjCallJmp(msgTttViewTakeSel, self, pNull, s, Error);

	ObjCallWarn(msgDestroy, listNew.object.uid, pNull);
	DbgTttViewSelMoveAndSelCopy(("returns stsOK"))
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	if (listNew.object.uid) {
		ObjCallWarn(msgDestroy, listNew.object.uid, pNull);
	}
	DbgTttViewSelMoveAndSelCopy(("Error; return 0x%lx",s))
	return s;
} /* TttViewSelMoveAndSelCopy */
