"68000"
                GLB     Init,Msgs,Cmd_Input
                GLB     Msg_Dest

                ORG     0
***********************************************
* The following instructions set up exception
* vector 0 for "run from reset".
***********************************************
                DC.L    Stack
                DC.L    Init


                DATA
Msgs
Msg_A           DC.B    'Command A entered '
Msg_B           DC.B    'Entered B command '
Msg_I           DC.B    'Invalid Command '
End_Msgs


                PROG
***********************************************
* Sets up the stack pointer.
***********************************************
Init            MOVE.L  #Stack,A7
***********************************************
* Clear previous command.
***********************************************
Read_Cmd        MOVE.B  #0,Cmd_Input
***********************************************
* Read command input byte.  If no command has
* been entered, continue to scan for input.
***********************************************
Scan            MOVE.B  Cmd_Input,D0
                BEQ     Scan
***********************************************
* A command has been entered.  Check if it is
* command A, command B, or invalid.
***********************************************
Exe_Cmd         CMP.B   #41H,D0
                BEQ     Cmd_A
                CMP.B   #42H,D0
                BEQ     Cmd_B
                BRA.B   Cmd_I
***********************************************
* Command A is entered.  D1 = the number of
* bytes in message A.  A0 = location of the
* message.  Jump to the routine which writes
* the messages.
***********************************************
Cmd_A           MOVE    #Msg_B-Msg_A-1,D1
                MOVE.L  #Msg_A,A0
                BRA.B   Write_Msg
***********************************************
* Command B is entered.
***********************************************
Cmd_B           MOVE    #Msg_I-Msg_B-1,D1
                MOVE.L  #Msg_B,A0
                BRA.B   Write_Msg
***********************************************
* An invalid command is entered.
***********************************************
Cmd_I           MOVE    #End_Msgs-Msg_I-1,D1
                MOVE.L  #Msg_I,A0
***********************************************
* Message is written to the destination.
***********************************************
Write_Msg       MOVE.L  #Msg_Dest,A1
Again           MOVE.B  [A0]+,[A1]+
                DBEQ    D1,Again
***********************************************
* The rest of the destination area is filled
* with zeros.
***********************************************
Fill_Dest       MOVE.B  #0,[A1]+
                CMPA    #Msg_Dest+20H,A1
                BNE     Fill_Dest
***********************************************
* Go back and scan for next command.
***********************************************
                BRA.B   Read_Cmd

                COMN
***********************************************
* Command input byte.
***********************************************
Cmd_Input       DS.B    1
***********************************************
* Destination of the command messages.
***********************************************
Msg_Dest        DS.L    3EH
Stack           DS.W    1       ; Stack area.
                END     Init
