"68000"
***********************************************
* If "68000", then "Proc_68010 EQU 0" below.
* If "68010", then "Proc_68010 EQU 1" below.
***********************************************
Proc_68010      EQU     0

                GLB     Init,Cmd_Input,Msg_Dest
Exe_Cmd         EQU     400H

                ORG     0
***********************************************
* Set up exception vector 0 for run from reset.
***********************************************
                DC.L    Stack
                DC.L    Init

                ORG     0B8H
***********************************************
* TRAP #0EH vector [switch to supervisor].
***********************************************
                DC.L    Restart_Pgm

                PROG
***********************************************
* Sets up the stack pointer.
***********************************************
Init            MOVE.L  #Stack,A7
***********************************************
* Clear previous command.
***********************************************
Read_Cmd        MOVE.B  #0,Cmd_Input
***********************************************
* Read command input byte.  If no command has
* been entered, continue to scan for input.
***********************************************
Scan            MOVE.B  Cmd_Input,D0
                BEQ     Scan
***********************************************
* If command is entered, switch to user state.
***********************************************
                IF      Proc_68010
                MOVE    #0,-[A7]
                ENDIF
                MOVE.L  #Exe_Cmd,-[A7]
                MOVE    #0,-[A7]
                RTE
***********************************************
* A TRAP #0e vectors to the instructions below.  
* The values pushed by the trap are replaced by 
* values that cause the program to restart.
***********************************************
Restart_Pgm     MOVE.L  #Read_Cmd,2[A7]
                MOVE    #2000H,[A7]
                RTE

                COMN
***********************************************
* Command input byte.
***********************************************
Cmd_Input       DS.B    1
***********************************************
* Destination of the command messages.
***********************************************
Msg_Dest        DS.L    3EH
Stack           DS.W    1       ; Stack area.
                END     Init
