"68000"
                GLB     Msg_Dest

                DATA
Msgs
Msg_A           DC.B    'Command A entered '
Msg_B           DC.B    'Entered B command '
Msg_I           DC.B    'Invalid Command '
End_Msgs


                PROG
***********************************************
* A command has been entered.  Check if it is
* command A, command B, or invalid.
***********************************************
Exe_Cmd         CMP.B   #41H,D0
                BEQ     Cmd_A
                CMP.B   #42H,D0
                BEQ     Cmd_B
                BRA.B   Cmd_I
***********************************************
* Command A is entered.  D1 = the number of
* bytesin message A.  A0 = location of the
* message.  Jump to the routine which writes
* the messages.
***********************************************
Cmd_A           MOVE    #Msg_B-Msg_A-1,D1
                MOVE.L  #Msg_A,A0
                BRA.B   Write_Msg
***********************************************
* Command B is entered.
***********************************************
Cmd_B           MOVE    #Msg_I-Msg_B-1,D1
                MOVE.L  #Msg_B,A0
                BRA.B   Write_Msg
***********************************************
* An invalid command is entered.
***********************************************
Cmd_I           MOVE    #End_Msgs-Msg_I-1,D1
                MOVE.L  #Msg_I,A0
***********************************************
* Message is written to the destination.
***********************************************
Write_Msg       MOVE.L  #Msg_Dest,A1
Again           MOVE.B  [A0]+,[A1]+
                DBEQ    D1,Again
***********************************************
* The rest of the destination area is filled
* with zeros.
***********************************************
Fill_Dest       MOVE.B  #0,[A1]+
                CMPA    #Msg_Dest+20H,A1
                BNE     Fill_Dest
***********************************************
* Trap causes entry into supervisor state.
***********************************************
                TRAP    #0EH

                COMN
***********************************************
* Command input byte.
***********************************************
Cmd_Input       DS.B    1
***********************************************
* Destination of the command messages.
***********************************************
Msg_Dest        DS.L    3EH
Stack           DS.W    1       ; Stack area.
                END
