*
* HP 64748 Demo Program
* This program is a simple 68000 assembler program that can be used
* to demonstrate run and trace features for the HP 64748 emulator.
* It emulates a simple command interpreter.             
* 
* The program scans the location Cmd_Input looking for a non-null
* value. When it finds one, it calls a routine to determine whether
* the command is "A," "B," or an invalid command. This routine sets
* up certain parms for the output message handler, then calls the 
* message handler to write a message based on the command input.
*
* Module name: demo.s
* Written by: Dave Kumpf, Document Technology, Inc.
* Written: February 27, 1991
* Last Revised: February 28, 1991
*

* Define the chip. Call it 68000 here since we don't use any 68020-specific
* features.

		chip 68000

* Int_Cmd is in the module handle_msg.

		xref	Int_Cmd

* Set up the stack pointer and initial program counter for run-from-reset.

		sect	Table,,r
		org $0

		dc.l	Top_of_Stack
		dc.l	Main

* The stack is declared as 16 long words, which should be more than
* sufficient since there shouldn't be more than 3 PC's on the stack (plus
* whatever the emulation monitor pushes).

		sect	Stack,,d
Stack		ds.l	16
Top_of_Stack

* The only data local to this module is the command input buffer, which
* is a single byte.

		sect	Data,,d

Cmd_Input	ds.b	1
  
* Main program starts here.

		sect	Prog,,c

* Load the user stack pointer, then clear the command input byte.
	
Main		move.l	#Top_of_Stack,a7
		move.b	#0,Cmd_Input
* Now loop, looking for a nonzero value. If found, call the message interpreter. 
Loop		move.b	Cmd_Input,d0
		bne	Call_Int
		bra	EndLoop

* Call to the message interpreter is a simple subroutine branch. The parameter
* is passed in d0 (the command we read). When finished, clear the command
* input buffer.	

Call_Int	bsr	Int_Cmd
		move.b	#0,Cmd_Input

* Branch forever.
 	
EndLoop		bra	Loop
		end	Main
		
* End of demo.s               
