/******************************************************************************
 A Hewlett-Packard Software Product
 Copyright Hewlett-Packard Co. 1992

 All Rights Reserved. Reproduction, adaptation, or translation without prior
 written  permission  is prohibited, except as allowed under copyright laws.
 ******************************************************************************/
/***************************************************************************
 * Function: init_system()
 *
 * Description: Initializes the environmental control system.
 *      It is called by main after power up.  The variables are
 *      initialized within this procedure so that the system can
 *      reboot without being reloaded.
 *
 * Parameters: None.
 *
 * References: None.
 *
 * Returns: Nothing.
 *
 * copyright Hewlett-Packard Company 1988
 ***************************************************************************/
#include        "updt_sys.h"
#include        "demo.h"

void init_val_arr();

void
init_system()
{   /* FUNCTION init_system() */
    /* Initialize the target values for temperature and humidity */
    target_temp = 73;
    target_humid = 45;

    /* Intialize the variables indicating the current environment */
    /* conditions */
    current_temp = 68;
    current_humid = 41;

    /* Set starting directions for temp and humid */
    temp_dir = up;
    humid_dir = up;

    /* Initialize the variables that depict the current status of the */
    /* computer room and what hardware needs to be on or off in the room */
    func_needed = 0;
    hdwr_encode = 0;

    /*Initialize the count of calls to update_state_of_system() */
    num_checks = 0;

    /* Initialize writing location in old_array */
    curr_loc = 0;

    /*Initialize the array that save the last cur_temp & cur_humid values*/
    init_val_arr();

}

/******************************************************************************
 * Function: init_val_arr()
 *
 * Description: This code initializes the val_arr data structure.
 *
 * Parameters: none
 *
 * References: None.
 *
 * Returns: Nothing.
 *****************************************************************************/
void
init_val_arr()
{
    int cur_el;
    for (cur_el = 0; cur_el < NUM_OF_OLD; cur_el++)
    {
        old_data[cur_el].temp = MIN_TEMP;
        old_data[cur_el].humid = MIN_HUMID;
        old_data[cur_el].ave_temp = 0.0;
        old_data[cur_el].ave_humid = 0.0;
    }
}

