"70116"
                GLB     Msgs,Init,Cmd_Input,Msg_Dest

		DATA
Msgs
Msg_A           DB      "Command A entered "
Msg_B           DB      "Command B entered "
Msg_I           DB      "Invalid Command   "
End_Msgs

		PROG
                ASSUME  DS0:DATA,DS1:COMN
******************************************************
* The following instructions initialize segment
* regsiters and set up the stack pointer.
******************************************************
Init            MOV     AW,SEG Msg_A
                MOV     DS0,AW
                MOV     AW,SEG Cmd_Input
                MOV     DS1,AW
                MOV     SS,AW
                MOV     SP,OFFSET Stk
******************************************************
* Clear previous command
******************************************************
Read_Cmd        MOV     Cmd_Input,#0
******************************************************
* Read command input byte.  If no command has been
* entered, continue to scan for command input.
******************************************************
Scan            MOV     AL,Cmd_Input
                CMP     AL,#0
                BE      Scan
******************************************************
* A command has been entered.  Check if it is
* command A, command B, or invalid.
******************************************************
Exe_Cmd         CMP     AL,#41H
                BE      Cmd_A
                CMP     AL,#42H
                BE      Cmd_B
                BR      Cmd_I
******************************************************
* Command A is entered.  CW = the number of bytes in
* message A.  BP = location of the message.  Jump to
* the routine which writes the message.
******************************************************
Cmd_A           MOV     CW,#Msg_B-Msg_A
                MOV     IX,OFFSET Msg_A
                BR      Write_Msg
******************************************************
* Command B is entered.
******************************************************
Cmd_B           MOV     CW,#Msg_I-Msg_B
                MOV     IX,OFFSET Msg_B
                BR      Write_Msg
******************************************************
* An invalid command is entered.
******************************************************
Cmd_I           MOV     CW,#End_Msgs-Msg_I
                MOV     IX,OFFSET Msg_I
******************************************************
* Message is written to the destination.
******************************************************
Write_Msg       MOV     IY,OFFSET Msg_Dest
                REP MOVBKB
******************************************************
* The rest of the destination area is filled
* with zeros.
******************************************************
Fill_Dest       MOV     BYTE PTR [IY],#0
                INC     IY
                CMP     IY,#Msg_Dest+20H
                BNE     Fill_Dest
******************************************************
* Go back and scan for next command
******************************************************
                BR      Read_Cmd

                COMN
******************************************************
* Command input byte.
******************************************************
Cmd_Input       DBS     1
******************************************************
* Destination of the command message.
******************************************************
Msg_Dest        DDS     3EH
Stk             DWS     1       ; Stack area.
                END	Init
