"80186"
;	@(mktid) 64764-11001  80186/8 EMUL FOREGRND MONITOR            A.00.01 27Jan88 11:06:39                                                                    
; Template for using background monitor features in user background code
;
; Following is a memory map of the background monitor.  The monitor always
; occupies 2Kbytes of space.  User code is always installed at offset 400H.
;
;-----------------------------------------------------------------------------
;
;   000H ****************************************************
;        *  IP,CS and flag jam area (all 8 bytes used)      *
;   008H ****************************************************
;        *  Vector area                                     *
;   00CH ****************************************************
;        *  Communications area                             *
;   020H ****************************************************
;        *  I/O area 0                                      *
;   030H ****************************************************
;        *  I/O area 1                                      *
;   040H ****************************************************
;        *  Set JAMBKGR flag                                *
;   048H ****************************************************
;        *  Reset JAMBKGW flag                              *
;   050H ****************************************************
;        *  Set BKGPS flag                                  *
;   058H ****************************************************
;        *  Reset BKGPS flag                                *
;   060H ****************************************************
;        *  Set BKGWTT flag                                 *
;   068H ****************************************************
;        *  Reset BKGWTT flag                               *
;   070H ****************************************************
;        *  Set BKGRFT flag                                 *
;   078H ****************************************************
;        *  Reset BKGRFT flag                               *
;   080H ****************************************************
;        *  Monitor Area                                    *
;   380H ****************************************************
;        *  Register Area                                   *
;   400H ****************************************************
;        *  Execute on Entry User code area                 *
;   480H ****************************************************
;        *  Execute while in Monitor User code area         *
;   500H ****************************************************
;        *  Execute on Exit User code area                  *
;   580H ****************************************************
;        *  Execute on Reset User code area                 *
;   6E0H ****************************************************
;        *  Monitor buffer area                             *
;   7F0H ****************************************************
;        *  Background reset area                           *
;   7FFH ****************************************************
;
;-----------------------------------------------------------------------------
; I/O Area 0
;
; A read from this area will bring in the following emulator status flags:
;
; Bit     Flag
;
;  0      Break request
;  1      Run request
;  2      Was Halted
;  3      Sixteen bit processor
;
; A write to this area will set the ready flag true.
;-----------------------------------------------------------------------------
; I/O Area 1
;
; A read from this area does the same thing as a read from I/O area 0.
;
; A write to this area sets the jam counter to the value written (only bit
; D0 is used).
;-----------------------------------------------------------------------------
; Locations 40H thru 7FH are special in that they require an opcode
; fetch from the appropriate range to set or reset the indicated flag.
; In all cases except for setting the jam read flag, JAMBKGR, the desired
; function must be called using the macro sfunc (sfunc guarantees that only
; opcode fetches are generated).
;-----------------------------------------------------------------------------

JAMAREA         EQU     000H
VECTAREA        EQU     008H
COMMAREA        EQU     00CH
IOAREA0         EQU     020H
IOAREA1         EQU     030H
MONAREA         EQU     080H

REGAREA         EQU     380H

ENTRYUAREA      EQU     400H
CONTUAREA       EQU     480H
EXITUAREA       EQU     500H
RESETUAREA      EQU     580H

BUFAREA         EQU     6E0H
RESETAREA       EQU     7F0H
TRUE            EQU     1
FALSE           EQU     0

SPECEN0         EQU     00001100000B
SPECEN1         EQU     00001000000B

BPA             EQU     00000B
BPB             EQU     01000B
BPC             EQU     10000B
BPD             EQU     11000B

IRETTOFG        EQU     00001000000B         ;SPECEN1 + BPA
CLRJAMBKGW      EQU     00001001000B         ;SPECEN1 + BPB

BREAKMASK       EQU     0001B
RUNMASK         EQU     0010B
WASHALTEDMASK   EQU     0100B
SXTNSELMASK     EQU     1000B
CMDAVAIL        EQU     0
CMDCOMPLETE     EQU     0FFFFH
INRFGLOOP       EQU     0FFFFH

; These functions may be useful.  They are called in the following manner:
;
; SFUNC <name>
;
; Where <name> (in lower case!!!) is one of the following:

; Present real status to the target system.
SETBKGPS        EQU     00001011000B         ;SPECEN1 + BPD
setbkgps        ORG     SETBKGPS

; Substitute either nothing or memory read for real status to the target
; (Depending on the setting of the ^cyc^ configuration item)
CLRBKGPS        EQU     00001010000B         ;SPECEN1 + BPC
clrbkgps        ORG     CLRBKGPS

; Send background writes to the target system.
SETBKGWTT       EQU     00001101000B         ;SPECEN0 + BPB
setbkgwtt       ORG     SETBKGWTT

; Send background writes to monitor memory.
CLRBKGWTT       EQU     00001100000B         ;SPECEN0 + BPA
clrbkgwtt       ORG     CLRBKGWTT

; Get background reads from monitor memory.
CLRBKGRFT       EQU     00001110000B         ;SPECEN0 + BPC
clrbkgrft       ORG     CLRBKGRFT

; Get background reads from the target system.
SETBKGRFT       EQU     00001111000B         ;SPECEN0 + BPD
setbkgrft       ORG     SETBKGRFT

;
; Macros
;
;

SFUNC           MACRO   &SUBADDR
                MOV     BP,#($+6)
                JMP     NEAR PTR &SUBADDR
                MEND

SFUNCRET        MACRO
                JMP     BP
                MEND

MONCALL         MACRO
                MOV     BX,#($+5)
;               JMP     [SI]
                DB      0FFH,024H
                MEND

MONRET          MACRO
                JMP     BX
                MEND

; User code macros
;
; These macros are used to get to and return from user routines.  Note that
; if BX is to be used, it must be saved and restored before executing a
; UCODERET.

UCODECALL       MACRO   &ULOC
                MOV     BX,#($+6)
                JMP     NEAR PTR &ULOC
                MEND

UCODERET        MACRO
                JMP     BX
                MEND

                ASSUME  CS:ORG,DS:ORG,ES:ORG

                ORG     ENTRYUAREA

; User code that is to execute on monitor entry goes here
;
; 1. dont use the stack
; 2. called on entry into the monitor
; 3. dont modify BX!!

                UCODERET



                ORG     CONTUAREA

; User code that is to execute on a continuous basis goes here.  This code
; is called whenever the monitor has nothing else to do.
;
; 1. dont use the stack
; 2. called once each monitor loop
; 3. dont modify BX!!
; ############################################################################
; Example to refresh DRAM
;
; This routine simply reads a word from every memory location below 80000H.
; This might be used as a replacement for DMA type refresh while in
; background.

                LDS     SI,CS:userptr           ;get word ptr to loc to read
                LODSW                           ;read it and inc si
                MOV     WORD PTR CS:userptr,SI  ;save it for next time
                CMP     SI,0                    ;is SI zero?
                JE      modseg                  ;if so skip
                UCODERET                        ;return
modseg:
                MOV     SI,DS                   ;get ds
                CMP     SI,7000H                ;is it 7000H?
                JE      zeroseg                 ;if so skip
                ADD     SI,1000H                ;else add 1000H
                MOV     WORD PTR CS:userptr+2,SI ;save it
                UCODERET                        ;return
zeroseg:
                MOV     SI,0                    ;clear si
                MOV     WORD PTR CS:userptr+2,SI ;put in seg location
                UCODERET                        ;return

; Define data
userptr         DD      0


; ############################################################################
; End example




                ORG     EXITUAREA

; User code that is to execute on monitor exit goes here
;
; 1. dont use the stack
; 2. called on exit from the monitor
; 3. dont modify BX!!

                UCODERET


                ORG     RESETUAREA

; User code that is to execute on monitor reset goes here
;
; 1. dont use the stack
; 2. called when the monitor is reset
; 3. dont modify BX!
; 4. a good place to set up memory/peripheral select lines

                UCODERET
