/******************************************************************************
 A Hewlett-Packard Software Product
 Copyright Hewlett-Packard Co. 1992

 All Rights Reserved. Reproduction, adaptation, or translation without prior
 written  permission  is prohibited, except as allowed under copyright laws.
 ******************************************************************************/
typedef enum    {false, true} boolean;
typedef enum {up,down} direction;

typedef struct
{
    short temp;
    short humid;
    float ave_temp;
    float ave_humid;
} old_el;

/********************
 * Global Variables
 ********************/
extern short    target_temp;            /* Target temperature. */
extern short    target_humid;           /* Target humidity. */

extern short    current_temp;           /* Current temperature. */
extern short    current_humid;          /* Current humidity. */

extern int      num_checks;             /* Number of times update_state_of_system */
                                        /* has been called. */
extern old_el old_data[NUM_OF_OLD];     /* temp and humid history */


extern char func_needed;       /* Function needed by system (humidify, */
                               /* dehumidify, heat, cool).  See main.c for  */
                               /* information. */

extern unsigned short hdwr_encode; /* Encoded 16-bit quantity used to */
                              /* communicate with */
                              /* hardware and indicate what external devices */
                              /* need to do to implement the needed function */
                              /* to the environment.  See main.c for more  */
                              /* information. */

extern int curr_loc;          /* location to write old temp and humid */
extern direction humid_dir,temp_dir; /* direction for current_vars */

