$mod186
$PL(98)
Org0000 SEGMENT AT 00000H
                ASSUME CS:Org0000,DS:Org0000,ES:Org0000
	NAME	fmon
; 
; Foreground monitor code for the 64767 emulators.
;
; NOTE: DO NOT MAKE ANY CHANGES TO THIS FILE, EXCEPT IN THE AREAS
; MARKED FOR USER CODE CHANGES.
; 

;
; Definitions of various address ranges in foreground monitor.
VECTORAREA      EQU     00000H
POINTERAREA     EQU     00400H
DATAAREA        EQU     00410H
COMMAREA        EQU     00430H
BUFAREA         EQU     00440H
MONAREA         EQU     00580H
TRAPBGAREA      EQU     00C00H

FMON_ENTRY1     EQU     MONAREA     
FMON_ENTRY2     EQU     FMON_ENTRY1+4
FMON_ENTRY3     EQU     FMON_ENTRY2+4

CMDCOMPLETE     EQU     0FFFFH
INRFGLOOP       EQU     0FFFFH

TRUE            EQU     1
FALSE           EQU     0

INTFLAG         EQU     0200H
SETERYVAL       EQU     00000001B
ENTNMIVAL       EQU     00000100B
SETMONVAL       EQU     00010000B
CTRLREGFGINIT   EQU     SETMONVAL+ENTNMIVAL

INTREQ          EQU     1
SBPBREAKMASK    EQU     00010000B
BREAKMASK       EQU     00001000B
RUNMASK         EQU     00000100B


                ORG     POINTERAREA
fregblk         DW      0
fdireg          DW      0
fsireg          DW      0
fbpreg          DW      0
fspreg          DW      0
fbxreg          DW      0
fdxreg          DW      0
fcxreg          DW      0
faxreg          DW      0
fdsreg          DW      0
fesreg          DW      0
fssreg          DW      0
fipreg          DW      0
fcsreg          DW      0
fflreg          DW      0
regblocksp      EQU     faxreg+2
lastbreakcause  DB      0
fgintvector     DB      0
emreadbkinfo    DB      0

                ORG     BUFAREA
buf             LABEL   BYTE
params          LABEL   WORD
                DB      0


                ORG     FMON_ENTRY1
                JMP     fmon1

                ORG     FMON_ENTRY2
                JMP     fmon2

                ORG     FMON_ENTRY3
                JMP     fmon3

                EVEN
fg_monitor 	PROC	NEAR

fmon1:
                MOV     AX,CS              ;Set the fgmon segment registers.
                MOV     DS,AX
                MOV     SS,AX
                LEA     SP,regblocksp      ;Initialize register stack pointer.
                MOV     ES,fspreg          ;Keep user SP value safe.
                MOV     AX,faxreg          ;Get user AX value.
                PUSHA                      ;Store DI,SI,BP,(fmon)SP,BX,DX,CX,AX
                PUSH    0
                MOV     fspreg,ES          ;Store real user SP.
                JMP     fgcmdloop          ;Now do the monitor.

                EVEN
fmon3:
                MOV     AX,CS
                MOV     DS,AX
                JMP     fgcmd_end


                EVEN
fmon2:

                MOV     AX,CS              ;Set the fgmon segment registers.
                MOV     DS,AX
                MOV     SS,AX
                LEA     SP,regblocksp      ;Initialize register stack pointer.
                MOV     ES,fspreg          ;Keep user SP value safe.
                MOV     AX,faxreg          ;Get user AX value.
                PUSHA                      ;Store DI,SI,BP,(fmon)SP,BX,DX,CX,AX
                PUSH    0
                MOV     SP,ES
                MOV     SS,fssreg          ;SS:SP points to user stack
                POP     fipreg             ;Get user IP, CS, FL.
                POP     fcsreg
                POP     fflreg
                MOV     fspreg,SP          ;Save the pre-interrupt user SP.
                TEST    lastbreakcause,SBPBREAKMASK ;Was it a software breakpoint?
                JZ      SHORT fgcmdloop    ;No, go straight to the monitor.
                DEC     fipreg             ;Yes, fix IP first.
                                           ;Now do the monitor.

fgcmdloop: 

;***************************************************************************
;***  BEGIN USER CODE CHANGES: ADD ANY CODE THAT MAY BE NEEDED TO KEEP   ***
;***  THE TARGET SYSTEM HAPPY.  CODE ADDED HERE WILL BE EXECUTED ONCE    ***
;***  BEFORE EACH COMMAND IS RECEIVED.                                   ***

                ; This is where your code will go.

;***                   END USER CODE CHANGES                            ****
;***************************************************************************

                LEA     SP,fregblk+2        ;Restore registers.
                MOV     AX,CS
                MOV     SS,AX
    	    	POPA	    	    	    ;Restore DI,SI,BP,BX,DX,CX,AX.
                MOV     SS,fssreg           ;Reload user stack in case
                MOV     SP,fspreg           ;registers were changed.
                MOV     ES,fesreg           ;Restore ES.
                MOV     DS,fdsreg           ;Restore DS.

                MOV     CS:ctrlreg,SETMONVAL;Enable target NMI.
                TEST    CS:fflreg,INTFLAG   ;Set user interrupts.
                JE      fgcmdloopa
                STI                         ;Enable maskable interrupts.
fgcmdloopa:

fgcmdloop1:

;***************************************************************************
;***  BEGIN USER CODE CHANGES: ADD ANY CODE THAT MAY BE NEEDED TO KEEP   ***
;***  THE TARGET SYSTEM HAPPY.  CODE ADDED HERE WILL BE EXECUTED         ***
;***  REPEATEDLY UNTIL A COMMAND IS RECEIVED.                            ***

                ; This is where your code will go.

;***                   END USER CODE CHANGES                            ****
;***************************************************************************

                CMP     CS:semaphore,CMDCOMPLETE ;test semaphore 
                JNE     fgcmdhere
                CMP     CS:statsemaphore,CMDCOMPLETE ;test semaphore 
                JE      fgcmdloop1  	;Wait for a command

fgcmdhere:
                CLI                     ;Command here: disable interrupts.
                MOV     CS:ctrlreg,SETMONVAL+ENTNMIVAL ;Disable target NMI.
                MOV     AX,CS
                MOV     DS,AX

;***************************************************************************
;***  BEGIN USER CODE CHANGES: ADD ANY CODE THAT MAY BE NEEDED TO KEEP   ***
;***  THE TARGET SYSTEM HAPPY.  CODE ADDED HERE WILL BE EXECUTED ONCE    ***
;***  WHEN A COMMAND HAS BEEN RECEIVED AND BEFORE IT IS PROCESSED.       ***

                ; This is where your code will go.

;***                   END USER CODE CHANGES                            ****
;***************************************************************************

exec_fgcmd: 
                CMP     CS:statsemaphore,CMDCOMPLETE
                JE      exec_fgcmd2
                JMP     fgbrkstatus

exec_fgcmd2:
                MOV     SI,DS:command   ;get command
                CMP     SI,10           ;test for max 
                JA      fgcmd_end       ;and skip if too big
                ADD     SI,SI           ;gen a word offset index
                ADD     SI,OFFSET fgcmd_table 
;               JMP     [SI]
 		DB	0FFH,024H
  

fgcmd_end: 

;***************************************************************************
;***  BEGIN USER CODE CHANGES: ADD ANY CODE THAT MAY BE NEEDED TO KEEP   ***
;***  THE TARGET SYSTEM HAPPY.  CODE ADDED HERE WILL BE EXECUTED ONCE    ***
;***  AFTER EACH COMMAND HAS BEEN RECEIVED AND PROCESSED.  WHEN THE      ***
;***  RUN COMMAND IS RECEIVED WE WILL GO TO USER CODE WITHOUT EXECUTING  ***
;***  THIS CODE.                                                         ***


                ; This is where your code will go.

;***                   END USER CODE CHANGES                            ****
;***************************************************************************

                MOV     CS:semaphore,CMDCOMPLETE ;Clear the semaphore
                MOV     CS:statsemaphore,CMDCOMPLETE ;Clear the semaphore
                JMP     fgcmdloop 
  
                EVEN
fgcmd_table     LABEL   WORD
                DW      OFFSET fgstatus ;command 0: get monitor status
                DW      OFFSET fgstep 	;command 1: single step (foreground?)
                DW      OFFSET fgexit 	;command 2: go to foreground monitor
                DW      OFFSET fgrfg 	;command 3: run from reset
                DW      OFFSET fgread 	;command 4: read memory
                DW      OFFSET fgwrite	;command 5: write memory
                DW      OFFSET fginput	;command 6: read io
                DW      OFFSET fgoutput ;command 7: write io
                DW      OFFSET fgrdpcb  ;command 8: read a list of PCB registers.
                DW      OFFSET fgwrpcb  ;command 9: write a list of PCB registers.
                DW      OFFSET fgbrkstatus ;command 10: get monitor status and sticky break status.

fg_monitor	ENDP		;+line+

; Foreground commands.
;
; NOTE: DO NOT MODIFY ANY OF THE CODE BELOW.

                EVEN
fgstatus        PROC    NEAR
    	    	MOV     AH,DS:breakcause
                MOV     AL,DS:fgintvector
                MOV     DS:params+0,AX
                MOV     DS:params+2,OFFSET fregblk
                JMP     fgcmd_end 
  
fgstatus	ENDP		;+line+

                EVEN
fgstep          PROC    NEAR
                MOV     DS:semaphore,CMDCOMPLETE 

                LEA     SP,fregblk+2        ;Restore registers.
                MOV     AX,CS
                MOV     SS,AX
    	    	POPA	    	    	    ;Restore DI,SI,BP,BX,DX,CX,AX.
                MOV     DS,CS:fdsreg        ;Restore DS.
                MOV     AX,0                ;Run command.
                MOV     CS:ctrlreg2,INTREQ  ;issue service request.
                NOP
                NOP                         ;shouldn't get this far.
    	    	JMP     fgcmd_end           ;Background service request:run user code.

                EVEN
fgexit: 
                MOV     DS:semaphore,CMDCOMPLETE 
                LEA     SP,fregblk+2        ;Restore registers.
                MOV     AX,CS
                MOV     SS,AX
    	    	POPA	    	    	    ;Restore DI,SI,BP,BX,DX,CX,AX.
                MOV     SS,fssreg           ;Reload user stack in case
                MOV     ES,fesreg           ;registers were changed.
                MOV     SP,fspreg
                MOV     DS,fdsreg           ;Restore DS.
                MOV     CS:ctrlreg,SETMONVAL+SETERYVAL+ENTNMIVAL ;set ready.
                MOV     CS:ctrlreg,SETMONVAL           ;enable target NMI.
                TEST    CS:fflreg,INTFLAG   ;Set user interrupts.
                JE      fgexita
                STI
fgexita:
		MOV	AH,CS:cmbstat   ;get status
exitlp:         ;Wait for run signal or break request.
		MOV	CS:wf_ready,TRUE ;tickle sense location
                MOV     AL,AH
		MOV	AH,CS:cmbstat    ;get status
                CMP     AL,AH
                JNZ     exitlp
                TEST    AL,RUNMASK       ;is there a run req?
                JZ      runit            ;if so, exit 
                TEST    AL,BREAKMASK     ;break request? 
                JNZ     exitlp           ;if not, loop
fgabortrun:
                CLI                      ;Disable interrupts.
                MOV     CS:ctrlreg,CTRLREGFGINIT ;Disable target NMI.
                JMP     fgcmd_end        ;Go back to monitor 

                EVEN
runit: 
                CLI                         ;Run command here: disable interrupts.
                MOV     CS:ctrlreg,CTRLREGFGINIT ;Disable target NMI.
                LEA     SP,fregblk+2        ;Restore registers.
                MOV     AX,CS
                MOV     SS,AX
    	    	POPA	    	    	    ;Restore DI,SI,BP,BX,DX,CX,AX.
                MOV     DS,CS:fdsreg        ;Restore DS.
                MOV     AX,1                ;Run command.
                MOV     CS:ctrlreg2,INTREQ  ;issue service request.
                NOP
                NOP                         ;shouldn't get this far.
    	    	JMP     fgcmd_end           ;Background service request:run user code.

fgstep  	ENDP		;+line+


                EVEN
fgrfg           PROC    NEAR
                MOV     DS:semaphore,INRFGLOOP  ;akw command
                MOV     DS:ctrlreg,SETMONVAL+SETERYVAL+ENTNMIVAL ;Set emul ready.
                MOV     DS:ctrlreg,SETMONVAL           ;enable target NMI.
                TEST    CS:fflreg,INTFLAG   ;Set user interrupts.
                JE      fgrfg1
                STI
fgrfg1: 
		MOV	DS:wf_reset,TRUE ;tickle sense location
                JMP     fgrfg1          ;loop until reset

fgrfg   	ENDP		;+line+

                EVEN
fgread          PROC    NEAR
                MOV     AX,4                ;Run command.
                MOV     CS:ctrlreg2,INTREQ  ;issue service request.
                NOP
                NOP                         ;shouldn't get this far.
    	    	JMP     fgcmd_end           ;Background service request:run user code.

fgread	ENDP

                EVEN
fgwrite         PROC    NEAR
                MOV     AX,5                ;Run command.
                MOV     CS:ctrlreg2,INTREQ  ;issue service request.
                NOP
                NOP                         ;shouldn't get this far.
    	    	JMP     fgcmd_end           ;Background service request:run user code.

fgwrite	ENDP
  
                EVEN
fginput         PROC    NEAR
                MOV     AX,CS
                MOV     ES,AX
                MOV     AX,DS:params+0
                MOV     CX,DS:params+2 
                MOV     DX,DS:params+4 
                MOV     DI,OFFSET buf   ;ES:DI points to monitor memory.
    	    	CLD
                CMP     AL,'b'
		JE      fginputbytes
                SHR     CX,1            ;Adjust count to words.
fginputwords: 
                REP INSW
		JMP     fgcmd_end       ;It's that easy.

                EVEN
fginputbytes:		      
                REP INSB
		JMP     fgcmd_end       ;It's that easy.

fginput	ENDP

                EVEN
fgoutput        PROC    NEAR
                MOV     AX,DS:params+0
                MOV     CX,DS:params+2 
                MOV     DX,DS:params+4 
                MOV     SI,OFFSET params+8 ;DS:SI points to monitor memory.
                CMP     AL,'b'
		JE      fgoutputbytes
fgoutputwords: 
                REP OUTSW
		JMP     fgcmd_end       ;It's that easy.

                EVEN
fgoutputbytes: 
                REP OUTSB
		JMP     fgcmd_end       ;It's that easy.
fgoutput	ENDP		;+line+

                EVEN
fgrdpcb         PROC    NEAR
                MOV     AX,2      ;Let background code do it.
                MOV     DS:ctrlreg2,INTREQ ;issue service request.
                NOP
                NOP                     ;shouldn't get this far.
    	    	JMP     fgcmd_end

fgrdpcb	ENDP		;+line+

                EVEN
fgwrpcb         PROC    NEAR
                MOV     AX,3      ;Let background code do it.
                MOV     DS:ctrlreg2,INTREQ ;issue service request.
                NOP
                NOP                     ;shouldn't get this far.
    	    	JMP     fgcmd_end

fgwrpcb	ENDP		;+line+

  
                EVEN
fgbrkstatus     PROC    NEAR
    	    	MOV     AH,DS:lastbreakcause
                MOV     AL,DS:fgintvector
                MOV     DS:statblock+0,AX
                MOV     DS:statblock+2,OFFSET fregblk
    	    	MOV     AH,DS:emreadbkinfo
                MOV     AL,0
                MOV     DS:statblock+4,AX
                MOV     DS:emreadbkinfo,0
                JMP     fgcmd_end 
  
fgbrkstatus	ENDP		;+line+






		ORG	VECTORAREA
;***************************************************************************
;***  BEGIN USER CODE CHANGES: CHANGE ENTRIES TO POINT TO USER CODE ********
;
;
; 186 interrupt vectors.  The 186 hardcodes the interrupt vector table at
; addresses 0-7fH.  This table is shown here in case anyone wants to make
; code that uses the interrupts.  The vectors are initialized to point to
; a dummy routine just in case.
;
; For each vector there is a word to be put in the IP register and a word
; for the CS register.
;
EMUL_MON_ADDR   EQU     0  ;Set this label to the foreground monitor address.

int_vector_000  LABEL   WORD               ;interrupt vector 000
                DW      emul_iv000_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_001  LABEL   WORD               ;interrupt vector 001
                DW      emul_iv001_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_002  LABEL   WORD               ;interrupt vector 002
                DW      emul_iv002_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_003  LABEL   WORD               ;interrupt vector 003
                DW      emul_iv003_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_004  LABEL   WORD               ;interrupt vector 004
                DW      emul_iv004_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_005  LABEL   WORD               ;interrupt vector 005
                DW      emul_iv005_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_006  LABEL   WORD               ;interrupt vector 006
                DW      emul_iv006_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_007  LABEL   WORD               ;interrupt vector 007
                DW      emul_iv007_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_008  LABEL   WORD               ;interrupt vector 008
                DW      emul_iv008_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_009  LABEL   WORD               ;interrupt vector 009
                DW      emul_iv009_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_010  LABEL   WORD               ;interrupt vector 010
                DW      emul_iv010_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_011  LABEL   WORD               ;interrupt vector 011
                DW      emul_iv011_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_012  LABEL   WORD               ;interrupt vector 012
                DW      emul_iv012_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_013  LABEL   WORD               ;interrupt vector 013
                DW      emul_iv013_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_014  LABEL   WORD               ;interrupt vector 014
                DW      emul_iv014_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_015  LABEL   WORD               ;interrupt vector 015
                DW      emul_iv015_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_016  LABEL   WORD               ;interrupt vector 016
                DW      emul_iv016_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_017  LABEL   WORD               ;interrupt vector 017
                DW      emul_iv017_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_018  LABEL   WORD               ;interrupt vector 018
                DW      emul_iv018_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_019  LABEL   WORD               ;interrupt vector 019
                DW      emul_iv019_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_020  LABEL   WORD               ;interrupt vector 020
                DW      emul_iv020_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_021  LABEL   WORD               ;interrupt vector 021
                DW      emul_iv021_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_022  LABEL   WORD               ;interrupt vector 022
                DW      emul_iv022_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_023  LABEL   WORD               ;interrupt vector 023
                DW      emul_iv023_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_024  LABEL   WORD               ;interrupt vector 024
                DW      emul_iv024_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_025  LABEL   WORD               ;interrupt vector 025
                DW      emul_iv025_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_026  LABEL   WORD               ;interrupt vector 026
                DW      emul_iv026_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_027  LABEL   WORD               ;interrupt vector 027
                DW      emul_iv027_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_028  LABEL   WORD               ;interrupt vector 028
                DW      emul_iv028_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_029  LABEL   WORD               ;interrupt vector 029
                DW      emul_iv029_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_030  LABEL   WORD               ;interrupt vector 030
                DW      emul_iv030_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_031  LABEL   WORD               ;interrupt vector 031
                DW      emul_iv031_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_032  LABEL   WORD               ;interrupt vector 032
                DW      emul_iv032_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_033  LABEL   WORD               ;interrupt vector 033
                DW      emul_iv033_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_034  LABEL   WORD               ;interrupt vector 034
                DW      emul_iv034_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_035  LABEL   WORD               ;interrupt vector 035
                DW      emul_iv035_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_036  LABEL   WORD               ;interrupt vector 036
                DW      emul_iv036_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_037  LABEL   WORD               ;interrupt vector 037
                DW      emul_iv037_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_038  LABEL   WORD               ;interrupt vector 038
                DW      emul_iv038_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_039  LABEL   WORD               ;interrupt vector 039
                DW      emul_iv039_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_040  LABEL   WORD               ;interrupt vector 040
                DW      emul_iv040_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_041  LABEL   WORD               ;interrupt vector 041
                DW      emul_iv041_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_042  LABEL   WORD               ;interrupt vector 042
                DW      emul_iv042_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_043  LABEL   WORD               ;interrupt vector 043
                DW      emul_iv043_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_044  LABEL   WORD               ;interrupt vector 044
                DW      emul_iv044_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_045  LABEL   WORD               ;interrupt vector 045
                DW      emul_iv045_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_046  LABEL   WORD               ;interrupt vector 046
                DW      emul_iv046_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_047  LABEL   WORD               ;interrupt vector 047
                DW      emul_iv047_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_048  LABEL   WORD               ;interrupt vector 048
                DW      emul_iv048_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_049  LABEL   WORD               ;interrupt vector 049
                DW      emul_iv049_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_050  LABEL   WORD               ;interrupt vector 050
                DW      emul_iv050_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_051  LABEL   WORD               ;interrupt vector 051
                DW      emul_iv051_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_052  LABEL   WORD               ;interrupt vector 052
                DW      emul_iv052_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_053  LABEL   WORD               ;interrupt vector 053
                DW      emul_iv053_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_054  LABEL   WORD               ;interrupt vector 054
                DW      emul_iv054_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_055  LABEL   WORD               ;interrupt vector 055
                DW      emul_iv055_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_056  LABEL   WORD               ;interrupt vector 056
                DW      emul_iv056_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_057  LABEL   WORD               ;interrupt vector 057
                DW      emul_iv057_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_058  LABEL   WORD               ;interrupt vector 058
                DW      emul_iv058_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_059  LABEL   WORD               ;interrupt vector 059
                DW      emul_iv059_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_060  LABEL   WORD               ;interrupt vector 060
                DW      emul_iv060_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_061  LABEL   WORD               ;interrupt vector 061
                DW      emul_iv061_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_062  LABEL   WORD               ;interrupt vector 062
                DW      emul_iv062_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_063  LABEL   WORD               ;interrupt vector 063
                DW      emul_iv063_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_064  LABEL   WORD               ;interrupt vector 064
                DW      emul_iv064_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_065  LABEL   WORD               ;interrupt vector 065
                DW      emul_iv065_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_066  LABEL   WORD               ;interrupt vector 066
                DW      emul_iv066_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_067  LABEL   WORD               ;interrupt vector 067
                DW      emul_iv067_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_068  LABEL   WORD               ;interrupt vector 068
                DW      emul_iv068_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_069  LABEL   WORD               ;interrupt vector 069
                DW      emul_iv069_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_070  LABEL   WORD               ;interrupt vector 070
                DW      emul_iv070_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_071  LABEL   WORD               ;interrupt vector 071
                DW      emul_iv071_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_072  LABEL   WORD               ;interrupt vector 072
                DW      emul_iv072_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_073  LABEL   WORD               ;interrupt vector 073
                DW      emul_iv073_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_074  LABEL   WORD               ;interrupt vector 074
                DW      emul_iv074_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_075  LABEL   WORD               ;interrupt vector 075
                DW      emul_iv075_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_076  LABEL   WORD               ;interrupt vector 076
                DW      emul_iv076_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_077  LABEL   WORD               ;interrupt vector 077
                DW      emul_iv077_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_078  LABEL   WORD               ;interrupt vector 078
                DW      emul_iv078_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_079  LABEL   WORD               ;interrupt vector 079
                DW      emul_iv079_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_080  LABEL   WORD               ;interrupt vector 080
                DW      emul_iv080_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_081  LABEL   WORD               ;interrupt vector 081
                DW      emul_iv081_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_082  LABEL   WORD               ;interrupt vector 082
                DW      emul_iv082_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_083  LABEL   WORD               ;interrupt vector 083
                DW      emul_iv083_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_084  LABEL   WORD               ;interrupt vector 084
                DW      emul_iv084_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_085  LABEL   WORD               ;interrupt vector 085
                DW      emul_iv085_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_086  LABEL   WORD               ;interrupt vector 086
                DW      emul_iv086_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_087  LABEL   WORD               ;interrupt vector 087
                DW      emul_iv087_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_088  LABEL   WORD               ;interrupt vector 088
                DW      emul_iv088_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_089  LABEL   WORD               ;interrupt vector 089
                DW      emul_iv089_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_090  LABEL   WORD               ;interrupt vector 090
                DW      emul_iv090_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_091  LABEL   WORD               ;interrupt vector 091
                DW      emul_iv091_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_092  LABEL   WORD               ;interrupt vector 092
                DW      emul_iv092_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_093  LABEL   WORD               ;interrupt vector 093
                DW      emul_iv093_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_094  LABEL   WORD               ;interrupt vector 094
                DW      emul_iv094_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_095  LABEL   WORD               ;interrupt vector 095
                DW      emul_iv095_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_096  LABEL   WORD               ;interrupt vector 096
                DW      emul_iv096_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_097  LABEL   WORD               ;interrupt vector 097
                DW      emul_iv097_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_098  LABEL   WORD               ;interrupt vector 098
                DW      emul_iv098_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_099  LABEL   WORD               ;interrupt vector 099
                DW      emul_iv099_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_100  LABEL   WORD               ;interrupt vector 100
                DW      emul_iv100_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_101  LABEL   WORD               ;interrupt vector 101
                DW      emul_iv101_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_102  LABEL   WORD               ;interrupt vector 102
                DW      emul_iv102_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_103  LABEL   WORD               ;interrupt vector 103
                DW      emul_iv103_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_104  LABEL   WORD               ;interrupt vector 104
                DW      emul_iv104_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_105  LABEL   WORD               ;interrupt vector 105
                DW      emul_iv105_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_106  LABEL   WORD               ;interrupt vector 106
                DW      emul_iv106_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_107  LABEL   WORD               ;interrupt vector 107
                DW      emul_iv107_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_108  LABEL   WORD               ;interrupt vector 108
                DW      emul_iv108_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_109  LABEL   WORD               ;interrupt vector 109
                DW      emul_iv109_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_110  LABEL   WORD               ;interrupt vector 110
                DW      emul_iv110_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_111  LABEL   WORD               ;interrupt vector 111
                DW      emul_iv111_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_112  LABEL   WORD               ;interrupt vector 112
                DW      emul_iv112_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_113  LABEL   WORD               ;interrupt vector 113
                DW      emul_iv113_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_114  LABEL   WORD               ;interrupt vector 114
                DW      emul_iv114_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_115  LABEL   WORD               ;interrupt vector 115
                DW      emul_iv115_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_116  LABEL   WORD               ;interrupt vector 116
                DW      emul_iv116_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_117  LABEL   WORD               ;interrupt vector 117
                DW      emul_iv117_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_118  LABEL   WORD               ;interrupt vector 118
                DW      emul_iv118_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_119  LABEL   WORD               ;interrupt vector 119
                DW      emul_iv119_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_120  LABEL   WORD               ;interrupt vector 120
                DW      emul_iv120_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_121  LABEL   WORD               ;interrupt vector 121
                DW      emul_iv121_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_122  LABEL   WORD               ;interrupt vector 122
                DW      emul_iv122_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_123  LABEL   WORD               ;interrupt vector 123
                DW      emul_iv123_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_124  LABEL   WORD               ;interrupt vector 124
                DW      emul_iv124_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_125  LABEL   WORD               ;interrupt vector 125
                DW      emul_iv125_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_126  LABEL   WORD               ;interrupt vector 126
                DW      emul_iv126_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_127  LABEL   WORD               ;interrupt vector 127
                DW      emul_iv127_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_128  LABEL   WORD               ;interrupt vector 128
                DW      emul_iv128_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_129  LABEL   WORD               ;interrupt vector 129
                DW      emul_iv129_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_130  LABEL   WORD               ;interrupt vector 130
                DW      emul_iv130_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_131  LABEL   WORD               ;interrupt vector 131
                DW      emul_iv131_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_132  LABEL   WORD               ;interrupt vector 132
                DW      emul_iv132_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_133  LABEL   WORD               ;interrupt vector 133
                DW      emul_iv133_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_134  LABEL   WORD               ;interrupt vector 134
                DW      emul_iv134_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_135  LABEL   WORD               ;interrupt vector 135
                DW      emul_iv135_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_136  LABEL   WORD               ;interrupt vector 136
                DW      emul_iv136_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_137  LABEL   WORD               ;interrupt vector 137
                DW      emul_iv137_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_138  LABEL   WORD               ;interrupt vector 138
                DW      emul_iv138_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_139  LABEL   WORD               ;interrupt vector 139
                DW      emul_iv139_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_140  LABEL   WORD               ;interrupt vector 140
                DW      emul_iv140_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_141  LABEL   WORD               ;interrupt vector 141
                DW      emul_iv141_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_142  LABEL   WORD               ;interrupt vector 142
                DW      emul_iv142_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_143  LABEL   WORD               ;interrupt vector 143
                DW      emul_iv143_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_144  LABEL   WORD               ;interrupt vector 144
                DW      emul_iv144_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_145  LABEL   WORD               ;interrupt vector 145
                DW      emul_iv145_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_146  LABEL   WORD               ;interrupt vector 146
                DW      emul_iv146_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_147  LABEL   WORD               ;interrupt vector 147
                DW      emul_iv147_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_148  LABEL   WORD               ;interrupt vector 148
                DW      emul_iv148_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_149  LABEL   WORD               ;interrupt vector 149
                DW      emul_iv149_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_150  LABEL   WORD               ;interrupt vector 150
                DW      emul_iv150_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_151  LABEL   WORD               ;interrupt vector 151
                DW      emul_iv151_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_152  LABEL   WORD               ;interrupt vector 152
                DW      emul_iv152_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_153  LABEL   WORD               ;interrupt vector 153
                DW      emul_iv153_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_154  LABEL   WORD               ;interrupt vector 154
                DW      emul_iv154_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_155  LABEL   WORD               ;interrupt vector 155
                DW      emul_iv155_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_156  LABEL   WORD               ;interrupt vector 156
                DW      emul_iv156_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_157  LABEL   WORD               ;interrupt vector 157
                DW      emul_iv157_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_158  LABEL   WORD               ;interrupt vector 158
                DW      emul_iv158_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_159  LABEL   WORD               ;interrupt vector 159
                DW      emul_iv159_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_160  LABEL   WORD               ;interrupt vector 160
                DW      emul_iv160_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_161  LABEL   WORD               ;interrupt vector 161
                DW      emul_iv161_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_162  LABEL   WORD               ;interrupt vector 162
                DW      emul_iv162_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_163  LABEL   WORD               ;interrupt vector 163
                DW      emul_iv163_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_164  LABEL   WORD               ;interrupt vector 164
                DW      emul_iv164_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_165  LABEL   WORD               ;interrupt vector 165
                DW      emul_iv165_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_166  LABEL   WORD               ;interrupt vector 166
                DW      emul_iv166_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_167  LABEL   WORD               ;interrupt vector 167
                DW      emul_iv167_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_168  LABEL   WORD               ;interrupt vector 168
                DW      emul_iv168_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_169  LABEL   WORD               ;interrupt vector 169
                DW      emul_iv169_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_170  LABEL   WORD               ;interrupt vector 170
                DW      emul_iv170_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_171  LABEL   WORD               ;interrupt vector 171
                DW      emul_iv171_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_172  LABEL   WORD               ;interrupt vector 172
                DW      emul_iv172_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_173  LABEL   WORD               ;interrupt vector 173
                DW      emul_iv173_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_174  LABEL   WORD               ;interrupt vector 174
                DW      emul_iv174_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_175  LABEL   WORD               ;interrupt vector 175
                DW      emul_iv175_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_176  LABEL   WORD               ;interrupt vector 176
                DW      emul_iv176_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_177  LABEL   WORD               ;interrupt vector 177
                DW      emul_iv177_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_178  LABEL   WORD               ;interrupt vector 178
                DW      emul_iv178_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_179  LABEL   WORD               ;interrupt vector 179
                DW      emul_iv179_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_180  LABEL   WORD               ;interrupt vector 180
                DW      emul_iv180_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_181  LABEL   WORD               ;interrupt vector 181
                DW      emul_iv181_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_182  LABEL   WORD               ;interrupt vector 182
                DW      emul_iv182_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_183  LABEL   WORD               ;interrupt vector 183
                DW      emul_iv183_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_184  LABEL   WORD               ;interrupt vector 184
                DW      emul_iv184_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_185  LABEL   WORD               ;interrupt vector 185
                DW      emul_iv185_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_186  LABEL   WORD               ;interrupt vector 186
                DW      emul_iv186_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_187  LABEL   WORD               ;interrupt vector 187
                DW      emul_iv187_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_188  LABEL   WORD               ;interrupt vector 188
                DW      emul_iv188_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_189  LABEL   WORD               ;interrupt vector 189
                DW      emul_iv189_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_190  LABEL   WORD               ;interrupt vector 190
                DW      emul_iv190_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_191  LABEL   WORD               ;interrupt vector 191
                DW      emul_iv191_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_192  LABEL   WORD               ;interrupt vector 192
                DW      emul_iv192_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_193  LABEL   WORD               ;interrupt vector 193
                DW      emul_iv193_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_194  LABEL   WORD               ;interrupt vector 194
                DW      emul_iv194_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_195  LABEL   WORD               ;interrupt vector 195
                DW      emul_iv195_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_196  LABEL   WORD               ;interrupt vector 196
                DW      emul_iv196_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_197  LABEL   WORD               ;interrupt vector 197
                DW      emul_iv197_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_198  LABEL   WORD               ;interrupt vector 198
                DW      emul_iv198_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_199  LABEL   WORD               ;interrupt vector 199
                DW      emul_iv199_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_200  LABEL   WORD               ;interrupt vector 200
                DW      emul_iv200_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_201  LABEL   WORD               ;interrupt vector 201
                DW      emul_iv201_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_202  LABEL   WORD               ;interrupt vector 202
                DW      emul_iv202_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_203  LABEL   WORD               ;interrupt vector 203
                DW      emul_iv203_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_204  LABEL   WORD               ;interrupt vector 204
                DW      emul_iv204_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_205  LABEL   WORD               ;interrupt vector 205
                DW      emul_iv205_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_206  LABEL   WORD               ;interrupt vector 206
                DW      emul_iv206_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_207  LABEL   WORD               ;interrupt vector 207
                DW      emul_iv207_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_208  LABEL   WORD               ;interrupt vector 208
                DW      emul_iv208_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_209  LABEL   WORD               ;interrupt vector 209
                DW      emul_iv209_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_210  LABEL   WORD               ;interrupt vector 210
                DW      emul_iv210_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_211  LABEL   WORD               ;interrupt vector 211
                DW      emul_iv211_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_212  LABEL   WORD               ;interrupt vector 212
                DW      emul_iv212_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_213  LABEL   WORD               ;interrupt vector 213
                DW      emul_iv213_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_214  LABEL   WORD               ;interrupt vector 214
                DW      emul_iv214_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_215  LABEL   WORD               ;interrupt vector 215
                DW      emul_iv215_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_216  LABEL   WORD               ;interrupt vector 216
                DW      emul_iv216_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_217  LABEL   WORD               ;interrupt vector 217
                DW      emul_iv217_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_218  LABEL   WORD               ;interrupt vector 218
                DW      emul_iv218_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_219  LABEL   WORD               ;interrupt vector 219
                DW      emul_iv219_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_220  LABEL   WORD               ;interrupt vector 220
                DW      emul_iv220_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_221  LABEL   WORD               ;interrupt vector 221
                DW      emul_iv221_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_222  LABEL   WORD               ;interrupt vector 222
                DW      emul_iv222_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_223  LABEL   WORD               ;interrupt vector 223
                DW      emul_iv223_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_224  LABEL   WORD               ;interrupt vector 224
                DW      emul_iv224_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_225  LABEL   WORD               ;interrupt vector 225
                DW      emul_iv225_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_226  LABEL   WORD               ;interrupt vector 226
                DW      emul_iv226_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_227  LABEL   WORD               ;interrupt vector 227
                DW      emul_iv227_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_228  LABEL   WORD               ;interrupt vector 228
                DW      emul_iv228_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_229  LABEL   WORD               ;interrupt vector 229
                DW      emul_iv229_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_230  LABEL   WORD               ;interrupt vector 230
                DW      emul_iv230_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_231  LABEL   WORD               ;interrupt vector 231
                DW      emul_iv231_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_232  LABEL   WORD               ;interrupt vector 232
                DW      emul_iv232_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_233  LABEL   WORD               ;interrupt vector 233
                DW      emul_iv233_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_234  LABEL   WORD               ;interrupt vector 234
                DW      emul_iv234_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_235  LABEL   WORD               ;interrupt vector 235
                DW      emul_iv235_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_236  LABEL   WORD               ;interrupt vector 236
                DW      emul_iv236_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_237  LABEL   WORD               ;interrupt vector 237
                DW      emul_iv237_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_238  LABEL   WORD               ;interrupt vector 238
                DW      emul_iv238_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_239  LABEL   WORD               ;interrupt vector 239
                DW      emul_iv239_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_240  LABEL   WORD               ;interrupt vector 240
                DW      emul_iv240_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_241  LABEL   WORD               ;interrupt vector 241
                DW      emul_iv241_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_242  LABEL   WORD               ;interrupt vector 242
                DW      emul_iv242_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_243  LABEL   WORD               ;interrupt vector 243
                DW      emul_iv243_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_244  LABEL   WORD               ;interrupt vector 244
                DW      emul_iv244_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_245  LABEL   WORD               ;interrupt vector 245
                DW      emul_iv245_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_246  LABEL   WORD               ;interrupt vector 246
                DW      emul_iv246_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_247  LABEL   WORD               ;interrupt vector 247
                DW      emul_iv247_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_248  LABEL   WORD               ;interrupt vector 248
                DW      emul_iv248_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_249  LABEL   WORD               ;interrupt vector 249
                DW      emul_iv249_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_250  LABEL   WORD               ;interrupt vector 250
                DW      emul_iv250_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_251  LABEL   WORD               ;interrupt vector 251
                DW      emul_iv251_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_252  LABEL   WORD               ;interrupt vector 252
                DW      emul_iv252_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_253  LABEL   WORD               ;interrupt vector 253
                DW      emul_iv253_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_254  LABEL   WORD               ;interrupt vector 254
                DW      emul_iv254_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.
int_vector_255  LABEL   WORD               ;interrupt vector 255
                DW      emul_iv255_entry   ;IP for service routine for this interrupt.
                DW      EMUL_MON_ADDR / 16 ;CS for service routine for this interrupt.

;***                   END USER CODE CHANGES                            ****
;***************************************************************************


                ORG     TRAPBGAREA
cmbstat         LABEL   BYTE 
ctrlreg 	LABEL	BYTE
                ORG     TRAPBGAREA+2
breakcause      LABEL   BYTE 
ctrlreg2 	LABEL	BYTE

                ORG     TRAPBGAREA
emul_iv000_entry:
                NOP
emul_iv001_entry:
                NOP
emul_iv002_entry:
                NOP
emul_iv003_entry:
                NOP
emul_iv004_entry:
                NOP
emul_iv005_entry:
                NOP
emul_iv006_entry:
                NOP
emul_iv007_entry:
                NOP
emul_iv008_entry:
                NOP
emul_iv009_entry:
                NOP
emul_iv010_entry:
                NOP
emul_iv011_entry:
                NOP
emul_iv012_entry:
                NOP
emul_iv013_entry:
                NOP
emul_iv014_entry:
                NOP
emul_iv015_entry:
                NOP
emul_iv016_entry:
                NOP
emul_iv017_entry:
                NOP
emul_iv018_entry:
                NOP
emul_iv019_entry:
                NOP
emul_iv020_entry:
                NOP
emul_iv021_entry:
                NOP
emul_iv022_entry:
                NOP
emul_iv023_entry:
                NOP
emul_iv024_entry:
                NOP
emul_iv025_entry:
                NOP
emul_iv026_entry:
                NOP
emul_iv027_entry:
                NOP
emul_iv028_entry:
                NOP
emul_iv029_entry:
                NOP
emul_iv030_entry:
                NOP
emul_iv031_entry:
                NOP
emul_iv032_entry:
                NOP
emul_iv033_entry:
                NOP
emul_iv034_entry:
                NOP
emul_iv035_entry:
                NOP
emul_iv036_entry:
                NOP
emul_iv037_entry:
                NOP
emul_iv038_entry:
                NOP
emul_iv039_entry:
                NOP
emul_iv040_entry:
                NOP
emul_iv041_entry:
                NOP
emul_iv042_entry:
                NOP
emul_iv043_entry:
                NOP
emul_iv044_entry:
                NOP
emul_iv045_entry:
                NOP
emul_iv046_entry:
                NOP
emul_iv047_entry:
                NOP
emul_iv048_entry:
                NOP
emul_iv049_entry:
                NOP
emul_iv050_entry:
                NOP
emul_iv051_entry:
                NOP
emul_iv052_entry:
                NOP
emul_iv053_entry:
                NOP
emul_iv054_entry:
                NOP
emul_iv055_entry:
                NOP
emul_iv056_entry:
                NOP
emul_iv057_entry:
                NOP
emul_iv058_entry:
                NOP
emul_iv059_entry:
                NOP
emul_iv060_entry:
                NOP
emul_iv061_entry:
                NOP
emul_iv062_entry:
                NOP
emul_iv063_entry:
                NOP
emul_iv064_entry:
                NOP
emul_iv065_entry:
                NOP
emul_iv066_entry:
                NOP
emul_iv067_entry:
                NOP
emul_iv068_entry:
                NOP
emul_iv069_entry:
                NOP
emul_iv070_entry:
                NOP
emul_iv071_entry:
                NOP
emul_iv072_entry:
                NOP
emul_iv073_entry:
                NOP
emul_iv074_entry:
                NOP
emul_iv075_entry:
                NOP
emul_iv076_entry:
                NOP
emul_iv077_entry:
                NOP
emul_iv078_entry:
                NOP
emul_iv079_entry:
                NOP
emul_iv080_entry:
                NOP
emul_iv081_entry:
                NOP
emul_iv082_entry:
                NOP
emul_iv083_entry:
                NOP
emul_iv084_entry:
                NOP
emul_iv085_entry:
                NOP
emul_iv086_entry:
                NOP
emul_iv087_entry:
                NOP
emul_iv088_entry:
                NOP
emul_iv089_entry:
                NOP
emul_iv090_entry:
                NOP
emul_iv091_entry:
                NOP
emul_iv092_entry:
                NOP
emul_iv093_entry:
                NOP
emul_iv094_entry:
                NOP
emul_iv095_entry:
                NOP
emul_iv096_entry:
                NOP
emul_iv097_entry:
                NOP
emul_iv098_entry:
                NOP
emul_iv099_entry:
                NOP
emul_iv100_entry:
                NOP
emul_iv101_entry:
                NOP
emul_iv102_entry:
                NOP
emul_iv103_entry:
                NOP
emul_iv104_entry:
                NOP
emul_iv105_entry:
                NOP
emul_iv106_entry:
                NOP
emul_iv107_entry:
                NOP
emul_iv108_entry:
                NOP
emul_iv109_entry:
                NOP
emul_iv110_entry:
                NOP
emul_iv111_entry:
                NOP
emul_iv112_entry:
                NOP
emul_iv113_entry:
                NOP
emul_iv114_entry:
                NOP
emul_iv115_entry:
                NOP
emul_iv116_entry:
                NOP
emul_iv117_entry:
                NOP
emul_iv118_entry:
                NOP
emul_iv119_entry:
                NOP
emul_iv120_entry:
                NOP
emul_iv121_entry:
                NOP
emul_iv122_entry:
                NOP
emul_iv123_entry:
                NOP
emul_iv124_entry:
                NOP
emul_iv125_entry:
                NOP
emul_iv126_entry:
                NOP
emul_iv127_entry:
                NOP
emul_iv128_entry:
                NOP
emul_iv129_entry:
                NOP
emul_iv130_entry:
                NOP
emul_iv131_entry:
                NOP
emul_iv132_entry:
                NOP
emul_iv133_entry:
                NOP
emul_iv134_entry:
                NOP
emul_iv135_entry:
                NOP
emul_iv136_entry:
                NOP
emul_iv137_entry:
                NOP
emul_iv138_entry:
                NOP
emul_iv139_entry:
                NOP
emul_iv140_entry:
                NOP
emul_iv141_entry:
                NOP
emul_iv142_entry:
                NOP
emul_iv143_entry:
                NOP
emul_iv144_entry:
                NOP
emul_iv145_entry:
                NOP
emul_iv146_entry:
                NOP
emul_iv147_entry:
                NOP
emul_iv148_entry:
                NOP
emul_iv149_entry:
                NOP
emul_iv150_entry:
                NOP
emul_iv151_entry:
                NOP
emul_iv152_entry:
                NOP
emul_iv153_entry:
                NOP
emul_iv154_entry:
                NOP
emul_iv155_entry:
                NOP
emul_iv156_entry:
                NOP
emul_iv157_entry:
                NOP
emul_iv158_entry:
                NOP
emul_iv159_entry:
                NOP
emul_iv160_entry:
                NOP
emul_iv161_entry:
                NOP
emul_iv162_entry:
                NOP
emul_iv163_entry:
                NOP
emul_iv164_entry:
                NOP
emul_iv165_entry:
                NOP
emul_iv166_entry:
                NOP
emul_iv167_entry:
                NOP
emul_iv168_entry:
                NOP
emul_iv169_entry:
                NOP
emul_iv170_entry:
                NOP
emul_iv171_entry:
                NOP
emul_iv172_entry:
                NOP
emul_iv173_entry:
                NOP
emul_iv174_entry:
                NOP
emul_iv175_entry:
                NOP
emul_iv176_entry:
                NOP
emul_iv177_entry:
                NOP
emul_iv178_entry:
                NOP
emul_iv179_entry:
                NOP
emul_iv180_entry:
                NOP
emul_iv181_entry:
                NOP
emul_iv182_entry:
                NOP
emul_iv183_entry:
                NOP
emul_iv184_entry:
                NOP
emul_iv185_entry:
                NOP
emul_iv186_entry:
                NOP
emul_iv187_entry:
                NOP
emul_iv188_entry:
                NOP
emul_iv189_entry:
                NOP
emul_iv190_entry:
                NOP
emul_iv191_entry:
                NOP
emul_iv192_entry:
                NOP
emul_iv193_entry:
                NOP
emul_iv194_entry:
                NOP
emul_iv195_entry:
                NOP
emul_iv196_entry:
                NOP
emul_iv197_entry:
                NOP
emul_iv198_entry:
                NOP
emul_iv199_entry:
                NOP
emul_iv200_entry:
                NOP
emul_iv201_entry:
                NOP
emul_iv202_entry:
                NOP
emul_iv203_entry:
                NOP
emul_iv204_entry:
                NOP
emul_iv205_entry:
                NOP
emul_iv206_entry:
                NOP
emul_iv207_entry:
                NOP
emul_iv208_entry:
                NOP
emul_iv209_entry:
                NOP
emul_iv210_entry:
                NOP
emul_iv211_entry:
                NOP
emul_iv212_entry:
                NOP
emul_iv213_entry:
                NOP
emul_iv214_entry:
                NOP
emul_iv215_entry:
                NOP
emul_iv216_entry:
                NOP
emul_iv217_entry:
                NOP
emul_iv218_entry:
                NOP
emul_iv219_entry:
                NOP
emul_iv220_entry:
                NOP
emul_iv221_entry:
                NOP
emul_iv222_entry:
                NOP
emul_iv223_entry:
                NOP
emul_iv224_entry:
                NOP
emul_iv225_entry:
                NOP
emul_iv226_entry:
                NOP
emul_iv227_entry:
                NOP
emul_iv228_entry:
                NOP
emul_iv229_entry:
                NOP
emul_iv230_entry:
                NOP
emul_iv231_entry:
                NOP
emul_iv232_entry:
                NOP
emul_iv233_entry:
                NOP
emul_iv234_entry:
                NOP
emul_iv235_entry:
                NOP
emul_iv236_entry:
                NOP
emul_iv237_entry:
                NOP
emul_iv238_entry:
                NOP
emul_iv239_entry:
                NOP
emul_iv240_entry:
                NOP
emul_iv241_entry:
                NOP
emul_iv242_entry:
                NOP
emul_iv243_entry:
                NOP
emul_iv244_entry:
                NOP
emul_iv245_entry:
                NOP
emul_iv246_entry:
                NOP
emul_iv247_entry:
                NOP
emul_iv248_entry:
                NOP
emul_iv249_entry:
                NOP
emul_iv250_entry:
                NOP
emul_iv251_entry:
                NOP
emul_iv252_entry:
                NOP
emul_iv253_entry:
                NOP
emul_iv254_entry:
                NOP
emul_iv255_entry:
                NOP

;Define communications area
		ORG	COMMAREA
wf_ready        DW      ?
wf_reset	DW	?
semaphore       DW      CMDCOMPLETE
command         DW      2
statsemaphore   DW      CMDCOMPLETE
statblock       DW      0
                DW      0
                DW      0
      



Org0000	ENDS		;+line+
	END		;+line+

