$ processor (214)	; target processor is 78214 
$ xref			; product cross reference list
$ debug			; output local symbol information

		public	Init,Msgs,Cmd_Input,Msg_Dest

;***************************************************
; Message Data
;***************************************************
S_Msg		dseg
Msgs:
Msg_A:		db	'Command A entered '
Msg_B:		db	'Entered B command '
Msg_I:		db	'Invalid Command   '
End_Msgs:

;***************************************************
; Set up Reset Vector.
;***************************************************
		org	0000h
		dw	Init

Code		cseg	unit
;***************************************************
; Actual start point of this sample program.	
;***************************************************
Init:		di			; disable interrupts
		sel	rb0		; select reg. bank 0
		movw	sp,#Stk		; set stack pointer
		mov	mm,#80h		; single chip mode

;***************************************************
; Clear previous command.
;***************************************************
Read_Cmd:	mov	a,#0
		mov	!Cmd_Input,a

;***************************************************
; Read command input byte.  If no command has been
; entered, continue to scan for command input. 
;***************************************************
Scan:		mov	a,!Cmd_Input
		cmp	a,#0
		be	$Scan

;***************************************************
; A command has been entered.  Check if it is
; command A, command B, or invalid.
;***************************************************
Exe_Cmd:	cmp	a,#'A'
		be	$Cmd_A
		cmp	a,#'B'
		be	$Cmd_B
		br	$Cmd_I

;***************************************************
; Command A is entered.
;***************************************************
Cmd_A:		mov	b,#Msg_B-Msg_A
		movw	hl,#Msg_A
		callf	!Write_Msg
		br	$Read_Cmd

;***************************************************
; Command B is entered.
;***************************************************
Cmd_B:		mov	b,#Msg_I-Msg_B
		movw	hl,#Msg_B
		callf	!Write_Msg
		br	$Read_Cmd

;***************************************************
; An invalid command is entered.
;***************************************************
Cmd_I:		mov	b,#End_Msgs-Msg_I
		movw	hl,#Msg_I
		callf	!Write_Msg
		br	$Read_Cmd

F_Table		cseg	fixed
;***************************************************
; Transfer message to message destination area.
;***************************************************
Write_Msg:	movw	de,#Msg_Dest
Fill_Dest:	mov	a,[hl+]
		mov	[de+],a
		dec 	b
		bne	$Fill_Dest
		ret 

Work		dseg
;***************************************************
; Cmd_Input, Message destination, Stack area.
;***************************************************
Cmd_Input:	ds	1
Msg_Dest:	ds	126
Stk:		ds	1

		end

