--{{{  interface header
--{{{  interface lexemes
VAL f.endprog   IS  -1 :
VAL f.startprog IS  -2 :
VAL f.startfold IS  -3 :
VAL f.nextitem  IS  -4 :
VAL f.endfold   IS  -5 :
VAL f.error     IS  -6 :
VAL f.string    IS  -7 :
VAL f.desc      IS  -8 :
VAL f.startsc   IS  -9 :
VAL f.totalcode IS -10 :
VAL f.code      IS -11 :
VAL f.entry     IS -12 :
VAL f.debug     IS -13 :
VAL f.sc        IS -14 :
VAL f.address   IS -15 :
VAL f.warning   IS -16 :
VAL f.comment   IS -17 :
VAL f.include   IS -18 :
VAL f.link      IS -19 :
VAL f.startlib  IS -26 :
VAL f.endlib    IS -27 :
VAL f.profile   IS -28 :
--}}}  
--{{{  options and check bits
VAL check.ix     IS 0 :      --STARTPROG indexing
VAL bpw.ix       IS 1 :      --bitsperword
VAL wslot.ix     IS 2 :      --wslot size
VAL reg.ix       IS 3 :      --register params
VAL target.ix    IS 4 :      --target processor type

--options
VAL range.chk           IS     3 :  --array bound checks
VAL alias.chk           IS     4 :  --set if alias checking
VAL usage.chk           IS     8 :  --set if usage checking
VAL sc.flag             IS    16 :  --set if SC compiling
VAL exe.unit            IS    32 :  --set if exe or util
VAL sep.vecs            IS    64 :  --set if separate vector space
VAL run.loc             IS   128 :  --enable production of runtime locate info
VAL config.mode         IS   256 :  --flag this is configuration level
VAL range.check         IS   512 :  --global range checking flag
VAL guy.allowed         IS  1024 :  --guy constructs allowed
VAL full.guy            IS  2048 :  --all guy constructs allowed
VAL profiling.enabled   IS  4096 :  --profiling enabled
VAL profiling.safeadd   IS  8192 :  --use safe add when profiling
VAL profiling.timeslice IS 16384 :  --timeslice when profiling
--}}}  
--{{{  processor types and info for configurer
VAL p.none      IS  -1 :
VAL p.tany      IS   0 :
VAL p.t2        IS   2 :
VAL p.t4        IS   4 :
VAL p.m68000    IS   5 :
VAL p.vax       IS   6 :
VAL p.t202a     IS   7 :
VAL p.t8        IS   8 :
VAL p.t425      IS   9 :
VAL p.ta        IS  10 :   -- t414/425/800
VAL p.tb        IS  11 :   -- t414/425
VAL p.tc        IS  12 :   -- t425/800
--}}}  
--{{{  linker tags
VAL ln.mininst      IS  0 :      --min transputer instruction
VAL ln.maxinst      IS 15 :      --max transputer instruction
VAL ln.long         IS 16 :
VAL ln.word         IS 17 :
VAL ln.longadj      IS 18 :

VAL ln.datasymb     IS 33 :
VAL ln.ref          IS 34 :
VAL ln.static       IS 35 :
VAL ln.common       IS 36 :
VAL ln.codefix      IS 37 :
VAL ln.datafix      IS 38 :
VAL ln.staticfix    IS 39 :
VAL ln.limit        IS 40 :
VAL ln.init         IS 41 :
VAL ln.maininit     IS 43 :
VAL ln.modnum       IS 44 :
VAL ln.codesymb     IS 45 :
VAL ln.nextmodule   IS 46 :
VAL ln.entrysymb    IS 47 :
VAL ln.workspacefix IS 48 :
VAL ln.newentrysymb IS 49 :
VAL ln.vectorspacefix IS 50 :
--}}}  
--{{{  error mode
VAL e.nocheck   IS 0 :
VAL e.halt      IS 1 :
VAL e.stop      IS 2 :
VAL e.universal IS 3 :
--}}}  
--{{{  library logical name mask bits
VAL m.R IS 1<<8:
VAL m.H IS 1<<16:
VAL m.S IS 1<<24:
VAL m.U IS (m.R + m.H) + m.S:
VAL m.T2 IS 1:
VAL m.T4 IS 2:
VAL m.T8 IS 4:
VAL m.T5 IS 8:
VAL m.TC IS m.T8 + m.T5:
VAL m.TB IS m.T4 + m.T5:
VAL m.TA IS m.T4 + m.TC:
--}}}  
--{{{  constants for bottom.up
--{{{  compiler functions
VAL fn.extract     IS -4 :
VAL fn.recompile   IS -3 :
VAL fn.compile     IS -2 :
VAL fn.check       IS -1 :
VAL fn.tracefront  IS  0 :
VAL fn.tracelexer  IS  1 :
VAL fn.tracesyntax IS  2 :
VAL fn.tracestruct IS  3 :
VAL fn.tracetype   IS  4 :
VAL fn.tracetrans  IS  5 :
VAL fn.tracegen    IS  6 :
VAL fn.tracebind   IS  7 :
VAL fn.tracecode   IS  8 :
VAL fn.special     IS  9 :
--}}}  
--{{{  compiler fold position constants
VAL fold.source IS 1 :       --fold number indexes into source fold
VAL fold.code   IS 2 :
VAL fold.desc   IS 3 :
VAL fold.link   IS 4 :
VAL fold.debug  IS 5 :

VAL desc.id     IS 1 :       --fold number indexes into descriptor fold
VAL desc.proc   IS 2 :
VAL desc.entry  IS 3 :
VAL desc.link   IS 4 :
VAL desc.libs   IS 5 :
--}}}  
--{{{  filer protocol tags
VAL f.finish IS 0 :
VAL f.read   IS 1 :
VAL f.write  IS 2 :
--}}}  
--}}}  
--}}}  
