--{{{  LIB 
--{{{  TDS header
--{{{  systems supported
VAL vaxvms IS 0 :
VAL tripos IS 1 :
VAL inmos IS 2 :
VAL host.os IS inmos :
--}}} 
--{{{  data sizes
VAL bytes.per.word IS 4 :
VAL bytes.in.word IS 4 :
VAL sh.bytes.in.word IS 2 :
VAL mask.bytes.in.word IS #03 :

VAL bits.in.byte IS 8 :
VAL sh.bits.in.byte IS 3 :
VAL mask.bits.in.byte IS #07 :

VAL bits.in.word IS bits.in.byte * bytes.in.word :
VAL sh.bits.in.word IS sh.bits.in.byte + sh.bytes.in.word :
VAL mask.bits.in.word IS (mask.bits.in.byte << sh.bytes.in.word) \/ mask.bytes.in.word :

VAL bytes.in.page IS 500 :       -- basic unit of disk IO (bytes) (TDS3)
VAL maxint IS (-1) >> 1 :
--}}} 
--{{{  text lines
VAL message.line      IS first.screen.line :
VAL first.text.line   IS first.screen.line + 1 :
--}}} 
--{{{  message tags to keyboard process (nc)
VAL read.key.request   IS BYTE 1 :
VAL terminate.request  IS BYTE 2 :
VAL initialise.request IS BYTE 3 :
VAL key.raw.request    IS BYTE 4 :
VAL key.cooked.request IS BYTE 5 :
VAL release.request    IS BYTE 6 :
VAL claim.request      IS BYTE 7 :
--}}} 
--{{{  various extra tags
VAL tt.set.poll IS BYTE 25:
VAL tkf.sp.transaction IS 45:
VAL fkf.sp.transaction IS 45:
--}}} 
--{{{  type and content
VAL fold.type IS 1 :
VAL fold.content IS 2 :
VAL fold.indent IS 3 :
--}}} 
--{{{  message tags to editor
VAL display.command IS 1 :
VAL endmessage.command IS 2 :
VAL locate.command IS 3 :
VAL forcelocate.command IS 4 :
VAL jump.command IS 5 :
VAL beep.command IS 6 :
VAL redisplayline.command IS 7 :
VAL redisplayscreen.command IS 8 :
VAL nextline.command IS 9 :
VAL getlinetype.command IS 10 :
VAL getitempos.command IS 11 :
VAL setitempos.command IS 12 :
VAL startline.command IS 13 :
VAL resetline.command IS 14 :
VAL getparams.command IS 15 :
VAL readkey.command IS 16 :
VAL rawdisplay.command IS 17 :
VAL finish.command IS 18 :
VAL release.command IS 19 :
VAL claim.command IS 20 :
VAL current.util IS 21 :
VAL prevline.command IS 22:
VAL end.view IS -1 :                      -- response by editor to nextline.command
--}}} 
--{{{  fold manager protocol
--{{{  message tags for fold manager protocol
VAL firstitem.signal IS 1 :
VAL lastitem.signal IS 2 :
VAL nextitem.signal IS 3 :
VAL previtem.signal IS 4 :
VAL nthitem.signal IS 5 :
VAL itemno.signal IS 6 :
VAL itemclass.signal IS 7 :
VAL foldlength.signal IS 8 :
VAL enterfold.signal IS 9 :
VAL exitfold.signal IS 10 :
VAL readstring.signal IS 11 :
VAL writestring.signal IS 12 :
VAL deleteitem.signal IS 13 :
VAL containsfile.signal IS 14 :
VAL insertafter.signal IS 15 :
VAL insertbefore.signal IS 16 :
VAL emptyfoldafter.signal IS 17 :
VAL emptyfoldbefore.signal IS 18 :
VAL pickitem.signal IS 19 :
VAL copyitem.signal IS 20 :
VAL putafter.signal IS 21 :
VAL putbefore.signal IS 22 :
VAL openfold.signal IS 23 :
VAL closefold.signal IS 24 :
VAL createfold.signal IS 25 :
VAL deletefold.signal IS 26 :
VAL createfile.signal IS 27 :
VAL deletefile.signal IS 28 :
VAL derivefile.signal IS 29 :
VAL readattr.signal IS 30 :
VAL writeattr.signal IS 31 :
VAL room.signal IS 32 :
VAL itempicked.signal IS 33 :
VAL changesoff.signal IS 34 :
VAL changeson.signal IS 35 :
VAL setchanged.signal IS 36 :

VAL readfileid.signal IS 37 :
VAL readparentid.signal IS 38 :
VAL writeback.signal IS 39 :

VAL flushfolds.signal IS 40 :
VAL filerresult.signal IS 41 :

VAL terminate.signal IS 42 :

VAL existsfile.signal IS 43 :
VAL namedfilestore.signal IS 44 :
VAL candeletefiles.signal IS 45 :
VAL cancopyfiles.signal IS 46 :
VAL canmovefiles.signal IS 47 :
VAL attachfile.signal IS 48 :
VAL readfileascii.signal IS 49 :
VAL deletecontents.signal IS 50 :
VAL simpleattachfile.signal IS 51 :
VAL simpledeletefile.signal IS 52 :

VAL swappick.signal IS 53 :

VAL switchtopickitem.signal   IS 54:
VAL switchfrompickitem.signal IS 55:
VAL copypickitem.signal       IS 56:
VAL addpickitem.signal        IS 57:
VAL switchtoitemafter.signal  IS 58:
VAL editor.signal             IS 59:
VAL noteditor.signal          IS 60:

VAL createhostfile.signal     IS 61:
VAL readfullstring.signal     IS 62:
VAL writefullstring.signal    IS 63:
VAL fmsize.signal             IS 64:
--}}} 
--{{{  responses from fold manager + derive
--{{{  replies to createfile signal
VAL create.ok.reply            IS 0 :
VAL create.fail.reply          IS 1 :
VAL create.exists.reply        IS 2 :
VAL create.attach.reply        IS 3 :
VAL create.new.file.reply      IS 4 :
VAL create.renamed.reply       IS 5 :
VAL create.already.filed.reply IS 6 :
--}}} 
--{{{  replies to derive (overlay to createfile replies)
VAL derive.ok.reply IS 0 :
VAL derive.fail.reply IS 1 :
VAL derive.baditem.reply IS 4 :
--}}} 
--{{{  replies to copyitem signal
VAL copy.ok.reply IS 0 :
VAL copy.noroom.reply IS 1 :
VAL copy.file.reply IS 2 :
VAL copy.fail.reply IS 3 :
VAL copy.nodisk.reply IS 4 :
VAL copy.toodeep.reply IS 5 :
--}}} 
--{{{  replies to open signal
VAL open.ok.reply IS 0 :
VAL open.new.reply IS 1 :
VAL open.fail.reply IS 2 :
VAL open.noroom.reply IS 3 :
VAL open.badfmt.reply IS 4 :
--}}} 
--{{{  replies to deletefile signal
VAL delfile.ok.reply IS 0 :
VAL delfile.new.reply IS 1 :
VAL delfile.fail.reply IS 2 :
VAL delfile.noroom.reply IS 3 :
VAL delfile.badfmt.reply IS 4 :
--}}} 
--{{{  replies to close signal
VAL close.ok.reply IS 0 :
VAL close.fail.reply IS 1 :
--}}} 
--}}} 
--}}} 
--{{{  file.numbers and an error
VAL fi.invalid.file.id           IS -1104 :
VAL max.valid.file  IS maxint :
VAL min.valid.file  IS 257 :
VAL raw.mode        IS max.valid.file :
VAL volume.file     IS max.valid.file - 1 :
VAL free.map        IS max.valid.file - 2 :
VAL file.map        IS max.valid.file - 3 :
VAL file.map.index  IS max.valid.file - 4 :
VAL max.normal.file IS max.valid.file - 5 :
VAL no.file         IS -1 :
--}}} 
--{{{  file stream internal codes -- 11-5-86 (21 to 32)
VAL uf.no.stopper             IS BYTE 21 :
VAL uf.terminate              IS BYTE 22 :
VAL uf.mx.terminate           IS BYTE 23 :
VAL fsd.aborted               IS BYTE 24 :
VAL uf.get.id.read            IS BYTE 25 :
VAL uf.get.id.write           IS BYTE 26 :
VAL uf.get.id                 IS BYTE 27 :
VAL fsd.full.id               IS BYTE 28 :
VAL uf.copy.all               IS BYTE 29: -- Copy this file and all it contains
VAL uf.open.fold.write.single IS BYTE 30 :
VAL fsc.read.real.id          IS BYTE 31 :
VAL uf.delete                 IS BYTE 32 :

--}}} 
--}}} 
--}}} 
