--{{{  var and exp node offsets and masks (for 32 bit host)
--{{{  variables stuff
--masks
VAL tag.mask   IS #FF000000 : --mode bits
VAL ptr.mask   IS #00FFFFFF : --pointer bits

--variable heap entry record offsets

VAL v.name     IS 0 :
VAL v.ptr      IS 1 :  --\ packed together
VAL v.tag      IS 1 :  --/ as one word
VAL v.size     IS 2 :

--var modes
VAL vt.small      IS #80000000 : --small constant
VAL vt.large      IS #01000000 : --large constant
VAL vt.double     IS #02000000 : --double length constant
VAL vt.var        IS #03000000 : --variable
VAL vt.seqprot    IS #04000000 : --sequential protocol
VAL vt.varprot    IS #05000000 : --variant protocol
VAL vt.proc       IS #06000000 : --proc/func definition
VAL vt.casetag    IS #07000000 : --protocol tag
VAL vt.configchan IS #08000000 : --config level channel
VAL vt.configsc   IS #09000000 : --config level SC
VAL vt.predef     IS #0A000000 : --prdef proc/func definition

--heap record offsets for variables
VAL v.q    IS 0 : --q bits for vars/lex level of def
VAL v.abbr IS 1 : --link to parent if item is abbreviated
VAL v.prot IS 2 : --pointer to protocol if channel
VAL v.type IS 3 : --type of identifier/array dims
VAL v.dims IS 4 : --start of dimensions
		  --also used as minimum record size

--extra values for known base & count replicators
VAL v.base  IS -1 :
VAL v.count IS -2 :

--offsets from end of dimensions for abbreviation info
VAL a.parent  IS 0 :  --pointer to previous abbrev for variable
VAL a.abbr    IS 1 :  --pointer to abbreviation which forced creation of this
VAL a.type    IS 2 :  --nil for name, otherwise l.subscr or l.slice
VAL a.subscr  IS 3 :  --subscript value if known or nil if variable
VAL a.base    IS 3 :  --base of slice if known   "   "  "   "
VAL a.count   IS 4 :  --slice length  "   "      "   "  "   "
VAL a.maxsize IS 5 :

--heap record offsets for procs / functions
VAL p.q        IS 0 : --q bits for vars/lex level of def/outer lex used
VAL p.name     IS 1 : --saved procs name during definition
VAL p.nonlocal IS 1 : --number of lex levels of non-local access
VAL p.free     IS 2 : --free variable list
VAL p.results  IS 3 : --number of results
VAL p.size     IS 4 :

--info for config level SC
VAL csc.target       IS -1 :
VAL csc.errormode    IS -2 :
VAL csc.size         IS  2 :

--alias stack record offsets
VAL a.next IS 0 :     --next record belonging to proc or nil at end
VAL a.ptr  IS 1 :     --pointer to free variables stack entry
VAL a.size IS 2 :

--alias stack variable usage info
-- The fact that a variable is in the free variable list implies
-- that it is either read or written.  If it is written to then it is
-- marked as such with the flag below.
-- If a channel is in the free variable list then it has been used for either
-- input or output.  If it has been used for input then it is marked
-- with the flag defined below.
-- These flags go in the a.ptr field of the entry with the pointer.

VAL a.written IS #80000000 : --flag variable is written
VAL a.input   IS a.written : --flag channel is used for input

VAL a.pmask   IS ~a.written : -- pointer mask

--var types are packed with array dimensions above type number
VAL type.bias  IS 8 : --shift count for array dimensions
VAL dimen.mask IS (-1) << type.bias :
VAL type.mask  IS ~dimen.mask : --mask for type

--packed access
VAL q.shift   IS 17 :
VAL q.mask    IS (-1) << q.shift :  -- = #FFFE0000 if q.shift = 17
VAL lex.mask  IS ~q.mask :          -- = #0001FFFF if q.shift = 17

VAL dim.lex.shift IS q.shift :      -- for packed dimension names
VAL dim.name.mask IS lex.mask :

VAL dim.in.exp    IS q.mask :
VAL dim.node.mask IS ~dim.in.exp :

VAL param.name.mask IS lex.mask :   -- for packed parameter defs

--Q bits indicate access to vars
VAL q.fixedrepl  IS #00020000 : --var is replicator with known base & count
VAL q.inputchan  IS #00040000 : --chan is used for input
VAL q.outputchan IS #00080000 : --chan is used for output
VAL q.ptr        IS #00100000 : --var is a pointer to its value
VAL q.varabbr    IS #00200000 : --var is rhs of non-val abbreviation
VAL q.abbrparam  IS #00400000 : --var is used in expression/subscr in abbrev
VAL q.written    IS #00800000 : --var is assigned/input to
VAL q.readonly   IS #01000000 : --var is read only
VAL q.flushed    IS #02000000 : --flag if constructor has been flushed
VAL q.place      IS #04000000 : --placed at memory address
VAL q.abbrev     IS #08000000 : --is an abbreviation
VAL q.const      IS #10000000 : --static constructor
VAL q.param      IS #20000000 : --parameter
VAL q.vec        IS #40000000 : --vector decl flag for procs,
				--in vecspace flag for variables
VAL q.lib        IS #80000000 : --proc is library flag

--usage info
--usage record offsets
VAL u.udata    IS 0 :
VAL u.bitmap   IS 1 :
VAL u.usize    IS 2 :

--usage data fields
VAL u.umask    IS #FF000000 : --mask for usage info
VAL u.pmask    IS ~u.umask :  --mask for variable pointer

--markers
VAL um.par     IS #00FFFFFE :
VAL um.inpar   IS #00FFFFFF :

--values for variables
VAL u.written  IS #80000000 : --flag var is written to in this process
VAL u.read     IS #40000000 : --flag var is read in this process
VAL u.input    IS #20000000 :
VAL u.output   IS #10000000 :
VAL u.array    IS #08000000 : --flag var is an array

--config porcessor info
VAL pro.next       IS 0 :
VAL pro.physical   IS 1 :
VAL pro.logical    IS 2 :
VAL pro.type       IS 3 :
VAL pro.error.mode IS 4 :
VAL pro.links      IS 5 :

--data storage in config channel record
VAL pro.shift IS 8 :
VAL link.mask IS ~((-1) << pro.shift) :

--offsets in config channel record
VAL cc.input  IS 0 :
VAL cc.output IS 1 :
--}}}
--{{{  expression offsets
VAL n.symb  IS 0 : --node symbol type
VAL n.type  IS 1 : --base type
VAL n.left  IS 2 : --subtree pointers
VAL n.right IS 3 :
VAL n.val   IS 4 : --value for numbers
VAL n.val2  IS 5 : --\extra value for double lengths
VAL n.def   IS 5 : --/var definition pointer

VAL n.size IS 6 :
--}}}
--}}}
