/*
 * 
 * $Copyright
 * Copyright 1993, 1994, 1995  Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
static char sccsid[] = "@(#)builtin.c	1.17  com/cmd/ksh/sh,3.1,9013 3/14/90 19:09:42";
/*
 * COMPONENT_NAME: (CMDKSH) Korn shell
 *
 * FUNCTIONS:
 *
 * ORIGINS: 3, 26, 27
 *
 * This module contains IBM CONFIDENTIAL code. -- (IBM
 * Confidential Restricted when combined with the aggregated
 * modules for this product)
 * OBJECT CODE ONLY SOURCE MATERIALS
 * (C) COPYRIGHT International Business Machines Corp. 1989
 * All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

/*

 *      Copyright (c) 1984, 1985, 1986, 1987, 
 *                  1988, 1989   AT&T
 *      All Rights Reserved

 *      THIS IS UNPUBLISHED PROPRIETARY SOURCE 
 *      CODE OF AT&T.
 *      The copyright notice above does not 
 *      evidence any actual or intended
 *      publication of such source code.

 */
/*
 *  builtin routines for the shell
 *
 *   David Korn
 *   AT&T Bell Laboratories
 *   Room 3C-526B
 *   Murray Hill, N. J. 07974
 *   Tel. x7975
 *
 */

#ifdef TSH
/*
 *   NOTE: The option flag T_FLAG is ambiguous in this code. Sometimes
 *         it means "tracked", as in tracked alias; sometimes it means 
 *         "xtrace", as in trace execution. As tsh disables tracked
 *	   aliases, this can sometimes be confusing.
 */
#endif /* TSH */
#ifdef MSG
#include "ksh_msg.h"
extern nl_catd catd;
#define MSGSTR(n,s) NLcatgets(catd,MS_KSH,n,s)
#else
#define MSGSTR(n,s) s
#endif

#include	<errno.h>
#include	"defs.h"
#include	"history.h"
#include	"builtins.h"
#include	"jobs.h"
#include	"sym.h"

#ifdef _sys_resource_
#   ifndef included_sys_time_
#	include <sys/time.h>
#   endif
#   include	<sys/resource.h>/* needed for ulimit */
#   define	LIM_FSIZE	RLIMIT_FSIZE
#   define	LIM_DATA	RLIMIT_DATA
#   define	LIM_STACK	RLIMIT_STACK
#   define	LIM_CORE	RLIMIT_CORE
#   define	LIM_CPU		RLIMIT_CPU
#   define	INFINITY	RLIM_INFINITY
#   ifdef RLIMIT_RSS
#	define	LIM_MAXRSS	RLIMIT_RSS
#   endif /* RLIMIT_RSS */
#   else
#   ifdef VLIMIT
#	include	<sys/vlimit.h>
#   endif /* VLIMIT */
#endif	/* _sys_resource_ */

#ifdef  KSH_88D
#ifdef UNIVERSE
    static int att_univ = -1;
#   ifdef _sys_universe_
#       include <sys/universe.h>
#       define getuniverse(x)   (setuniverse(flag=setuniverse(0)),\
                                (--flag>=0?strncpy(x,univ_name[flag],TMPSIZ):0),\
                                flag)
#   else
#       define univ_number(x)   (x)
#   endif /* _sys_universe_ */
#endif /* UNIVERSE */
#endif /* KSH_88D */
#ifdef ECHOPRINT
#   undef ECHO_RAW
#   undef ECHO_N
#endif /* ECHOPRINT */

#define DOTMAX	32	/* maximum level of . nesting */
#define PHYS_MODE	H_FLAG
#define LOG_MODE	N_LJUST

/* This module references these external routines */
#ifdef ECHO_RAW
    extern char		*echo_mode();
#endif	/* ECHO_RAW */
#ifdef FS_3D
    extern char		*path_real();
#endif /* FS_3D */
extern int		gscan_all();
extern char		*utos();
extern void		ltou();

static int	flagset();
static void	cfailed();
static int	sig_number();
static int	scanargs();
static char	*cmd_name;
#ifdef JOBS
#ifdef  KSH_88D
    static void sig_list(int);
#else
    static void sig_list();
#endif  /* KSH_88D */
#endif	/* JOBS */
static int	argnum;
static int 	aflag;
static int	newflag;
static int	echon;

void sh_builtin(int xbuiltin, int argn, char *com[], union anynode *t)
{
	register char *a1 = com[1];
	struct Amemory *troot;
#ifndef KJI
	register
#endif
	int flag = 0;
	int scoped = 0;
	aflag = 0;
	argnum = 0;
	newflag = 0;
	if(a1)
		aflag = *a1;
	cmd_name = com[0];
	switch(xbuiltin)
	{
		case SYSEXEC:
			com++;
			st.ioset = 0;
			if(a1==0)
				break;

		case SYSLOGIN:
	
			if(is_option(RSHFLG))
				cfailed(MSGSTR(E_RESTRICTED, (char *)e_restricted)); /*MSG*/
			else
			{
				if(job_close() < 0)
				{
					sh.exitval=1;
					break;
				}
				/* force bad exec to terminate shell */
				st.states &= ~(PROFILE|PROMPT|BUILTIN|LASTPIPE);
				sig_reset(0);
				io_rmtemp((struct ionod*)0);
				path_exec(com,(struct argnod*)0);
				sh_done(0);
			}


		case SYSSETGROUPS:
		case SYSNEWGRP:
		case SYSLOGOUT:
		case SYSSETSENV:

			if(job_close() < 0)
				{
					sh.exitval=1;
					break;
				}
			/* force bad exec to terminate shell */
			st.states &= ~(PROFILE|PROMPT|BUILTIN|LASTPIPE);
			sig_reset(0);
			io_rmtemp((struct ionod*)0);
			path_exec(com,(struct argnod*)0);
			sh_done(0);

#ifdef OLDTEST
		case SYSTEST:	/* test	expression */
			sh.exitval = b_test(argn, com);
			break;
#endif /* OLDTEST */

		case SYSPWD:	/* pwd routine */
#if defined(LSTAT) || defined(FS_3D)
			while(a1 && *a1=='-'&& 
				(flag = flagset(a1,~(PHYS_MODE|LOG_MODE))))
			{
				if(flag&LOG_MODE)
					flag = 0;
				com++;
				a1 = com[1];
			}
#endif /* LSTAT||FS_3D */
			if(*(a1 = path_pwd(0))!='/')
				cfailed(MSGSTR(E_PWD, (char *)e_pwd)); /*MSG*/
#if defined(LSTAT) || defined(FS_3D)
			if(flag)
			{
#   ifdef FS_3D
				a1 = path_real(a1);
#   else
				a1 = strcpy(stak_alloc((unsigned)PATH_MAX),a1);
#   endif /* FS_3D */
#if     (!defined(KSH_88D) || defined(LSTAT))
                                path_physical(a1);
#endif /* !KSH_88D || LSTAT */
			}
#endif /* LSTAT||FS_3D */
			p_setout(st.standout);
			p_str(a1,NL);
			break;
			
		case SYSECHO:	/* system V echo routine */
#ifndef ECHOPRINT
#   ifdef ECHO_RAW
			/* This mess is because /bin/echo on BSD is archaic */
			com--;
#ifdef  KSH_88D
#ifdef UNIVERSE
                        if(att_univ < 0)
                        {
                                char universe[TMPSIZ];
                                if(getuniverse(universe) >= 0)
                                        att_univ = (strcmp(universe,"att")==0);
                        }
                        if(att_univ>0)
                                a1 = (char*)e_minus;
                        else
#endif /* UNIVERSE */
#endif /* KSH_88D */
			a1 = echo_mode();
#   else
#	ifdef ECHO_N
			/* same as echo except -n special */
			echon = 1;
#	else
			/* equivalent to print - */
			com--;
			a1 = (char*)e_minus; /*NOTX*/
#	endif /* ECHO_N */
#   endif	/* ECHO_RAW */
#endif /* ECHOPRINT */

		case SYSPRINT:	/* print routine */
		{
			register int fd;
			const char *msg = MSGSTR(E_FILE, (char *)e_file); /*MSG*/
			int raw = 0;
			argnum =  1;
			while(a1 && *a1 == '-')
			{
				int c = *(a1+1);
				com++;
				/* echon set when only -n is legal */
				if(echon)
				{
					if(strcmp(a1,"-n")==0)
						c = 0;
					else
					{
						com--;
						break;
					}
				}
#ifdef  KSH_88D
#ifdef POSIX
                                newflag = flagset(a1,~(N_FLAG|R_FLAG|P_FLAG|U_FLAG|S_FLAG|N_RJUST|E_FLAG|X_FLAG));
                                if(newflag&E_FLAG)
                                        flag &= ~(R_FLAG|N_RJUST);
#else
                                newflag = flagset(a1,~(N_FLAG|R_FLAG|P_FLAG|U_FLAG|S_FLAG|N_RJUST));
#endif /* POSIX */
#else
                                newflag = flagset(a1,~(N_FLAG|R_FLAG|P_FLAG|U_FLAG|S_FLAG|N_RJUST));
#endif /* KSH_88D */
				flag |= newflag;
				/* handle the -R flag for BSD style echo */
				if(flag&N_RJUST)
					echon = 1;
				if(c==0 || newflag==0)
					break;
				a1 = com[1];
			}
			echon = 0;
			argnum %= 10;
			if(flag&(R_FLAG|N_RJUST))
				raw = 1;
#ifdef  KSH_88D
#ifdef  POSIX
                        if(flag&X_FLAG)
                                raw |= 2;
#endif /* POSIX */
#endif /* KSH_88D */
			if(flag&S_FLAG)
			{
				/* print to history file */
				if(!hist_open()) 
					cfailed(MSGSTR(E_HISTORY, (char *)e_history)); /*MSG*/
				fd = hist_ptr->fixfd;
				st.states |= FIXFLG;
				goto skip;
			}
			else if(flag&P_FLAG)
			{
				fd = COTPIPE;
				msg = MSGSTR(E_QUERY, (char *)e_query); /*MSG*/
			}
			else if(flag&U_FLAG)
				fd = argnum;
			else	
				fd = st.standout;
			if(sh.exitval = !fiswrite(fd))
			{
				if(fd==st.standout)
					break;
				cfailed(msg);
			}
		skip:
			p_setout(fd);
			if(echo_list(raw,com+1) && (flag&N_FLAG)==0)
				newline();
			if(flag&S_FLAG)
				hist_flush();
			break;
		}

		case SYSLET:
		{
			if(argn < 2)
				cfailed(MSGSTR(E_NARGS, (char *)e_nargs)); /*MSG*/
			while(--argn)
				sh.exitval = !sh_arith(*++com);
			break;
		}

		/*
		 * The following few builtins are provided to set,print,
		 * and test attributes and variables for shell variables,
		 * aliases, and functions.
		 * In addition, typeset -f can be used to test whether a
		 * function has been defined or to list all defined functions
		 * Note readonly is same as typeset -r.
		 * Note export is same as typeset -x.
		 */
		case SYSRDONLY:
			flag = R_FLAG;
			aflag = '-';
			goto typset;

		case SYSXPORT:
			flag = X_FLAG;
			aflag = '-';
			goto typset;

		case SYSALIAS:
		case SYSTYPESET:
		{
			register int fd;
			int type;	/* 0 for typeset, non-zero for alias */
			/* G_FLAG forces name to be in newest scope */
			if(st.fn_depth)
				scoped = G_FLAG;
			com += scanargs(com,~(N_LJUST|N_RJUST|N_ZFILL
					|N_INTGER|N_LTOU |N_UTOL|X_FLAG|R_FLAG
					|F_FLAG|T_FLAG|N_HOST
					|N_DOUBLE|N_EXPNOTE));
			flag = newflag;
			if((flag&N_INTGER) && (flag&(N_LJUST|N_RJUST|N_ZFILL|F_FLAG)))
				cfailed(MSGSTR(E_OPTION, (char *)e_option)); /*MSG*/

		typset:
			type = 0;
			if(xbuiltin == SYSALIAS)
			{

				if(flag&~(N_EXPORT|T_FLAG))
					cfailed(MSGSTR(E_OPTION, 
					    (char *)e_option)); /*MSG*/

				if(flag&T_FLAG)
					troot = sh.track_tree;
				else
					troot = sh.alias_tree;
				/* env_namset treats this value specially */
				type = (V_FLAG|G_FLAG);
			}
			else if(flag&F_FLAG)
			{
				if(flag&~(N_EXPORT|F_FLAG|T_FLAG|U_FLAG))
					cfailed(MSGSTR(E_OPTION, (char *)e_option)); /*MSG*/
				troot = sh.fun_tree;
				flag &= ~F_FLAG;
			}
			else
				troot = sh.var_tree;
			fd = st.standout;
			p_setout(fd);
			if(aflag == 0)
			{
				if(type)
					env_scan(fd,0,troot,0);
				else
					gscan_all(env_prattr,troot);
				break;
			}
			if(com[1])
			{

				if(st.subflag)
					break;
				while(a1 = *++com)
				{
					register unsigned newflag;
					register struct namnod *np;
					unsigned curflag;
					if(troot == sh.fun_tree)
					{
						/*
						 *functions can be exported or
						 * traced but not set
						 */
						if(flag&U_FLAG)
							np = env_namset(a1,sh.fun_tree,P_FLAG|V_FLAG);
						else
							np = nam_search(a1,sh.fun_tree,0);
						if(np)
						{
							if(flag==0)
							{
								env_prnamval(np,0);
								continue;
							}
							if(aflag=='-')
								nam_ontype(np,flag|N_FUNCTION);
							else if(aflag=='+')
								nam_offtype(np,~flag);
						}
						else
							sh.exitval++;
						continue;
					}
					np = env_namset(a1,troot,(type|scoped));
					/* tracked alias */
					if(troot==sh.track_tree && aflag=='-')
					{

						nam_ontype(np,NO_ALIAS);
						path_alias(np,path_absolute(np->namid));
						continue;
					}
					if(flag==0 && aflag!='-' && strchr(a1,'=') == NULL)
					{
#ifdef  KSH_88D
                                                if(type && env_prnamval (np, 0)== 0)
#else
						/* type==0 for TYPESET */
						if(type==0)
						{
							if(nam_strval(np))
								env_prattr(np);
							else
								sh.exitval++;
							continue;
						}
						if(env_prnamval(np,0) == 0)
#endif /* KSH_88D */
						{
							p_str(a1,0);
							p_str(MSGSTR(E_ALIAS, (char *)e_alias),NL); /*MSG*/
							sh.exitval++;
						}
						continue;
					}
					curflag = namflag(np);
					if (aflag == '-')
					{
						newflag = curflag;
						if(flag&~NO_CHANGE)
							newflag &= NO_CHANGE;
						newflag |= flag;
						if (flag & (N_LJUST|N_RJUST))
						{
							if (flag & N_LJUST)
								newflag &= ~N_RJUST;
							else
								newflag &= ~N_LJUST;
						}
						if (flag & N_UTOL)
							newflag &= ~N_LTOU;
						else if (flag & N_LTOU)
							newflag &= ~N_UTOL;
					}
					else
						newflag = curflag & ~flag;
					if (aflag && (argnum>0 || (curflag!=newflag)))
					{
#ifdef apollo
						/* keep aliases from going
						   into environment */
						if(type)
							namflag(np) = newflag;
						else
							nam_newtype (np, newflag,argnum);
#endif /* apollo */
						nam_newtype (np, newflag,argnum);
					}
				}
			}
			else
				env_scan(fd,flag,troot,aflag=='+');
			break;
		}


		/*
		 * The removing of Shell variable names, aliases, and functions
		 * is performed here.
		 * Unset functions with unset -f
		 * Non-existent items being deleted give non-zero exit status
		 */
		case SYSUNALIAS:
		case SYSUNSET:
		{
			register struct namnod *np;
			register struct blk *bp;
#ifdef apollo
			short namlen;
#endif /* apollo */
			if(st.subflag)
				break;
			if(xbuiltin == SYSUNALIAS)
			{
				troot = sh.alias_tree;
				goto unall;
			}
			if(aflag == '-')
			{
				flag = flagset(a1,~F_FLAG);

				com++;
				troot = sh.fun_tree;
			}
			else
				troot = sh.var_tree;
		unall:
			if(argn < 2)
				cfailed(MSGSTR(E_NARGS, (char *)e_nargs)); /*MSG*/
			while(a1 = *++com)
			{
				np=env_namset(a1,troot,P_FLAG);
				if(np)
				{
					if(troot==sh.var_tree)
					{
						if (nam_istype (np, N_RDONLY))
							sh_fail(np->namid,MSGSTR(E_READONLY, (char *)e_readonly)); /*MSG*/
						else if (nam_istype (np, N_RESTRICT))
							sh_fail(np->namid,MSGSTR(E_RESTRICTED, (char *)e_restricted)); /*MSG*/
#ifdef apollo
						namlen =strlen(np->namid);
						ev_$delete_var(np->namid,&namlen);
#endif /* apollo */
					}
					else if(bp=(struct blk*)(np->value.namenv))
					/* free function definition */
					{
					/*@ assert troot==sh.var.tree @*/
						while(bp)
						{
							free((void *)bp);
							bp = bp->word;
						}
#ifdef  KSH_88D
                                                np->value.namenv = 0;
#endif /* KSH_88D */
					}
					nam_free(np);
					env_check_nls_and_locale (np,0);
				}
				else
					sh.exitval = 1;
			}
			break;
		}

		case SYSDOT:
			if(a1)
			{
#ifdef  KSH_88D
#ifdef POSIX
                                /* check for function first */
                                register struct namnod *np;
                                np = nam_search(a1,sh.fun_tree,0);
                                if(np && !np->value.namval.ip)
                                {
                                        if(!nam_istype(np,N_FUNCTION))
                                                np = 0;
                                        else
                                        {
                                                path_search(a1,0);
                                                if(np->value.namval.ip==0)
                                                        sh_fail(a1,e_found);
                                        }
                                }
                                if(!np)
#endif /* POSIX */
#endif /* KSH_88D */
				if((sh.un.fd=path_open(a1,path_get(a1))) < 0)
					sh_fail(a1,MSGSTR(E_FOUND, (char *)e_found)); /*MSG*/
#ifndef KSH_88D
                                else
                                {
#endif /* KSH_88D */
					if(st.dot_depth++ > DOTMAX)
						cfailed(MSGSTR(E_RECURSIVE, (char *)e_recursive)); /*MSG*/
					if(argn > 2)
						arg_set(com+1);
#ifdef  KSH_88D
#ifdef POSIX
                                        if(np)
                                                sh_exec((union anynode*)(funtree(np))
                                                ,(int)(st.states&(ERRFLG|MONITOR)));
                                        else
#endif /* POSIX */
#endif /* KSH_88D */
					sh_eval((char*)0);
					st.dot_depth--;
#ifndef KSH_88D
                                }
#endif /* KSH_88D */
			}
			else
				cfailed(MSGSTR(E_ARGEXP, (char *)e_argexp)); /*MSG*/
			break;
	
		case SYSTIMES:
		{
			struct tms tt;
			times(&tt);
			p_setout(st.standout);
			p_time(tt.tms_utime,' ');
			p_time(tt.tms_stime,NL);
			p_time(tt.tms_cutime,' ');
			p_time(tt.tms_cstime,NL);
			break;
		}
		
		case SYSRETURN:	/* return from a subroutine */
#ifdef  KSH_88D
                case SYSEXIT:
			if(st.subflag)
				break;
                        flag = ((a1?atoi(a1):sh.oldexit)&EXITMASK);
                        if(xbuiltin==SYSRETURN && sh.freturn)
                        {
                                sh.exitval = flag;
                                longjmp(*sh.freturn,1);
                        }
                        if(job_close() < 0)
                                break;
                        /* force exit */
                        st.states &= ~(PROMPT|PROFILE|BUILTIN|FUNCTION|LASTPIPE);
                        sh_exit(flag);
#else
                        if(st.subflag)
                                break;
			if(sh.freturn)
			{
				sh.exitval = (a1?atoi(a1):sh.oldexit);
				longjmp(*sh.freturn,1);
			}

		case SYSEXIT:
			if(st.subflag || job_close() < 0)
				break;
			/* force exit */
			st.states &= ~(PROMPT|PROFILE|BUILTIN|FUNCTION|LASTPIPE);
			sh_exit(a1?atoi(a1):sh.oldexit);
#endif /* KSH_88D */
		
		case SYSNULL:
			t->tre.treio = 0;
			break;
		
		case SYSCONT:
			if(st.subflag)
				break;
			if(st.loopcnt)
			{
				st.execbrk = st.breakcnt = 1;
				if(a1)
					st.breakcnt = atoi(a1);
				if(st.breakcnt > st.loopcnt)
					st.breakcnt = st.loopcnt;
				else
					st.breakcnt = -st.breakcnt;
			}
			break;
		
		case SYSBREAK:
			if(st.subflag)
				break;
			if(st.loopcnt)
			{
				st.execbrk = st.breakcnt = 1;
				if(a1)
					st.breakcnt = atoi(a1);
				if(st.breakcnt > st.loopcnt)
					st.breakcnt = st.loopcnt;
			}
			break;
		
		case SYSTRAP:
			if(a1)
			{
				register int	clear;
				char *action = a1;
				if(st.subflag)
					break;
				if((clear=isdigit(*a1))==0)
				{
					++com;
					if(*a1=='-')
						clear++;
				}
				while(a1 = *++com)
				{
					flag = sig_number(a1);
					if(flag>=MAXTRAP || flag<MINTRAP)
						sh_fail(a1,MSGSTR(E_TRAP, (char *)e_trap)); /*MSG*/
					else if(clear)
						sig_clear(flag);
					else
					{
						free((void *)st.trapcom[flag]);
						st.trapcom[flag] = sh_heap(action);
						if(*action)
							sig_ontrap(flag);
						else
							sig_ignore(flag);
					}
				}
			}
			else /* print out current traps */
#if     defined(KSH_88D) && defined(POSIX)
                                sig_list (-1);
#else
			{
				p_setout(st.standout);
				for(; flag<MAXTRAP; flag++)
					if(st.trapcom[flag])
					{
						p_num(flag,':');
						p_str(st.trapcom[flag],NL);
					}
			}
#endif /* KSH_88D && POSIX */
			break;
		
		case SYSCD:
		{
			register const char *dp;
			register char *cdpath = NULLSTR;
			int rval;
			char *oldpwd;
			if(st.subflag)
				break;
			if(is_option(RSHFLG))
				cfailed(MSGSTR(E_RESTRICTED, (char *)e_restricted)); /*MSG*/
#ifdef LSTAT
			while(a1 && *a1=='-' && a1[1]) 
			{
				flag = flagset(a1,~(PHYS_MODE|LOG_MODE));
				if(flag&LOG_MODE)
					flag = 0;
				com++;
				argn--;
				a1 =  com[1];
			}
#endif /* LSTAT */
			if(argn >3)
				cfailed(MSGSTR(E_NARGS, (char *)e_nargs)); /*MSG*/
			oldpwd = sh.pwd;
			if(argn==3)
				a1 = sh_substitute(oldpwd,a1,com[2]);
			else if(a1==0 || *a1==0)
				a1 = nam_strval(HOME);
			else if(*a1 == '-' && *(a1+1) == 0)
				a1 = nam_strval(OLDPWDNOD);
			if(a1==0 || *a1==0)
				cfailed(argn==3?MSGSTR(E_SUBST, (char *)e_subst):MSGSTR(E_DIRECT, (char *)e_direct)); /*MSG*/
			if(*a1 != '/')
			{
				cdpath = nam_strval(CDPNOD);
				if(oldpwd==0)
					oldpwd = path_pwd(1);
			}
			if(cdpath==0)
				cdpath = NULLSTR;
			if(*a1=='.')
			{
				/* test for pathname . ./ .. or ../ */
				if(*(dp=a1+1) == '.')
					dp++;
				if(*dp==0 || *dp=='/')
					cdpath = NULLSTR;
			}
			do
			{
				dp = cdpath;
				cdpath=path_join((char*)dp,a1);
				if(*stak_word()!='/')
#ifdef  KSH_88D
                                {
                                        char *last=(char*)stak_end(sh.staktop);
                                        char *cp = sh_copy(oldpwd,stak_begin());
                                        *cp++ = '/';
                                        sh.staktop = sh_copy(last,cp);
                                }
#else
					path_join(oldpwd,(char*)stak_end(sh.staktop));
#endif /* KSH_88D */
#ifdef LSTAT
				if(!flag)
#endif /* LSTAT */
				{
#ifdef  KSH_88D
                                        register char *cp;
#ifdef FS_3D
                                        cp = pathcanon(stak_word());
                                        /* eliminate trailing '/' */
                                        while(*--cp == '/' && cp>stak_word())
                                                *cp = 0;
#else
                                        if(*(cp=stak_word())=='/')
                                                pathcanon(cp);
#endif /* FS_3D */
#else
#ifdef FS_3D
					dp = pathcanon(stak_word());
					/* eliminate trailing '/' */
					while(*--dp == '/' && dp>stak_word())
						*dp = 0;
#else
					pathcanon(stak_word());
#endif /* FS_3D */
#endif /* KSH_88D */
				}
			}
			while((rval=chdir(path_relative(stak_word())))<0 && cdpath);
			if(rval<0)
			{
				switch(errno)
				{
#ifdef ENAMETOOLONG
				case ENAMETOOLONG:
					dp = MSGSTR(E_LONGNAME, (char *)e_longname); /*MSG*/
					break;
#endif /* ENAMETOOLONG */
#ifdef EMULTIHOP
				case EMULTIHOP:
					dp = MSGSTR(E_MULTIHOP, (char *)e_multihop); /*MSG*/
					break;
#endif /* EMULTIHOP */
				case ENOTDIR:
					dp = MSGSTR(E_NOTDIR, (char *)e_notdir); /*MSG*/
					break;

				case ENOENT:
					dp = MSGSTR(E_FOUND, (char *)e_found); /*MSG*/
					break;

				case EACCES:
					dp = MSGSTR(E_ACCESS, (char *)e_access); /*MSG*/
					break;
#ifdef ENOLINK
				case ENOLINK:
					dp = MSGSTR(E_LINK, (char *)e_link); /*MSG*/
					break;
#endif /* ENOLINK */
				default: 	
					dp = MSGSTR(E_DIRECT, (char *)e_direct); /*MSG*/
					break;
				}
				sh_fail(a1,dp);
			}
			if(a1 == nam_strval(OLDPWDNOD) || argn==3)
				dp = a1;	/* print out directory for cd - */
#ifdef LSTAT
			if(flag)
			{
				a1 = stak_end(stak_word()+PATH_MAX);
				path_physical(a1);
			}
			else
#endif /* LSTAT */
				a1 = (char*)stak_fix();
			if(*dp && *dp!= ':' && (st.states&PROMPT) && strchr(a1,'/'))
			{
				p_setout(st.standout);
				p_str(a1,NL);
			}
#ifdef  KSH_88D
                        if (*a1 != '/')
                                break;
#endif /* KSH_88D */
			nam_fputval(OLDPWDNOD,oldpwd);
			free((void *)oldpwd);
			nam_free(PWDNOD);
			nam_fputval(PWDNOD,a1);
			nam_ontype(PWDNOD,N_FREE|N_EXPORT);
			sh.pwd = PWDNOD->value.namval.cp;
			break;
		}
		
		case SYSSHFT:
		{
			flag = (a1?(int)sh_arith(a1):1);
			if(flag<0 || st.dolc<flag)
				cfailed(MSGSTR(E_SHIFT, (char *)e_number)); /*MSG*/
			else
			{
				if(st.subflag)
					break;
				st.dolv += flag;
				st.dolc -= flag;
			}
			break;
		}
		
		case SYSWAIT:
			if(!st.subflag)
				job_bwait(com+1);
			break;
		
		case SYSREAD:
		{
			register int fd;
			com += scanargs(com,~(R_FLAG|P_FLAG|U_FLAG|S_FLAG));
			a1 = com[1];
			flag = newflag;
			if(flag&P_FLAG)
			{
				if((fd = sh.cpipe[INPIPE])<=0)
					cfailed(MSGSTR(E_QUERY, (char *)e_query)); /*MSG*/
			}
			else if(flag&U_FLAG)
				fd = argnum;
			else
				fd = 0;
			if(fd && !fisread(fd))
				cfailed(MSGSTR(E_FILE, (char *)e_file)); /*MSG*/
			/* look for prompt */
#ifdef  KSH_88D
                        if(a1 && (a1=strchr(a1,'?')) && tty_check(fd))
#else
                        if((a1=strchr(a1,'?')) && tty_check(fd))
#endif /* KSH_88D */
			{
				p_setout(ERRIO);
				p_str(a1+1,0);
			}
			env_readline(&com[1],fd,flag&(R_FLAG|S_FLAG));
			if(fiseof(io_ftable[fd]))
			{
				sh.exitval=1;
				if(flag&P_FLAG)
				{
					io_pclose(sh.cpipe);
					break;
				}
			}
			ClearErr(io_ftable[fd]);
			break;
		}
	
		case SYSSET:
			flag = is_option(EXECPR);
			if(a1)
			{
				arg_opts(argn,com);
				st.states &= ~(READPR|MONITOR);
				st.states |= is_option(READPR|MONITOR);
			}
			if(flag)
				sh_trace(com,1);
			if(a1==0 && t->com.comset==0)
				/*scan name chain and print*/
				env_scan(st.standout,0,sh.var_tree,0);
			break;
		
		case SYSEVAL:
			if(a1)
			{
				sh.un.com = com+2;
				sh_eval(a1);
			}
			break;
		
		case SYSINLIB:
			{
			  int i;
			  if(a1)
			  {
			    if( i=ldr_install(a1) < 0)
				cfailed(MSGSTR(E_INLIB,(char *)e_inlib));
			  }
			  else
			    cfailed(MSGSTR(E_NARGS,(char *)e_nargs));
			  break;
			}

		case SYSRMLIB:
			{
			  int i;
			  if(a1)
			  {
			    if( i=ldr_remove(a1) < 0)
				cfailed(MSGSTR(E_RMLIB,(char *)e_rmlib));
			  }
			  else
			    cfailed(MSGSTR(E_NARGS,(char *)e_nargs));
			  break;
			}

		case SYSFC:
		{

			register struct history *fp;
			int fdo;
			char *argv[2];
			char fname[TMPSIZ];
			int index2;
			int indx = -1; /* used as subscript for range */
			char *edit = NULL;		/* name of editor */
			char *replace = NULL;		/* replace old=new */
			int incr;
			int range[2];	/* upper and lower range of commands */
			int lflag = 0;
			int nflag = 0;
			int rflag = 0;
			histloc location;
			if(!hist_open())
				cfailed(MSGSTR(E_HISTORY, (char *)e_history)); /*MSG*/
			fp = hist_ptr;
			while((a1=com[1]) && *a1 == '-')
			{
				argnum = -1;
				flag = flagset(a1,~(E_FLAG|L_FLAG|N_FLAG|R_FLAG));
				if(flag==0)
				{
					flag = fp->fixind - argnum-1;
					if(flag <= 0)
						flag = 1;
					range[++indx] = flag;
					argnum = 0;
					if(indx==1)
						break;
				}
				else
				{
					if(flag&E_FLAG)
					{
						/* name of editor specified */
						com++;
						if((edit=com[1]) == NULL)
							cfailed(MSGSTR(E_ARGEXP, (char *)e_argexp)); /*MSG*/
					}
					if(flag&N_FLAG)
						nflag++;
					if(flag&L_FLAG)
						lflag++;
					if(flag&R_FLAG)
						rflag++;
				}
				com++;
			}
			flag = indx;
			while(flag<1 && (a1=com[1]))
			{
#ifdef  KSH_88D
                                /* look for old=new argument */
                                if(replace==NULL && strchr(a1+1,'='))
                                {
                                        replace = a1;
                                        com++;
                                        continue;
                                }
                                else
#endif /* KSH_88D */
				if(isdigit(*a1) || *a1 == '-')
				{
					/* see if completely numeric */
					do	a1++;
					while(isdigit(*a1));
					if(*a1==0)
					{
						a1 = com[1];
						range[++flag] = atoi(a1);
						if(*a1 == '-')
							range[flag] += (fp->fixind-1);
						com++;
						continue;
					}
				}
#ifndef KSH_88D
				/* look for old=new argument */
				else if(replace==NULL && strchr(a1+1,'='))
				{
					replace = a1;
					com++;
					continue;
				}
#endif /* KSH_88D */
				/* search for last line starting with string */
				location = hist_find(com[1],fp->fixind-1,0,-1);
				if((range[++flag] = location.his_command) < 0)
					sh_fail(com[1],MSGSTR(E_FOUND, (char *)e_found)); /*MSG*/
				com++;
			}
			if(flag <0)
			{
				/* set default starting range */
				if(lflag)
				{
					flag = fp->fixind-16;
					if(flag<1)
						flag = 1;
				}
				else
					flag = fp->fixind-2;
				range[0] = flag;
				flag = 0;
			}
			if(flag==0)
				/* set default termination range */
				range[1] = (lflag?fp->fixind-1:range[0]);
			if((index2 = fp->fixind - fp->fixmax) <=0)
			index2 = 1;
			/* check for valid ranges */
			for(flag=0;flag<2;flag++)
				if(range[flag]<index2 ||
					range[flag]>=(fp->fixind-(lflag==0)))
					cfailed(MSGSTR(E_NUMBER, (char *)e_number)); /*MSG*/
			if(edit && *edit=='-' && range[0]!=range[1])
				cfailed(MSGSTR(E_NUMBER, (char *)e_number)); /*MSG*/
			/* now list commands from range[rflag] to range[1-rflag] */
			incr = 1;
			flag = rflag>0;
			if(range[1-flag] < range[flag])
				incr = -1;
			if(lflag)
			{
				fdo = st.standout;
				a1 = "\n\t";
			}
			else
			{
				fdo = io_mktmp(fname);
				a1 = "\n";
				nflag++;
			}
			p_setout(fdo);
			while(1)
			{
				if(nflag==0)
					p_num(range[flag],'\t');
				else if(lflag)
					p_char('\t');
				hist_list(hist_position(range[flag]),0,a1);
				if(lflag && (sh.trapnote&SIGSET))
					sh_exit(SIGFAIL);
				if(range[flag] == range[1-flag])
					break;
				range[flag] += incr;
			}
#ifndef KSH_88D
			hist_eof();
#endif /* KSH_88D */
			if(lflag)
				return;
			io_fclose(fdo);
#ifdef  KSH_88D
                        hist_eof();
#endif /* KSH_88D */
			p_setout(ERRIO);
			a1 = edit;
			if(a1==NULL && (a1=nam_strval(FCEDNOD)) == NULL)
				a1 = (char*)e_defedit; /*NOTX*/
			if(*a1 != '-')
			{
				sh.un.com = argv;
				argv[0] =  fname;
				argv[1] = NULL;
				sh_eval(a1);
			}
			fdo = io_fopen(fname);
			unlink(fname);
			/* don't history fc itself unless forked */
			if(!(st.states&FORKED))
				hist_cancel();
			st.states |= (READPR|FIXFLG);	/* echo lines as read */
			st.exec_flag--;  /* needed for command numbering */
			if(replace!=NULL)
				hist_subst(cmd_name,fdo,replace);
			else if(sh.exitval == 0)
			{
				/* read in and run the command */
				st.states &= ~BUILTIN;
				sh.un.fd = fdo;
				sh_eval((char*)0);
			}
			else
			{
				io_fclose(fdo);
				if(!is_option(READPR))
					st.states &= ~(READPR|FIXFLG);
			}
			st.exec_flag++;
			break;
		}

		case SYSGETOPTS:
		{
			register struct namnod *n;
#ifdef  KSH_88D
                        extern char opt_option[];
                        extern char *opt_arg;
                        static char value[2];
                        const char *message = MSGSTR(E_ARGEXP, (char *)e_argexp);
#else
                        extern char *opt_option;
#endif /* KSH_88D */
			if(argn < 3)
				cfailed(MSGSTR(E_ARGEXP, (char *)e_argexp)); /*MSG*/
			n = env_namset(com[2],sh.var_tree,P_FLAG);
#ifdef  KSH_88D
                        if(argn>3)
                        {
                                com +=2;
                                argn -=2;
                        }
                        else
                        {
                                com = st.dolv;
                                argn = st.dolc;
                        }
                        switch(opt_index<=argn?flag=optget(com,a1):0)
                        {
                                case '?':
                                        message = MSGSTR (E_OPTION, (char *)e_option);
                                        /* fall through */
                                case ':':
                                        if(*a1==':')
                                                opt_arg = opt_option+1;
                                        else
                                        {
                                                p_prp(cmd_name);
                                                p_str(e_colon,opt_option[1]);
                                                p_char(' ');
                                                p_str(message,NL);
                                                flag = '?';
                                        }
                                        *(a1 = value) = flag;
                                        break;

                                case 0:
                                        a1 = NULLSTR;
                                        sh.exitval = 1;
                                        opt_char = 0;
                                        break;

                                default:
                                        a1 = opt_option + (*opt_option=='-');
                        }
                        nam_putval(n, a1);
#else
			if(flag=optget((argn>3?com+2:st.dolv),a1))
			{
				char	opt[2];
				if(*a1 == ':')
				{
					if( flag == ':' || flag == '?') {
						opt[0] = flag; opt[1] = '\0';
						a1 = opt;
					}
					else
						a1 = opt_option + (*opt_option=='-');
				}
				else
					a1 = opt_option + (*opt_option=='-');
				nam_putval(n, a1);
			}
			else
			{
				nam_putval(n,NULLSTR);
				sh.exitval = 1;
				opt_char = 0;
			}
#endif /* KSH_88D */
			break;
		}
	
		case SYSWHENCE:
		{
			com += scanargs(com,~(V_FLAG|P_FLAG));
			if(com[1] == 0)
				cfailed(MSGSTR(E_NARGS, (char *)e_nargs)); /*MSG*/
			p_setout(st.standout);
			sh_whence(com,newflag);
			break;
		}


		case SYSUMASK:
		{
			if(a1)
			{
				register int c;	
				if(st.subflag)
					break;
				if(isdigit(*a1))
				{
					while(c = *a1++)
					{
						if (c>='0' && c<='7')	
							flag = (flag<<3) + (c-'0');	
						else
							cfailed(MSGSTR(E_UMASK, (char *)e_number)); /*MSG*/
					}
				}
				else
				{
					char **cp = com+1;
					flag = umask((mode_t)0);
					c = strperm(a1,cp,~flag);
					if(**cp)
					{
						umask((mode_t)flag);
						cfailed(MSGSTR(E_FORMAT, (char *)e_format)); /*MSG*/
					}
					flag = (~c&0777);
				}
				umask((mode_t)flag);	
			}	
			else
			{
				p_setout(st.standout);
				a1 = utos((ulong)(flag=umask((mode_t)0)),8);
				umask((mode_t)flag);
				*++a1 = '0';
				p_str(a1,NL);
			}
			break;
		}

#ifdef LIM_CPU
#		define HARD	1
#		define SOFT	2
		 /* BSD style ulimit */
		case SYSULIMIT:
		{
#   ifdef RLIMIT_CPU
			struct rlimit rlp;
#   endif /* RLIMIT_CPU */
			const struct sysnod *sp;
			long i;
			int label;
			register int n;
			register int mode = 0;
			int unit;

				/*	PTM 31472
				*	I believe that the call to optget
				*	was added after getopts was written.
				*	The following shell script used to
				*	fail because a call to ulimit altered
				*	opt_index and possibly opt_char:
				*
				*	while getopts :a: c
				*	do case $c in
				*		a) ulimit -m -s -d ;;
				*	esac
				*
				*	The variables save_index and save_char.
				*	have been added to restore the values
				*	of opt_index and opt_char.
				*/
			int	save_index = opt_index;
			int	save_char = opt_char;
#ifdef  KSH_88D
                        opt_char = 0;
                        opt_index = 1;
#else
                        opt_index = opt_char = 0;
#endif /* KSH_88D */
			while((n = optget(com,":HSacdfmnstvw")))
			{
				switch(n)
				{
					case 'H':
						mode |= HARD;
						continue;
					case 'S':
						mode |= SOFT;
						continue;
					case 'a':
#ifdef  KSH_88D
                                                flag = (0x2f
#   ifdef LIM_MAXRSS
                                                |(1<<4)
#   endif /* LIM_MAXRSS */
#   ifdef RLIMIT_NOFILE
                                                |(1<<6)
#   endif /* RLIMIT_NOFILE */
#   ifdef RLIMIT_VMEM
                                                |(1<<7)
#   endif /* RLIMIT_VMEM */
#else
						flag = (0x3d
#   ifdef LIM_MAXRSS
						|(1<<1)
#   endif /* LIM_MAXRSS */
#   ifdef RLIMIT_NOFILE
						|(1<<6)
#   endif /* RLIMIT_NOFILE */
#   ifdef RLIMIT_SWAP
						|(1<<7)
#   endif /* RLIMIT_SWAP */
#   ifdef RLIMIT_VMEM
						|(1<<8)
#   endif /* RLIMIT_VMEM */
#endif /* KSH_88D */
							);
						break;
					case 't':
						flag |= 1;
						break;
#   ifdef LIM_MAXRSS
					case 'm':
#       ifdef   KSH_88D
                                                flag |= (1<<4);
#       else
                                                flag |= (1<<1);
#       endif /* KSH_88D */
						break;
#   endif /* LIM_MAXRSS */
					case 'd':
						flag |= (1<<2);
						break;
					case 's':
						flag |= (1<<3);
						break;
					case 'f':
#       ifdef   KSH_88D
                                                flag |= (1<<1);
#       else
                                                flag |= (1<<4);
#       endif /* KSH_88D */
						break;
					case 'c':
						flag |= (1<<5);
						break;
#   ifdef RLIMIT_NOFILE
					case 'n':
						flag |= (1<<6);
						break;
#   endif /* RLIMIT_SWAP */
#ifndef KSH_88D
#   ifdef RLIMIT_SWAP
					case 'w':
						flag |= (1<<7);
						break;
#   endif /* RLIMIT_SWAP */
#endif /* KSH_88D */
#   ifdef RLIMIT_VMEM
					case 'v':
#       ifdef   KSH_88D
                                                flag |= (1<<7);
#       else
                                                flag |= (1<<8);
#       endif /* KSH_88D */
						break;
#   endif /* RLIMIT_VMEM */
					default:
						opt_index = save_index;
						opt_char = save_char;
						cfailed(MSGSTR(E_OPTION, (char *)e_option)); /*MSG*/
				}
			}
#ifdef  KSH_88D
                        a1 = com[opt_index];
                        opt_index = save_index;
                        opt_char = save_char;
                        /* default to -f */
                        if(flag==0)
                                flag |= (1<<1);
                        /* only one option at a time for setting */
                        label = (flag&(flag-1));
                        if(a1 && label)
#else
			/* default to -f */
			opt_char = save_char;
			save_char = opt_index;
			opt_index = save_index;
			save_index = save_char;
			if(flag==0)
				flag |= (1<<4);
			/* only one option at a time for setting */
			label = (flag&(flag-1));
			if((a1 = com[save_index]) && label)
#endif /* KSH_88D */
				cfailed(MSGSTR(E_OPTION, (char *)e_option)); /*MSG*/
			sp = limit_names;
			if(mode==0)
				mode = (HARD|SOFT);
			for(; flag; sp++,flag>>=1)
			{
				if(!(flag&1))
					continue;
				n = sp->sysval>>11;
				unit = sp->sysval&0x7ff;
				if(a1)
				{
					if(st.subflag)
						break;
					if(strcmp(a1,MSGSTR(E_UNLIMITED, (char *)e_unlimited))==0) /*MSG*/
						i = INFINITY;
					else
					{
						if((i=sh_arith(a1)) < 0)
							cfailed(MSGSTR(E_NUMBER, (char *)e_number)); /*MSG*/
						if ( i > INFINITY / unit )
							cfailed(MSGSTR(E_ULIMIT, (char *)e_ulimit)); /*MSG*/
						i *= unit;
					}
#   ifdef RLIMIT_CPU
					if(getrlimit(n,&rlp) <0)
						cfailed(MSGSTR(E_NUMBER, (char *)e_number)); /*MSG*/
					if(mode&HARD)
						rlp.rlim_max = i;
					if(mode&SOFT)
						rlp.rlim_cur = i;
					if(setrlimit(n,&rlp) <0)
						cfailed(MSGSTR(E_ULIMIT, (char *)e_ulimit)); /*MSG*/
#   endif /* RLIMIT_CPU */
				}
				else
				{
#   ifdef  RLIMIT_CPU
					if(getrlimit(n,&rlp) <0)
						cfailed(MSGSTR(E_NUMBER, (char *)e_number)); /*MSG*/
					if(mode&HARD)
						i = rlp.rlim_max;
					if(mode&SOFT)
						i = rlp.rlim_cur;
#   else
					i = -1;
				}
				if((i=vlimit(n,i)) < 0)
					cfailed(MSGSTR(E_NUMBER, (char *)e_number)); /*MSG*/
				if(a1==0)
				{
#   endif /* RLIMIT_CPU */
					p_setout(st.standout);
					if(label)
						p_str(sp->sysnam,SP);
					if(i!=INFINITY)
					{
						i = (i+unit-1)/unit;
						p_str(utos((ulong)i,10),NL);
					}
					else
						p_str(MSGSTR(E_UNLIMITED, (char *)e_unlimited),NL); /*MSG*/
				}
			}
			break;
		}
#else
		case SYSULIMIT:
		{
#   ifndef VENIX
			long i;
			long ulimit();
			register int mode = 2;
			if(aflag == '-')
			{
				flag = flagset(a1,~F_FLAG);
				a1 = com[2];
			}
			if(flag&P_FLAG)
				mode = 5;
			if(a1)
			{
				if(st.subflag)
					break;
				if((i=sh_arith(a1)) < 0)
					cfailed(MSGSTR(E_NUMBER, (char *)e_number)); /*MSG*/
			}
			else
			{
				mode--;
				i = -1;
			}
			if((i=ulimit(mode,i)) < 0)
				cfailed(MSGSTR(E_NUMBER, (char *)e_number)); /*MSG*/
			if(a1==0)
			{
				p_setout(st.standout);
				p_str(utos((ulong)i,10),NL);
			}
#   endif /* VENIX */
			break;
		}
#endif /* LIM_CPU */

#ifdef JOBS
#   ifdef SIGTSTP
		case SYSBG:
			flag = 1;
		case SYSFG:
			if(!is_option(MONITOR) || !job.jobcontrol)
			{
				sh.exitval = 1;
				if(st.states&PROMPT)
					cfailed(MSGSTR(E_NO_JCTL, (char *)e_no_jctl)); /*MSG*/
				break;
			}
			if(job_walk(job_switch,flag,com+1))
				cfailed(MSGSTR(E_NO_JOB, (char *)e_no_job)); /*MSG*/
			break;
#    endif /* SIGTSTP */

		case SYSJOBS:
			com += scanargs(com,~(N_FLAG|L_FLAG|P_FLAG));
			if(*++com==0)
				com = 0;
#       ifdef   KSH_88D
                        p_setout (st.standout);
#       endif /* KSH_88D */
			if(job_walk(job_list,newflag,com))
				cfailed(MSGSTR(E_NO_JOB, (char *)e_no_job)); /*MSG*/
			break;

		case SYSKILL:
		{
			if(argn < 2)
				cfailed(MSGSTR(E_NARGS, (char *)e_nargs)); /*MSG*/
			/* just in case we send a kill -9 $$ */
			p_flush();
			flag = SIGTERM;
			if(aflag == '-')
			{
				a1++;
				if(*a1 == 'l')
				{
#       ifdef   KSH_88D
#ifdef POSIX
                                        if(argn>2)
                                        {
                                                com++;
                                                while(a1= *++com)
                                                {
                                                        if(isdigit(*a1))
                                                                sig_list((atoi(a1)&0177)+1);
                                                        else
                                                        {
                                                                if((flag=sig_number(a1)) < 0)
                                                                        cfailed(e_option);
                                                                p_num(flag,NL);
                                                        }
                                                }
                                        }
                                        else
#endif /* POSIX */
                                        sig_list(0);
#       else
                                        sig_list();
#       endif /* KSH_88D */
					return;
				}
				else if(*a1=='s')
				{
					com++;
					a1 = com[1];
				}
				flag = sig_number(a1);
#ifdef  KSH_88D
                                if(flag <0 || flag > NSIG)
#else
                                if(flag <0 || flag >= NSIG)
#endif /* KSH_88D */
					cfailed(MSGSTR(E_OPTION, (char *)e_option)); /*MSG*/
				com++;
			}
			if(*++com==0)
				cfailed(MSGSTR(E_NARGS, (char *)e_nargs)); /*MSG*/
			if(job_walk(job_kill,flag,com))
				sh.exitval = 2;
			break;
		}
#endif
		
#ifdef apollo
		/*
		 *  Apollo system support library loads into the virtual address space
		 */
		case SYSINLIB:
		{
			int status,xfer;
			short len;
			std_$call void pm_$load();
			std_$call void pm_$call();
			if(st.subflag)
				break;
			if(a1)
			{
				len = strlen(a1);
				pm_$load(*a1, len, 2 , 0, xfer,status);
				if(status!=0)
				sh_fail(a1,"cannot inlib");
				else if(xfer)
					pm_$call(xfer);
			}
			break;
		}

		case SYSINPROCESS:
			if(argn < 2)
				on_option(INPROC);
			else
				sh.exitval = exec_here(com);
			break;
#endif	/* apollo */

#ifdef MSG
/*
 *   NOTE: There are several hardcoded message strings below within the 
 *	   FS_3D ifdef. These were not externalized. Also: Those doing
 *	   the KJI/NLS conversion should note the weird use of sptbnl
 *	   below-- this will need work!
 */
#endif

#ifdef FS_3D
#define VLEN		14
		case SYSVMAP:
			flag = 1;
		case SYSVPATH:
		{
			char version[VLEN+1];
			char *vend; 
			char toggle;
			wchar_t ncdec;
			switch(argn)
			{
			case 1:
				p_setout(st.standout);
				vend = stak_alloc(v_size(flag)+1);
				v_getbuf(vend,flag);
				toggle = 0;
#ifdef KJI
				ncdec = flag;
				while(vend += NCdec(vend,&ncdec),ncdec>0)
				{
					flag = ncdec;
					if(NCisspace(flag))
#else
				while(flag = *vend++)
				{
					if(flag==' ')
#endif
					{
						flag  = e_sptbnl[toggle+1]; /*NOTX*/
						toggle = !toggle;
					}
					p_char(flag);
				}
				if(toggle)
					newline();
				break;
			case 2:
				if(flag)
				{
					if(getvmap(a1,version)<0)
						cfailed("cannot get mapping");
					a1 = version;
				}
				else
				{
					if((a1 = path_real(a1)) ==0)
						cfailed("cannot get vpath");
				}
				p_str(a1,NL);
				break;
			case 3:
				if(st.subflag)
					break;
				if(flag)
				{
					if(setvmap(a1,com[2])<0)
						cfailed("cannot set mapping");
				}
				else
				{
					if(setvpath(a1,com[2])<0)
						cfailed("cannot set vpath");
				}
				break;
			default:
				cfailed(MSGSTR(E_NARGS, (char *)e_nargs)); /*MSG*/
			}
			break;
		}
#endif /* FS_3D */
#ifdef  KSH_88D
#ifdef UNIVERSE
    /*
     * there are two styles of universe
     * Pyramid universes have <sys/universe.h> file
     * Masscomp universes do not
     */

                case SYSUNIVERSE:
                if(a1)
                {
                        register char *sp;
                        if(setuniverse(univ_number(a1)) < 0)
                                cfailed("invalid name");
                        att_univ = (strcmp(a1,"att")==0);
                        /* set directory in new universe */
                        if(*(a1 = path_pwd(0))=='/')
                                chdir(a1);
                        /* clear out old tracked alias */
                        nam_fputval(PATHNOD,nam_strval(PATHNOD));
                }
                else
                {
                        char universe[TMPSIZ];
                        if(getuniverse(universe) < 0)
                                cfailed("not accessible");
                        else
                                p_str(universe,NL);
                }
                break;
#endif /* UNIVERSE */


#ifdef SYSSLEEP
                /* fine granularity sleep builtin someday */
                case SYSSLEEP:
                {
                        extern double atof();
                        if(a1)
                        {
                                if(strmatch(a1,"*([0-9])?(.)*([0-9])"))
                                        sh_delay(atof(a1));
                                else
                                        cfailed(e_number);
                        }
                        else
                                cfailed(e_argexp);
                        break;

                }
#endif /* SYSSLEEP */
#endif /* KSH_88D */
	}
}

static const char flgchar[] = "efgilmnprstuvxEFHLPRZ";
static const int flgval[] = {E_FLAG,F_FLAG,G_FLAG,I_FLAG,L_FLAG,M_FLAG,
			N_FLAG,P_FLAG,R_FLAG,S_FLAG,T_FLAG,U_FLAG,V_FLAG,
			X_FLAG,N_DOUBLE|N_INTGER|N_EXPNOTE,N_DOUBLE|N_INTGER,
			N_HOST,N_LJUST,H_FLAG,N_RJUST,N_RJUST|N_ZFILL};
/*
 * process option flags for built-ins
 * flagmask are the invalid options
 */

static int flagset(flaglist,flagmask)
char *flaglist;
{
	register int flag = 0;
	register int c;
	register char *cp,*sp;
	int numset = 0;

#if (defined(NLS) || defined(KJI))
	/* okay, flag string is all ascii */
#endif

	for(cp=flaglist+1;c = *cp;cp++)
	{
		if(isdigit(c))
		{
			if(argnum < 0)
			{
				argnum = 0;
				numset = -100;
			}
			else
				numset++;
			argnum = 10*argnum + (c - '0');
		}
		else if(sp=strchr(flgchar,c))
			flag |= flgval[sp-flgchar];
		else if(c!= *flaglist)
			goto badoption;
	}
	if(numset>0 && flag==0)
		goto badoption;
	if((flag&flagmask)==0)
		return(flag);
badoption:
	cfailed(MSGSTR(E_OPTION, (char *)e_option)); /*MSG*/
	/* NOTREACHED */
}

/*
 * process command line options and store into newflag
 */

static int scanargs(com,flags)
char *com[];
{
	register char **argv = ++com;
	register int flag;
	register char *a1;
	if(aflag!='+' && aflag!='-')
		return(0);
	while((a1 = *argv) && *a1==aflag)
	{
		if(a1[1] && a1[1]!=aflag)
			flag = flagset(a1,flags);
		else
			flag = 0;
		argv++;
		if(flag==0)
			break;
		newflag |= flag;
	}
	return(argv-com);
}

/*
 * evaluate the string <s> or the contents of file <un.fd> as shell script
 * If <s> is not null, un is interpreted as an argv[] list instead of a file
 */

void sh_eval(char *s)
{
	struct fileblk	fb;
	union anynode *t;
	char inbuf[IOBSIZE+1];
	io_push(&fb);
	if(s)
	{
		io_sopen(s);
		if(sh.un.com)
		{
			fb.feval=sh.un.com;
			if(*fb.feval)
				fb.ftype = F_ISEVAL;
		}
	}
	else if(sh.un.fd>=0)
	{
		io_init(input=sh.un.fd,&fb,inbuf);
	}
	sh.un.com = 0;
	st.exec_flag++;
#ifdef  KSH_88D
        t = sh_parse(NL,NLFLG|MTFLG|TOPFLG);
#else
        t = sh_parse(NL,NLFLG|MTFLG);
#endif /* KSH_88D */
	st.exec_flag--;
	if(is_option(READPR)==0)
		st.states &= ~READPR;
	if(s==NULL && hist_ptr)
		hist_flush();
	p_setout(ERRIO);
	io_pop(0);
	sh_exec(t,(int)(st.states&(ERRFLG|MONITOR)));
}


/*
 * Given the name or number of a signal return the signal number
 */

static int sig_number(string)
register char *string;
{
	register int n;
	if(isdigit(*string))
		n = atoi(string);
	else
	{
		ltou(string,string);
		n = sh_lookup(string,sig_names);
		n &= (1<<SIGBITS)-1;
		n--;
	}
	return(n);
}

#ifdef JOBS
/*
 * list all the possible signals
 * ifdef KSH_88D
 * If flag is 1, then the current trap settings are displayed
 * endif KSH_88D
 */
#ifdef  KSH_88D
static void sig_list(int flag)
#else
static void sig_list()
#endif /* KSH_88D */
{
	register const struct sysnod	*syscan;
	register int n = MAXTRAP;
#ifdef  KSH_88D
        const char *names[MAXTRAP+3];
#else
        const char *names[MAXTRAP+1];
#endif /* KSH_88D */
	syscan=sig_names;
	p_setout(st.standout);
	/* not all signals may be defined */
#ifdef  KSH_88D
#ifdef POSIX
        if(flag<0)
                n += 2;
#endif /* POSIX */
#endif /* KSH_88D */
	while(--n >= 0)
		names[n] = MSGSTR(E_TRAP, (char *)e_trap); /*MSG*/
	while(*syscan->sysnam)
	{
		n = syscan->sysval;
		n &= ((1<<SIGBITS)-1);
		names[n] = syscan->sysnam;
		syscan++;
	}
	n = MAXTRAP-1;
#ifdef  KSH_88D
#ifdef POSIX
        if(flag<0)
                n += 2;
#endif /* POSIX */
#endif /* KSH_88D */
	while(names[--n]==MSGSTR(E_TRAP, (char *)e_trap)); /*MSG*/
	names[n+1] = NULL;
#ifdef  KSH_88D
#ifdef POSIX
        if(flag<0)
        {
                while(--n >= 0)
                {
                        if(st.trapcom[n])
                        {
                                p_str("trap",' ');
                                p_qstr(st.trapcom[n],' ');
                                p_str(names[n+1],NL);
                        }
                }
        }
        else if(flag)
        {
                if(flag <= n && names[flag])
                        p_str(names[flag],NL);
                else
                        p_num(flag-1,NL);
        }
        else
#endif /* POSIX */
#endif /* KSH_88D */
	p_list(n-1,names+2);
}
#endif	/* JOBS */

static void cfailed(message)
MESG message;
{
	sh_fail(cmd_name,message);
}

#ifdef  KSH_88D
#ifdef SYSSLEEP
/*
 * delay execution for time <t>
 */

#ifdef _poll_
#   include     <poll.h>
#endif /* _poll_ */
#ifdef HZ
#   define TIC_SEC      HZ      /* number of ticks per second */
#else
#   define TIC_SEC      60      /* number of ticks per second */
#endif /* HZ */


int     sh_delay(t)
double t;
{
        register int n = t;
#ifdef _poll_
        struct pollfd fd;
        if(t<=0)
                return;
        else if(n > 30)
        {
                sleep(n);
                t -= n;
        }
        if(n=1000*t)
                poll(&fd,0,n);
#else
#   ifdef _SELECT5_
        struct timeval timeloc;
        if(t<=0)
                return;
        timeloc.tv_sec = n;
        timeloc.tv_usec = 1000000*(t-(double)n);
        select(0,(fd_set*)0,(fd_set*)0,(fd_set*)0,&timeloc);
#   else
#       ifdef _SELECT4_
                /* for 9th edition machines */
                if(t<=0)
                        return;
                if(n > 30)
                {
                        sleep(n);
                        t -= n;
                }
                if(n=1000*t)
                        select(0,(fd_set*)0,(fd_set*)0,n);
#       else
                struct tms tt;
                if(t<=0)
                        return;
                sleep(n);
                t -= n;
                if(t)
                {
                        clock_t begin = times(&tt);
                        if(begin==0)
                                return;
                        t *= TIC_SEC;
                        n += (t+.5);
                        while((times(&tt)-begin) < n);
                }
#       endif /* _SELECT4_ */
#   endif /* _SELECT5_ */
#endif /* _poll_ */
}
#endif /* SYSSLEEP */

#ifdef UNIVERSE
#   ifdef _sys_universe_
        int univ_number(str)
        char *str;
        {
                register int n = 0;
                while( n < NUMUNIV)
                {
                        if(strcmp(str,univ_name[n++])==0)
                                return(n);
                }
                return(-1);
        }
#   endif /* _sys_universe_ */
#endif /* UNIVERSE */
#endif /* KSH_88D */

