# 
# $Copyright
# Copyright 1993, 1994 , 1995 Intel Corporation
# INTEL CONFIDENTIAL
# The technical data and computer software contained herein are subject
# to the copyright notices; trademarks; and use and disclosure
# restrictions identified in the file located in /etc/copyright on
# this system.
# Copyright$
# 
 
:	#  The ':' assures that this will run under Bourne shell
#
#  Run the test to write dataset with variable spanned (VS)/variable blocked and
#	spanned (VR) format
#
#  Syntax: testvsw.sh 
#

PART=test3480
DEV=/dev/io1/rmt6
PATH=/home/slk/util

# Check arguments
if [ $# -gt 0 ]
then
        echo "Usage: testvsw.sh "
        echo ""
        echo "RESULT: F (usage error)" >> NOT_RUN
        exit 2
fi       
echo ""
echo "*****  VS/VR WRITE TEST *****" | tee -a testvsw.SLr0
echo "" | tee -a testvsw.SLr0
echo "please PREPARE 3 tapes on the STK 4980 cabinet and LOAD the first tape, " | tee -a testvsw.SLr0
echo "then press return to continue ..." | tee -a testvsw.SLr0
read response
echo "starting nsh -s to run make scratch tape \"ms\" utilility & unload tapes" | tee -a testvsw.SLr0

mkpart -sz 1 $PART
nsh -s << EOF
$PATH/ms -f -vtest01 -neval $DEV
mt -f $DEV offline
echo "sleeping to wait for tape fully unloaded from tape drive ..."
sleep 20
$PATH/ms -f -vtest02 -neval $DEV
mt -f $DEV offline
echo "sleeping to wait for tape fully unloaded from tape drive ..."
sleep 20
$PATH/ms -f -vtest03 -neval $DEV
mt -f $DEV offline
echo "sleeping to wait for tape fully unloaded from tape drive ..."
sleep 20
exit
EOF
echo "nsh -s done" | tee -a testvsw.SLr0
         
echo " "
echo "please REINSERT the previous 3 tapes in same order & LOAD the 1st tape," |  tee -a testvsw.SLr0
echo "then press return to continue ..." | tee -a testvsw.SLr0
read response


d1=`date '+%j'`
h1=`date '+%H'`
m1=`date '+%M'`
s1=`date '+%S'`


TYPE="-t 1"
NUM=1

getcube $SRM $TYPE $CUBENAME  > scratch 2>&1
load 0 node.rx  
waitcube
relcube
cat scratch | tee -a testvsw.SLr0

# Execute time
d=`expr \( \`date '+%j'\` - $d1 \) \* 86400`
h=`expr \( \`date '+%H'\` - $h1 \) \* 3600`
m=`expr \( \`date '+%M'\` - $m1 \) \* 60`
execTime=`expr $d + $h + $m + \( \`date '+%S'\` - $s1 \)`


#
#  Check for test failure
#

if grep 'PASSED' scratch > /dev/null
then
 echo "T90_RESULT: P `hostname` $execTime" | tee -a testvsw.SLr0
 echo "T90_RESULT: P `hostname` $execTime" > testvsw.SRr0
else
 echo "T90_RESULT: F (found FAILED) `hostname` $execTime" | tee -a testvsw.SLr0
 echo "T90_RESULT: F (found FAILED) `hostname` $execTime" > testvsw.SRr0
fi

echo "" | tee -a testvsw.SLr0
echo "*****  VS/VR WRITE TEST COMPLETE *****" | tee -a testvsw.SLr0
