
/*
 * clock.h
 *	Definitions for 18/12A on-board 8253 (timer).
 *
 * See 86/12A reference manual or 8086 Famile User's Manual for details.
 *
 * Bob Beck, 12-29-81.
 */

#define	PIT_CTR0_PORT	0x44		/* PIT counter 0 port */	
#define	PIT_CTR1_PORT	0x45		/* PIT counter 1 port */	
#define	PIT_CTR2_PORT	0x46		/* PIT counter 2 port */	
#define	PIT_CTRL_PORT	0x47		/* PIT control port */

/*
 * Control commands for 8253
 */

#define PIT_S0          0x00            /* select timer 0 */
#define PIT_S1          0x40            /* select timer 1 */
#define PIT_S2          0x80            /* select timer 2 */
#define	PIT_CNTR_LATCH	0x00		/* counter latch operation */
#define	PIT_READ_LOAD	0x30		/* read/load least signf/most signf */
#define	PIT_SQWAVE_MODE	0x06		/* square-wave mode */
#define	PIT_RATE_MODE	0x06		/* square-wave mode for USART */
#define	PIT_ONE_SHOT	0x00		/* one-shot mode */
