
/*
 * intr.h
 *      definitions for interrupt control system on the
 *	iSBC 86/330.
 *
 * Mods for 330 box by Bob Beck, 12-15-81.
 * Eliminated CLOCKVEC, 3-2-82.
 */

/*
 * PIC Constants (for 86/12)
 */

#define	PIC_VEC_BASE	0x10		/* Base Vector (maskable 0) */
#define	PIC_ICW1	0x17		/* Edge mode, single (no slaves) */
#define	PIC_ICW2	PIC_VEC_BASE	/* Base of vectors */
#define	PIC_ICW4	0x0D		/* Nested, Master, Not auto-EOI */
#define	PIC_CMD1	0xC0		/* 1st command port */
#define	PIC_CMD2	0xC2		/* 2nd command port */
#define	PIC_EOI		0x20		/* Non-specific EOI command */
#define	PIC_MASK	PIC_CMD2	/* output ==> set mask */
#define	PIC_SISR	0x0B		/* Select ISR for input */
#define	PIC_ISR		PIC_CMD1	/* input ==> read ISR */

/*
 * Generate masks to turn on/off a given level.
 * PIC_MASK: bit(i) = 1 ==> masked; 0 ==> enabled.
 */

#define	PIC_MON(i)	(0xFF & ~(1<<(i)))
#define	PIC_MOFF(i)	(1<<(i))
