/*
 *      Conditional compilation parameters:
 *
 *              HOME    if defined, indicates host system version
 *              SYSTEM  if defined, user is part of system device driver
 *              SALONE  if defined, stand alone target machine system
 *              Z8000   if defined, target machine is Z8000
 */

#define	SYN1	001
#define	SYN2	002
#define	ACK	006
#define	NAK	025

#define	MAXBLK	131
#define	NRETRY	5

/*      Format of a logical message buffer      */

struct	sm_msg {
	int	sm_nchar;	/* number of chars in buf */
	int	sm_seq;	/* sequence number for message */
	char	sm_mesg;	/* message codes */
	union	{
		struct	{		/* for w,d & l messages */
			int	sm_bn;
			char	sm_bc[512];
		};
		int	sm_ibuf;
		long	sm_lbuf;
		char	sm_cbuf[516];
	} sm_un;
};

/*      Format of a physical message block
 *
 *      A logical message block is broken into byte-sized pieces,
 *      each of which is transmitted and checked seperately. They
 *      are:
 */

struct	sm_blk	{
	char	sm_nch;		/* number of chars in buf */
	char	sm_buf[MAXBLK];	/* text of message */
	int	sm_chk;		/* checksum */
};

/*	Diagnostic print routines	*/
# ifdef  HOME
#define Print(f,a)      fprintf(stderr, f, a)
#define ERROR(f,a)      Print(f, a)
# else
#define Print(f,a)      printf(f, a)
#define ERROR(f,a)
#define EOF     -1
# endif

# ifdef  DEBUG
#define	DPRINT(c,f,a)	{ if (sm_debug&c) Print(f,a); }
# ifndef HOME
#undef	ERROR
#define	ERROR(f,a)	Print(f,a)
# endif
# else
#define	DPRINT(c,f,a)	
# endif

/*	character transmission routines for the package		*/
# ifdef  HOME
#define	SMPUTC(c)	putchar(c)
#define	SMGETC()	getchar()
# endif

# ifdef  SYSTEM
#define	SMPORT	0X204
# endif

# ifdef  SALONE
#define	SMPORT	0X204
#define	SMPUTC(c)	putc(c)
#define	SMGETC()	getc()
# endif

# ifdef  Z8000
#define	UCHAR	unsigned char
#define	swap(x)	(((x) >> 8) & 0377 | (x)<<8)
# else
#define	UCHAR	unsigned
#define	swap(x)	(x)
# endif
