/*
 *      syscall.h - Document System Calling Convention
 */



/*      SYSTEM CALLING CONVENTION
 *
 *      Since there is a large disparity of 8086 XENIX systems we've
 *      gone to some measures to allow executable images to be portable
 *      amoung a large range of machines from the smallest unprotected
 *      8088 to the largest MMU'ed 8086.
 *
 *      There are two basic OS functions that must be considered:
 *      system calls and stack growth.  Our scheme is to reserve the
 *      first 128 bytes of code space for each program.  The kernel
 *      will the proper system call and stack growth code into those
 *      128 bytes.  User programs generate long calls to magic offsets
 *      in those bytes.
 *
 *      There are magic addresses defined for 8 functions, of which
 *      three are defined:
 *
 *
 *      loc     subr
 *
 *      2       system call             (documented as Ios_sc)
 */





/***    Ios_sc - Invoke Operating system for System call
 *
 *      Entry   (ax) = system call code
 *              (bx) = 1st arg
 *              (cx) = 2nd arg
 *              (si) = 3rd arg
 *              (di) = 4th arg
 *      Exit    'c' clear if ok
 *              'c' set if error
 *              (ax) = low part of return code
 *              (bx) = high part of return code
 *      Uses    ax, bx, dx
 */



