.H 2 "The XENIX 8086 Assembly Language Interface"
The \*(x1 system is designed so that there should be
little need to program in assembly language. 
Occasionally, however, the need does arise, and you may
need to know the conventions for storing words in memory
and for accessing parameters on the stack in a way compatible
with the C run-time environment.
Remember, however, that programming in assembly language
is highly machine dependent, and that you sacrifice 
portability whenever you forsake C for 
whatever low-level advantages you might gain.
.H 3 "Memory Format"
With the 8086, words are stored as followed:
.DS I
<addr+1>	<high order byte>
<addr+0>	<low  order byte>
.DE
The words of a long are stored 'backwards' to this convention, 
the high order word comes first in memory:
.DS I
<addr+3>        <high order byte of low  order word>
<addr+2>        <low  order byte of low  order word>
<addr+1>        <high order byte of high order word>
<addr+0>        <low  order byte of high order word>
.DE
.P
The floating point format is currently Microsoft format,
but will definitely change to an IEEE compatible format
in the future.  
.P
Pascal 32-bit integers are stored as follows:
.DS I
<addr+3>        <high order byte of low  order word>
<addr+2>        <low  order byte of low  order word>
<addr+1>        <high order byte of high order word>
<addr+0>        <low  order byte of high order word>
.DE
.H 3 "Calling Sequence"
Arguments are pushed last first, 
and are in fact evaluated in that order.
In C, the order of evaluation of arguments is undefined.
Arguments are pushed by value, in a choice of 4 sizes:  
chars, ints, and unsigned ints are pushed in one 16-bit word.  
Longs are pushed as two 16-bit words, low
order word first so the order in memory is preserved.  
Floats and doubles
as four 16-bit words, again order preserving.  
Note that chars and floats
are extended to the size of int or double respectively.  
Structures, which are allocated rounded up to the next even byte size, 
are pushed so that their memory order is preserved.  
This means that the last word is pushed first.
.H 3 "Procedure Entry and Exit"
Th bp, sp, si, and di registers must be restored upon procedure exit 
if they have been modified.  
The following sequence does this, and is what the compiler uses:
.DS I
entry:
	push    bp
	mov     sp,bp
	push    di
	push    si

	<body>

return:
	jmp     cret    | cret cleans up, 
			| including any modifications 
			| that may have been made to sp. 
			| Ax, bx, cx, and dx 
			| are preserved, as
			| well as segment registers.  
			| Flags are not preserved.
			| Cret does a ret instruction, 
			| so there is no need 
			| for the user to do it.

.DE
Note that with this mechanism, 
the first argument (the last pushed) will
be at 4(bp), with subsequent words at 6(bp), 8(bp) and so forth.
Where the various arguments are is based on the
size of arguments pushed.
.P
We recommend that this sequence always be used, 
even if the registers SI and DI will not be modified.  
Use of this sequence allows backtracing by
ADB in the case of a program crash.
.H 3 "Return Values"
Int and char return values are left in the ax register.
Long return values are left in ax-dx, high order in dx. 
(Note that this corresponds to what the cwl instruction does, 
so it should be easy to remember.)
Structures are returned by having ax point 
to a static area of memory, which contains the return value;  
floats are returned the same way.
.H 3 "System calls"
In order to issue system calls, it is necessary for the user 
to use the library functions discussed earlier in this chapter.  
Assembly language programmers need to make a proper C-compatible 
call to these routines, as described in preceding sections.
See also the sections in the
.I "XENIX Reference Manual"
on system calls and subroutines.
.H 3 "Calling From Assembly Language"
Above, we have shown how to interface an assembly
language routine to a C program; now we want to show
the opposite, how to interface C routines to an
assembly language program.
To illustrate, let's look at the following example
of a C routine that we wish to interface to our
assembly language program.
.DS I
add(i,j)
   int i,j;
{
	return(i+j);
}
.DE
In assembly language, we might do the same thing with:
.DS I
_add:
	push	bp
	mov	sp,bp
	push	di
	push	si

	mov	ax,*4(bp)
	add	ax,*6(bp)

	jmp	cret
.DE
Say we'd written 'add' above in C, and wanted to
call it from assembly language:
.DS I
|	part of assembly language program 
|	that uses add
	push	<computed j value>
	push	<computed i value>
	call	_add
	add	sp,*4		| remove arguments from stack

|	(ax) contains resultant value
.DE
