'\" 	@(#)Document: V2-00-3
'\" 	@(#)Subject: V3.0 SW Dev - Tools
'\" 	@(#)Writer: Stewart Konzen
'\" 	@(#)Work: 1 weeks
'\" 	@(#)Target: 1/1
'\" 	@(#)Notes: 
'\" 	@(#)Mods: 
.ds :? SOFTWARE TOOLS
.nr H1 3
.PH "'Software Tools''Software Tools'"
.H 2 "Introduction"
This chapter discusses the tools available for use in
software development on the \*(x1 system.
The wide variety of these tools provides for a rich
environment for programmers and software engineers.
However, because so many different
commands are available to the programmer, it is often
difficult to know what subset is especially useful 
in software development.
To solve this problem, this chapter 
circumscribes the set of commands useful
in software development, then
summarizes the function of each.
In addition, this chapter contains a section describing
the basic tools required for developing software on
the \*(x1 system.
.H 2 "Basic Tools"
The tools used to create executable C programs are:
.VL 10 2
.LI \fBcc\fR
The \*(x1 C compiler
.LI \fBlint\fR
The \*(x1 C program checker
.LI \fBld\fR
The \*(x1 loader
.LI \fBas\fR
The \*(x1 assembler
.LI \fBadb\fR
The \*(x1 debugger
.LI \fBmake\fR
The \*(x1 program maintainer
.LE
.P
The 
.B cc
command
automatically invokes both the loader and the assembler
so that use of either is optional.
.B Lint 
is normally used in the early stages of program development
to check for illegal and improper usage of the C language.
The program
.B adb 
is used to debug executable programs.
The program
.B make 
is used with the above tools to automatically 
maintain and regenerate 
software in medium-scale programming projects.
.P
Note that not all programming projects are best implemented in C, 
even if they are programs written for \*(x1. 
Often, simple programs can be written
in the shell command language much more quickly than
they can be in C.
For some complicated programs, 
.B lex
and 
.B yacc
may be just what are required.
.B Lex 
is a lexical analyzer that can be used to accept a given
input language.
.B Yacc 
is a program designed to compile 
grammars into a parsing program.
Typically, it is used to compile 
languages that are recognized by 
.B lex .
For this reason,
.B lex
and
.B yacc 
are often used together, although either can be used
separately.
.H 2 "Other Tools"
Other tools useful in software development are
described below: 
.VL 12
.de Li 
.LI "\\fB\\$1\\fP"
..
.Li "ar"
Archives files and maintains libraries.
Useful when constructing or maintaining 
large object libraries.
.Li "at"
Executes commands at a later time.
Used to execute time-consuming compilations,
printouts, and 
.Q makes , 
so that they execute when the system isn't busy.
.Li "awk"
Recognizes text patterns and performs
transformation operations based on the
.B awk 
language.
.Li "basename"
Strips directory affixes and filename prefixes from 
a filename or pathname.
Useful in shell scripts to obtain the filename
part of a pathname or to strip off filename extensions.
.Li "cb"
Beautifies C programs,
improving their readability. 
Note that the output from 
.I cb 
is not necessarily attractive to all programmers.
.Li "chgrp"
Changes the group affiliation of a file, so that
it has the proper group permission when it is accessed
or, if it is an executable file, when it is executed.
.Li "chown"
Changes the ownership of a file, so that
it has the proper owner when it is accessed
or, if it is an executable file, when it is executed.
.Li "cmp"
Compares two sorted files.
Useful when comparing object files and other binary images.
.Li "comm"
Compares sorted text files by either
selecting or rejecting common lines.
.Li "copy"
Copies groups of files.
Useful in recursively copying directories or in creating files 
that are linked to another set of files.
Note that 
.I cp 
does not copy recursively.
.Li "csh"
Interprets and executes commands taken from the keyboard or from
a command file.
The 
.Q "C shell"
supports a C-like command language,
an aliasing facility, and a command history
mechanism.
.Li "ctags"
Creates a tags file so that 
C functions can be quickly found in a set of
related C source files.
.Li "dd"
Converts and copies a file to the standard output.
Use this to read in files from various media.
A variety of formats and conversions are available.
.Li "df"
Reports the amount of space that is free and
available in a given file system.
.Li "diff"
Compares two text files, line by line.
.Li "diff3"
Compares three text files, line by line.
.Li "du"
Summarizes disk usage.
Use this to determine how much disk space you are using.
.Li "file"
Determines the file type of given files.
Use this to examine files to
determine whether they are directories, special
files, or executable files.
.Li "find"
Finds filenames in a file system and optionally
performs commands that affect the found files.
Use this in performing complex operations on a selected
set of files.
.Li "fsck"
Checks file system consistency, and if possible
interactively repairs the file system
when inconsistencies are found.
.Li "ln"
Creates a link between one file and another so that
file contents are shared and both filenames 
refer to the same file.
.Li "lorder"
Finds the ordering relation in an object library.
.Li "m4"
Processes input text performing several functions,
including macro definition and invocation.
.Li "mkfs"
Constructs a file system.
.Li "mknod"
Creates a special file.
.Li "mkstr"
Creates an error message file by examining a C source file.
.Li "mount"
Mounts a file system on the given directory.
.Li "ncheck"
Generates filenames from inode numbers.
.Li "nice"
Runs a command at a low priority.
.Li "nm"
Prints the list of symbol names in a program.
.Li "od"
Performs an 
.Q "octal dump"
of given files,
printing files in a variety of formats, one of which
is octal.
.Li "printenv"
Prints out the environment.
.Li "prof"
Displays profile data.
.Li "pstat"
Prints system facts.
.Li "quot"
Summarizes file system ownership.
.Li "ranlib"
Converts archive libraries to random libraries by placing a
table of contents at the front of each library.
.Li "settime"
Changes the access and modification dates of files.
.Li "size
Reports the size of an object file.
.Li "sleep"
Suspends execution of a process for a given period of time.
.Li "strings"
Finds and prints readable text (strings) 
in an object or other binary file.
.Li "strip"
Removes symbols and relocation bits from executable files.
.Li "su"
Logs in user as super-user or any other user.
.Li "sum"
Computes check sum for a file and counts blocks.
Useful in looking for bad spots in a file and for
verifying transmission of data between systems.
.Li "sync"
Updates the super-block so that all input and
output to the disk is completed before the 
.B sync 
command finishes.
.Li "tar"
Archives files to tape or to a file.
Use to move or copy large sets of files.
.Li "time"
Times a given command.
Use this in making execution-time benchmarks for programs.
.Li "touch"
Updates the modification date of a file
without altering the contents of the file.
.Li "tr"
Translates a given set of characters to another
set for all characters in a file.
.Li "tsort"
Topologically sorts object libraries so that
dependencies are apparent.
.Li "umount"
Unmounts a mounted file system.
.Li "xstr"
Extracts strings from C programs to implement shared strings.
.LE
.TC 2 1 5 0
