.ds :? LINT: A C PROGRAM CHECKER
.nr H1 5
.PH "'Lint''Lint'"
.H 2 "Introduction"
.I Lint
is a program that examines C source programs,
detecting bugs and checking language usage.
It enforces the type rules of C more strictly than
any C compiler.
.I Lint
may also be used to enforce a number of portability
restrictions involved in moving
programs between different machines and operating systems.
.I Lint 
can also detect wasteful or error-prone constructions
that are nevertheless legal.
.P
The separation of function between
.I lint
and the C compilers has a practical
rationale.
The C compiler turns C programs into executable files rapidly
and efficiently.
This is possible in part because the
compiler does not perform sophisticated
type checking, especially between
separately compiled programs.  
.I Lint
takes a more global view of a program,
looking much more carefully at compatibilities.
.H 2 "Command Usage"
The syntax for the 
.I lint
command follows:
.DS I
.B
lint [\fIoptions\fP ] \fIfiles\fP ... \fIlibrary-descriptors\fP ...
.R
.DE
Available options are listed below, and described
more thoroughly in following sections:
.VL 12 2
.LI \fB\-a\fR
Report assignments of
.B long
to
.B int
or shorter
.LI \fB\-b\fR
Report unreachable
.B break
statements
.LI \fB\-c\fR
Report questionable casts
.LI \fB\-h\fR
Perform heuristic checks
.LI \fB\-l\fIlibname\fR
Check library file 
.I libname
.LI \fB\-n\fR
Do not check libraries
.LI \fB\-p\fR
Perform portability checks
.LI \fB\-s\fR
Same as
.B \-h 
.LI \fB\-u\fR
Do not report unused or undefined externals
.LI \fB\-v\fR
Do not report unused arguments
.LI \fB\-x\fR
Report unused external declarations
.LE 1
For example,
suppose there are two C source files,
.I file1.c
and
.I file2.c  ,
that are ordinarily compiled and loaded together.
The command
.DS I
lint  file1.c  file2.c
.DE
produces messages describing 
inconsistencies and inefficiencies in these programs.
In addition to the above messages, the command
.DS I
lint \-p file1.c file2.c
.DE
produces additional messages
that relate to the portability of the programs 
to other operating systems and machines.
Replacing the
.B \-p
option with the
.B \-h
option produces messages about various legal, 
but probably wrong constructions
These flags may be combined by grouping the options with
.B \-hp .
.H 2 "Checks"
Many of the facts about a particular C program that 
.I lint
needs may be impossible for it to discover.
For example, whether a given function in a program 
ever gets called may depend on the input data.
Thus, most of the
.I lint
algorithms are a compromise.
If a function is never mentioned, it can never be called.
If a function is mentioned,
.I lint
assumes it can be called: 
this is not necessarily so, 
but in practice it is a quite reasonable assumption.
.P
.I Lint
tries to give information with a high degree of relevance.
Messages of the form 
.Q "\fIxxx\fR might be a bug"
are easy to generate, but are acceptable only in proportion
to the fraction of real bugs they uncover.
If this fraction of real bugs is too small, 
the messages lose their credibility
and serve merely to clutter up the output,
obscuring more important messages.
.P
Keeping these issues in mind, we now consider in more detail
the classes of messages that
.I lint
produces.
.H 3 "Unused Variables and Functions"
As sets of programs evolve and develop,
previously used variables and arguments to
functions may become unused;
it is common for external variables, or even entire
functions, to become unnecessary, and yet
not be removed from the source.
These 
.Q "errors of commission"
rarely cause working programs to fail, 
but they are a source of inefficiency, 
and make programs harder to understand and change.
Moreover, information about such unused variables and functions 
can occasionally serve to discover bugs. 
If a function does a necessary job, and
is never called, something must be wrong.
.P
.I Lint
reports variables and functions 
that are defined but not otherwise mentioned.
An exception is made for variables that are declared 
through explicit
.B extern
statements but are never referenced. 
Thus, the statement
.DS I
extern  float  sin();
.DE
will evoke no comment if
.I sin
is never used.
This agrees with the semantics of the C compiler.
.P
In some cases, these unused external declarations might 
be of interest: 
they can be discovered by using the
.B \-x
invocation flag.
.P
Certain styles of programming
require many functions to be written with similar interfaces;
frequently, some of the arguments may be unused
in many of the calls.
The
.B \-v
option is available to suppress the printing of
reports of unused arguments.
When
.B \-v
is in effect, no messages are produced about unused
arguments except for those
arguments that are unused and also declared as
register arguments. 
This can be considered
an active (and preventable) waste of the register
resources of the machine.
.P
There is one case where information about unused, or
undefined variables is more distracting than helpful.
This is when 
.I lint
is applied to only some of the files in a collection
that are to be loaded together.
In this situation, many of the functions and variables defined
may not be used, but, conversely,
many functions and variables defined elsewhere may be used.
The
.B \-u
flag is used to suppress 
the spurious messages that might otherwise appear.
.H 3 "Variable Set/Used Information"
.I Lint
attempts to detect cases where a variable 
is used before it is set.
This is very difficult to do well:
many algorithms take a good deal of time and space,
and still produce messages about perfectly valid programs.
.I Lint
detects local variables (automatic and register storage classes)
whose first use appears physically earlier in the input file 
than the first assignment to the variable.
It assumes that taking the address 
of a variable constitutes a 
.Q "use" ,
since the actual use
may occur at any later time, in a data-dependent fashion.
.P
Because static and external variables are initialized to zero,
no meaningful information can be discovered about their uses.
.I Lint
deals correctly, however, 
with initialized automatic variables, and variables
which are used in the expression that first sets them.
.P
Variable set/used information also permits recognition of those 
local variables that are set and never used; 
these form a frequent source of inefficiencies, 
and may also be symptomatic of bugs.
.H 3 "Flow of Control"
.I Lint
attempts to detect unreachable portions of program code.
It reports unlabeled statements immediately following
.B goto , 
.B break , 
.B continue ,
and 
.B return
statements.
An attempt is made to detect loops that can never be left 
at the bottom, detecting the special cases
.Q "while (1)" 
and 
.Q "for (;;)"
as infinite loops.
.I Lint
also reports loops that cannot be entered at the top;
some valid programs may have such loops, 
but at best they are bad style and at worst, bugs.
.P
.I Lint
has an important area of blindness in the flow of control algorithm:
it cannot detect functions that are called and never return.
Thus, a call to
.I exit
may cause unreachable code which
.I lint
does not detect; the most serious effects of this are in the
determination of returned function values, 
discussed in the next section.
.P
One form of unreachable statement is not 
usually reported by
.I lint :
a
.B break
statement that cannot be reached causes no message.
Programs generated by
.I yacc 
and especially
.I lex 
may have literally hundreds of unreachable
.B break
statements.
Using the
.B \-O
optimization switch with the C compiler will often eliminate 
the resulting object code inefficiency.
Thus, these unreached statements are of little importance.
There is typically nothing that can be done about them, and the
resulting messages only clutter the
.I lint
output.
If these messages are desired,
.I lint
can be invoked with the
.B \-b
option.
.H 3 "Function Values"
Sometimes functions return values which are never used;
conversely, some programs incorrectly use function 
.Q "values"
that have never been returned.
.I Lint
addresses these problems in a number of ways.
.P
Locally, within a function definition,
the appearance of both
.DS I
return (expr);
.DE
and
.DS I
return ;
.DE
statements is cause for alarm.
In this case,
.I lint
produces the following error message:
.DS I
function name contains return(e) and return
.DE
It is difficult to 
detect when a function return is implied
by the flow of control reaching the end of 
the given function.
This is demonstrated with a simple example:
.DS I
f (a) {
	if (a) return (3);
	g ();
	}
.DE
Note that if 
.Q a
tests false, 
then 
.Q f
will call 
the function 
.Q g 
and then return
with no defined return value. 
This will trigger a report from
.I lint .
If 
.Q g , 
like 
.Q exit , 
never returns,
the message will still be produced 
when in fact nothing is wrong.
In practice, potentially serious bugs 
can be discovered with this feature.
It also accounts for a substantial fraction of the 
.Q "noise"
messages produced by 
.I lint .
.P
On a global scale,
.I lint
detects cases where a function returns a value, 
but where this value is sometimes
or always unused.
When the value is always unused, 
it may constitute an inefficiency in the function definition.
When the value is sometimes unused, 
it may represent bad style (e.g., not testing for
error conditions).
Using a function value 
when the function does not return one
is also detected.
.H 3 "Type Checking"
.I Lint
enforces the type checking rules of C more strictly 
than the C compiler.
The additional checking is in four major areas:
.AL 1
.LI
Across certain binary operators and implied assignments
.LI
At the structure selection operators
.LI
Between the definition and uses of functions
.LI
In the use of enumerations
.LE 1
.P
There are a number of operators 
that have an implied balancing between types of the operands.
The assignment, conditional ( ?\|: ), and relational operators
have this property. 
The argument
of a 
.B return
statement,
and expressions used in initialization 
also suffer similar conversions.
In these operations,
.B char , 
.B short , 
.B int , 
.B long , 
.B unsigned , 
.B float , 
and 
.B double 
types may be freely intermixed.
The types of pointers must agree exactly,
except that arrays of x's 
can be intermixed with pointers to x's.
.P
The type checking rules also require that, 
in structure references, 
the left operand of a pointer arrow symbol (->)
be a pointer to a structure, 
the left operand of a period (\|\fB.\fP\|) be a structure, 
and the right operand of these operators be a member
of the structure implied by the left operand.
Similar checking is done for references to unions.
.P
Strict rules apply to function argument and return value matching.
The types 
.B float 
and 
.B double 
may be freely matched, as may the types 
.B char , 
.B short , 
.B int ,
and 
.B unsigned .
Pointers can also be matched with the associated arrays.
Aside from these relaxations in type checking, 
all actual arguments must agree in type 
with their declared counterparts.
.P
For enumerations, checks are made that enumeration variables 
or members are not mixed with other types or other enumerations,
and that the only operations applied are assignment (=), 
initialization, equals (==), not-equals (!=), 
and function arguments and return values.
.H 3 "Type Casts"
The type cast feature in C was introduced largely as an aid
to producing more portable programs.
Consider the assignment
.DS I
p = 1 ;
.DE
where
.Q p
is a character pointer.
.I Lint
quite rightly reports this as suspect.
Now, consider the assignment
.DS I
p = (char *)1 ;
.DE
in which a cast has been used to
convert the integer to a character pointer.
The programmer obviously had a strong motivation
for doing this, and has clearly signaled his intentions.
On the other hand, if this code is moved to another
machine, such code should be looked at carefully.
The
.B \-c
flag controls the printing of comments about casts.
When
.B \-c
is in effect, casts are checked.
Otherwise, all legal casts are passed without comment,
no matter how strange the type mixing seems to be.
.H 3 "Nonportable Character Use"
.I Lint
flags certain comparisons and assignments as illegal or nonportable.
For example, the fragment
.DS I
char c;
 .
 .
 .
if( (c = getchar()) < 0 ) ...
.DE
works on some machines, but
fails on machines where characters always take on positive values.
The solution is to declare
.Q c
an integer, since
.I getchar
is actually returning integer values.
In any case, 
.I lint
issues the message:
.DS I
nonportable character comparison
.DE
.P
A similar issue arises with bitfields. 
When assignments
of constant values are made to bitfields, the field may
be too small to hold the value.
This is especially true because
on some machines bitfields are considered as signed
quantities.
While it may seem counter-intuitive to consider
that a 2-bit field declared of type
.B int
cannot hold the value 3, the problem disappears
if the bitfield is declared to have type
.B unsigned .
.H 3 "Assignment of longs to ints"
Bugs may arise from the assignment of
.B long 
to an 
.B int ,
because of a loss in accuracy in the process.
This may happen in programs
that have been incompletely converted by changing
type definitions with
.B typedef .
When a 
.B typedef 
variable
is changed from 
.B int 
to 
.B long ,
the program can stop working because
some intermediate results may be assigned
to integer values, losing accuracy.
Since there are a number of legitimate reasons for
assigning longs to integers, the detection
of these assignments is enabled with the
.B \-a
flag.
.H 3 "Strange Constructions"
Several perfectly legal, but somewhat strange, 
constructions are flagged by
.I lint 
with the 
.B \-h
heuristic flag.
The generated messages encourage better code quality, 
clearer style, and may even point out bugs.
For example, in the statement
.DS I
*p++ ;
.DE
the star (\(**) does nothing
and 
.I lint 
prints:
.DS I
null effect
.DE
The program fragment
.DS I
unsigned x ;
if (x < 0) ...
.DE
is also strange since the test will never succeed.
Similarly, the test
.DS I
if (x > 0) ...
.DE
is equivalent to
.DS I
if( x != 0 )
.DE
which may not be the intended action.
In these cases,
.I lint
prints the message:
.DS I
degenerate unsigned comparison
.DE
If you use
.DS I
if( 1 != 0 ) ...
.DE
then
.I lint
reports
.DS I
constant in conditional context
.DE
since the comparison
of 1 with 0 gives a constant result.
.P
Another construction detected by 
.I lint
involves operator precedence.
Bugs that arise from misunderstandings about the precedence
of operators can be accentuated by spacing and formatting,
making such bugs extremely hard to find.
For example, the statements
.DS I
if( x&077 == 0 ) ...
.DE
or
.DS I
x<<2 + 40
.DE
probably do not do what is intended.
The best solution is to parenthesize such expressions.
.I Lint
encourages this by printing an appropriate message.
.P
Finally, when the
.B \-h
flag is in force, 
.I lint
checks variables that are redeclared in inner blocks
in a way that conflicts with their use in outer blocks.
This is legal, but is considered bad style, 
usually unnecessary, and frequently a bug.
.H 3 "Older Syntax"
There are several forms of older C syntax 
discouraged by 
.I lint .
These fall into two classes:
assignment operators and initialization.
.P
The older forms of assignment operators (e.g., =+, =\-, ... )
can cause ambiguous expressions, such as
.DS I
a =\-1 ;
.DE
which could be taken as either
.DS I
a =\-  1 ;
.DE
or
.DS I
a  =  \-1 ;
.DE
The situation is especially perplexing if this
kind of ambiguity arises as the result of a macro substitution.
The newer, and preferred operators (e.g., +=, \-=)
have no such ambiguities.
To encourage the abandonment of the older forms,
.I lint
checks for occurrences of these old-fashioned operators.
.P
A similar issue arises with initialization.
The older language allowed
.DS I
int  x  1 ;
.DE
to initialize
.I x
to 1.
This causes syntactic difficulties. 
For example
.DS I
int  x  ( \-1 ) ;
.DE
looks somewhat like the beginning of a function declaration
.DS I
int  x  ( y ) {  . . .
.DE
and the compiler must read past
.Q x
to determine what the declaration really is.
The problem is even more perplexing when the
initializer involves a macro.
The current C syntax places an equal sign between the
variable and the initializer:
.DS I
int x  =  \-1 ;
.DE
This form is free of any possible syntactic ambiguity.
.H 3 "Pointer Alignment"
Certain pointer assignments may be reasonable on some machines,
and illegal on others, due entirely to
alignment restrictions.
For example, on some machines it is reasonable
to assign integer pointers to double pointers, since
double precision values may begin on any integer boundary.
On other machines, however, double precision values must begin
on even word boundaries;
thus, not all such assignments make sense.
.I Lint
tries to detect cases where pointers are assigned to other
pointers, and such alignment problems might arise.
The message
.DS I
possible pointer alignment problem
.DE
results from this situation whenever the
.B \-p
or
.B \-h
flag is in effect.
.H 3 "Multiple Uses and Side Effects"
In complicated expressions, the best order in which to evaluate
subexpressions may be highly machine-dependent.
For example, on machines in which the stack
runs backwards, function arguments will probably be best evaluated
from right to left; on machines with a stack running forward,
left to right is probably best.
Function calls embedded as arguments of other functions
may or may not be treated similarly to ordinary arguments.
Similar issues arise with other operators which have side effects,
such as the assignment operators 
and the increment and decrement operators.
.P
In order that the efficiency of C on a particular machine not be
unduly compromised, 
the C language leaves the order
of evaluation of complicated expressions up to the
compiler, and various C compilers have considerable
differences in the order in which 
they will evaluate complicated expressions.
In particular, if any variable is changed by a side effect, 
and also used elsewhere in the same expression, 
the result is explicitly undefined.
.P
.I Lint
checks for the important special case where
a simple scalar variable is affected.
For example, the statement
.DS I
a[i] = b[i++] ;
.DE
will draw the comment:
.DS I
warning: i evaluation order undefined
.DE
.H 2 "Directives"
There are occasions when
the programmer is smarter than 
.I lint .
There may be valid reasons for 
.Q "illegal"
type casts,
functions with a variable number of arguments, 
and other construtions that 
.I lint
finds objectionable.
Moreover, as specified in the above sections, 
the flow of control information produced by 
.I lint
often has blind spots, 
causing occasional spurious
messages about perfectly reasonable programs.
Some way of communicating with 
.I lint ,
typically to turn off its output, is desirable.
Therefore, a number of words are recognized by 
.I lint
when they were embedded in comments
in a C source file.
These words are called 
.Q directives .
.XX "lint>directives"
.XX "directives \- lint"
.I Lint
directives are invisible to the compiler, and
the effect on compilers with the older preprocessors
is merely that the 
.I lint
directives do not work.
.P
The first directive discussed concerns flow of control information.
If a particular place in the program cannot be reached,
but this is not apparent to 
.I lint ,
this can be asserted at the appropriate spot in the program
with the directive:
.DS I
/* NOTREACHED */
.DE
Similarly, if you desire to turn off strict type checking for
the next expression, use the directive:
.DS I
/* NOSTRICT */
.DE
The situation reverts to the
previous default after the next expression.
The
.B \-v
flag can be turned on for one function by the directive:
.DS I
/* ARGSUSED */
.DE
Comments about a variable number of arguments 
in calls to a function can be turned off 
by preceding the function definition with the directive:
.DS I
/* VARARGS */
.DE
In some cases, it is desirable to check the
first several arguments, and leave the later arguments unchecked.
Do this by following the VARARGS keyword immediately
with a digit giving the number of arguments that should be checked. 
Thus:
.DS I
/* VARARGS2 */
.DE
causes only the first two arguments to be checked. 
Finally, the directive
.DS I
/* LINTLIBRARY */
.DE
at the head of a file identifies this file as
a library declaration file, discussed in the next section. 
.H 2 "Library Declaration Files"
.I Lint
accepts certain library directives, such as
.DS I
\-ly
.DE
and tests the source files for compatibility with these libraries.
This testing is done by accessing library description files whose
names are constructed from the library directives.
These files all begin with the directive
.DS I
/* LINTLIBRARY */
.DE
which is followed by a series of dummy function
definitions.
The critical parts of these definitions
are the declaration of the function return type,
whether the dummy function returns a value, and
the number and types of arguments to the function.
The VARARGS and ARGSUSED directives can
be used to specify features of the library functions.
.P
.I Lint
library files are processed almost exactly like ordinary
source files.
The only difference is that functions that are defined 
in a library file,
but are not used in a source file, draw no comments.
.I Lint
does not simulate a full library search algorithm,
and checks to see if the source files contain redefinitions of
library routines.
.P
By default,
.I lint
checks the programs it is given against a standard library
file, which contains descriptions of the programs that
are normally loaded when a C program is run.
When the
.B \-p
flag is in effect, another file is checked containing
descriptions of the standard I/O library routines
which are expected to be portable across various machines.
The
.B \-n
flag can be used to suppress all library checking.
.H 2 "Summary"
Listed blow are summaries of the 
.I lint
command line options and directives.
.HU "Options
.VL 12 2
.LI \fB\-a\fR
Report assignments of
.B long
to
.B int
or shorter
.LI \fB\-b\fR
Report unreachable
.B break
statements
.LI \fB\-c\fR
Report questionable casts
.LI \fB\-h\fR
Perform heuristic checks
.LI \fB\-l\fIlibname\fR
Check library file 
.I libname
.LI \fB\-n\fR
Do not check libraries
.LI \fB\-p\fR
Perform portability checks
.LI \fB\-s\fR
Same as
.B \-h 
.LI \fB\-u\fR
Do not report unused or undefined externals
.LI \fB\-v\fR
Do not report unused arguments
.LI \fB\-x\fR
Report unused external declarations
.LE
.HU "Directives"
.VL 20
.LI "/* NOTREACHED */"
Indicates that flow of control does not reach
this point in a program.
.LI "/* NOSTRICT */"
Turns off strict typechecking for the next expression.
.LI "/* ARGUSED */"
Turns on the 
.B \-v 
option for the next function only.
.LI "/* VARARGS */"
Turns off checking for variable number of
arguments in calls to a function. 
.LI "/* LINTLIBRARY */"
Precedes files containing dummy library functions.
.LE
.TC 2 1 5 0
