.ds :? MAKE: A PROGRAM MAINTAINER
.nr H1 7
.PH "'Make''Make'"
.H 2 "Introduction"
It is common practice to divide large programs into smaller, 
more manageable pieces.
The pieces may require quite different treatments:
some may need to be run through a macro processor, 
some may need to be processed by
a sophisticated program generator (e.g., Yacc or Lex).
The outputs of these generators may then have to 
be compiled with special options and with
certain definitions and declarations.
The code resulting from these transformations may then need 
to be loaded together with
certain libraries under the control of special options.
Related maintenance activities include running complicated 
test scripts and installing validated modules.
Unfortunately, it is very easy for a programmer 
to forget which files depend on which others,
which files have been modified recently, 
and the exact sequence of operations
needed to make or exercise a new version of the program.
After a long editing session, 
you may lose track of which files have been changed
and which object modules are still valid,
since a change to a declaration 
can make a dozen other files obsolete.
Forgetting to compile a routine that has been changed or 
that uses changed declarations will result in
a program that will not work, 
and a bug that can be very hard to track down.
On the other hand, recompiling everything in sight 
just to be safe is very wasteful.
.P
The 
.I make 
program automates many of the 
activities of program development and maintenance.
If the information on interfile dependencies 
and command sequences is stored in a file, 
the simple command
.DS I
make
.DE
is frequently sufficient to update the affected files,
regardless of the number that have been edited 
since the last 
.B make
command.
In most cases, the description file is easy 
to write and will change infrequently.
It is usually easier to type the 
.B make
command than to issue even one of the needed operations, 
so the typical cycle of program development operations becomes
think, edit, make, test.
.P
.I Make 
is most useful for medium-sized programming projects.
It does not solve the problems of maintaining multiple source versions
or of describing huge programs.
.H 2 "Command Usage"
The 
.B make 
command takes four kinds of arguments:
macro definitions,
flags, description filenames, and target filenames.
The syntax is as follows:
.DS I
.B
make [ \fIflags\fP ]  [ \fImacrodefinitions\fP ]  [ \fItargets\fP ]
.R
.DE
.P
This section summarizes the operation of the 
.B make
command and explains how its arguments are interpreted.
.P
First, all macro definition arguments 
(arguments with embedded equal signs) are analyzed
and the assignments made.
Command-line macros override corresponding definitions 
found in the description files.
.P
Next, the flag arguments are examined.
The permissible flags are
.de Lb
.LI "\\fb\\$1\\fR"
..
.VL 8 2
.Lb \-i
Ignore error codes returned by invoked commands.
This mode is entered if the fake target name 
.Q ".IGNORE"
appears in the description file.
.Lb \-s
Do not print command lines before executing.
This 
.Q silent 
mode is also entered 
if the fake target name 
.Q ".SILENT"
appears in the description file.
.Lb \-r
Do not use the built-in rules.
.Lb \-n
Print commands, but do not execute them.
In this 
.Q "no execute"
mode, even lines beginning with an at-sign (@)
are printed.
.Lb \-t
Touch the target files (causing them to be up to date) 
rather than issue the usual commands.
.Lb \-q
Return a zero or nonzero status code 
depending on whether the target file
is or is not up to date.
This is 
.Q question
mode.
.Lb \-p
Print out the complete set of macro definitions 
and target descriptions.
.Lb \-d
Print out detailed information on files and times examined.
This is 
.Q "debug"
mode.  
.ne 2i
.Lb \-f
Take the next argument as the name of a description file.
A filename of 
.Q "\-"
denotes the standard input. 
If there are no 
.B \-f
arguments, the file named either
.FN makefile
or
.FN Makefile
in the current directory is read.
The contents of the description files override 
the built-in rules if they are present.
.LE
.P
Finally, the remaining arguments are assumed 
to be the names of targets to be made;
they are done in left to right order.
If there are no such arguments, 
the first name in the description files that does not
begin with a period is 
.Q "made" .
.H 2 "Basic Features"
.I Make
updates a target file by ensuring
that all of the files on which it depends exist and are up to date,
It then recreates the target file
if it has not been modified since any of its dependents were
last modified.
.I Make 
does a depth-first search of the graph of dependencies.
The operation of the command depends 
on the ability to find the date and time
that a file was last modified.
.P
To illustrate, consider a simple example.
A program named
.I prog
is made by compiling and loading three C language files
.FN x.c ,
.FN y.c ,
and
.FN z.c .
By convention, the output of the C compilations 
is found in files named
.FN x.o ,
.FN y.o ,
and
.FN z.o .
Assume that the files
.FN x.c
and
.FN y.c
share some declarations in a file named
.FN defs ,
but that
.FN z.c
does not.
That is,
.FN x.c
and
.FN y.c
have the line:
.DS I
#include "defs"
.DE
The following text describes the relationships and operations:
.DS I
prog:  x.o  y.o  z.o
	cc  x.o  y.o  z.o  \-o  prog

x.o y.o: defs
.DE
If this information is stored in a file named
.I makefile ,
the command
.DS I
make
.DE
performs the operations needed to recreate
.I prog
after any changes have been made to any of the four source files
.FN x.c ,
.FN y.c ,
.FN z.c ,
or
.FN defs .
.P
.I Make 
operates using three sources of information:
a user-supplied description file (as above),
filenames and 
.Q "last-modified"
times from the file system,
and built-in rules to bridge some of the gaps.
In the example, the first line says that
.I prog
depends on three 
.I .o
files.
Once these object files are current, 
the second line describes how to load them to create
.I prog .
The third line says that
.FN x.o
and
.FN y.o
depend on the file
.FN defs .
From the file system, 
.I make
discovers that there are 
three 
.I .c
files corresponding 
to the needed 
.I .o
files,
and uses built-in information 
on how to generate an object from a source file
(\fIi.e.,\fR issue a 
.Q "cc\ \-c"
command).
.P
The following description file is equivalent 
to the one above, but takes no advantage of
.I Make's
default rules:
.DS I
prog:  x.o  y.o  z.o
	cc  x.o  y.o  z.o  \-o  prog

x.o:  x.c  defs
	cc  \-c  x.c
y.o:  y.c  defs
	cc  \-c  y.c
z.o:  z.c
	cc  \-c  z.c
.DE
.P
If none of the source or object files have been
altered since the last time
.I prog
was made, then all of the files are current, and
the command
.DS I
make
.DE
simply announces this fact and stops.
If, however, the
.FN defs
file has been edited,
.FN x.c
and
.FN y.c
(but not
.FN z.c )
are recompiled, and then
.I prog
is created from the new 
.I ".o"
files.
If only the file
.FN y.c
has changed, only it is recompiled, 
but it is still necessary to reload
.I prog .
.P
If no target name is given on the 
.I make
command line, the first target mentioned 
in the description is created;
otherwise the specified targets are made.
The command
.DS I
make x.o
.DE
recompiles
.FN x.o
if
.FN x.c
or
.FN defs
have changed.
.P
If the file exists after the commands are executed,
its time of last modification is used in further decisions;
otherwise the current time is used.
It is often useful to include rules with 
mnemonic names and commands that do not
actually produce a file with that name.
These targets can take advantage of 
.I make 's
ability to generate files and substitute macros.
Thus, a target named 
.Q "save"
might be included to copy a certain set of files, or a target
.Q "cleanup"
might be used to throw away unneeded intermediate files.
In each case, these are not real target files, but
pseudo-target files.
In other cases, you might maintain 
a zero-length file to keep track
of the time certain actions are performed.
This technique is useful 
for maintaining remote archives and listings.
.P
.I Make
has a simple macro mechanism for substituting 
in dependency lines and command strings.
Macros are defined by command arguments or description file 
lines with embedded equal signs.
A macro is invoked by preceding the name by a dollar sign;
macro names longer than one character must be placed
in parentheses.
The name of the macro is either 
the single character after the dollar sign or 
a name inside parentheses.
The following are valid macro invocations:
.DS I
$(CFLAGS)
$2
$(xy)
$Z
$(Z)
.DE
The last two invocations are identical.
The 
.B $$
macro is a dollar sign.
All of these macros are assigned values during input, as shown below.
Four special macros change values during the execution of the command:
.B $\(** , 
.B $@ , 
.B $? , 
and 
.B $< .
They will be discussed later.
The following makefile fragment shows how macros
might typically be used:
.DS I
OBJECTS = x.o y.o z.o
LIBES = \-lln
prog: $(OBJECTS)
	cc $(OBJECTS)  $(LIBES)  \-o prog
  ...
.DE
The command
.DS I
make
.DE
loads the three object files with the lex library
specified with the
.B \-lln 
switch.  
The command
.DS I
make  "LIBES=\-lln \-lm"
.DE
loads them with both the lex (\-lln) 
and the math (\-lm) libraries,
since macro definitions on the command line 
override definitions in the description.
(It is necessary to quote arguments 
with embedded blanks in \*(x1
commands.)
.P
The following sections detail the form of description files 
and the command line,
and discuss options and built-in rules in more detail.
.H 2 "Description Files and Substitutions"
A description file contains three types of information:
macro definitions,
dependency information,
and executable commands.
There is also a comment convention:
all characters after a number sign (#) are ignored, 
as is the number sign itself.
Blank lines and lines beginning with a number sign 
are totally ignored.
If a noncomment line is too long, 
it can be continued using a backslash.
If the last character of a line is a backslash, the backslash, newline,
and following blanks and tabs are replaced by a single blank.
.P
A macro definition is a line containing an equal sign 
not preceded by a colon or a tab.
The name (string of letters and digits) to the left of the equal sign
(trailing blanks and tabs are stripped) 
is assigned the string of characters following the equal sign
(leading blanks and tabs are stripped.)
The following are valid macro definitions:
.DS I
2 = xyz
abc = -ll -ly 
LIBES =
.DE
The last definition assigns LIBES the null string.
A macro that is never explicitly defined has the null string as value.
Macro definitions may also appear on the
.I make
command line (see the section, 
.Q "Command Usage" above).
.P
Other lines give information about target files.
The general form of a target is:
.DS I
.B
\fItarget\fP ... :[:] [\fIdependent\fP ...] [; \fIcommands\fP] [# ...]
[\s-2<TAB>\s0\fIcommands\fP] [# ...]
 .
 .
 .
.R
.DE
Items inside brackets may be omitted.
Targets and dependents are strings of 
letters, digits, periods, and slashes.
(The shell metacharacters 
star (\(**) and question mark (?) are expanded.)
A command is any string of characters 
not including a number sign (except in quotation
marks) or newline.
Commands may appear either after a semicolon on a dependency line
or on lines beginning with a tab immediately 
following a dependency line.
.P
A dependency line may have either a single or a double colon.
A target name may appear on more than one dependency line, 
but all of those lines must be of the
same (single or double colon) type:
.AL 1
.LI 
If a dependency line contains a target list
followed by a single colon,
then one and only one 
command sequence may be associated with the targets
on the line.
If any of the targets is out of date 
with respect to any of its dependents
and a command sequence is specified,
(even a null one following a semicolon or tab), then
that command sequence is executed.
Otherwise a default creation rule may be invoked.
.LI 
If the same target names appear on multiple dependency lines,
then the target lists on these lines should be
followed by a
.I double
colon and not a single colon.
If the target is out of date 
with any of the dependent files on 
.I any
double-colon dependency line, then the associated
commands for each dependency line are executed.
A built-in rule may also be executed.
Being able to specify the same target name on
several different dependency lines is of particular value 
when updating archive-type files.
.LE
.P
If a target must be created, the sequence of commands is executed.
Normally, each command line is printed and then
passed to a separate invocation of 
the shell after substituting for macros.
(The printing is suppressed in silent mode or 
if the command line begins with an at-sign (@)).
.I Make
normally stops if any command signals an error 
by returning a nonzero error code.
(Errors are ignored if the 
.B \-i
flag has been specified on the
.I Make
command line,
if the fake target name 
.Q ".IGNORE"
appears in the description file,
or if the command string in the description file begins with a hyphen.
Some \*(x1 commands return meaningless status).
Because each command line is passed to a separate 
invocation of the shell,
care must be taken 
with certain commands (e.g., 
.B cd
and shell control commands) 
that have meaning only within a single shell process;
the results are forgotten before the next line is executed.
.P
Before issuing any command, certain macros are set.
The macro 
.B $@ 
is set to the name of the file to be 
.Q "made" .
The macro 
.B $? 
is set to the string of names that were found 
to be younger than the target.
If the command is generated by an implicit rule (see the
next section, below),
the macro
.B $< 
is the name of the related file that caused the action, and
the macro
.B $\(** 
is the prefix shared by the current and the dependent filenames.
.P
If a file must be made, but there are no explicit commands or 
built-in rules concerning it, 
the commands associated with the name 
.Q ".DEFAULT"
are used.
If there is no such name, 
.I make
prints a message and stops.
.H 2 "Implicit Rules"
The 
.I make 
program uses a table of interesting suffixes and a set
of transformation rules to supply default dependency
information and implied commands.
These tables and means of overriding
them are described in the section, 
.Q "Suffixes and Transformation Rules" .
The default suffix list is:
.DS
.sp
.ta 0.5i 1.5i
	\fI.o\fR	Object file
	\fI.c\fR	C source file
	\fI.e\fR	Efl source file
	\fI.r\fR	Ratfor source file
	\fI.f\fR	Fortran source file
	\fI.s\fR	Assembler source file
	\fI.y\fR	Yacc-C source grammar
	\fI.yr\fR	Yacc-Ratfor source grammar
	\fI.ye\fR	Yacc-Efl source grammar
	\fI.l\fR	Lex source grammar
.DE
.P
Figure 7-1 summarizes the default transformation paths.
If there are two paths connecting a pair of suffixes, the longer
path is used only if the intermediate file exists or is
named in the description.
.DS  I
                           .o
                           ^
                           |
   +-----+-----+-----+-----+--+--+-----+-----+-----+-----+
   |     |     |     |     |     |     |     |     |     |
   .c    .r    .e    .f    .s    .y    .yr   .ye   .l    .d
   ^     ^     ^
   |     |     |
+--+--+  |     |
|     |  |     |
\&.y    .l .yr   .ye

.FG "Default Transformation Paths" 7-
.DE
.P
If the file
.FN x.o
is needed and there is an
.FN x.c
in the description or directory, it is compiled.
If there is also an
.FN x.l ,
that grammar would be run through 
.B lex 
before compiling the result.
However, if there is no
.FN x.c
file,
but there is an
.FN x.l 
file,
.I make
then discards the intermediate C-language file and uses the
direct link in the graph above.
.P
It is possible to change the names of some of the compilers 
used in the
default, or the flag arguments 
with which they are invoked, by knowing the macro names used.
The compiler names are 
the macros AS, CC, RC, EC, YACC, YACCR, YACCE, and LEX.
The command
.DS I
make CC=newcc
.DE
causes the 
.I newcc 
command to be used instead of the usual C compiler.
The macros CFLAGS, RFLAGS, EFLAGS, YFLAGS, and LFLAGS may be set to
cause these commands to be issued with optional flags.
Thus
.DS I
make "CFLAGS=\-O"
.DE
causes the optimizing C compiler to be used.
.bp
.H 2 "Example"
As an example of the use of 
.I make ,
examine the following description file used to maintain the 
.B make 
command itself.
The code for 
.I make
is spread over a number of C source files and a YACC grammar.
The description file contains:
.P
.DS 
# Description file for the make command

P = lpr
FILES = Makefile vers.c defs main.c doname.c misc.c files.c dosys.c\e
	gram.y lex.c 
OBJECTS = vers.o main.o ... dosys.o gram.o
LIBES= 
LINT = lint \-p
CFLAGS = \-O

make:  $(OBJECTS)
	cc $(CFLAGS) $(OBJECTS) $(LIBES) \-o make
	size make

$(OBJECTS):  defs
gram.o: lex.c

cleanup:
	\-rm *.o gram.c
	\-du

install:
	@size make /usr/bin/make
	cp make /usr/bin/make ; rm make

print:  $(FILES)	# print recently changed files
	pr $? | $P
	touch print

test:
	make \-dp | grep \-v TIME >1zap
	/usr/bin/make \-dp | grep \-v TIME >2zap
	diff 1zap 2zap
	rm 1zap 2zap

lint :  dosys.c doname.c files.c main.c misc.c vers.c gram.c
	$(LINT) dosys.c doname.c files.c main.c misc.c vers.c gram.c
	rm gram.c

arch:
	ar uv /sys/source/s2/make.a $(FILES)

.DE
.I Make
usually prints out each command before issuing it.
The following output results from typing the simple command
.DS I
make
.DE
in a directory containing only the source and description file:
.DS I
cc  \-c vers.c
cc  \-c main.c
cc  \-c doname.c
cc  \-c misc.c
cc  \-c files.c
cc  \-c dosys.c
yacc  gram.y
mv y.tab.c gram.c
cc  \-c gram.c
cc  vers.o main.o ... dosys.o gram.o \-o make
13188+3348+3044 = 19580b = 046174b
.DE
Although none of the source files or grammars were mentioned
by name in the description file,
.I Make
found them by using its suffix rules and issued the needed commands.
The string of digits results from the 
.Q "size make"
command; the printing of the command line itself was
suppressed by an at-sign (@).
The at-sign on the
.B size
command in the description file suppressed the printing of the command,
so only the sizes are written.
.P
The last few targets in the description file 
are useful maintenance sequences.
The 
.Q "print"
target prints only the files 
that have been changed since the last
.Q "make print"
command.
A zero-length file
.I print
is maintained to keep track of the time of the printing;
the 
.B $? 
macro in the command line 
then picks up only the names of the files changed since
.I print
was touched.
The printed output can be sent to a different printer or to a file 
by changing the definition of the P macro:
.DS I
make print "P = lpr"

	or

make print "P=  cat >zap"
.DE
.H 2 "Suggestions and Warnings"
Most difficulties in using 
.I make
arise from
.I make 's
specific meaning of dependency.
If the file
.FN x.c
has the line 
.DS I
#include "defs"
.DE
then the object file
.FN x.o
depends on
.FN defs ;
the source file
.FN x.c
does not.
(If
.FN defs
is changed, it is not necessary to do anything
to the file
.FN x.c ,
while it is necessary to recreate
.FN x.o .)
.P
To determine which commands
.I make
will execute, 
.I without
actually executing them, use the
.B \-n
option.
For example, the command
.DS I
make \-n
.DE
prints out the commands 
.I make 
would normally execute
without actually executing them.
.P
If a change to a file is absolutely certain to be benign
(e.g., adding a new definition to an include file),
the 
.B \-t
(touch) option can save a lot of time:
instead of issuing a large number of superfluous recompilations,
.I make
updates the modification times on the affected file.
Thus, the command
.DS I
make \-ts
.DE
which stands for 
.Q "touch silently" ,
causes the relevant files to appear up to date.
Obvious care is necessary, since this mode of operation subverts
the intention of 
.I make
and destroys all memory of the previous relationships.
.P
The debugging flag 
.B \-d 
causes 
.I make
to print out a very detailed description of what it is doing, 
including the file times.  
The output is verbose, and recommended only as a last resort.
.bp
.H 2 "Suffixes and Transformation Rules"
.I Make
maintains an internal table that has the form of a description file.
This table contains information about
filename suffix transformation rules.
If the 
.B \-r
flag is used, this table is not used.
.P
The list of suffixes is actually the dependency list for the name
.Q ".SUFFIXES" .
.I Make
uses 
.Q ".SUFFIXES"
by looking for a file with any of the suffixes on the list.
If such a file exists, and if there is a transformation
rule for that combination,
.I make
acts as described earlier.
The transformation rule names are the concatenation of the
two suffixes.
The name of the rule to transform a 
.I .r
file to a 
.I .o
file
is thus 
.I .r.o .
If the rule is present and no explicit command sequence
has been given in the user's description files, the command
sequence for the rule 
.I .r.o
is used.
If a command is generated by using one of these suffixing rules,
the macro 
.B $\(** 
is given the value of the stem
(everything but the suffix) of the name of the file to be made,
and the macro 
.B $<
is the name of the dependent that caused the action.
.P
The order of the suffix list is significant, since it is scanned from
left to right, and the first name that is formed that has both a file
and a rule associated with it is used.
If new names are to be appended, you can just add a target for
.Q .SUFFIXES
in your own description file; 
the dependents will be added to the usual list.
A 
.Q .SUFFIXES
line without any dependents deletes the current list.
(It is necessary to clear the current list 
if the order of names is to be changed).
.ne 4i
.P
The following is an excerpt from the default rules file:
.DS I 
 .SUFFIXES : .o .c .e .r .f .y .yr .ye .l .s
 YACC=yacc
 YACCR=yacc -r
 YACCE=yacc -e
 YFLAGS=
 LEX=lex
 LFLAGS=
 CC=cc
 AS=as -
 CFLAGS=
 RC=ec
 RFLAGS=
 EC=ec
 EFLAGS=
 FFLAGS=
 .c.o :
 	$(CC) $(CFLAGS) -c $<
 .e.o .r.o .f.o :
 	$(EC) $(RFLAGS) $(EFLAGS) $(FFLAGS) -c $<
 .s.o :
 	$(AS) -o $@ $<
 .y.o :
 	$(YACC) $(YFLAGS) $<
 	$(CC) $(CFLAGS) -c y.tab.c
 	rm y.tab.c
 	mv y.tab.o $@
 .y.c :
 	$(YACC) $(YFLAGS) $<
 	mv y.tab.c $@
.DE
.TC 2 1 5 0
