.nr H1 3
.H 1 "Document Preparation and Text Formatting"
Once you have mastered one or more of your text editors, you will 
be ready to do extensive writing, revision,
and text processing with \*(x1.	
The first part of this chapter discusses the overall organization of
a writing project. 
It offers some common-sense suggestions for managing and 
standardizing your text files to make processing more efficient.
Although not all of the suggestions and writing aids discussed
here will be equally appropriate in all situations, generally
the larger and more complex the writing project, the more
time and confusion can be saved by their implementation.
.P
The second part of this chapter is an introduction to \*(x1 text formatting
with the
.B nroff
and
.B troff
programs, 
along with the
.B ms
macro package, which allows you to format documents easily,
without having to use
.B nroff/troff
directly.
Also discussed are several specialized formatting programs: 
.BL
.LI
.B tbl
for specifying the final output of tables
.LI
.B eqn
for typesetting mathematical equations
.LI
.B refer
for creating indexes and bibliographic citations.
.LE
.H 2 "Tools and Techniques for Document Preparation With Xenix"
To use \*(x1 effectively as a text processing environment, you will
need to learn the following editing and formatting tools:
.BL
.LI
editors (like \fBvi\fR, \fBed\fR, and \fBsed\fR)
.LI
common \*(x1 commands (like \fBgrep\fR and \fBdiff\fR)
.LI
formatting programs, like those described in the remainder of this
manual 
.LE
.P
Equally important, however, is making use of the power of \*(x1 as
an operating system by using its features to your advantage.
In particular, consider how your work can be made more efficient:
.BL
.LI
by utilizing the \*(x1 hierarchical file structure to organize text 
efficiently
.LI
by taking advantage of the characteristics of the \*(x1 shell, including:
.DL
.LI
the capacity to \*`pipe\*' one process to another and run several processes
concurrently.
.LI
the capacity to use the \*(x1 shell programming language to create
\*`scripts\*' for automating your text processing work. 
.LE
.LI
by enhancing your editing capabilities with various \*(x1 utilities like 
.B grep,
.B awk,
and
.B diff,
which though not specifically text processing tools, can be extremely
useful for some text processing tasks. 
.LE
.sp
It is important that you begin to develop strategies for managing your
writing projects beyond merely learning a collection of commands or macros. 
.H 3 "Organizing Your Project"
Organization is a key element, especially if you are working on a large 
document, or attempting to control many short ones.
Text processing can greatly simplify any writing project, if
you use common sense in adapting the wide range of \*(x1 tools
to your work. If you work with many short memos, letters, and
documents which are similar in content but require constant
revision, or if you are involved with large-scale documentation
projects, or the production of book-length manuscripts, you can
easily find yourself swamped with many huge files of innumerable
text variations and fragments.
These can become extremely difficult to control and process.
Any time you spend defining the scope of your project
in advance will be well rewarded. 
Decide which files and versions you will need to maintain, and which 
formatting and error-checking programs you will be likely to use. 
Determine in advance, if possible, the style and format of your text.
.P
Since most documents will go through several revisions before they are
finished, a few simple measures will make the work of repeated 
revision considerably easier. 
If you are like most writers, you probably rewrite phrases and add,
delete, or rearrange sentences. 
Subsequent editing of your text will be easier if every sentence starts on 
a new line, and if each line is short and breaks at a natural place,
such as after a semicolon or comma.
You may wish to leave markers in your text, so that you can return
later;
use an unlikely string that you can search for easily, with 
.B grep
or with a global search using the text editor.
If, for example, you are unsure of which term to use, or how you
want the final text to look, use a given word, or text formatting
macro provisionally, but
.I consistently.
In this way, a global substitution can be made efficiently later on.
You may find that certain universal definitions, like the choice
of a font for a given header level, or the definition of a commonly
used string, may be defined at the last minute and placed at the beginning
of your text file.
When you are experienced in the use of these macros, you may want to
create \*`template\*' definitions which you use repeatedly.
You can even place your definitions in a separate file to be called every 
time you invoke a script you have pre-written for processing your documents.
This will facilitate consistency in your documents and allow
greater flexibility if changes are required.
In many cases, you will find that you can delay your
formatting decisions until the document is to be printed or typeset.
.P
Naturally, long documents should be broken down into individual
files of reasonable length, perhaps ten to fifteen thousand
characters.
Operations on larger files are considerably slower, and the 
accidental loss of a small file is less catastrophic.
If possible, each file should represent a natural boundary
in the document, such as a chapter section. 
Develop naming conventions to make your filenames consistent and 
self-explanatory,
such as:
.DS I
     1.intro.s     2.basic.s     3.adv.s
.DE
This allows files to be processed in groups with global commands,
editing and shell scripts, along with giving you a clue to what is in
each file. 
In this example, filenames end in \*`.s\*' for \*`source files\*'
and are output into formatted files which end in \*`.ms\*':
.DS I
ms *.s> *.ms& 
.DE
You will also be able to see the contents of files and directories
at a glance, and if someone else needs to access your files, they 
will not be confronted with files named \*`aardvark\*', \*`katmandu\*',
or \*`fred\*'.
.P
You should also use the \*(x1 hierarchical file structure to
your advantage in organizing your work, by creating different
directories for special purposes. 
For example, you may wish to have your source text files in a different 
directory from your formatted output files, or you may find it handy to
have \*`scratch\*' and \*`final\*' draft directories. 
If your projects grow and change over time, you may need to maintain 
several versions of a document at once. 
.P
One possibility might be to use an elaborate configuration
control scheme, 
but unless your project is truly unwieldly, the creation of
parallel directories may prove sufficient:
.DS L
             /usr/docwriter
                   |
   ___________________________________
   |               |                 |
version1        version2          version3                   
   |               |                 |
                               ___________________
                               |        |        |
                            scratch   final    nroff
                                       |         |
                                    1.intro.s  1.intro.n
                                    2.basic.s  2.basic.n
                                    3.adv.s    3.adv.n  
.DE
If you have created definition files and scripts, such as shell
programs for processing text or
.B sed 
scripts for making uniform changes,
place them in yet another directory.
This might also be a good
place to add some \*`help\*' files, such as explanations of procedures,
or other notes you need to refer to.
.P
Obviously, there are no rules to apply in deciding which
procedures will produce documentation with the fewest errors and the least 
effort.
How elaborate you make your procedures will depend largely on 
the quantity of text you need to process and maintain.
The essential point here is the theme of this entire volume:
select the \*(x1 tools which seem most appropriate and adapt them
to your own specific needs. 
The more organized and consistent
your work is, the more powerful your use of these tools will
become.
.H 3 "Shortcuts: Boilerplates and Cut and Paste"
It is very probable that \*(x1 offers several approaches to
almost any writing or revision work.
Begin each writing project by reviewing these alternatives, and determine
which solution requires the least repetitive human effort (after all, that's
why you have a computer) and leaves the least room for error. 
You can increase your productivity, whether you are writing technical 
papers, documentation, or many memos with similar content, by focusing on 
writing clearly and concisely, rather than wasting time on 
needless duplication of effort. 
If you  proceed in
an organized, consistent way, as outlined in the previous
section, you will quickly find that \*(x1 offers you
innumerable shortcuts. 
One of these is the concept of the \*`editing script\*'. 
Either of the line editors,
.B ed
or 
.B ex, 
can be used to accomplish a complicated sequence of
editing operations on a large group of files simultaneously.
These can often be a simple substitute for the use of a
batch editing facility like
.B sed,
or the use of such programs as
.B awk
or
.B grep.
.P
For example, to change every \*`Xenix\*' to \*`XENIX\*' and every
\*`Unix\*' to \*`UNIX\*' in all your files, create a script file with 
the following lines:
.DS I
g/Xenix/s//XENIX/g
g/Unix/s//UNIX/g
w
q
.DE
Now, you can use the command
.DS I
ed *.s<script
.DE
to make this change globally. 
The editor will take its commands from the prepared script. 
You can further automate your procedures by using the \*(x1 shell language 
to write a shell script. 
For example, you can write a script which asks \*(x1 to make the above 
changes, reformat the entire text, and print the results.
It is even possible to put this script in a file to be read by the 
\*(x1
.B \*`at\*' 
command, to do your processing at some specified off-peak hour. 
You can edit, format, and print your files while you sleep.
.P
If you must produce many similar documents, or long 
documents which contain repeated material, the concept
of the \*`boilerplate\*' may already be familiar to you.
Often, information which must be presented in a standardized
way can be stored in a separate file which can be re-used as
necessary. 
Not only is this a valuable shortcut to rewriting,
it may be the preferred approach, if a complex display, or
an example of program text, must be reproduced. 
Using boilerplates assures consistency and makes subsequent changes
to all recurrences of the copied material much simpler.
.P
The so-called boilerplate, however, is only one example of
how files may be manipulated by a kind of computerized
cut and paste operation to save time-consuming text entry
and allow for the easy rearrangement of lines, paragraphs,
and extensive sections of text. 
You are already familiar with the \*(x1 commands for copying,
changing filenames, removing files, and putting two or
more files together, and the methods for manipulating parts
of files, individual lines, or groups of lines, using 
.B ed.
By utilizing the power of the shell command
language, you can edit several files simultaneously, by 
invoking new instances of the editor 
while you remain within the editing workspace of another
file. 
You are warned to do this cautiously and conservatively,
however: recursive editing can be both a powerful tool and
a powerful source of confusion.
.H 3 "Error-Checking With Spell"
One specialized \*(x1 tool
can save you much time and grief in document
preparation by finding a high percentage of your spelling and
typographical errors with a minimum of effort and processing time:
the
.B spell
program.
.B Spell
is no substitute for careful editing and rewriting, but it does help you 
uncover most of the obvious text errors.
The 
.B spell
program matches all the words in the text files you specify, and 
checks them against a pre-existing \*(x1 dictionary file. 
Words which neither
appear in this dictionary, nor can be derived by the application
of ordinary English prefixes, suffixes, or inflections are printed
out as spelling errors.
If you do not specify an output file in which to store the list of
misspelled words, they will appear on your screen.
For example, to find the spelling errors in your file called \*`1.intro.s\*',
type
.DS I
spell 1.intro.s
.DE
and the list will appear on your screen.
You can also use a command line like
.DS I
spell *.s>*.sp&
.DE
to check all your files at once and output the error lists into corresponding
files with names that end in \*`sp\*'.
.P
.B Spell 
ignores most of the common formatting macros from
.B nroff/troff,
.B tbl,
and
.B eqn.
If you use the \fBspell -v\fR option, words not literally in
the spelling list are printed, along with plausible derivations
from spelling list words. 
With the \fB-b\fR option, British spelling is checked. 
This option prefers centre, colour, speciality, and travelled,
and insists on the use of \fI-ise\fR in words like ``standardise''.
.P
This spelling list is derived from many sources, and while it recognizes
many proper names and popular technical terms, it does not include
an extensive specialized vocabulary in biology, medicine, or
chemistry. 
Naturally, the \*(x1 dictionary will not recognize your friends' names,
your company's acronyms, and many esoteric words.
You will have to examine your list of spelling \*`errors\*' critically in 
this light, then search your text for those words which really are misspelled.
In practice, you may discover that it
is difficult to predict in advance which technical terms, names,
and acronyms, 
.B spell 
will uncover in your documentation. 
You may wish to run
.B spell
on your files first, then edit the output list, deleting those
words which are allowable, before correcting your errors.
.H 2 "Text Formatting"
In the next section you will be introduced to 
.B nroff
and
.B troff, 
the two \*(x1 formatting programs for the lineprinter and phototypesetter,
respectively.
By inserting a series of commands into your text you will be
able to produce text with justified right margins, automatic page numbering 
and titling, automatic hyphenation, and many other special features.
.B Nroff
(pronounced \*`en-roff\*') is designed to produce output on terminals and
lineprinters.
.B Troff
(pronounced \*`tee-roff\*')
uses identical commands to drive a phototypesetter. 
The two programs are completely compatible, but
because of the limitations of ordinary lineprinters, 
.B troff
output can be made considerably more sophisticated.
With 
.B troff,
for example, you can specify italic font, variable spacing, and point size.
On the other hand, if you format the text using the same macros with
.B nroff,
italicized text will be underlined instead, the spacing will be approximated,
and the text will be printed in whatever size type the lineprinter
offers. 
.H 3 "The Macro Package ms"
To use
.B nroff 
and 
.B troff,
you must add a fairly complicated series of commands directly into your text.
These \*`formatting commands\*' specify in detail
how the final output will look.
Because
.B nroff
and
.B troff
are relatively hard to learn to use effectively, \*(x1 also offers a 
package of canned formatting requests called
.B ms.
With 
.B ms,
you can specify the style of paragraphs, running titles, footnotes, 
multicolumn output, lists and so on, with less effort
and without having to learn
.B nroff
and
.B troff
themselves.
The
.B ms
program reads the macros from the text, and translates them
into
.B nroff/troff
specifications.
.B Ms 
is described in detail in the next chapter.
It is recommended that you learn 
.B ms
first, and use it for most of your formatting needs.
Then if you need to fine-tune your output, you can add
.B nroff/troff
macros to the text as necessary.
.P
To produce a document with 
.B ms,
use the command
.DS I
troff -ms filename
.DE
for output to the typesetter, and
.DS I
nroff -ms filename 
.DE
to print your output on a lineprinter, or view it on your terminal screen.
.H 3 "Supporting Tools"
In addition to the 
.B nroff
and
.B troff
formatting programs,
and the
.B ms
formatting package, there are also formatting programs to meet
some specialized needs.
The
.B eqn
program, for example,
typesets complicated mathematical symbols and equations. 
A version of   
.B eqn
called
.B neqn
outputs the same mathematical text for the more limited capabilities of the
lineprinter. 
Like the macro package
.B ms,
.B eqn
is a preprocessor.
That is, you run
.B eqn
first, before 
.B nroff/troff,
to translate the commands of the 
.B eqn
\*`language\*' into ordinary
.B nroff/troff
macros.
You may find the
.B eqn 
program quite interesting, because many of the formatting commands
resemble English words (e.g., over, lineup, bold, union),
and the format is specified much as you might try to describe an equation
in conversation. 
However, it is recommended that you delay learning about
.B eqn
in detail until you actually need to use it.
.P
The 
.B tbl
program
is also a preprocessor: the
.B tbl
commands are translated into
.B nroff/troff
commands
to prepare quite complex tables. 
.B Tbl
gives a you a high degree of control over material which must appear in tabular
form, by doing all the computations necessary to align complicated columns
with elements of varying widths.
However, like
.B eqn,
it requires that you learn another group of commands, and process your
files through another program before using
.B nroff/troff.
Since you can build simple tables successfully using only the 
.B ms
macro package, using the commands
.B .TS 
and
.B .TE,
supplemented with some
.B nroff/troff
spacing commands,
it is recommended that you reserve your use of
.B tbl
for very complicated material,
and concentrate on learning
.B ms
and
.B nroff/troff.
.P
The last program introduced in this volume is
.B refer.
.B Refer
prepares bibliographic citations from a database,
in whatever style you define using your other formatting programs.
It looks after all the details of numbering references in sequence,
supplying page and volume numbers, and providing the exact citation of the 
author and title.
Once again, this is very specialized material.
In order to prepare a bibliography,
you will have to create a database of citations first.
You can also use
.B refer
in conjunction with
.B ms
to generate a permutated index.
.H 3 "Order of Invoking Programs"
After you have inserted all your macros into the text, you are ready
to process your files, using the various \*(x1 formatting programs.
Please note that it is extremely important to use the various macro
packages and formatters in the correct order.
However, you may invoke all these programs with a single command line,
utilizing the \*(x1 \*`pipe\*' facility. 
As noted above, you can invoke the
.B ms
macro package along with 
.B nroff/troff
using a command such as:
.DS I
nroff -ms ch1.s
.DE
However, if you are using several specialized formatters along with
.B nroff/troff,
the command becomes more complex.
You must invoke
.B eqn
before
.B nroff/troff
and
.B ms,
in order to translate the
.B eqn
commands into
.B nroff/troff
specifications before the files are formatted, as in the following: 
.DS I
eqn ch1.s|troff -ms&
.DE
If you are using both
.B eqn
and
.B tbl,
the
.B tbl
program should be called first:
.DS I
tbl ch1.s|eqn|troff -ms
.DE
.P
If you are formatting multi-column material with 
.B nroff, 
or using the
.B .TS
and
.B .TE
commands in
.B ms 
to format tables,
you must use the 
.B col 
(for \*`column\*') program.
The function of
.B col
is to process your text into the necessary columns,
after formatting, as in:
.DS I
nroff -ms ch1.s|col
.DE
If you are using the
.B tbl
program,
.B col 
will be invoked automatically.
.H 3 "A Note About the Papers"
In the next section, after an introduction to the
.B ms
macro package,
you will find a group of papers from Bell Labs about
.B nroff ,
.B troff,
and the specialized formatting programs,
.B tbl ,
.B eqn ,
and
.B refer .
Keep in mind that although these papers refer to \*(u1,
the operating system from which \*(x1 is derived, all references to \*(u1 are 
equally applicable to \*(x1.
These papers were written largely by the authors of the programs. 
Besides providing clear tutorial and reference material about
the programs, each article uses the various \*(x1 text processing tools 
quite extensively. 
Collectively, these papers provide an 
excellent example of extremely complicated text formatted directly to 
a phototypesetter using 
.B troff.
.TC
