/*
 * c215.c
 *	iSBC 215 Specific Configuration file.
 *
 * This split out from c.c to avoid name-clashing with other device-
 * specific configuration files.
 *
 * Modified 6-29-82 for bad-track support:
 *	priam partition[0] is whole disk, priam drtab[] entry altered for this.
 */

#include "../h/param.h"
#include "../h/i215.h"
#include "../h/buf.h"		/* I003 for buf struct definition */


/*
 * These tables specify the wake-up blocks, and per-controller data-structures
 * for each 218/218 or 220 controller.  The partitions, device-characteristics
 * are defined.  See i215.h for descriptions of these structures.
 */

/*
 * Note: MUST have 215/218,220 boards contiguous major numbers AND have
 *	 same 1st index in bdevsw[] & cdevsw[].
 */

int	i215fmaj = 0;				/* 1st {b,c}devsw index */

/*
 * Firstape is the first tape device which uses non-bsize'd record sizes.
 */
short	FIRSTAPE = FIRSTREMOV + NEXT_REMOVE_UNIT;	/* all tape devices */

/*
 * Priam 3450 Partitions.
 * Note: Partition[0] is the entire disk (except for the diagnostic cylinder).
 *	 This includes the alternate-track cylinders and the bad-track data.
 *	 Partitions[1-3] only address cylinders 0-509.  510-519 are alternate
 *	 track cylinders.  Cylinders 520-523 contain the bad-track data.
 *	 Cylinder 524 is for diagnostics.
 */

struct	i215part Piw0[] = {
	   0,	     524*5*12,		/* [0] whole disk (+alts & bad-track)*/
	  12,		 6000,		/* [1] "root":  6000K */
	6012,		 1188,		/* [2] "swap":  1188K */
	7200,           23400           /* [3] rest:   23400K */
};

/*
 * Pertec D8020 Partitions.
 * Note: Partition[0] is the entire disk.
 *	 Alternate-tracking not supported automatically for the Pertec.
 */

struct	i215part Ppw0[] = {
	   0,	    466*3*12,		/* [0] whole disk */
	  12,		6000,		/* [1] "root":  6000K */
	6012,		1188,		/* [2] "swap":  1188K */
	7200,		9360		/* [3] rest:    9360K */
};

/*
 * 215 Board 0, Unit 0 (Wini) Device-Table Definitions (drtab's)
 * Note: the Priam description sets nalt == 0; this is to allow
 *	 access to the bad-track data which is beyond the alternate
 *	 tracks.  The user must be careful not to overwrite this
 *	 data unintentionally (ie, via format).
 */

struct	i215cdrt i215d00[] = {
/*Cyls, Fixed, Remov,  #Sec,  SecSiz,  Nalt, Partitons    Unit: Drive-Type   */
  524,	5,	0,	12,	1024,	0,	Piw0,	/* [0]: Priam 3450   */
  466,	3,	0,	12,	1024,	6,	Ppw0	/* [1]: Pertec D8020 */
};

/*
 * SS/DD Floppy, 1024-byte sector Partitions.  Note: track 0 unused.
 */

struct	i215part Pf0[] = {
	8,		608		/* [1] rest:  608K    */
};

/*
 * DS/DD Floppy, 1024-byte sector Partitions.  Note: track 0 unused.
 */

struct	i215part Pdf0[] = {
	8,		1224		/* [1] rest:  1224K   */
};

/*
 * SS/SD Floppy, 128-byte sector Partitions.
 */

struct	i215part Psf0[] = {
	   0,		  26,		/* [0] track 0: 26 sectors: 3.25K */
	  26,		1976		/* [1] rest:  1976 sectors: 247K  */
};

/*
 * SS/DD Floppy, 256-byte sector Partitions.  Note: track 0 unused.
 */

struct	i215part Pxf0[] = {
	  26,		1976		/* [0] rest:  1976 sectors: 494K  */
};

/*
 * DS/DD Floppy, 256-byte sector Partitions.  Note: track 0 unused.
 */

struct	i215part Pdxf0[] = {
	  26,		3978		/* [0] rest:  3978 sectors: 994.5K */
};

/*
 * STARTSTOP Tape Minimums/maximums
 */
struct	i215part Mmt0[] = {
	1,		16384,			/* kennedy start-stop */
	512,		65024			/* Archive streamer */
};

/*
 * 215 Board 0, Unit 4 (Floppy) Device-Table Definitions (drtab's)
 */

struct	i215cdrt i215d04[] = {
/*Cyls, Fixed, Remov,  #Sec,  SecSiz,  Nalt, Partitions  Unit: Drive-Type */
  77,	0,	1,	8,	1024,  FLPY_MFM,Pf0,  /* [0]: SS/DD 1024 byte */
  77,	0,	2,	8,	1024,  FLPY_MFM,Pdf0, /* [1]: DS/DD 1024 byte */
  77,	0,	1,	26,	128,   FLPY_FM,	Psf0, /* [2]: SS/SD 128 byte */
  77,	0,	1,	26,	256,   FLPY_MFM,Pxf0, /* [3]: SS/DD 256 byte */
  77,	0,	2,	26,	256,   FLPY_MFM,Pdxf0 /* [4]: DS/DD 256 byte */
};

/* 
 * 215 Board 0 unit 8 (Tape) Device-Table Definitions (drtab's) 
 *
 * Note: Tape is treated differently from disk.
 *	Formating a tape unit will cause the Tape to be erased.
 *	Sector Size refers to the block size of the tape device.
 *	#Sec (Number of sectors per Track) is the Number of Blocks 
 *	per Tape.
 *	Streamer Tapes (Archive) Must be blocked in a multiple of the
 *	on board buffer size. (512 bytes)
 *
 */

struct	i215cdrt i215t00[] = {
/* unit-present, no-op, no-op, no-op, no-op, !rew?, Partitions, Unit: Drive-Type */  
  49,	0,	0,	0,	0,	0, Mmt0,    /* [0]: SS Kennedy */
  49,	0,	0,	0,	0,	1, Mmt0,    /* [0]: SS non-rewinding Kennedy */
  49,	0,	0,	0,	0,	0, Mmt0,    /* [1]: ST Archive */
  49,	0,	0,	0,	0,	1, Mmt0     /* [1]: ST non-rewinding Archive */
};

/*
 * i215minor		I003
 *
 * This structure has been added to widen the minor number information. I003
 *
 * This table configures the board number, partition number, drtab number
 * and unit number. Beware of the C restrictions described in The C Programming
 * Language book by Kernighan/Ritchie (6.7 Fields).
 *
 *
 * struct i215minor i215minor {
 *		board:		4;
 *		partition:	4;
 *		drtab:		4;
 *		unit:		4;
 * };
 */
unsigned i215minor[] = {			/* I003 addition */

/*	i215MINOR(board#,unit#,drtab#,partition#)		I003	*/
						/* [minor] device */
	i215MINOR(0,0,0,0),			/* [0] priam track 0 */
	i215MINOR(0,0,0,1),			/* [1] priam root part */
	i215MINOR(0,0,0,2),			/* [2] priam swap part */
	i215MINOR(0,0,0,3),			/* [3] priam usr  part */
	i215MINOR(4,0,0,0),			/* [4]	invalid */
	i215MINOR(4,0,0,0),			/* [5]	invalid */
	i215MINOR(4,0,0,0),			/* [6]	invalid */
	i215MINOR(4,0,0,0),			/* [7]	invalid */
	i215MINOR(0,4,0,0),			/* [8] f0 floppy */
	i215MINOR(0,4,1,0),			/* [9] df0 floppy */
	i215MINOR(0,4,2,0),			/* [10] sft0 floppy */
	i215MINOR(0,4,2,1),			/* [11] sf0 floppy */
	i215MINOR(0,4,3,0),			/* [12] xf0 floppy */
	i215MINOR(0,4,4,0),			/* [13] dxf0 floppy */
	i215MINOR(0,8,0,0),			/* [14] mt0 ss tape rewind */
	i215MINOR(0,8,1,0),			/* [15] mnt0 ss tape no-rewind*/
	i215MINOR(4,8,2,1),			/* [16] smt0 st tape rewind */
	i215MINOR(4,8,3,1),			/* [17] smnt0 st tape no-rewind*/
	/*
	 * Archive support NOT implemented Yet!!!
	 * Re: smt0 and smnt0
	 */
	i215MINOR(4,0,0,0),			/* [18]	invalid */
	i215MINOR(4,0,0,0),			/* [19]	invalid */
	i215MINOR(4,0,0,0),			/* [20]	invalid */
	i215MINOR(4,0,0,0),			/* [21]	invalid */
	i215MINOR(4,0,0,0),			/* [22]	invalid */
	i215MINOR(4,0,0,0),			/* [23]	invalid */
	i215MINOR(4,0,0,0),			/* [24]	invalid */
	i215MINOR(4,0,0,0),			/* [25]	invalid */
	i215MINOR(0,0,1,0),			/* [26]	pw0t0 wini(215a/b) */
	i215MINOR(0,0,1,1),			/* [27]	pw0a wini(215a/b) */
	i215MINOR(0,0,1,2),			/* [28]	pw0b wini(215a/b) */
	i215MINOR(0,0,1,3) 			/* [29]	pw0c wini(215a/b) */
};


/*
 * 215 Board configuration.
 *
 * This configures ONE 215/218/217 controller, with units [0] & [4] & [8] valid.
 *
 * To configure the 215(a/b) just replace the Dev-code[1] with a INVALID
 * NOTE: If tape is configured, you MUST have a 215G board, even if you
 *	 aren't going to use the tape.  Stated another way, if you are
 *	 going to use a 215A or B, you MUST set Dev-Code[1] to INVALID
 *	 instead of STARTSTOP.
 *
 */

struct	i215cfg	 i215cfg[] = {
/*       WUA,	Dev-Code[0], Dev-Code[1], Int, Device Table[unit]	    */
	0x0100,	DEV8FLPY, INVALID, 	5,	i215d00,	/* Unit [0] */
						0,		/* Unit [1] */
						0,		/* Unit [2] */
						0,		/* Unit [3] */
		/* for Device code[0] */	i215d04,	/* Unit [4] */
						0,		/* Unit [5] */
						0,		/* Unit [6] */
						0,		/* Unit [7] */
		/* for Device code[1]*/		i215t00,	/* Unit [8] */
						0,		/* Unit [9] */
						0,		/* Unit [10] */
						0		/* Unit [11] */
};
/*
 * The following are static initialization variables
 * which are based on the configuration. These variables
 * MUST NOT CHANGE because the i215 device driver makes
 * most of the calculations based on these variables.
 *
 * This is an addition to I003
 */

#define	NUM215	((sizeof i215cfg) / (sizeof (struct i215cfg)))

/*
 * maximum minor number posible .
 */
short	i215maxmin = ((sizeof i215minor) / (sizeof (struct i215minor)));

int	N215 =	NUM215;			/* I003 number of configured boards */
struct	buf	i215tab[NUM215];	/* I003 buffer headers per board */
struct	buf	i215rbuf[NUM215];	/* I003 raw buffer headers per board */
struct	i215dev	*i215bdd[NUM215];	/* I003 board-idx -> "dev" map */
struct	i215dev	i215dev[NUM215];	/* I003 per-board device-data-structures */
