/*
 * gcpc.c
 *	Stand-alone versions of getchar() and putchar().
 *
 * Use co,ci from M.a86.
 *
 * Written by Bob Beck, 11-28-81.
 * Added line-edit, 12-31-81.
 * 
 * I000		rbk	6-24-82
 *		Added msgbuf[] and msgbufp code/support.
 */

#include "../h/param.h"					/* I000 */

/*
 * getchar
 *	Get a character from the console.
 */

#define	LEBUFSZ	128
#define	RUB	'\177'
#define	BS	'\010'
#define	CTRL_X	'\030'

char	gc_buf[LEBUFSZ];		/* line-edit buffer */
int	gc_cnt = 0;			/* character count */
int	gc_idx = 0;			/* current index */

int
getchar()
{
	register char	c;

	if (gc_idx >= gc_cnt) {			/* fill buffer */
		gc_cnt = 0;
		while((c = ci()) != '\r') {
			if (c == RUB) {
				if (gc_cnt > 0) {
					putchar(BS); putchar(' '); putchar(BS);
					gc_cnt--;
				}
				continue;
			}
			if (c == CTRL_X) {
				putchar('#'); putchar('\n');
				gc_cnt = 0;
				continue;
			}
			putchar(c);
			gc_buf[gc_cnt++] = c;
		}
		gc_buf[gc_cnt++] = '\n';
		putchar('\n');
		gc_idx = 0;
	}
	return(gc_buf[gc_idx++]);
}

/*
 * getflush
 *	Flush any buffered input to getchar.
 */

getflush()
{
	gc_cnt = 0;			/* forces read next-time */
}

/*
 * putchar
 *	Output a character to the console.
 *
 * Also, save messages in ring-buffer for error logging.
 *
 * Value = input character.
 */

char	msgbuf[MSGBUFS];
char	*msgbufp = msgbuf;

int
putchar(c)
char	c;
{
	if (c != '\0' && c != '\r' && c != 177) {		/* I000 */
		*msgbufp++ = c;					/* I000 */
		if (msgbufp >= &msgbuf[MSGBUFS])		/* I000 */
			msgbufp = msgbuf;			/* I000 */
	}							/* I000 */
	if (c == '\n')
		co('\r');	/* insure CR,LF */
	co(c);			/* output it */
	return(c);
}

