#ifdef NEVER
/*      Symbol Reference File
 *
 *      This is a typical symbol reference file.  The area between
 *      (but not including) the comments  'STRICT FORMAT' must obey
 *      the following format:
 *
 *      1. The defined array must be named 'JGLJGL', this is recognized
 *         by the awk script.
 *      2. The first array element must be 0
 *      3. Each line in the array must be in the form
 *              &dumy.<symb>,   /* asmname */
 *         where 'dumy' is a dumy static declaration of the appropriate
 *         structure.  <symb> is the symbol, and 'asmname' is the
 *         assembly language name which will be generated.
 *      4. The first #3 entry must have the comment
 *              /* awknameb */          (all caps)
 *         appended, the last #3 entry must bave
 *              /* awknamee */          (all caps)
 *
 *      Note that the #3 records are understood by AWK, who parses
 *      the lines on blank-space.  Thus, do not add or remove elements,
 *      including the presense or absense of white-space, until
 *      after '/* asmname */'
 *
 *      Also, in #4, above, we show 'awkname?' in lower case, because
 *      an uppercase mention would be matched by 'awk'.  Those names
 *      appear correctly below, where they should be matched.
 */
#endif


#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/mmu.h"
#include "../h/intr.h"
#include "../h/reg.h"
#include "../h/clock.h"
#include "../h/i8087.h"

struct proc zerop;
struct user zerou;
char zeroc[1000];

		   /* STRICT FORMAT */
int *JGLJGL[]={
	0,
	&zerop.p_pnum,          /* P_PNUM     */    /*  AWKNAMEB */
	&zerou.u_procp,         /* U_PROCP    */
	&zerou.u_fpused,        /* U_FPUSED   */
	&zerou.u_fpsaved,       /* U_FPSAVED  */
	&zerou.u_fps.fp_stat,   /* U_FPSTAT   */
	&zerou.u_fps.fp_cntrl,  /* U_FPCNTRL  */
	&zerou.u_fps.fp_tag,    /* U_FPTAG    */
	&zeroc[I87_DV0],        /* I87_DV0    */
	&zeroc[I87_OVF],        /* I87_OVF    */
	&zeroc[I87_IOP],        /* I87_IOP    */
	&zeroc[I87_UNF],        /* I87_UNF    */
	&zeroc[MM_BSTACK],      /* MM_BSTACK  */
	&zeroc[MM_CLRST],       /* MM_CLRST   */
	&zeroc[MMP_ENA],        /* MMP_ENA    */
	&zeroc[MM_KMAP],        /* MM_KMAP    */
	&zeroc[MM_PROC],        /* MM_PROC    */
	&zeroc[MM_RD],          /* MM_RD      */
	&zeroc[MM_SCALL],       /* MM_SCALL   */
	&zeroc[MM_SCSYS],       /* MM_SCSYS   */
	&zeroc[MMSEG_D],        /* MMSEG_D    */
	&zeroc[MMSEG_T],        /* MMSEG_T    */
	&zeroc[MM_SR],          /* MM_SR      */
	&zeroc[MM_TR],          /* MM_TR      */
	&zeroc[MM_WR],          /* MM_WR      */
	&zeroc[MMK_WUB],        /* MMK_WUB    */
	&zeroc[IBIT],           /* IBIT	*/
	&zeroc[MMPGSZ],         /* MMPGSZ	*/
	&zeroc[NPAGEPS],        /* NPAGEPS	*/
	&zeroc[OFFUSRPG],       /* OFFUSRPG	*/
	&zeroc[OFFWRKPG],       /* OFFWRKPG	*/
	&zeroc[PS_SYS],         /* PS_SYS	*/
	&zeroc[PS_USER],        /* PS_USER	*/
	&zeroc[SPL0MASK],       /* SPL0MASK	*/
	&zeroc[PGADRCF],        /* PGADRCF	*/
	&zeroc[PGADRCT],        /* PGADRCT	*/
	&zeroc[PGADRFU],        /* PGADRFU      */
	&zeroc[PGADRSU],        /* PGADRSU      */
	&zeroc[PGADRSF],        /* PGADRSF      */
	&zeroc[PGADRUD],        /* PGADRUD	*/
	&zeroc[PGADRUI],        /* PGADRUI	*/
	&zeroc[PGADRUT],        /* PGADRUT	*/
	&zeroc[PGADRUU],        /* PGADRUU	*/
	&zeroc[PGDELTA],        /* PGDELTA	*/
	&zeroc[PGZERO],         /* PGZERO	*/
	&zeroc[PIC_CMD1],       /* PIC_CMD1	*/
	&zeroc[PIC_EOI],        /* PIC_EOI	*/
	&zeroc[PIC_ISR],        /* PIC_ISR	*/
	&zeroc[PIC_MASK],       /* PIC_MASK	*/
	&zeroc[PIC_VEC_BASE],   /* PIC_VEC_BASE	*/
	&zeroc[PIT_CTR0_PORT],  /* PIT_CTR0_PORT	*/
	&zeroc[PIT_CTRL_PORT],  /* PIT_CTRL_PORT	*/
	&zeroc[PIT_READ_LOAD],  /* PIT_READ_LOAD	*/
	&zeroc[PIT_S0],         /* PIT_S0	*/
	&zeroc[PIT_SQWAVE_MODE], /* PIT_SQWAVE_MODE      */
	&zeroc[SEGCF],          /* SEGCF	*/
	&zeroc[SEGCT],          /* SEGCT	*/
	&zeroc[SEGSU],          /* SEGSU        */
	&zeroc[SEGSF],          /* SEGSF        */
	&zeroc[SEGFU],          /* SEGFU        */
	&zeroc[SEGKCOPY],       /* SEGKCOPY	*/
	&zeroc[SEGKD],          /* SEGKD	*/
	&zeroc[SEGKDATA],       /* SEGKDATA	*/
	&zeroc[SEGKI],          /* SEGKI	*/
	&zeroc[SEGUD],          /* SEGUD	*/
	&zeroc[SEGUI],          /* SEGUI	*/
	&zeroc[SEGCOPYMAX],     /* SEGCOPYMAX */        /*  AWKNAMEE */
		   /* STRICT FORMAT */
};

.comm	_canonb,256
.comm	_rootdir,2
.comm	_runq,2
.comm	_Hogproc,2
.comm	_cputype,2
.comm	_lbolt,2
.comm	_time,4
.comm	_nblkdev,2
.comm	_nchrdev,2
.comm	_mpid,2
.comm	_runin,2
.comm	_runout,2
.comm	_runrun,2
.comm	_runtxt,2
.comm	_curpri,2
.comm	_maxmem,2
.comm	_lks,2
.comm	_swplo,4
.comm	_nswap,2
.comm	_updlock,2
.comm	_rablock,4
.comm	_msgbuf,128
.comm	_rootdev,2
.comm	_swapdev,2
.comm	_pipedev,2
.comm	_acctp,2
.comm	_Nproca,2
.comm	_Nproc,2
.comm	_Timezon,2
.comm	_Dstflag,2
.comm	_dk_busy,2
.comm	_dk_time,128
.comm	_dk_numb,12
.comm	_dk_wds,12
.comm	_tk_nin,4
.comm	_tk_nout,4
.comm	_zerop,34
.comm	_zerou,466
.comm	_zeroc,1000
.globl	_JGLJGL
.data
_JGLJGL:/0
	20.+_zerop
	140.+_zerou
	13.+_zerou
	12.+_zerou
	16.+_zerou
	14.+_zerou
	18.+_zerou
	4.+_zeroc
	8.+_zeroc
	1.+_zeroc
	16.+_zeroc
	4096.+_zeroc
	-30720.+_zeroc
	32.+_zeroc
	_zeroc
	-32768.+_zeroc
	32.+_zeroc
	-30720.+_zeroc
	-30208.+_zeroc
	3.+_zeroc
	35.+_zeroc
	128.+_zeroc
	64.+_zeroc
	16.+_zeroc
	1.+_zeroc
	512.+_zeroc
	2048.+_zeroc
	32.+_zeroc
	-2048.+_zeroc
	-4096.+_zeroc
	254.+_zeroc
	1.+_zeroc
	_zeroc
	1024.+_zeroc
	5120.+_zeroc
	9216.+_zeroc
	13312.+_zeroc
	17408.+_zeroc
	7168.+_zeroc
	7168.+_zeroc
	-3072.+_zeroc
	-1024.+_zeroc
	2048.+_zeroc
	1024.+_zeroc
	192.+_zeroc
	32.+_zeroc
	192.+_zeroc
	194.+_zeroc
	16.+_zeroc
	208.+_zeroc
	214.+_zeroc
	48.+_zeroc
	_zeroc
	6.+_zeroc
	8192.+_zeroc
	8448.+_zeroc
	8960.+_zeroc
	9216.+_zeroc
	8704.+_zeroc
	2.+_zeroc
	_zeroc
	_zeroc
	4096.+_zeroc
.globl	
	384.+_zeroc
	4480.+_zeroc
	16.+_zeroc
.data
