/*
 *  ebfthdr is a structure defining the data written in the special
 *  boot from tape header record written by ibtape immediately after
 *  writing the bootstrap itself.  bfthdr is a subset of this info,
 *  used by the second stage loader.  The extra information in ebfthdr
 *  was put there with the idea that it could be inspected later to
 *  get a clue as to what was on the tape, since the xenix and the
 *  optional disk image are laid down as part of the boot and cannot
 *  be examined by the usual ls, tar, etc.
 */

struct bfthdr
{
	long xnx_len;		/* length of xenix file		   */
	short di_pres;		/* 0==no disk image, 1== diskimage */
	long di_base;		/* base address of disk image      */
	long di_len;		/* length of disk image            */
};

struct ebfthdr
{
	long e_xnx_len;		/* same as above		   */
	short e_di_pres;	/*      "			   */
	long e_di_base;		/*      "			   */
	long e_di_len;		/*      "			   */
	char[26] e_b_itime;	/* installation time of boot	   */
	char [26] e_x_mtime;	/* last mod time of the xenix      */
	char[26] e_d_mtime;	/* last mod time of the disk image */
	char[26] e_2_mtime;	/* last mod time of the 2nd stage  */
	char[128] e_x_name;	/* path name of the xenix          */
	char[128] e_d_name;	/* path name of the disk image     */
	char[128] e_2_name;	/* path name of the 2nd stage      */
};
