#undef	SPL
#define SPL	spl5		/* keep interrupts away */
/*
 * N534 must be modified if the configuration
 * changes the number of isbc534 boards in the system.
 */
#define	N534		2	/* Number of isbc534's in configuration  */

#define ISPEED		13	/* initial baud rate of 9600==(13);300==(7)*/
#define MINORMSK 	0x1F	/* reserve bit 7 ; bit 6 for modem */
#define MODEMMSK	0xC0	/* bit 6 of the minor number sets modem op */
#define MODEMWAIT       0x40    /* wait for carrier modem op */
#define	DTRON		0x80	/* bit 8 of usart status byte; 1 if present */

/*
 * Structures for the iSBC534
 * ____________________________
 *
 * Commands used for operation and initialization of
 * pic's,pit's,usarts and the ppi
 *
 * ____________________________
 *
 * Written by J. Chorn 		December 7'th 1981
 *
 * ____________________________
 *
 * Refer to iSBC534 Hardware Reference Manual Chapter Three I/O Address
 * Assignments for further information.
 *
 * Device PHYSICAL port layout
 * Based on Data Block Select
 *
 *
 * Usart I/O functions:
 *
 *	Write: I/O
 *	Read:  I/O
 *
 * PIC status port functions:
 *
 * 	Write:	ICW1,OCW2, and OCW3
 * 	Read:	Status and Poll
 *
 * PIC mask port functions:
 *
 * 	Write:	ICW2 and OCW1(mask)
 *	Read:	OCW1
 *
 *
 * structure db534:
 *
 * 	8251 Usarts [4] 	{2 bytes wide each}
 * 	8259 PIC's  [2] 	{2 bytes wide each}
 *   	Board command port's	{4 bytes}
 *
 */

struct db534{
	struct	{
		char	data;		/* serial I/O data port  */
		char	cntrl;		/* serial control port  */
	} USART[4];
	struct	{
		char	csr;		/* PIC status port  */
		char	msr;		/* PIC mask port    */
	} PIC[2];
	char	selcntr;		/* Select control block */
	char	seldata;		/* Select data block */
	char	stestmd;		/* Select/deselect test mode  */
	char	reset;			/* Board Reset port */
};	
	
/*
 * Refer to iSBC534 Hardware Reference Manual Chapter Three I/O Address
 * Assignments for further information.
 *
 * Device Physical Port Layout
 * Based on Control Block Select
 * 
 *
 * 8253 PIT Functions:
 *
 * 	Load/Read count 
 *
 * 8255 PPI Functions:
 *	
 * Write :
 * 	Port A None
 *	Port B None
 *	Port C Data out
 *	Port (Control) Control commands
 *
 * Read :
 *
 *	Port A Data in
 *	Port B Data in
 *	Port C Data status
 *	Port (Control) None
 *
 *
 * structure cd534:
 *
 * 	8253 PIT's [2]			{4 byte wide each}
 *  	8255 PPI Parallel port		{4 bytes}
 *   	Board command port's		{4 bytes}
 *
 */

struct	cb534{
	struct	{
		char	timer[3];	/* read/load BDG[?] & BDG[?+3] */
		char	pcr;		/* PIT control register */
	} PIT[2];
	char	porta;			/* read port a data in */
	char	portb;			/* read port b data in */
	char	portc;			/* read/write port c */
	char	ppi_pcr;		/* PPI control register */
	char	selcntr;		/* select control block */
	char	seldata;		/* select data block */
	char	stestmd;		/* select/deselect test mode */
	char	reset;			/* board reset */
};

/* 
 * Structure for base assignments of boards in the configuration
 * This is used to associate the board to the base address
 */
struct i534cfg{
	int	c_base;
};


/*
 * Commands for the i534 proc's
 *
 *
 * 8253 PIT commands
 *
 *	RATEMD0:	read/load timer0(or 4) for mode 3 (baud rate generator)
 *
 *	U534SPEED:		int constant of 1600 pit count in hex.
 *
 *	NOTE:	mode zero can only be used on timers 4 or 5 !! (according to 
 *		the manual ) and this is garf. Program for mode 3 for two second
 *		clock signal.
 *
 */

#define	RATEMD0	0x36
#define U534SPEED	0x0640

/*
 * 8251 USART command instructions
 *
 * SRESET :	disable		transmitter
 *		disable		reciever
 *		enable		return to mode instruction format
 *
 * SANSWER :	enable		transmitter
 *		enable		DTR
 *		enable		reciever
 *		enable		a reset of error flags
 *		enable		RTS
 *
 * STXD :	disable		transmitter
 *		enable		receiver
 *		enable		a reset of error flags
 *
 * SHANGUP :	disable		transmitter
 *		disable		reciever
 *		enable		a reset of error flags
 *
 *
 */

#define	SRESET	0x40
#define	SANSWER	0x37
#define STXD	0x14
#define	SHANGUP	0x10


/*
 * RXRDY: Reciever has data
 * TXRDY: Transmitter empty
 */

#define RXRDY	0x02
#define TXRDY	0x01

/*
 * 8251 USART mode instructions
 *
 * SMODE : usart mode of operaton as follows:
 *	 	16X clock
 *	 	8 data bits
 *	 	No parity
 *		2 stop bits
 *
 */

#define	SMODE	0x4E

/*
 * 8259 PIC commands
 *
 * ICW'S 
 *
 * PICICW1:	Format = 4,single pic,edge triggered.
 * PICICW2:	Initialization address.
 * 		Picicw3 and picicw4 not needed.
 * OCW's
 *
 * MASKINT:	Set 8259 to mask all interrupt levels.
 *
 * GETINT :	Set 8259 for polled mode
 * 		read requesting device on next rd pulse.
 * GOODINT:	Mask to check bit 8 ;produce from the 'getint' command.
 * 		Bit 8 set == valid interrupt at this pic.
 *
 * TIMERGO:	Pic mask which allows bdg5 timer interrupts
 *
 */

#define PICICW1	0x16
#define PICICW2	0
#define MASKINT	0xFF
#define GETINT	0x0C
#define	GOODINT	0x80
#define TIMERGO	0xFD
