#define NLP 1				/* Number of line printers */
#define SPL spl5			/* raised interrupt priority */
#define	LPPRI	(PZERO+1)		/* allow sleepers to wakeup early */
#define LPUNIT(dev) (minor(dev) >> 3)	/* macro to obtain device unit number */

/*
 *	Markers
 */
#define	LPLWAT	50	/* line printer low water mark */
#define	LPHWAT	75	/* line printer high water mark */
#define MAXCOL	132	/* page width */
#define MAXLINE 66	/* page length (if device doesn't support '\f') */

/*
 *	States
 */
#define	OPEN	01	/* device is open */
#define	ASLP	02	/* awaiting draining of printer */
#define	TOUT	04	/* the device needed a timeout for a terminator */
#define PALIVE	010	/* board alive indicator */

/*
 *	Hardware constants
 */
#define PINIT	0xaa	/* 8255 command word for port init */
#define INTRON	0x0d	/* enable 8255 generation of an intr */
#define TEST	0xaa	/* test pattern read back by probe */
#define READY	0x10	/* printer online bit active high */
#define NOPAPER 0x20	/* paper out bit active high */
#define HACK    0x88    /* hardware acknowledge bit active high */
#define ONSTROBE 1
#define OFFSTROBE 0

/*
 *	Flags
 */
#define CAP	1		/* from minor # force caps! */

/*
 *	Device Structures
 */
struct clist {
	int	c_cc;			/* character count */
	char	*c_cf;			/* pointer to the first character */
	char	*c_cl;			/* pointer to the last character */
};

struct lp330cfg {
		int p_level;		/* intr level */
		int p_porta;		/* data out */
		int stport;		/* status port C */
		int control;
};

struct lp_softc {
	struct	clist lp_outq;
	int	lp_physcol;
	int	lp_logcol;
	int	lp_phline;
	int	lp_lpchar;
	int	lp_state;
	int	lp_flags;
	int	lp_addr;
	struct	buf	*lp_buffer;
};
