/*
 * MLC driver
 */
#define	NMLC	8
 
/*
 * MCL queue definition.
 */
#define	MLCIQSIZ	6144
#define	MLCOQSIZ	10240
 
struct	mlcq {
	char	m_lock;		/* queue lock */
	char	m_wait;		/* waiting for queue */
	char	*m_fp;		/* first byte of queue */
	char	*m_lp;		/* last byte of queue + 1 */
	char	*m_ip;		/* next input message */
	char	*m_op;		/* next output message */
	char	*m_gp;		/* next input byte */
	char	*m_pp;		/* next output byte */
	struct	proc *m_server;	/* queue server */
	struct	proc *m_sleep;	/* sleeping on queue */
};
 
/*
 * tty structure variables.
 */
#define	t_cmd		t_line
#define	t_status	t_col
#define	t_open		t_char
 
/*
 * Internal state bits.
 */
#define	T_INPUT		TIMEOUT	/* waiting for input */
#define	T_DELCT		FLUSH	/* delimiter character valid when encountered */
#define	T_IHILIM	BUSY	/* input high water mark reached */
#define	T_OHILIM	ASLEEP	/* output high water mark reached */
 
/*
 * Queue thresholds.
 */
#define M_OHILIM	2048	/* output buffer hi water mark */
#define M_OLOLIM	1024	/* output buffer lo water mark */
#define M_IHILIM	2048	/* input buffer hi water mark */
#define M_ILOLIM	1024 	/* input buffer lo water mark */
 
/*
 * Priorities.
 */
#define	MLCQPRI		-100	/* queue service priority */
 
/*
 * MLC message header.
 */
struct	mlcheader {
	char	m_da;		/* device address */
	char	m_cmd;		/* MLC command */
	int	m_length;	/* message length in bytes */
};
 
/*
 * MLC commands.
 */
#define	RESET		0X11	/* reset PDS program */
#define	BOOT		0X12	/* boot PDS program */
#define	SET		0X21	/* set characteristics */
#define	READ		0X31	/* read terminal */
#define	WRITE		0X32	/* write terminal */

/*
 * MLC status byte definition.
 */
#define	POWER		0X80	/* device power */
#define	CARRIER		0X40	/* PDS program loaded */
#define	BADGE_READER	0X20	/* badge reader present */
#define	TERMINAL_LOCKED	0X10	/* terminal key locked */
#define	KEYBOARD_LOCKED	0X08	/* keyboard locked */
#define	FUNCTION_KEY	0X40	/* function key */
#define	INTERRUPT_KEY	0X02	/* interrupt key */
#define	QUIT_KEY	0X01	/* quit key */
 
/*
 * PDS information.
 */
#define	PDSSIZ		8192	/* PDS program size */
#define	SPEED		13	/* 9600 baud */
