/*
 * Instrumentation
 *
 *      The following cells are used by
 *              iostat.c
 *              systat.c
 *              disk device drivers (optional)
 *
 *      This instrumentation is very rudimentary and inflexible.
 *      It currently allows the monitoring of up to 3 independent units:
 *      there needs to be magic code in the device drivers to divvy up
 *      those three into three different disks devices, three units
 *      of one kind, or whatever.
 *
 *      Whenever each unit is busy, its corresponding bit (01, 02, or 04)
 *      is set in dk_busy.  The driver also should accumulate the
 *      number of transfers performed in dk_numb[unit], and
 *      the number of words transfered in dk_wds[unit].
 *
 *      clock.c increments one cell in dk_time[] depending upon which
 *      of the three units are active (8 possibilities) and upon
 *      whether we're in user or system mode, niced or idle (4 choices)
 *
 *      The structure of dk_time is:
 *
 *      {  long usermode[8],            /* in user mode
 *         long usernice[8],            /* in user mode, nice priority
 *         long sysmode [8],            /* in system mode
 *         long sysidle [8]; }          /* in the idle loop
 *
 *      Programs like systat and iostat can sum these numbers and
 *      extract both disk performance data and the amount of time spent
 *      with the cpu assigned to user, nice, or system, as well as
 *      idle time.  Note that dk_time[24+0] counts system totally idle
 *      time, dk_time[24+1] to dk_time[24+7] count "wasted" time:
 *      time where the cpu was idle waiting for I/O to complete.
 */

struct dkstat {                                         /* M001 */
    int     dk_busy;
    long    dk_time[32];
    long    dk_numb[3];
    long    dk_wds[3];
    long    tk_nin;
    long    tk_nout;
} Dk;
