'
' Stewart Konzen
' Copyright (c) Microsoft Corporation, 1982
'
' %W% %H%	%Q%
'
.nr Hu 3
.ds :? XENIX Reference Manual
.HU "Introduction"
.PH "'XENIX Reference''XENIX Reference'"
.PF "''- \\\\nP -''"
This manual is a reference to the
commands, facilities, and utilities of the \*(x1 system.
Within the area it surveys, this manual attempts
to be complete and concise.
This manual does not attempt 
to provide introductory or tutorial information.
See other \*(x1 manuals for this information.
.P
The volume is divided into
eight sections:
.VL 11
.LI "Section\ 1\ \ Commands
.br
Commands are programs intended to be invoked directly by the user. 
This is in contrast to system calls and subroutines which are
intended to be called from within user programs.
System startup commands, and commands invoked by
only internally by the system are in in Section 8.
Some of the entries for this section come only with the 
\*(x2 Software Development Package
and the 
\*(x2 Text Processing Package.
Commands generally reside in the directory
.I /bin
(for
.IR bin \|ary
programs).
Some programs also reside in
.I
/\|usr/\|bin,
.R
to save space in
.I  /bin.
These directories are searched automatically 
by the shell command interpreter.
.LI "Section\ 2\ \ System Calls"
.br
Section 2 describes the C language interface to
each system call.
System calls are entries into the \*(x1 operating
system kernel. 
It is in the kernel that the system's
resources are manipulated.
Entries for this section come only with the 
\*(x2 Software Development Package.
.LI "Section\ 3\ \ Subroutines"
.br
An assortment of standard subroutines is available.
These subroutines are intended to be included and compiled 
into C programs.
The libraries in which they are kept are described in
.IR intro (3).
Entries for this section come only with the 
\*(x2 Software Development Package.
.LI "Section\ 4\ \ Special Files"
.br
This section discusses the characteristics of
each system \*`file\*' that actually refers to an I/O device.
.LI "Section\ 5\ \ File Formats"
.br
This section documents the structure of particular kinds of files. 
For example, the form of the output of the loader and
assembler is given.  
Excluded are files used by only one command,
for example any program's intermediate files.
.LI "Section\ 6\ \ Games"
.br
This section describes the games available in 
.FN /usr/games .
.LI "Section\ 7\ \ Miscellaneous"
.br
This section is mainly a miscellaneous collection of 
information necessary to
writing in various specialized languages.
For example character codes, 
and macro packages for typesetting,
are included here.
.LI "Section\ 8\ \ Maintenance"
.br
This section discusses procedures not intended
for use by the ordinary user.
These procedures often involve use of commands
of section 1, where an attempt has been made to
single out peculiarly maintenance-flavored commands
by marking them 1M.
.LE
.HU "Page Format"
Each section consists of a number of independent
entries of a page or so each.
The name of the entry is in the upper corners of its pages,
together with the section number, and sometimes a
letter characteristic of a subcategory, e.g. graphics is 1G,
and the math library is 3M.
Entries within each section are alphabetized.
The page numbers of each entry start at 1.
.P
All entries are based on a common format,
not all of whose subsections will always appear.
.P
The
.B NAME
subsection lists the exact names of the commands and subroutines
covered under the entry and gives
a very short description of their purpose.
.P
The
.B SYNTAX
summarizes usage of the program being described.
.P
The
.B "DESCRIPTION"
subsection discusses in detail the subject at hand.
.P
The
.B "FILES"
subsection gives the names of files that are
built into the program or that are closely related
to the manual entry.
.P
A
.B "SEE\ ALSO"
subsection gives pointers to related information.
.P
A
.B DIAGNOSTICS
subsection discusses
the error messages and other diagnostic indications 
that may be produced.
Messages that are intended to be self-explanatory
are not listed.
.P
The
.B NOTES 
subsection gives
known bugs, limitations, and other programmer notes.
.P
At the end of this volume 
is a permuted index derived from the table of contents.
Within each index entry, the title
of the writeup to which
it refers is followed by the appropriate section number in parentheses.
This fact is important because there is considerable
name duplication among the sections,
arising principally from commands which
exist only to exercise a particular system call.
.HU "Notational Conventions"
The following conventions are used throughout this
manual:
.P
.B Boldface
words are considered literals, and
are typed just as they appear.
.P
Square brackets [ ] around an argument
indicate that the argument is optional.
When an argument is given as `name', it always
refers to a file name.
.P
Ellipses `.\|.\|.' are used to show 
that the previous argument-prototype
may be repeated.
.P
A final convention is used by the commands themselves.
A dash (\-) 
is often taken to mean some sort of option-specifying argument
even if it appears in a position where a file name
could appear.  
Therefore, it is unwise to have files
whose names begin with a dash.
